/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.openprovenance.prov.model.BeanTraversal;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.DocumentEquality;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvFrameworkTest;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;

public class ExtensionRoundTripFromJavaTest
extends ProvFrameworkTest {
    public static final String EX_NS = "http://example.org/";
    public static final String EX2_NS = "http://example2.org/";
    public static final String EX_PREFIX = "ex";
    public static final String EX2_PREFIX = "ex2";
    public static final String EX3_NS = "http://example3.org/";
    public static ProvFactory pFactory = new org.openprovenance.prov.vanilla.ProvFactory();
    public static Name name = pFactory.getName();
    Map<String, Document> table = new Hashtable<String, Document>();
    public boolean test = true;

    public ExtensionRoundTripFromJavaTest() {
        this.documentEquality = new DocumentEquality(this.mergeDuplicateProperties(), null);
    }

    @Override
    public void updateNamespaces(Document doc) {
        Namespace ns = Namespace.gatherNamespaces((Document)doc);
        ns.register("provext", "http://openprovenance.org/prov/extension#");
        doc.setNamespace(ns);
    }

    @Override
    public boolean checkSchema(String name) {
        return !name.contains("qualified");
    }

    public void doCheckSchema2(String file) {
        String command = "xmllint --schema src/main/resources/ex.xsd " + file;
        try {
            Process proc = Runtime.getRuntime().exec(command);
            proc.waitFor();
            int code = proc.exitValue();
            if (code != 0) {
                BufferedReader outReader;
                String s_out;
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                String s_error = errorReader.readLine();
                if (s_error != null) {
                    System.out.println("Error:  " + s_error);
                }
                if ((s_out = (outReader = new BufferedReader(new InputStreamReader(proc.getInputStream()))).readLine()) != null) {
                    System.out.println("Out:  " + s_out);
                }
            }
            ExtensionRoundTripFromJavaTest.assertTrue((code == 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Document readDocument(String file1) {
        return this.table.get(file1);
    }

    @Override
    public void writeDocument(Document doc, String file2) {
        System.out.println("deep copy of " + file2);
        Namespace.withThreadNamespace((Namespace)doc.getNamespace());
        Document doc2 = ExtensionRoundTripFromJavaTest.deepCopy(doc);
        this.table.put(file2, doc2);
    }

    public static Document deepCopy(Document doc) {
        BeanTraversal bc = new BeanTraversal((ModelConstructor)pFactory, pFactory);
        Document doc2 = bc.doAction(doc);
        return doc2;
    }

    @Override
    public boolean checkTest(String name) {
        return name.contains("qualified");
    }

    @Override
    public QualifiedName q(String n) {
        return pFactory.newQualifiedName(EX_NS, n, EX_PREFIX);
    }

    public void testQualifiedSpecializationOf1() {
        QualifiedSpecializationOf gen = pFactory.newQualifiedSpecializationOf(this.q("spec1"), this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-specialization1");
    }

    public void testQualifiedSpecializationOf2() {
        QualifiedSpecializationOf gen = pFactory.newQualifiedSpecializationOf(null, this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-specialization2");
    }

    public void testQualifiedAlternateOf1() {
        QualifiedAlternateOf gen = pFactory.newQualifiedAlternateOf(this.q("alt1"), this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-alternate1");
    }

    public void testQualifiedAlternateOf2() {
        QualifiedAlternateOf gen = pFactory.newQualifiedAlternateOf(null, this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-alternate2");
    }

    public void testQualifiedHadMemberf1() {
        LinkedList<QualifiedName> entities = new LinkedList<QualifiedName>();
        entities.add(this.q("e2"));
        QualifiedHadMember gen = pFactory.newQualifiedHadMember(this.q("mem"), this.q("e1"), entities, null);
        this.makeDocAndTest((Statement)gen, "target/qualified-member1");
    }

    public void testQualifiedHadMember2() {
        LinkedList<QualifiedName> entities = new LinkedList<QualifiedName>();
        entities.add(this.q("e2"));
        QualifiedHadMember gen = pFactory.newQualifiedHadMember(null, this.q("e1"), entities, null);
        this.makeDocAndTest((Statement)gen, "target/qualified-member2");
    }
}

