/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import junit.framework.TestCase;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.DocumentComparator;
import org.openprovenance.prov.model.DocumentEquality;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasLocation;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.HasValue;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.UncheckedTestException;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class ProvFrameworkTest
extends TestCase {
    public static final String EX_NS = "http://example.org/";
    public static final String EX_PREFIX = "ex";
    public static final String OUTER_PREFIX = "outer";
    public static final String INNER_PREFIX = "inner";
    static final ProvUtilities util = new ProvUtilities();
    public static ProvFactory pFactory = new org.openprovenance.prov.vanilla.ProvFactory();
    public static Name name = pFactory.getName();
    protected DocumentEquality documentEquality = new DocumentEquality(this.mergeDuplicateProperties(), System.out);
    protected final DocumentComparator documentComparator = new DocumentComparator(this.documentEquality);

    public void updateNamespaces(Document doc) {
        Namespace ns = Namespace.gatherNamespaces((Document)doc);
        doc.setNamespace(ns);
    }

    public String extension() {
        return "";
    }

    public void makeDocAndTest(Statement stment, String file) {
        this.makeDocAndTest(stment, file, null, true);
    }

    public void makeDocAndTest(Statement stment, String file, boolean check) {
        this.makeDocAndTest(stment, file, null, check);
    }

    public void makeDocAndTest(Statement stment, Statement[] opt, String file) {
        this.makeDocAndTest(stment, file, opt, true);
    }

    public void makeDocAndTest(Statement[] stment, Statement[] opt, String file) {
        this.makeDocAndTest(stment, file, opt, true);
    }

    public void makeDocAndTest(Statement stment, String file, Statement[] opt, boolean check) {
        this.makeDocAndTest(new Statement[]{stment}, file, opt, check);
    }

    public void makeDocAndTest(Statement[] stment, String file, Statement[] opt, boolean check) {
        this.makeDocAndTest(stment, null, file, opt, check);
    }

    public void makeDocAndTest(Statement[] stment, Bundle[] bundles, String file, Statement[] opt, boolean check) {
        Document doc = this.makeDocument(stment, bundles);
        this.doTest(doc, file, opt, check);
    }

    public void doTest(Document doc, String file, Statement[] opt, boolean check) {
        Object file1 = opt == null ? file : file + "-S";
        this.compareDocAndFile(doc, (String)file1, check);
        if (opt != null && this.doOptional(opt)) {
            String file2 = file + "-M";
            doc.getStatementOrBundle().addAll(Arrays.asList(opt));
            this.compareDocAndFile(doc, file2, check);
        }
    }

    public Document makeDocument(Statement[] stment, Bundle[] bundles) {
        Document doc = pFactory.newDocument();
        for (Statement statement : stment) {
            doc.getStatementOrBundle().add(statement);
        }
        if (bundles != null) {
            for (Statement statement : bundles) {
                doc.getStatementOrBundle().add(statement);
            }
        }
        this.updateNamespaces(doc);
        if (bundles != null) {
            for (Statement statement : bundles) {
                statement.getNamespace().setParent(doc.getNamespace());
            }
        }
        return doc;
    }

    public boolean doOptional(Statement[] opt) {
        return true;
    }

    public void compareDocAndFile(Document doc, String file, boolean check) {
        file = (String)file + this.extension();
        this.writeDocument(doc, (String)file);
        if (check) {
            this.conditionalCheckSchema((String)file);
        }
        Document doc3 = this.readDocument((String)file);
        this.documentComparator.compareDocuments(doc, doc3, check && this.checkTest((String)file));
    }

    public void conditionalCheckSchema(String file) {
        if (this.checkSchema(file)) {
            this.doCheckSchema1(file);
        }
    }

    public boolean checkSchema(String name) {
        return true;
    }

    public void doCheckSchema1(String file) {
    }

    public Document readDocument(String file1) {
        try {
            return this.readDocumentFromFile(file1);
        }
        catch (IOException e) {
            throw new UncheckedTestException(e);
        }
    }

    public void writeDocument(Document doc, String file2) {
        Namespace.withThreadNamespace((Namespace)doc.getNamespace());
        try {
            this.writeDocumentToFile(doc, file2);
        }
        catch (IOException e) {
            throw new UncheckedTestException(e);
        }
    }

    public boolean checkTest(String name) {
        return true;
    }

    public boolean mergeDuplicateProperties() {
        return false;
    }

    public Document readDocumentFromFile(String file) throws IOException {
        this.readingMessage(file);
        return null;
    }

    public void readingMessage(String file) {
    }

    public void writeDocumentToFile(Document doc, String file) throws IOException {
        this.writingMessage(file);
    }

    public void writingMessage(String file) {
        System.out.println("constructing " + file);
    }

    public QualifiedName q(String n) {
        return pFactory.newQualifiedName(EX_NS, n, EX_PREFIX);
    }

    public void addLabel(HasLabel hl) {
        hl.getLabel().add(pFactory.newInternationalizedString("hello"));
    }

    public void addLabels(HasLabel hl) {
        hl.getLabel().add(pFactory.newInternationalizedString("hello"));
        hl.getLabel().add(pFactory.newInternationalizedString("bye", "en"));
        hl.getLabel().add(pFactory.newInternationalizedString("bonjour", "fr"));
    }

    public void addTypes(HasType ht) {
        ht.getType().add(pFactory.newType((Object)"a", ProvFrameworkTest.name.XSD_STRING));
        ht.getType().add(pFactory.newType((Object)1, ProvFrameworkTest.name.XSD_INT));
        ht.getType().add(pFactory.newType((Object)1.0, ProvFrameworkTest.name.XSD_FLOAT));
        ht.getType().add(pFactory.newType((Object)true, ProvFrameworkTest.name.XSD_BOOLEAN));
        ht.getType().add(pFactory.newType((Object)pFactory.newQualifiedName(EX_NS, "abc", EX_PREFIX), ProvFrameworkTest.name.PROV_QUALIFIED_NAME));
        ht.getType().add(pFactory.newType((Object)pFactory.newTimeNow(), ProvFrameworkTest.name.XSD_DATETIME));
        ht.getType().add(pFactory.newType((Object)"http://example.org/hello", ProvFrameworkTest.name.XSD_ANY_URI));
    }

    public void addLocations(HasLocation hl) {
        hl.getLocation().add(pFactory.newLocation((Object)"London", ProvFrameworkTest.name.XSD_STRING));
        hl.getLocation().add(pFactory.newLocation((Object)1, ProvFrameworkTest.name.XSD_INT));
        hl.getLocation().add(pFactory.newLocation((Object)1.0, ProvFrameworkTest.name.XSD_FLOAT));
        hl.getLocation().add(pFactory.newLocation((Object)true, ProvFrameworkTest.name.XSD_BOOLEAN));
        hl.getLocation().add(pFactory.newLocation((Object)pFactory.newQualifiedName(EX_NS, "london", EX_PREFIX), ProvFrameworkTest.name.PROV_QUALIFIED_NAME));
        hl.getLocation().add(pFactory.newLocation((Object)pFactory.newTimeNow(), ProvFrameworkTest.name.XSD_DATETIME));
        hl.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", ProvFrameworkTest.name.XSD_ANY_URI));
        hl.getLocation().add(pFactory.newLocation((Object)pFactory.newGYear(2002), ProvFrameworkTest.name.XSD_GYEAR));
    }

    public void addValue(HasValue hl) {
        hl.setValue(pFactory.newValue((Object)pFactory.newQualifiedName(EX_NS, "avalue", EX_PREFIX), ProvFrameworkTest.name.PROV_QUALIFIED_NAME));
    }

    public void addFurtherAttributes(HasOther he) {
        he.getOther().add(pFactory.newOther(EX_NS, "tag1", EX_PREFIX, (Object)"hello", ProvFrameworkTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag1", EX_PREFIX, (Object)"bonjour", ProvFrameworkTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag1", EX_PREFIX, (Object)pFactory.newGYear(2002), ProvFrameworkTest.name.XSD_GYEAR));
        he.getOther().add(pFactory.newOther(EX_NS, "tag2", EX_PREFIX, (Object)"bye", ProvFrameworkTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther("http://example2.org/", "tag3", "ex2", (Object)"hi", ProvFrameworkTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, this.get0tagWithDigit(), EX_PREFIX, (Object)"hello", ProvFrameworkTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, this.get0tagWithDigit(), EX_PREFIX, (Object)"hello2", ProvFrameworkTest.name.XSD_STRING));
    }

    public String get0tagWithDigit() {
        return "0tagWithDigit";
    }

    public void addFurtherAttributes0(HasOther he) {
        he.getOther().add(pFactory.newOther(EX_NS, "tag1", EX_PREFIX, (Object)"hello", ProvFrameworkTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag2", EX_PREFIX, (Object)"bye", ProvFrameworkTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag2", EX_PREFIX, (Object)pFactory.newInternationalizedString("bonjour", "fr"), ProvFrameworkTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther("http://example2.org/", "tag3", "ex2", (Object)"hi", ProvFrameworkTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Integer(1), ProvFrameworkTest.name.XSD_INT));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Long(1L), ProvFrameworkTest.name.XSD_LONG));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Short(1), ProvFrameworkTest.name.XSD_SHORT));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Double(1.0), ProvFrameworkTest.name.XSD_DOUBLE));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Float(1.0), ProvFrameworkTest.name.XSD_FLOAT));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new BigDecimal(1.0), ProvFrameworkTest.name.XSD_INTEGER));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Boolean(true), ProvFrameworkTest.name.XSD_BOOLEAN));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Byte(123), ProvFrameworkTest.name.XSD_BYTE));
        this.addFurtherAttributesWithQNames(he);
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)"http://example.org/london", ProvFrameworkTest.name.XSD_ANY_URI));
    }

    public void addFurtherAttributesWithQNames(HasOther he) {
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)pFactory.newQualifiedName("http://example2.org/", "newyork", "ex2"), ProvFrameworkTest.name.PROV_QUALIFIED_NAME));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "london", EX_PREFIX), ProvFrameworkTest.name.PROV_QUALIFIED_NAME));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)pFactory.newQualifiedName("http://example3.org/", "london", null), ProvFrameworkTest.name.PROV_QUALIFIED_NAME));
    }

    public void testAlwaysSuccessful() {
        ProvFrameworkTest.assertTrue((boolean)true);
    }

    public String escapeRed(String str) {
        return "\u001b[31m" + str + "\u001b[0m";
    }

    public String escapeGreen(String str) {
        return "\u001b[32m" + str + "\u001b[0m";
    }
}

