/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.io.IOException;
import junit.framework.TestCase;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.ExtensionRoundTripFromJavaTest;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasGeneratedBy;

public class PC1FullTest
extends TestCase {
    public static final String PC1_NS = "http://www.ipaw.info/pc1/";
    public static final String PC1_PREFIX = "pc1";
    public static final String PRIM_NS = "http://openprovenance.org/primitives#";
    public static final String PRIM_PREFIX = "prim";
    public static ProvFactory pFactory = new org.openprovenance.prov.vanilla.ProvFactory();
    public static Name name = pFactory.getName();
    public boolean urlFlag = true;
    public static Document graph1;
    public static Document graph2;
    static String FILE_LOCATION;
    static String URL_LOCATION;
    public static final QualifiedName PRIMITIVE_ALIGN_WARP;
    public static final QualifiedName PRIMITIVE_RESLICE;
    public static final QualifiedName PRIMITIVE_SOFTMEAN;
    public static final QualifiedName PRIMITIVE_CONVERT;
    public static final QualifiedName PRIMITIVE_SLICER;

    public QualifiedName q(String n) {
        return pFactory.newQualifiedName(PC1_NS, n, PC1_PREFIX);
    }

    public void testPC1() throws IOException {
        this.subtestPC1Full();
        this.subtestCopyPC1Full();
    }

    public void subtestPC1Full() throws IOException {
        Document graph = this.makePC1FullGraph(pFactory);
        Namespace.withThreadNamespace((Namespace)graph.getNamespace());
        graph1 = graph;
        PC1FullTest.assertTrue((boolean)true);
    }

    public Entity newFile(ProvFactory pFactory, String id, String label, String file, String location) {
        Entity a = pFactory.newEntity(this.q(id), label);
        pFactory.addType((HasType)a, pFactory.newQualifiedName(PRIM_NS, "FILE", PRIM_PREFIX));
        this.addUrl((HasOther)a, location + file);
        return a;
    }

    public Entity newParameter(ProvFactory pFactory, String id, String label, String value) {
        Entity a = pFactory.newEntity(this.q(id), label);
        pFactory.addType((HasType)a, pFactory.newQualifiedName(PRIM_NS, "String", PRIM_PREFIX));
        this.addValue((HasOther)a, value);
        return a;
    }

    public Document makePC1FullGraph(ProvFactory pFactory) {
        if (this.urlFlag) {
            return this.makePC1FullGraph(pFactory, URL_LOCATION, URL_LOCATION);
        }
        return this.makePC1FullGraph(pFactory, FILE_LOCATION, "./");
    }

    public void addValue(HasOther p1, String val) {
        p1.getOther().add(pFactory.newOther(PC1_NS, "value", PC1_PREFIX, (Object)val, PC1FullTest.name.XSD_STRING));
    }

    public void addUrl(HasOther p1, String val) {
        p1.getOther().add(pFactory.newOther(PC1_NS, "url", PC1_PREFIX, (Object)val, PC1FullTest.name.XSD_STRING));
    }

    public Used newUsed(Activity activity, String role, Entity entity) {
        return this.newUsed(activity.getId(), role, entity.getId());
    }

    public Used newUsed(QualifiedName activity, String role, QualifiedName entity) {
        Used u1 = pFactory.newUsed(activity, entity);
        u1.getRole().add(pFactory.newRole((Object)role, PC1FullTest.name.XSD_STRING));
        return u1;
    }

    public WasDerivedFrom newWasDerivedFrom(Entity entity2, Entity entity1) {
        WasDerivedFrom wdf = pFactory.newWasDerivedFrom(null, entity2.getId(), entity1.getId());
        return wdf;
    }

    public Document makePC1FullGraph(ProvFactory pFactory, String inputLocation, String outputLocation) {
        Activity p1 = pFactory.newActivity(this.q("a1"), "align_warp 1");
        pFactory.addType((HasType)p1, PRIMITIVE_ALIGN_WARP);
        Activity p2 = pFactory.newActivity(this.q("a2"), "align_warp 2");
        pFactory.addType((HasType)p2, PRIMITIVE_ALIGN_WARP);
        Activity p3 = pFactory.newActivity(this.q("a3"), "align_warp 3");
        pFactory.addType((HasType)p3, PRIMITIVE_ALIGN_WARP);
        Activity p4 = pFactory.newActivity(this.q("a4"), "align_warp 4");
        pFactory.addType((HasType)p4, PRIMITIVE_ALIGN_WARP);
        Activity p5 = pFactory.newActivity(this.q("a5"), "Reslice 1");
        pFactory.addType((HasType)p5, PRIMITIVE_RESLICE);
        Activity p6 = pFactory.newActivity(this.q("a6"), "Reslice 2");
        pFactory.addType((HasType)p6, PRIMITIVE_RESLICE);
        Activity p7 = pFactory.newActivity(this.q("a7"), "Reslice 3");
        pFactory.addType((HasType)p7, PRIMITIVE_RESLICE);
        Activity p8 = pFactory.newActivity(this.q("a8"), "Reslice 4");
        pFactory.addType((HasType)p8, PRIMITIVE_RESLICE);
        Activity p9 = pFactory.newActivity(this.q("a9"), "Softmean");
        pFactory.addType((HasType)p9, PRIMITIVE_SOFTMEAN);
        Activity p10 = pFactory.newActivity(this.q("a10"), "Slicer 1");
        pFactory.addType((HasType)p10, PRIMITIVE_SLICER);
        Activity p11 = pFactory.newActivity(this.q("a11"), "Slicer 2");
        pFactory.addType((HasType)p11, PRIMITIVE_SLICER);
        Activity p12 = pFactory.newActivity(this.q("a12"), "Slicer 3");
        pFactory.addType((HasType)p12, PRIMITIVE_SLICER);
        Activity p13 = pFactory.newActivity(this.q("a13"), "Convert 1");
        pFactory.addType((HasType)p13, PRIMITIVE_CONVERT);
        Activity p14 = pFactory.newActivity(this.q("a14"), "Convert 2");
        pFactory.addType((HasType)p14, PRIMITIVE_CONVERT);
        Activity p15 = pFactory.newActivity(this.q("a15"), "Convert 3");
        pFactory.addType((HasType)p15, PRIMITIVE_CONVERT);
        Agent ag1 = pFactory.newAgent(this.q("ag1"), "John Doe");
        Entity a1 = this.newFile(pFactory, "e1", "Reference Image", "reference.img", inputLocation);
        Entity a2 = this.newFile(pFactory, "e2", "Reference Header", "reference.hdr", inputLocation);
        Entity a3 = this.newFile(pFactory, "e3", "Anatomy I1", "anatomy1.img", inputLocation);
        Entity a4 = this.newFile(pFactory, "e4", "Anatomy H1", "anatomy1.hdr", inputLocation);
        Entity a5 = this.newFile(pFactory, "e5", "Anatomy I2", "anatomy2.img", inputLocation);
        Entity a6 = this.newFile(pFactory, "e6", "Anatomy H2", "anatomy2.hdr", inputLocation);
        Entity a7 = this.newFile(pFactory, "e7", "Anatomy I3", "anatomy3.img", inputLocation);
        Entity a8 = this.newFile(pFactory, "e8", "Anatomy H3", "anatomy3.hdr", inputLocation);
        Entity a9 = this.newFile(pFactory, "e9", "Anatomy I4", "anatomy4.img", inputLocation);
        Entity a10 = this.newFile(pFactory, "e10", "Anatomy H4", "anatomy4.hdr", inputLocation);
        Entity a11 = this.newFile(pFactory, "e11", "Warp Params1", "warp1.warp", outputLocation);
        Entity a12 = this.newFile(pFactory, "e12", "Warp Params2", "warp2.warp", outputLocation);
        Entity a13 = this.newFile(pFactory, "e13", "Warp Params3", "warp3.warp", outputLocation);
        Entity a14 = this.newFile(pFactory, "e14", "Warp Params4", "warp4.warp", outputLocation);
        Entity a15 = this.newFile(pFactory, "e15", "Resliced I1", "resliced1.img", outputLocation);
        Entity a16 = this.newFile(pFactory, "e16", "Resliced H1", "resliced1.hdr", outputLocation);
        Entity a17 = this.newFile(pFactory, "e17", "Resliced I2", "resliced2.img", outputLocation);
        Entity a18 = this.newFile(pFactory, "e18", "Resliced H2", "resliced2.hdr", outputLocation);
        Entity a19 = this.newFile(pFactory, "e19", "Resliced I3", "resliced3.img", outputLocation);
        Entity a20 = this.newFile(pFactory, "e20", "Resliced H3", "resliced3.hdr", outputLocation);
        Entity a21 = this.newFile(pFactory, "e21", "Resliced I4", "resliced4.img", outputLocation);
        Entity a22 = this.newFile(pFactory, "e22", "Resliced H4", "resliced4.hdr", outputLocation);
        Entity a23 = this.newFile(pFactory, "e23", "Atlas Image", "atlas.img", outputLocation);
        Entity a24 = this.newFile(pFactory, "e24", "Atlas Header", "atlas.hdr", outputLocation);
        Entity a25 = this.newFile(pFactory, "e25", "Atlas X Slice", "atlas-x.pgm", outputLocation);
        Entity a25p = this.newParameter(pFactory, "e25p", "slicer param 1", "-x .5");
        Entity a26p = this.newParameter(pFactory, "e26p", "slicer param 2", "-y .5");
        Entity a27p = this.newParameter(pFactory, "e27p", "slicer param 3", "-z .5");
        Entity a26 = this.newFile(pFactory, "e26", "Atlas Y Slice", "atlas-y.pgm", outputLocation);
        Entity a27 = this.newFile(pFactory, "e27", "Atlas Z Slice", "atlas-z.pgm", outputLocation);
        Entity a28 = this.newFile(pFactory, "e28", "Atlas X Graphic", "atlas-x.gif", outputLocation);
        Entity a29 = this.newFile(pFactory, "e29", "Atlas Y Graphic", "atlas-y.gif", outputLocation);
        Entity a30 = this.newFile(pFactory, "e30", "Atlas Z Graphic", "atlas-z.gif", outputLocation);
        Used u1 = this.newUsed(p1, "img", a3);
        Used u2 = this.newUsed(p1, "hdr", a4);
        Used u3 = this.newUsed(p1, "imgRef", a1);
        u3.setId(this.q("u3"));
        Used u4 = this.newUsed(p1, "hdrRef", a2);
        Used u5 = this.newUsed(p2, "img", a5);
        Used u6 = this.newUsed(p2, "hdr", a6);
        Used u7 = this.newUsed(p2, "imgRef", a1);
        Used u8 = this.newUsed(p2, "hdrRef", a2);
        Used u9 = this.newUsed(p3, "img", a7);
        Used u10 = this.newUsed(p3, "hdr", a8);
        Used u11 = this.newUsed(p3, "imgRef", a1);
        Used u12 = this.newUsed(p3, "hdrRef", a2);
        Used u13 = this.newUsed(p4, "img", a9);
        Used u14 = this.newUsed(p4, "hdr", a10);
        Used u15 = this.newUsed(p4, "imgRef", a1);
        Used u16 = this.newUsed(p4, "hdrRef", a2);
        Used u17 = this.newUsed(p5, "in", a11);
        Used u18 = this.newUsed(p6, "in", a12);
        Used u19 = this.newUsed(p7, "in", a13);
        Used u20 = this.newUsed(p8, "in", a14);
        Used u21 = this.newUsed(p9, "i1", a15);
        Used u22 = this.newUsed(p9, "h1", a16);
        Used u23 = this.newUsed(p9, "i2", a17);
        Used u24 = this.newUsed(p9, "h2", a18);
        Used u25 = this.newUsed(p9, "i3", a19);
        Used u26 = this.newUsed(p9, "h3", a20);
        Used u27 = this.newUsed(p9, "i4", a21);
        Used u28 = this.newUsed(p9, "h4", a22);
        Used u29 = this.newUsed(p10, "img", a23);
        Used u30 = this.newUsed(p10, "hdr", a24);
        Used u30p = this.newUsed(p10, "param", a25p);
        Used u31 = this.newUsed(p11, "img", a23);
        Used u32 = this.newUsed(p11, "hdr", a24);
        Used u32p = this.newUsed(p11, "param", a26p);
        Used u33 = this.newUsed(p12, "img", a23);
        Used u34 = this.newUsed(p12, "hdr", a24);
        Used u34p = this.newUsed(p12, "param", a27p);
        Used u35 = this.newUsed(p13, "in", a25);
        Used u36 = this.newUsed(p14, "in", a26);
        Used u37 = this.newUsed(p15, "in", a27);
        WasGeneratedBy wg1 = pFactory.newWasGeneratedBy(this.q("wgb1"), a11, "out", p1);
        WasGeneratedBy wg2 = pFactory.newWasGeneratedBy(a12, "out", p2);
        WasGeneratedBy wg3 = pFactory.newWasGeneratedBy(a13, "out", p3);
        WasGeneratedBy wg4 = pFactory.newWasGeneratedBy(a14, "out", p4);
        WasGeneratedBy wg5 = pFactory.newWasGeneratedBy(a15, "img", p5);
        WasGeneratedBy wg6 = pFactory.newWasGeneratedBy(a16, "hdr", p5);
        WasGeneratedBy wg7 = pFactory.newWasGeneratedBy(a17, "img", p6);
        WasGeneratedBy wg8 = pFactory.newWasGeneratedBy(a18, "hdr", p6);
        WasGeneratedBy wg9 = pFactory.newWasGeneratedBy(a19, "img", p7);
        WasGeneratedBy wg10 = pFactory.newWasGeneratedBy(a20, "hdr", p7);
        WasGeneratedBy wg11 = pFactory.newWasGeneratedBy(a21, "img", p8);
        WasGeneratedBy wg12 = pFactory.newWasGeneratedBy(a22, "hdr", p8);
        WasGeneratedBy wg13 = pFactory.newWasGeneratedBy(a23, "img", p9);
        WasGeneratedBy wg14 = pFactory.newWasGeneratedBy(a24, "hdr", p9);
        WasGeneratedBy wg15 = pFactory.newWasGeneratedBy(a25, "out", p10);
        WasGeneratedBy wg16 = pFactory.newWasGeneratedBy(a26, "out", p11);
        WasGeneratedBy wg17 = pFactory.newWasGeneratedBy(a27, "out", p12);
        WasGeneratedBy wg18 = pFactory.newWasGeneratedBy(a28, "out", p13);
        WasGeneratedBy wg19 = pFactory.newWasGeneratedBy(a29, "out", p14);
        WasGeneratedBy wg20 = pFactory.newWasGeneratedBy(a30, "out", p15);
        wg18.setTime(pFactory.newTimeNow());
        wg19.setTime(pFactory.newTimeNow());
        wg20.setTime(pFactory.newTimeNow());
        WasDerivedFrom wd1 = this.newWasDerivedFrom(a11, a1);
        wd1.setActivity(p1.getId());
        wd1.setGeneration(wg1.getId());
        wd1.setUsage(u3.getId());
        WasDerivedFrom wd2 = this.newWasDerivedFrom(a11, a2);
        WasDerivedFrom wd3 = this.newWasDerivedFrom(a11, a3);
        WasDerivedFrom wd4 = this.newWasDerivedFrom(a11, a4);
        WasDerivedFrom wd5 = this.newWasDerivedFrom(a12, a1);
        WasDerivedFrom wd6 = this.newWasDerivedFrom(a12, a2);
        WasDerivedFrom wd7 = this.newWasDerivedFrom(a12, a5);
        WasDerivedFrom wd8 = this.newWasDerivedFrom(a12, a6);
        WasDerivedFrom wd9 = this.newWasDerivedFrom(a13, a1);
        WasDerivedFrom wd10 = this.newWasDerivedFrom(a13, a2);
        WasDerivedFrom wd11 = this.newWasDerivedFrom(a13, a7);
        WasDerivedFrom wd12 = this.newWasDerivedFrom(a13, a8);
        WasDerivedFrom wd13 = this.newWasDerivedFrom(a14, a1);
        WasDerivedFrom wd14 = this.newWasDerivedFrom(a14, a2);
        WasDerivedFrom wd15 = this.newWasDerivedFrom(a14, a9);
        WasDerivedFrom wd16 = this.newWasDerivedFrom(a14, a10);
        WasDerivedFrom wd17 = this.newWasDerivedFrom(a15, a11);
        WasDerivedFrom wd18 = this.newWasDerivedFrom(a16, a11);
        WasDerivedFrom wd19 = this.newWasDerivedFrom(a17, a12);
        WasDerivedFrom wd20 = this.newWasDerivedFrom(a18, a12);
        WasDerivedFrom wd21 = this.newWasDerivedFrom(a19, a13);
        WasDerivedFrom wd22 = this.newWasDerivedFrom(a20, a13);
        WasDerivedFrom wd23 = this.newWasDerivedFrom(a21, a14);
        WasDerivedFrom wd24 = this.newWasDerivedFrom(a22, a14);
        WasDerivedFrom wd25 = this.newWasDerivedFrom(a23, a15);
        WasDerivedFrom wd26 = this.newWasDerivedFrom(a23, a16);
        WasDerivedFrom wd27 = this.newWasDerivedFrom(a23, a17);
        WasDerivedFrom wd28 = this.newWasDerivedFrom(a23, a18);
        WasDerivedFrom wd29 = this.newWasDerivedFrom(a23, a19);
        WasDerivedFrom wd30 = this.newWasDerivedFrom(a23, a20);
        WasDerivedFrom wd31 = this.newWasDerivedFrom(a23, a21);
        WasDerivedFrom wd32 = this.newWasDerivedFrom(a23, a22);
        WasDerivedFrom wd33 = this.newWasDerivedFrom(a24, a15);
        WasDerivedFrom wd34 = this.newWasDerivedFrom(a24, a16);
        WasDerivedFrom wd35 = this.newWasDerivedFrom(a24, a17);
        WasDerivedFrom wd36 = this.newWasDerivedFrom(a24, a18);
        WasDerivedFrom wd37 = this.newWasDerivedFrom(a24, a19);
        WasDerivedFrom wd38 = this.newWasDerivedFrom(a24, a20);
        WasDerivedFrom wd39 = this.newWasDerivedFrom(a24, a21);
        WasDerivedFrom wd40 = this.newWasDerivedFrom(a24, a22);
        WasDerivedFrom wd41 = this.newWasDerivedFrom(a25, a23);
        WasDerivedFrom wd42 = this.newWasDerivedFrom(a25, a24);
        WasDerivedFrom wd43 = this.newWasDerivedFrom(a26, a23);
        WasDerivedFrom wd44 = this.newWasDerivedFrom(a26, a24);
        WasDerivedFrom wd45 = this.newWasDerivedFrom(a27, a23);
        WasDerivedFrom wd46 = this.newWasDerivedFrom(a27, a24);
        WasDerivedFrom wd47 = this.newWasDerivedFrom(a28, a25);
        WasDerivedFrom wd48 = this.newWasDerivedFrom(a29, a26);
        WasDerivedFrom wd49 = this.newWasDerivedFrom(a30, a27);
        WasAssociatedWith waw1 = pFactory.newWasAssociatedWith(this.q("waw1"), p1.getId(), ag1.getId());
        Document graph = pFactory.newDocument(new Activity[]{p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15}, new Entity[]{a1, a2, a5, a6, a3, a4, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a25p, a26, a26p, a27, a27p, a28, a29, a30}, new Agent[]{ag1}, new Statement[]{u1, u2, u3, u4, u5, u6, u7, u8, u9, u10, u11, u12, u13, u14, u15, u16, u17, u18, u19, u20, u21, u22, u23, u24, u25, u26, u27, u28, u29, u30, u31, u32, u33, u34, u30p, u32p, u34p, u35, u36, u37, wg1, wg2, wg3, wg4, wg5, wg6, wg7, wg8, wg9, wg10, wg11, wg12, wg13, wg14, wg15, wg16, wg17, wg18, wg19, wg20, wd1, wd2, wd3, wd4, wd5, wd6, wd7, wd8, wd9, wd10, wd11, wd12, wd13, wd14, wd15, wd16, wd17, wd18, wd19, wd20, wd21, wd22, wd23, wd24, wd25, wd26, wd27, wd28, wd29, wd30, wd31, wd32, wd33, wd34, wd35, wd36, wd37, wd38, wd39, wd40, wd41, wd42, wd43, wd44, wd45, wd46, wd47, wd48, wd49, waw1});
        graph.setNamespace(Namespace.gatherNamespaces((Document)graph));
        return graph;
    }

    public void subtestCopyPC1Full() throws IOException {
        Document c;
        graph2 = c = ExtensionRoundTripFromJavaTest.deepCopy(graph1);
        PC1FullTest.assertEquals((String)"self graph1 differ", (Object)graph1, (Object)graph1);
        PC1FullTest.assertEquals((String)"self graph2 differ", (Object)graph2, (Object)graph2);
        PC1FullTest.assertEquals((String)"graph1 and graph2 differ", (Object)graph1, (Object)graph2);
    }

    static {
        FILE_LOCATION = "/shomewhere/pc1/";
        URL_LOCATION = "http://www.ipaw.info/challenge/";
        PRIMITIVE_ALIGN_WARP = pFactory.newQualifiedName(PRIM_NS, "align_warp", PRIM_PREFIX);
        PRIMITIVE_RESLICE = pFactory.newQualifiedName(PRIM_NS, "reslice", PRIM_PREFIX);
        PRIMITIVE_SOFTMEAN = pFactory.newQualifiedName(PRIM_NS, "softmean", PRIM_PREFIX);
        PRIMITIVE_CONVERT = pFactory.newQualifiedName(PRIM_NS, "convert", PRIM_PREFIX);
        PRIMITIVE_SLICER = pFactory.newQualifiedName(PRIM_NS, "slicer", PRIM_PREFIX);
    }
}

