/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import junit.framework.TestCase;
import org.openprovenance.prov.model.QualifiedNameUtils;

public class QualifiedNameTest
extends TestCase {
    QualifiedNameUtils u = new QualifiedNameUtils();

    public QualifiedNameTest(String name) {
        super(name);
    }

    boolean doEscape(String in, String out) {
        String val = this.u.escapeProvLocalName(in);
        System.err.println("Escape " + in + " " + val);
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch(out));
        return val.equals(out);
    }

    boolean doUnescape(String out, String in) {
        String val = this.u.unescapeProvLocalName(in);
        System.err.println("Unescape " + in + " " + val);
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch(in));
        return val.equals(out);
    }

    boolean doEscapeUnicode(String in, String out) {
        String val = this.u.escapeUnicode(in);
        System.err.println("Escape Unicode " + in + " " + val);
        return val.equals(out);
    }

    boolean doUnescapeUnicode(String out, String in) {
        String val = this.u.unescapeUnicode(in);
        System.err.println("Unescape " + in + " " + val);
        return val.equals(out);
    }

    boolean doRT1(String in) {
        String val = this.u.unescapeProvLocalName(this.u.escapeProvLocalName(in));
        System.err.println("RT1 " + in + " " + val);
        return val.equals(in);
    }

    boolean doRT2(String in) {
        String val = this.u.escapeProvLocalName(this.u.unescapeProvLocalName(in));
        System.err.println("RT2 " + in + " " + val);
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch(in));
        return val.equals(in);
    }

    public void testEscape1() {
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01bc", "a01bc"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b=c", "a01b\\=c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b'c", "a01b\\'c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b(c", "a01b\\(c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b)c", "a01b\\)c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b,c", "a01b\\,c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b-c", "a01b-c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b:c", "a01b\\:c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b;c", "a01b\\;c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b[c", "a01b\\[c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b]c", "a01b\\]c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01b.c", "a01b.c"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("a01bc.", "a01bc\\."));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("-", "\\-"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("='(),-:;[].a", "\\=\\'\\(\\)\\,-\\:\\;\\[\\].a"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("?a=b", "?a\\=b"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("?user=ima3", "?user\\=ima3"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("55348dff-4fcc-4ac2-ab56-641798c64400", "55348dff-4fcc-4ac2-ab56-641798c64400"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("news/world-asia-17507976", "news/world-asia-17507976"));
        QualifiedNameTest.assertTrue((boolean)this.doEscape("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d"));
    }

    public void testUnescape1() {
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01bc", "a01bc"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b=c", "a01b\\=c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b'c", "a01b\\'c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b(c", "a01b\\(c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b)c", "a01b\\)c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b,c", "a01b\\,c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b-c", "a01b-c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b:c", "a01b\\:c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b;c", "a01b\\;c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b[c", "a01b\\[c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b]c", "a01b\\]c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b.c", "a01b\\.c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01b.c", "a01b.c"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("a01bc.", "a01bc\\."));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("='(),-:;[].", "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\."));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("?a=b", "?a\\=b"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("55348dff-4fcc-4ac2-ab56-641798c64400", "55348dff-4fcc-4ac2-ab56-641798c64400"));
        QualifiedNameTest.assertTrue((boolean)this.doUnescape("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d"));
    }

    public void testRoundTripFromUnescaped() {
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01bc"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b\\c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b=c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b'c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b(c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b)c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b,c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b-c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b:c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b;c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b[c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b]c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("a01b.c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1(".a01bc"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("-"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("='(),-:;[]."));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("?a=b"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("55348dff-4fcc-4ac2-ab56-641798c64400"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("news/world-asia1-17507976"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d"));
        QualifiedNameTest.assertTrue((boolean)this.doRT1("application/6/subject/byURI/smartshare%2Fdirk/"));
    }

    public void testRoundTripFromEscaped() {
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01bc"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b\\=c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b\\'c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b\\(c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b\\)c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b\\,c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b-c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b\\:c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b\\;c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b\\[c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b\\]c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("a01b.c"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("\\=\\'\\(\\)\\,-\\:\\;\\[\\].a"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("?a\\=b"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("55348dff-4fcc-4ac2-ab56-641798c64400"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("foo?a\\=1"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("\\-"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("?fred\\=fish20soup"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("?fred\\=fish%20soup"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("news/world-asia-17507976"));
        QualifiedNameTest.assertTrue((boolean)this.doRT2("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d"));
    }

    public void testPattern1() {
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch("/@~&+*?#$!"));
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch("ab"));
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch("01"));
        QualifiedNameTest.assertFalse((boolean)this.u.patternExactMatch("."));
        QualifiedNameTest.assertFalse((boolean)this.u.patternExactMatch("01."));
        QualifiedNameTest.assertFalse((boolean)this.u.patternExactMatch("01[]b"));
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch("abc\\[\\]b"));
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch("_"));
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch("ab_"));
        QualifiedNameTest.assertTrue((boolean)this.u.patternExactMatch("ab___"));
    }

    public void testEscapeUnicode1() {
        QualifiedNameTest.assertTrue((boolean)this.doEscapeUnicode("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\\u02FF\\u0370\\u037D"));
    }

    public void testUnescapeUnicode1() {
        QualifiedNameTest.assertTrue((boolean)this.doUnescapeUnicode("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\\u02FF\\u0370\\u037D"));
    }
}

