/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.util.Arrays;
import java.util.LinkedList;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasLocation;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.HasValue;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvFrameworkTest;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;

public class RoundTripFromJavaTest
extends ProvFrameworkTest {
    public static final String EX2_NS = "http://example2.org/";
    public static final String EX2_PREFIX = "ex2";
    public static final String EX3_NS = "http://example3.org/";
    public static final String NS_DEFAULT = "http://example.org/test/";
    public boolean test = true;
    String problematic = "?a\\=b";

    @Override
    public boolean checkTest(String name) {
        return false;
    }

    @Override
    public boolean checkSchema(String name) {
        return !name.endsWith("SOME PROBLEMATIC TEST" + this.extension());
    }

    public QualifiedName qInnerAsEx(String n) {
        return pFactory.newQualifiedName("http://example.org/inner/", n, "ex");
    }

    public QualifiedName qOuterAsEx(String n) {
        return pFactory.newQualifiedName("http://example.org/outer/", n, "ex");
    }

    public QualifiedName qInner(String n) {
        return pFactory.newQualifiedName("http://example.org/inner/", n, "inner");
    }

    public QualifiedName qOuter(String n) {
        return pFactory.newQualifiedName("http://example.org/outer/", n, "outer");
    }

    public QualifiedName qDefault(String n) {
        return pFactory.newQualifiedName(NS_DEFAULT, n, null);
    }

    public void testRoles() {
        Role r1 = pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING);
        Role r2 = pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING);
        Location l1 = pFactory.newLocation((Object)"otherLocation", RoundTripFromJavaTest.name.XSD_STRING);
        Location l2 = pFactory.newLocation((Object)"otherLocation", RoundTripFromJavaTest.name.XSD_STRING);
        RoundTripFromJavaTest.assertEquals((Object)r1, (Object)r2);
        RoundTripFromJavaTest.assertEquals((Object)l1, (Object)l2);
    }

    public void testEntity0() {
        Entity a = pFactory.newEntity(this.q("e0"));
        a.getOther().add(pFactory.newOther(pFactory.newQualifiedName("http://example.org/", "tag2", "ex"), (Object)pFactory.newInternationalizedString("bonjour", "fr"), RoundTripFromJavaTest.name.PROV_LANG_STRING));
        if (this.test) {
            a.getLocation().add(pFactory.newLocation((Object)"un llieu", RoundTripFromJavaTest.name.XSD_STRING));
            a.getLocation().add(pFactory.newLocation((Object)1, RoundTripFromJavaTest.name.XSD_INT));
            a.getLocation().add(pFactory.newLocation((Object)2.0, RoundTripFromJavaTest.name.XSD_DOUBLE));
            a.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
            Location loc = pFactory.newLocation((Object)2L, RoundTripFromJavaTest.name.XSD_LONG);
            a.getLocation().add(loc);
        }
        this.makeDocAndTest((Statement)a, "target/entity0");
    }

    public void testEntity1() {
        Entity a = pFactory.newEntity(this.q("e1"));
        this.makeDocAndTest((Statement)a, "target/entity1");
    }

    public void testEntity2() {
        Entity a = pFactory.newEntity(this.q("e2"), "entity2");
        this.makeDocAndTest((Statement)a, "target/entity2");
    }

    public void testEntity3() {
        Entity a = pFactory.newEntity(this.q("e3"), "entity3");
        this.addValue((HasValue)a);
        this.makeDocAndTest((Statement)a, "target/entity3");
    }

    public void testEntity4() {
        Entity a = pFactory.newEntity(this.q("e4"), "entity4");
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/entity4");
    }

    public void testEntity5() {
        Entity a = pFactory.newEntity(this.q("e5"), "entity5");
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/entity5");
    }

    public void testEntity6() {
        Entity a = pFactory.newEntity(this.q("e6"), "entity6");
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/entity6");
    }

    public void testEntity7() {
        Entity a = pFactory.newEntity(this.q("e7"), "entity7");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/entity7");
    }

    public void testEntity8() {
        Entity a = pFactory.newEntity(this.q("e8"), "entity8");
        this.addTypes((HasType)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/entity8");
    }

    public void testEntity9() {
        Entity a = pFactory.newEntity(this.q("e9"), "entity9");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addFurtherAttributes((HasOther)a);
        this.makeDocAndTest((Statement)a, "target/entity9");
    }

    public void testEntity10() {
        Entity a = pFactory.newEntity(this.q("e10"), "entity10");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addFurtherAttributes((HasOther)a);
        this.makeDocAndTest((Statement)a, "target/entity10");
    }

    public void NOtestEntity100() {
        Entity e = pFactory.newEntity(this.q("100-generalEntity"), "entity100");
        e.getOther().add(pFactory.newOther("http://example.org/", "a01b\\[c", "ex", (Object)pFactory.newQualifiedName(EX2_NS, "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "a01bc", "ex", (Object)pFactory.newQualifiedName(EX2_NS, "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "unicode", "ex", (Object)pFactory.newQualifiedName(EX2_NS, "\u00c0-\u00d6\u00d8-\u00f6\u00f8-", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-", "ex", (Object)pFactory.newQualifiedName(EX2_NS, "unicode", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", this.problematic, "ex", (Object)1, RoundTripFromJavaTest.name.XSD_INT));
        e.getOther().add(pFactory.newOther("http://example.org/", "123", "ex", (Object)"mystring", RoundTripFromJavaTest.name.XSD_STRING));
        e.getOther().add(pFactory.newOther("http://example.org/", "123", "ex", (Object)pFactory.newInternationalizedString("ma chaine", "fr"), RoundTripFromJavaTest.name.PROV_LANG_STRING));
        this.makeDocAndTest((Statement)e, "target/entity100");
    }

    public void testEntity101() {
        Entity e = pFactory.newEntity(this.q("101-generalEntity"), "entity101");
        e.getOther().add(pFactory.newOther("http://example.org/", "a01b\\[c", "ex", (Object)pFactory.newQualifiedName(EX2_NS, "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "a01bc", "ex", (Object)pFactory.newQualifiedName(EX2_NS, "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "unicode", "ex", (Object)pFactory.newQualifiedName(EX2_NS, "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-", "ex", (Object)pFactory.newQualifiedName(EX2_NS, "unicode", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", this.problematic, "ex", (Object)1, RoundTripFromJavaTest.name.XSD_INT));
        e.getOther().add(pFactory.newOther("http://example.org/", "123", "ex", (Object)"mystring", RoundTripFromJavaTest.name.XSD_STRING));
        e.getOther().add(pFactory.newOther("http://example.org/", "123", "ex", (Object)pFactory.newInternationalizedString("ma chaine", "fr"), RoundTripFromJavaTest.name.PROV_LANG_STRING));
        this.makeDocAndTest((Statement)e, "target/entity101");
    }

    public void testDocument1() {
        Activity a = pFactory.newActivity(this.q("a1"));
        this.makeDocAndTest(new Statement[0], null, "target/document1");
    }

    public void testActivity1() {
        Activity a = pFactory.newActivity(this.q("a1"));
        this.makeDocAndTest((Statement)a, "target/activity1");
    }

    public void testActivity2() {
        Activity a = pFactory.newActivity(this.q("a2"), "activity2");
        this.makeDocAndTest((Statement)a, "target/activity2");
    }

    public void testActivity3() {
        Activity a = pFactory.newActivity(this.q("a1"));
        a.setStartTime(pFactory.newTimeNow());
        a.setEndTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)a, "target/activity3");
    }

    public void testActivity4() {
        Activity a = pFactory.newActivity(this.q("a2"), "activity2");
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/activity4");
    }

    public void testActivity5() {
        Activity a = pFactory.newActivity(this.q("a5"), "activity5");
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/activity5");
    }

    public void testActivity6() {
        Activity a = pFactory.newActivity(this.q("a6"), "activity6");
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/activity6");
    }

    public void testActivity7() {
        Activity a = pFactory.newActivity(this.q("a7"), "activity7");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/activity7");
    }

    public void testActivity8() {
        Activity a = pFactory.newActivity(this.q("a8"), "activity8");
        a.setStartTime(pFactory.newTimeNow());
        a.setEndTime(pFactory.newTimeNow());
        this.addTypes((HasType)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/activity8");
    }

    public void testActivity9() {
        Activity a = pFactory.newActivity(this.q("a9"), "activity9");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addFurtherAttributes((HasOther)a);
        this.makeDocAndTest((Statement)a, "target/activity9");
    }

    public void testAgent1() {
        Agent a = pFactory.newAgent(this.q("ag1"));
        this.makeDocAndTest((Statement)a, "target/agent1");
    }

    public void testAgent2() {
        Agent a = pFactory.newAgent(this.q("ag2"), "agent2");
        this.makeDocAndTest((Statement)a, "target/agent2");
    }

    public void testAgent3() {
        Agent a = pFactory.newAgent(this.q("ag2"), "agent2");
        a.getLabel().add(pFactory.newInternationalizedString("hello"));
        this.makeDocAndTest((Statement)a, "target/agent3");
    }

    public void testAgent4() {
        Agent a = pFactory.newAgent(this.q("ag2"), "agent2");
        a.getLabel().add(pFactory.newInternationalizedString("hello"));
        a.getLabel().add(pFactory.newInternationalizedString("bye", "en"));
        this.makeDocAndTest((Statement)a, "target/agent4");
    }

    public void testAgent5() {
        Agent a = pFactory.newAgent(this.q("ag2"), "agent2");
        a.getLabel().add(pFactory.newInternationalizedString("hello"));
        a.getLabel().add(pFactory.newInternationalizedString("bye", "en"));
        a.getLabel().add(pFactory.newInternationalizedString("bonjour", "fr"));
        this.makeDocAndTest((Statement)a, "target/agent5");
    }

    public void testAgent6() {
        Agent a = pFactory.newAgent(this.q("ag6"), "agent6");
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/agent6");
    }

    public void testAgent7() {
        Agent a = pFactory.newAgent(this.q("ag7"), "agent7");
        this.addTypes((HasType)a);
        a.getLabel().add(pFactory.newInternationalizedString("hello"));
        a.getLabel().add(pFactory.newInternationalizedString("bye", "en"));
        a.getLabel().add(pFactory.newInternationalizedString("bonjour", "fr"));
        a.getLocation().add(pFactory.newLocation((Object)"London", RoundTripFromJavaTest.name.XSD_STRING));
        a.getLocation().add(pFactory.newLocation((Object)1, RoundTripFromJavaTest.name.XSD_INT));
        a.getLocation().add(pFactory.newLocation((Object)1.0, RoundTripFromJavaTest.name.XSD_FLOAT));
        a.getLocation().add(pFactory.newLocation((Object)true, RoundTripFromJavaTest.name.XSD_BOOLEAN));
        a.getLocation().add(pFactory.newLocation((Object)pFactory.newTimeNow(), RoundTripFromJavaTest.name.XSD_DATETIME));
        a.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
        this.makeDocAndTest((Statement)a, "target/agent7");
    }

    public void testAgent8() {
        Agent a = pFactory.newAgent(this.q("ag8"), "agent8");
        this.addTypes((HasType)a);
        this.addTypes((HasType)a);
        a.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
        a.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
        this.makeDocAndTest((Statement)a, "target/agent8");
    }

    public void testGeneration1() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen1"), this.q("e1"), null, null);
        this.makeDocAndTest((Statement)gen, "target/generation1");
    }

    public void testGeneration2() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen2"), this.q("e1"), null, this.q("a1"));
        this.makeDocAndTest((Statement)gen, "target/generation2");
    }

    public void testGeneration3() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen3"), this.q("e1"), "somerole", this.q("a1"));
        gen.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)gen, "target/generation3");
    }

    public void testGeneration4() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen4"), this.q("e1"), "somerole", this.q("a1"));
        gen.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)gen, "target/generation4");
    }

    public void testGeneration5() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen4"), this.q("e1"), "somerole", this.q("a1"));
        gen.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)gen);
        this.addLocations((HasLocation)gen);
        this.addLabels((HasLabel)gen);
        this.addFurtherAttributes((HasOther)gen);
        this.makeDocAndTest((Statement)gen, "target/generation5");
    }

    public void testGeneration6() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), null, this.q("a1"));
        this.makeDocAndTest((Statement)gen, "target/generation6");
    }

    public void testGeneration7() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), "somerole", this.q("a1"));
        gen.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)gen);
        this.addLocations((HasLocation)gen);
        this.addLabels((HasLabel)gen);
        this.addFurtherAttributes((HasOther)gen);
        this.makeDocAndTest((Statement)gen, "target/generation7");
    }

    public void testUsage1() {
        Used use = pFactory.newUsed(this.q("use1"), null, null, this.q("e1"));
        this.makeDocAndTest((Statement)use, "target/usage1");
    }

    public void testUsage2() {
        Used use = pFactory.newUsed(this.q("use2"), this.q("a1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)use, "target/usage2");
    }

    public void testUsage3() {
        Used use = pFactory.newUsed(this.q("use3"), this.q("a1"), "somerole", this.q("e1"));
        use.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)use, "target/usage3");
    }

    public void testUsage4() {
        Used use = pFactory.newUsed(this.q("use4"), this.q("a1"), "somerole", this.q("e1"));
        use.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)use, "target/usage4");
    }

    public void testUsage5() {
        Used use = pFactory.newUsed(this.q("use5"), this.q("a1"), "somerole", this.q("e1"));
        use.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)use);
        this.addLocations((HasLocation)use);
        this.addLabels((HasLabel)use);
        this.addFurtherAttributes((HasOther)use);
        this.makeDocAndTest((Statement)use, "target/usage5");
    }

    public void testUsage6() {
        Used use = pFactory.newUsed((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)use, "target/usage6");
    }

    public void testUsage7() {
        Used use = pFactory.newUsed((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), "somerole", this.q("e1"));
        use.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)use);
        this.addLocations((HasLocation)use);
        this.addLabels((HasLabel)use);
        this.addFurtherAttributes((HasOther)use);
        this.makeDocAndTest((Statement)use, "target/usage7");
    }

    public void testInvalidation1() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv1"), this.q("e1"), null);
        this.makeDocAndTest((Statement)inv, "target/invalidation1");
    }

    public void testInvalidation2() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv2"), this.q("e1"), this.q("a1"));
        this.makeDocAndTest((Statement)inv, "target/invalidation2");
    }

    public void testInvalidation3() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv3"), this.q("e1"), this.q("a1"));
        inv.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        inv.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)inv, "target/invalidation3");
    }

    public void testInvalidation4() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv4"), this.q("e1"), this.q("a1"));
        inv.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        inv.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)inv, "target/invalidation4");
    }

    public void testInvalidation5() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv4"), this.q("e1"), this.q("a1"));
        inv.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        inv.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)inv);
        this.addLocations((HasLocation)inv);
        this.addLabels((HasLabel)inv);
        this.addFurtherAttributes((HasOther)inv);
        this.makeDocAndTest((Statement)inv, "target/invalidation5");
    }

    public void testInvalidation6() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), this.q("a1"));
        this.makeDocAndTest((Statement)inv, "target/invalidation6");
    }

    public void testInvalidation7() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), this.q("a1"));
        inv.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        inv.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)inv);
        this.addLocations((HasLocation)inv);
        this.addLabels((HasLabel)inv);
        this.addFurtherAttributes((HasOther)inv);
        this.makeDocAndTest((Statement)inv, "target/invalidation7");
    }

    public void testStart1() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)start, "target/start1");
    }

    public void testStart2() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start2"), this.q("a1"), this.q("e1"));
        this.makeDocAndTest((Statement)start, "target/start2");
    }

    public void testStart3() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start3"), this.q("a1"), null);
        this.makeDocAndTest((Statement)start, "target/start3");
    }

    public void testStart4() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start4"), null, this.q("e1"));
        start.setStarter(this.q("a2"));
        this.makeDocAndTest((Statement)start, "target/start4");
    }

    public void testStart5() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start5"), this.q("a1"), this.q("e1"));
        start.setStarter(this.q("a2"));
        this.makeDocAndTest((Statement)start, "target/start5");
    }

    public void testStart6() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start6"), this.q("a1"), null);
        start.setStarter(this.q("a2"));
        this.makeDocAndTest((Statement)start, "target/start6");
    }

    public void testStart7() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start7"), this.q("a1"), null);
        start.setStarter(this.q("a2"));
        start.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)start, "target/start7");
    }

    public void testStart8() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start8"), this.q("a1"), null);
        start.setStarter(this.q("a2"));
        start.setTime(pFactory.newTimeNow());
        start.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        start.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.addTypes((HasType)start);
        this.addLocations((HasLocation)start);
        this.addLabels((HasLabel)start);
        this.addFurtherAttributes((HasOther)start);
        this.makeDocAndTest((Statement)start, "target/start8");
    }

    public void testStart9() {
        WasStartedBy start = pFactory.newWasStartedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), this.q("e1"));
        this.makeDocAndTest((Statement)start, "target/start9");
    }

    public void testStart10() {
        WasStartedBy start = pFactory.newWasStartedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), null);
        start.setStarter(this.q("a2"));
        start.setTime(pFactory.newTimeNow());
        start.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        start.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.addTypes((HasType)start);
        this.addLocations((HasLocation)start);
        this.addLabels((HasLabel)start);
        this.addFurtherAttributes((HasOther)start);
        this.makeDocAndTest((Statement)start, "target/start10");
    }

    public void testEnd1() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)end, "target/end1");
    }

    public void testEnd2() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end2"), this.q("a1"), this.q("e1"));
        this.makeDocAndTest((Statement)end, "target/end2");
    }

    public void testEnd3() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end3"), this.q("a1"), null);
        this.makeDocAndTest((Statement)end, "target/end3");
    }

    public void testEnd4() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end4"), null, this.q("e1"));
        end.setEnder(this.q("a2"));
        this.makeDocAndTest((Statement)end, "target/end4");
    }

    public void testEnd5() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end5"), this.q("a1"), this.q("e1"));
        end.setEnder(this.q("a2"));
        this.makeDocAndTest((Statement)end, "target/end5");
    }

    public void testEnd6() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end6"), this.q("a1"), null);
        end.setEnder(this.q("a2"));
        this.makeDocAndTest((Statement)end, "target/end6");
    }

    public void testEnd7() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end7"), this.q("a1"), null);
        end.setEnder(this.q("a2"));
        end.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)end, "target/end7");
    }

    public void testEnd8() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end8"), this.q("a1"), null);
        end.setEnder(this.q("a2"));
        end.setTime(pFactory.newTimeNow());
        end.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        end.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.addTypes((HasType)end);
        this.addLocations((HasLocation)end);
        this.addLabels((HasLabel)end);
        this.addFurtherAttributes((HasOther)end);
        this.makeDocAndTest((Statement)end, "target/end8");
    }

    public void testEnd9() {
        WasEndedBy end = pFactory.newWasEndedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), this.q("e1"));
        this.makeDocAndTest((Statement)end, "target/end9");
    }

    public void testEnd10() {
        WasEndedBy end = pFactory.newWasEndedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), null);
        end.setEnder(this.q("a2"));
        end.setTime(pFactory.newTimeNow());
        end.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        end.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.addTypes((HasType)end);
        this.addLocations((HasLocation)end);
        this.addLabels((HasLabel)end);
        this.addFurtherAttributes((HasOther)end);
        this.makeDocAndTest((Statement)end, "target/end10");
    }

    public void testDerivation1() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)der, "target/derivation1");
    }

    public void testDerivation2() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der2"), this.q("e2"), null);
        this.makeDocAndTest((Statement)der, "target/derivation2");
    }

    public void testDerivation3() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der3"), this.q("e2"), this.q("e1"));
        this.makeDocAndTest((Statement)der, "target/derivation3");
    }

    public void testDerivation4() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der4"), this.q("e2"), this.q("e1"));
        this.addLabel((HasLabel)der);
        this.makeDocAndTest((Statement)der, "target/derivation4");
    }

    public void testDerivation5() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der5"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        this.makeDocAndTest((Statement)der, "target/derivation5");
    }

    public void testDerivation6() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der6"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        this.makeDocAndTest((Statement)der, "target/derivation6");
    }

    public void testDerivation7() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der7"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        this.makeDocAndTest((Statement)der, "target/derivation7");
    }

    public void testDerivation8() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der8"), this.q("e2"), this.q("e1"));
        this.addLabel((HasLabel)der);
        this.addTypes((HasType)der);
        this.addFurtherAttributes((HasOther)der);
        this.makeDocAndTest((Statement)der, "target/derivation8");
    }

    public void testDerivation9() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e2"), null);
        this.addTypes((HasType)der);
        this.makeDocAndTest((Statement)der, "target/derivation9");
    }

    public void testDerivation10() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        this.makeDocAndTest((Statement)der, "target/derivation10");
    }

    public void testDerivation11() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("rev1"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        pFactory.addRevisionType((HasType)der);
        this.makeDocAndTest((Statement)der, "target/derivation11");
    }

    public void testDerivation12() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("quo1"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        pFactory.addQuotationType((HasType)der);
        this.makeDocAndTest((Statement)der, "target/derivation12");
    }

    public void testDerivation13() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("prim1"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        pFactory.addPrimarySourceType((HasType)der);
        this.makeDocAndTest((Statement)der, "target/derivation13");
    }

    public void testAssociation1() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc1"), this.q("a1"), null);
        this.makeDocAndTest((Statement)assoc, "target/association1");
    }

    public void testAssociation2() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc2"), null, this.q("ag1"));
        this.makeDocAndTest((Statement)assoc, "target/association2");
    }

    public void testAssociation3() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc3"), this.q("a1"), this.q("ag1"));
        this.makeDocAndTest((Statement)assoc, "target/association3");
    }

    public void testAssociation4() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc4"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        this.makeDocAndTest((Statement)assoc, "target/association4");
    }

    public void testAssociation5() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), this.q("ag1"));
        this.makeDocAndTest((Statement)assoc, "target/association5");
    }

    public void testAssociation6() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc6"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        this.addLabels((HasLabel)assoc);
        this.makeDocAndTest((Statement)assoc, "target/association6");
    }

    public void testAssociation7() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc7"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        this.addLabels((HasLabel)assoc);
        this.addTypes((HasType)assoc);
        this.makeDocAndTest((Statement)assoc, "target/association7");
    }

    public void testAssociation8() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc8"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        assoc.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        assoc.getRole().add(pFactory.newRole((Object)"someOtherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)assoc, "target/association8");
    }

    public void testAssociation9() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc9"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        this.addLabels((HasLabel)assoc);
        this.addTypes((HasType)assoc);
        this.addFurtherAttributes((HasOther)assoc);
        this.makeDocAndTest((Statement)assoc, "target/association9");
    }

    public void testAttribution1() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr1"), this.q("e1"), null);
        this.makeDocAndTest((Statement)attr, "target/attribution1");
    }

    public void testAttribution2() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr2"), null, this.q("ag1"));
        this.makeDocAndTest((Statement)attr, "target/attribution2");
    }

    public void testAttribution3() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr3"), this.q("e1"), this.q("ag1"));
        this.makeDocAndTest((Statement)attr, "target/attribution3");
    }

    public void testAttribution4() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr4"), this.q("e1"), this.q("ag1"));
        this.makeDocAndTest((Statement)attr, "target/attribution4");
    }

    public void testAttribution5() {
        WasAttributedTo attr = pFactory.newWasAttributedTo((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), this.q("ag1"));
        this.makeDocAndTest((Statement)attr, "target/attribution5");
    }

    public void testAttribution6() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr6"), this.q("e1"), this.q("ag1"));
        this.addLabels((HasLabel)attr);
        this.makeDocAndTest((Statement)attr, "target/attribution6");
    }

    public void testAttribution7() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr7"), this.q("e1"), this.q("ag1"));
        this.addLabels((HasLabel)attr);
        this.addTypes((HasType)attr);
        this.makeDocAndTest((Statement)attr, "target/attribution7");
    }

    public void testAttribution8() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr8"), this.q("e1"), this.q("ag1"));
        this.addLabels((HasLabel)attr);
        this.addTypes((HasType)attr);
        this.addFurtherAttributes((HasOther)attr);
        this.makeDocAndTest((Statement)attr, "target/attribution8");
    }

    public void testDelegation1() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del1"), this.q("e1"), null, null);
        this.makeDocAndTest((Statement)del, "target/delegation1");
    }

    public void testDelegation2() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del2"), null, this.q("ag1"), null);
        this.makeDocAndTest((Statement)del, "target/delegation2");
    }

    public void testDelegation3() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del3"), this.q("e1"), this.q("ag1"), null);
        this.makeDocAndTest((Statement)del, "target/delegation3");
    }

    public void testDelegation4() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del4"), this.q("e1"), this.q("ag1"), this.q("a"));
        this.makeDocAndTest((Statement)del, "target/delegation4");
    }

    public void testDelegation5() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf((QualifiedName)null, this.q("e1"), this.q("ag1"), null);
        this.makeDocAndTest((Statement)del, "target/delegation5");
    }

    public void testDelegation6() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del6"), this.q("e1"), this.q("ag1"), this.q("a"));
        this.addLabels((HasLabel)del);
        this.makeDocAndTest((Statement)del, "target/delegation6");
    }

    public void testDelegation7() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del7"), this.q("e1"), this.q("ag1"), this.q("a"));
        this.addLabels((HasLabel)del);
        this.addTypes((HasType)del);
        this.makeDocAndTest((Statement)del, "target/delegation7");
    }

    public void testDelegation8() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del8"), this.q("e1"), this.q("ag1"), this.q("a"));
        this.addLabels((HasLabel)del);
        this.addTypes((HasType)del);
        this.addFurtherAttributes((HasOther)del);
        this.makeDocAndTest((Statement)del, "target/delegation8");
    }

    public void testCommunication1() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf1"), this.q("a2"), null);
        this.makeDocAndTest((Statement)inf, "target/communication1");
    }

    public void testCommunication2() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf2"), null, this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/communication2");
    }

    public void testCommunication3() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf3"), this.q("a2"), this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/communication3");
    }

    public void testCommunication4() {
        WasInformedBy inf = pFactory.newWasInformedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a2"), this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/communication4");
    }

    public void testCommunication5() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf5"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.makeDocAndTest((Statement)inf, "target/communication5");
    }

    public void testCommunication6() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf6"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.addTypes((HasType)inf);
        this.makeDocAndTest((Statement)inf, "target/communication6");
    }

    public void testCommunication7() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf7"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.addTypes((HasType)inf);
        this.addFurtherAttributes((HasOther)inf);
        this.makeDocAndTest((Statement)inf, "target/communication7");
    }

    public void testInfluence1() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf1"), this.q("a2"), null);
        this.makeDocAndTest((Statement)inf, "target/influence1");
    }

    public void testInfluence2() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf2"), null, this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/influence2");
    }

    public void testInfluence3() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf3"), this.q("a2"), this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/influence3");
    }

    public void testInfluence4() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a2"), this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/influence4");
    }

    public void testInfluence5() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf5"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.makeDocAndTest((Statement)inf, "target/influence5");
    }

    public void testInfluence6() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf6"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.addTypes((HasType)inf);
        this.makeDocAndTest((Statement)inf, "target/influence6");
    }

    public void testInfluence7() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf7"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.addTypes((HasType)inf);
        this.addFurtherAttributes((HasOther)inf);
        this.makeDocAndTest((Statement)inf, "target/influence7");
    }

    public void testAlternate1() {
        AlternateOf alt = pFactory.newAlternateOf(this.q("e1"), this.q("e2"));
        this.makeDocAndTest((Statement)alt, "target/alternate1");
    }

    public void testSpecialization1() {
        SpecializationOf spe = pFactory.newSpecializationOf(this.q("e2"), this.q("e1"));
        this.makeDocAndTest((Statement)spe, "target/specialization1");
    }

    public void testMembership1() {
        HadMember mem = pFactory.newHadMember(this.q("c"), new QualifiedName[]{this.q("e1")});
        this.makeDocAndTest((Statement)mem, "target/member1");
    }

    public void testMembership2() {
        HadMember mem = pFactory.newHadMember(this.q("c"), new QualifiedName[]{this.q("e1"), this.q("e2")});
        this.makeDocAndTest((Statement)mem, "target/member2");
    }

    public void testMembership3() {
        HadMember mem = pFactory.newHadMember(this.q("c"), new QualifiedName[]{this.q("e1"), this.q("e2"), this.q("e3")});
        this.makeDocAndTest((Statement)mem, "target/member3");
    }

    public void testBundle1() {
        Used use1 = pFactory.newUsed(this.q("use1"), this.q("a1"), null, this.q("e1"));
        Entity e1 = pFactory.newEntity(this.q("e1"));
        Activity a1 = pFactory.newActivity(this.q("a1"));
        LinkedList<Object> st1 = new LinkedList<Object>();
        st1.add(a1);
        st1.add(e1);
        st1.add(use1);
        Bundle b1 = pFactory.newNamedBundle(this.q("bundle1"), st1);
        Used use2 = pFactory.newUsed(this.q("use2"), this.q("aa1"), null, this.q("ee1"));
        Entity ee1 = pFactory.newEntity(this.q("ee1"));
        Activity aa1 = pFactory.newActivity(this.q("aa1"));
        LinkedList<Object> st2 = new LinkedList<Object>();
        st2.add(aa1);
        st2.add(ee1);
        st2.add(use2);
        b1.setNamespace(Namespace.gatherNamespaces((Bundle)b1, (ProvFactory)pFactory));
        Bundle b2 = pFactory.newNamedBundle(this.q("bundle2"), st2);
        Entity eb1 = pFactory.newEntity(this.q("bundle1"));
        pFactory.addBundleType((HasType)eb1);
        Entity eb2 = pFactory.newEntity(this.q("bundle2"));
        pFactory.addBundleType((HasType)eb2);
        b2.setNamespace(Namespace.gatherNamespaces((Bundle)b2, (ProvFactory)pFactory));
        Statement[] statements = new Statement[]{eb1, eb2};
        Bundle[] bundles = new Bundle[]{b1, b2};
        this.makeDocAndTest(statements, bundles, "target/bundle1", null, true);
    }

    public void testBundle2() {
        Used use1 = pFactory.newUsed(this.q("use1"), this.q("a1"), null, this.q("e1"));
        Entity e1 = pFactory.newEntity(this.q("e1"));
        Activity a1 = pFactory.newActivity(this.q("a1"));
        LinkedList<Object> st1 = new LinkedList<Object>();
        st1.add(a1);
        st1.add(e1);
        st1.add(use1);
        Bundle b1 = pFactory.newNamedBundle(this.q("bundle1"), st1);
        b1.setNamespace(Namespace.gatherNamespaces((Bundle)b1, (ProvFactory)pFactory));
        Used use2 = pFactory.newUsed(this.q("use2"), this.q("e1"), null, this.q("a1"));
        Entity ee1 = pFactory.newEntity(this.q("a1"));
        Activity aa1 = pFactory.newActivity(this.q("e1"));
        LinkedList<Object> st2 = new LinkedList<Object>();
        st2.add(aa1);
        st2.add(ee1);
        st2.add(use2);
        Bundle b2 = pFactory.newNamedBundle(this.q("bundle2"), st2);
        b2.setNamespace(Namespace.gatherNamespaces((Bundle)b2, (ProvFactory)pFactory));
        Entity eb1 = pFactory.newEntity(this.q("bundle1"));
        pFactory.addBundleType((HasType)eb1);
        Entity eb2 = pFactory.newEntity(this.q("bundle2"));
        pFactory.addBundleType((HasType)eb2);
        Statement[] statements = new Statement[]{eb1, eb2};
        Bundle[] bundles = new Bundle[]{b1, b2};
        this.makeDocAndTest(statements, bundles, "target/bundle2", null, true);
    }

    public void testBundle3() {
        Used use1 = pFactory.newUsed(this.q("use1"), this.q("a1"), null, this.q("e1"));
        Entity e1 = pFactory.newEntity(this.q("e1"));
        Activity a1 = pFactory.newActivity(this.q("a1"));
        LinkedList<Object> st1 = new LinkedList<Object>();
        st1.add(a1);
        st1.add(e1);
        st1.add(use1);
        Bundle b1 = pFactory.newNamedBundle(this.q("bundle1"), st1);
        Used use2 = pFactory.newUsed(this.q("use2"), this.q("aa1"), null, this.q("ee1"));
        Entity ee1 = pFactory.newEntity(this.q("ee1"));
        Activity aa1 = pFactory.newActivity(this.q("aa1"));
        LinkedList<Object> st2 = new LinkedList<Object>();
        st2.add(aa1);
        st2.add(ee1);
        st2.add(use2);
        Namespace ns1 = Namespace.gatherNamespaces((Bundle)b1, (ProvFactory)pFactory);
        b1.setNamespace(ns1);
        Bundle b2 = pFactory.newNamedBundle(this.q("bundle2"), st2);
        Entity eb1 = pFactory.newEntity(this.q("bundle1"));
        pFactory.addBundleType((HasType)eb1);
        Entity eb2 = pFactory.newEntity(this.q("bundle2"));
        pFactory.addBundleType((HasType)eb2);
        Namespace ns2 = Namespace.gatherNamespaces((Bundle)b2, (ProvFactory)pFactory);
        b2.setNamespace(ns2);
        Statement[] statements = new Statement[]{eb1, eb2};
        Bundle[] bundles = new Bundle[]{b1, b2};
        this.makeDocAndTest(statements, bundles, "target/bundle3", null, true);
    }

    public QualifiedName another(String n) {
        return pFactory.newQualifiedName("http://another.org/", n, "ex");
    }

    public void testBundle4() {
        Used use1 = pFactory.newUsed(this.q("use1"), this.q("a1"), null, this.q("e1"));
        Entity e1 = pFactory.newEntity(this.q("e1"));
        Activity a1 = pFactory.newActivity(this.q("a1"));
        LinkedList<Object> st1 = new LinkedList<Object>();
        st1.add(a1);
        st1.add(e1);
        st1.add(use1);
        Bundle b1 = pFactory.newNamedBundle(this.q("bundle4"), st1);
        Namespace ns1 = Namespace.gatherNamespaces((Bundle)b1, (ProvFactory)pFactory);
        b1.setNamespace(ns1);
        Used use2 = pFactory.newUsed(this.another("use2"), this.another("aa1"), null, this.another("ee1"));
        Entity ee1 = pFactory.newEntity(this.another("ee1"));
        Activity aa1 = pFactory.newActivity(this.another("aa1"));
        LinkedList<Object> st2 = new LinkedList<Object>();
        st2.add(aa1);
        st2.add(ee1);
        st2.add(use2);
        Bundle b2 = pFactory.newNamedBundle(this.another("bundle4_other"), st2);
        Namespace ns2 = Namespace.gatherNamespaces((Bundle)b2, (ProvFactory)pFactory);
        b2.setNamespace(ns2);
        Entity eb1 = pFactory.newEntity(pFactory.newQualifiedName("http://example.org/", "bundle4", "foo"));
        pFactory.addBundleType((HasType)eb1);
        Entity eb2 = pFactory.newEntity(this.another("bundle4_other"));
        pFactory.addBundleType((HasType)eb2);
        Statement[] statements = new Statement[]{eb1, eb2};
        Bundle[] bundles = new Bundle[]{b1, b2};
        this.makeDocAndTest(statements, bundles, "target/bundle4", null, true);
    }

    public void testBundle5() {
        Activity a1 = pFactory.newActivity(this.qInnerAsEx("a1"));
        LinkedList<Activity> st1 = new LinkedList<Activity>();
        st1.add(a1);
        Bundle b5 = pFactory.newNamedBundle(this.qInnerAsEx("bundle5"), st1);
        Namespace ns5 = Namespace.gatherNamespaces((Bundle)b5, (ProvFactory)pFactory);
        b5.setNamespace(ns5);
        Entity e1 = pFactory.newEntity(this.qOuterAsEx("e1"));
        Statement[] statements = new Statement[]{e1};
        Bundle[] bundles = new Bundle[]{b5};
        this.makeDocAndTest(statements, bundles, "target/bundle5", null, true);
    }

    public void testBundle6() {
        Activity a1 = pFactory.newActivity(this.qInner("a1"));
        LinkedList<Activity> st1 = new LinkedList<Activity>();
        st1.add(a1);
        QualifiedName b5Id = this.qInner("bundle5");
        Bundle b6 = pFactory.newNamedBundle(b5Id, st1);
        Namespace ns6 = Namespace.gatherNamespaces((Bundle)b6, (ProvFactory)pFactory);
        b6.setNamespace(ns6);
        QualifiedName q1 = this.qOuter("e1");
        Entity e1 = pFactory.newEntity(q1);
        QualifiedName q2 = this.qOuter("a2");
        Entity a2 = pFactory.newEntity(q2);
        b6.getStatement().add(a2);
        Statement[] statements = new Statement[]{e1};
        Bundle[] bundles = new Bundle[]{b6};
        Namespace ns = new Namespace();
        ns.register(q1.getPrefix(), q1.getNamespaceURI());
        ns6.setParent(ns);
        Document doc = pFactory.newDocument(ns, Arrays.asList(statements), Arrays.asList(bundles));
        this.doTest(doc, "target/bundle6", null, true);
    }

    public void testDefault1() {
        QualifiedName q1 = this.qDefault("a1");
        Activity a1 = pFactory.newActivity(q1);
        LinkedList<Object> statements = new LinkedList<Object>();
        statements.add(a1);
        QualifiedName q2 = this.qOuter("e2");
        Entity e2 = pFactory.newEntity(q2);
        statements.add(e2);
        Namespace ns = new Namespace();
        ns.register(q2.getPrefix(), q2.getNamespaceURI());
        ns.registerDefault(q1.getNamespaceURI());
        ns.register("bar", q1.getNamespaceURI());
        Document doc = pFactory.newDocument(ns, statements, new LinkedList());
        this.doTest(doc, "target/default1", null, true);
    }

    public void testDictionaryMembership1() {
        DictionaryMembership mem = pFactory.newDictionaryMembership(this.q("d"), null);
        Statement[] statements = new Statement[]{mem};
        Statement[] opt = new Statement[]{};
        this.makeDocAndTest(statements, opt, "target/dictionaryMembership1");
    }

    public void testDictionaryMembership2() {
        LinkedList<Entry> ll = new LinkedList<Entry>();
        Entry p1 = pFactory.newEntry(pFactory.newKey((Object)"a", RoundTripFromJavaTest.name.XSD_STRING), this.q("e0"));
        ll.add(p1);
        DictionaryMembership d5 = pFactory.newDictionaryMembership(this.q("d"), ll);
        Statement[] statements = new Statement[]{d5};
        Statement[] opt = new Statement[]{};
        this.makeDocAndTest(statements, opt, "target/dictionaryMembership2");
    }

    public void testDictionaryMembership3() {
        LinkedList<Entry> ll = new LinkedList<Entry>();
        Entry p1 = pFactory.newEntry(pFactory.newKey((Object)"a", RoundTripFromJavaTest.name.XSD_STRING), this.q("e0"));
        ll.add(p1);
        Entry p2 = pFactory.newEntry(pFactory.newKey((Object)1, RoundTripFromJavaTest.name.XSD_INT), this.q("e1"));
        ll.add(p2);
        DictionaryMembership d5 = pFactory.newDictionaryMembership(this.q("d"), ll);
        Statement[] statements = new Statement[]{d5};
        Statement[] opt = new Statement[]{};
        this.makeDocAndTest(statements, opt, "target/dictionaryMembership3");
    }

    public void testDictionaryMembership4() {
        LinkedList<Entry> ll = new LinkedList<Entry>();
        Entry p1 = pFactory.newEntry(pFactory.newKey((Object)"a", RoundTripFromJavaTest.name.XSD_STRING), this.q("e0"));
        ll.add(p1);
        Entry p2 = pFactory.newEntry(pFactory.newKey((Object)1, RoundTripFromJavaTest.name.XSD_INT), this.q("e1"));
        ll.add(p2);
        Entry p3 = pFactory.newEntry(pFactory.newKey((Object)this.q("a"), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME), this.q("e2"));
        ll.add(p3);
        DictionaryMembership d5 = pFactory.newDictionaryMembership(this.q("d"), ll);
        Statement[] statements = new Statement[]{d5};
        Statement[] opt = new Statement[]{};
        this.makeDocAndTest(statements, opt, "target/dictionaryMembership4");
    }

    public void testQualifiedSpecializationOf1() {
        QualifiedSpecializationOf gen = pFactory.newQualifiedSpecializationOf(this.q("spec1"), this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-specialization1");
    }

    public void testQualifiedSpecializationOf2() {
        QualifiedSpecializationOf gen = pFactory.newQualifiedSpecializationOf(null, this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-specialization2");
    }

    public void testQualifiedAlternateOf1() {
        QualifiedAlternateOf gen = pFactory.newQualifiedAlternateOf(this.q("alt1"), this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-alternate1");
    }

    public void testQualifiedAlternateOf2() {
        QualifiedAlternateOf gen = pFactory.newQualifiedAlternateOf(null, this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-alternate2");
    }

    public void testQualifiedHadMember1() {
        LinkedList<QualifiedName> entities = new LinkedList<QualifiedName>();
        entities.add(this.q("e2"));
        QualifiedHadMember gen = pFactory.newQualifiedHadMember(this.q("mem"), this.q("e1"), entities, null);
        this.makeDocAndTest((Statement)gen, "target/qualified-member1");
    }

    public void testQualifiedHadMember2() {
        LinkedList<QualifiedName> entities = new LinkedList<QualifiedName>();
        entities.add(this.q("e2"));
        QualifiedHadMember gen = pFactory.newQualifiedHadMember(null, this.q("e1"), entities, null);
        this.makeDocAndTest((Statement)gen, "target/qualified-member2");
    }
}

