/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.tuple.Pair;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Element;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasLocation;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.Influence;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.exception.InvalidIndexException;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;

public class IndexedDocument
implements StatementAction {
    ProvUtilities u = new ProvUtilities();
    final ProvFactory pFactory;
    private final HashMap<QualifiedName, Entity> entityMap = new HashMap();
    private final HashMap<QualifiedName, Activity> activityMap = new HashMap();
    private final HashMap<QualifiedName, Agent> agentMap = new HashMap();
    private final HashMap<QualifiedName, Collection<Used>> activityUsedMap = new HashMap();
    private final HashMap<QualifiedName, Collection<Used>> entityUsedMap = new HashMap();
    private final Collection<Used> anonUsed = new LinkedList<Used>();
    private final HashMap<QualifiedName, Collection<Used>> namedUsedMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasGeneratedBy>> activityWasGeneratedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasGeneratedBy>> entityWasGeneratedByMap = new HashMap();
    private final Collection<WasGeneratedBy> anonWasGeneratedBy = new LinkedList<WasGeneratedBy>();
    private final HashMap<QualifiedName, Collection<WasGeneratedBy>> namedWasGeneratedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasDerivedFrom>> entityCauseWasDerivedFromMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasDerivedFrom>> entityEffectWasDerivedFromMap = new HashMap();
    private final Collection<WasDerivedFrom> anonWasDerivedFrom = new LinkedList<WasDerivedFrom>();
    private final HashMap<QualifiedName, Collection<WasDerivedFrom>> namedWasDerivedFromMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasAssociatedWith>> activityWasAssociatedWithMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasAssociatedWith>> agentWasAssociatedWithMap = new HashMap();
    private final Collection<WasAssociatedWith> anonWasAssociatedWith = new LinkedList<WasAssociatedWith>();
    private final HashMap<QualifiedName, Collection<WasAssociatedWith>> namedWasAssociatedWithMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasAttributedTo>> entityWasAttributedToMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasAttributedTo>> agentWasAttributedToMap = new HashMap();
    private final Collection<WasAttributedTo> anonWasAttributedTo = new LinkedList<WasAttributedTo>();
    private final HashMap<QualifiedName, Collection<WasAttributedTo>> namedWasAttributedToMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasInformedBy>> activityCauseWasInformedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasInformedBy>> activityEffectWasInformedByMap = new HashMap();
    private final Collection<WasInformedBy> anonWasInformedBy = new LinkedList<WasInformedBy>();
    private final HashMap<QualifiedName, Collection<WasInformedBy>> namedWasInformedByMap = new HashMap();
    private Namespace nss;
    private final boolean flatten;
    private final Collection<ActedOnBehalfOf> anonActedOnBehalfOf = new LinkedList<ActedOnBehalfOf>();
    private final HashMap<QualifiedName, Collection<ActedOnBehalfOf>> namedActedOnBehalfOfMap = new HashMap();
    private final HashMap<QualifiedName, Collection<ActedOnBehalfOf>> responsibleActedOnBehalfOfMap = new HashMap();
    private final HashMap<QualifiedName, Collection<ActedOnBehalfOf>> delegateActedOnBehalfOfMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasInvalidatedBy>> namedWasInvalidatedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasInvalidatedBy>> entityWasInvalidatedByMap = new HashMap();
    private final Collection<WasInvalidatedBy> anonWasInvalidatedBy = new LinkedList<WasInvalidatedBy>();
    private final HashMap<QualifiedName, Collection<WasInvalidatedBy>> activityWasInvalidatedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<SpecializationOf>> namedSpecializationOfMap = new HashMap();
    private final HashMap<QualifiedName, Collection<SpecializationOf>> specificEntitySpecializationOfMap = new HashMap();
    private final Collection<SpecializationOf> anonSpecializationOf = new LinkedList<SpecializationOf>();
    private final HashMap<QualifiedName, Collection<SpecializationOf>> genericEntitySpecializationOfMap = new HashMap();
    private final Collection<AlternateOf> anonAlternateOf = new LinkedList<AlternateOf>();
    private final HashMap<QualifiedName, Collection<AlternateOf>> namedAlternateOfMap = new HashMap();
    private final HashMap<QualifiedName, Collection<AlternateOf>> entityCauseAlternateOfMap = new HashMap();
    private final HashMap<QualifiedName, Collection<AlternateOf>> entityEffectAlternateOfMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasInfluencedBy>> influenceeWasInfluencedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasInfluencedBy>> influencerWasInfluencedByMap = new HashMap();
    private final Collection<WasInfluencedBy> anonWasInfluencedBy = new LinkedList<WasInfluencedBy>();
    private final HashMap<QualifiedName, Collection<WasInfluencedBy>> namedWasInfluencedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasStartedBy>> activityWasStartedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasStartedBy>> entityWasStartedByMap = new HashMap();
    private final Collection<WasStartedBy> anonWasStartedBy = new LinkedList<WasStartedBy>();
    private final HashMap<QualifiedName, Collection<WasStartedBy>> namedWasStartedByMap = new HashMap();
    private final Collection<WasEndedBy> anonWasEndedBy = new LinkedList<WasEndedBy>();
    private final HashMap<QualifiedName, Collection<WasEndedBy>> activityWasEndedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasEndedBy>> namedWasEndedByMap = new HashMap();
    private final HashMap<QualifiedName, Collection<WasEndedBy>> entityWasEndedByMap = new HashMap();
    private final Collection<HadMember> anonHadMember = new LinkedList<HadMember>();
    private final HashMap<QualifiedName, Collection<HadMember>> collHadMemberMap = new HashMap();
    private final HashMap<QualifiedName, Collection<HadMember>> namedHadMemberMap = new HashMap();
    private final HashMap<QualifiedName, Collection<HadMember>> entityHadMemberMap = new HashMap();
    HashMap<QualifiedName, IndexedDocument> bundleMap = new HashMap();

    public Collection<Used> getUsed() {
        return this.anonUsed;
    }

    public Collection<Used> getUsed(Activity p) {
        return this.activityUsedMap.get(p.getId());
    }

    public Collection<Used> getUsed(Entity p) {
        return this.entityUsedMap.get(p.getId());
    }

    public Collection<WasGeneratedBy> getWasGeneratedBy() {
        return this.anonWasGeneratedBy;
    }

    public Collection<WasGeneratedBy> getWasGeneratedBy(Activity p) {
        return this.activityWasGeneratedByMap.get(p.getId());
    }

    public Collection<WasGeneratedBy> getWasGeneratedBy(Entity p) {
        return this.entityWasGeneratedByMap.get(p.getId());
    }

    public Collection<WasDerivedFrom> getWasDerivedFrom() {
        return this.anonWasDerivedFrom;
    }

    public Collection<WasDerivedFrom> getWasDerivedFromWithCause(Entity a) {
        return this.entityCauseWasDerivedFromMap.get(a.getId());
    }

    public Collection<WasDerivedFrom> getWasDerivedFromWithEffect(Entity a) {
        return this.entityEffectWasDerivedFromMap.get(a.getId());
    }

    public Collection<WasInformedBy> getWasInformedBy() {
        return this.anonWasInformedBy;
    }

    public Collection<WasInformedBy> getWasInformedByWithCause(Activity a) {
        return this.activityCauseWasInformedByMap.get(a.getId());
    }

    public Collection<WasInformedBy> getWasInformedByWithEffect(Activity a) {
        return this.activityEffectWasInformedByMap.get(a.getId());
    }

    public Collection<WasAssociatedWith> getWasAssociatedWith() {
        return this.anonWasAssociatedWith;
    }

    public Collection<WasAssociatedWith> getWasAssociatedWith(Activity p) {
        return this.activityWasAssociatedWithMap.get(p.getId());
    }

    public Collection<WasAssociatedWith> getWasAssociatedWith(Agent a) {
        return this.agentWasAssociatedWithMap.get(a.getId());
    }

    public Entity add(Entity entity) {
        return this.add(entity.getId(), entity);
    }

    public Entity add(QualifiedName name, Entity entity) {
        Entity existing = this.entityMap.get(name);
        if (existing != null) {
            this.mergeAttributes(existing, entity);
            return existing;
        }
        this.entityMap.put(name, entity);
        return entity;
    }

    <T extends Element> void mergeAttributes(T existing, T newElement) {
        Element newElement2;
        Element existing2;
        HashSet<LangString> set = new HashSet<LangString>(newElement.getLabel());
        set.removeAll(existing.getLabel());
        existing.getLabel().addAll(set);
        HashSet<Location> set2 = new HashSet<Location>(newElement.getLocation());
        set2.removeAll(existing.getLocation());
        existing.getLocation().addAll(set2);
        HashSet<Type> set3 = new HashSet<Type>(newElement.getType());
        set3.removeAll(existing.getType());
        existing.getType().addAll(set3);
        HashSet<Other> set4 = new HashSet<Other>(newElement.getOther());
        set4.removeAll(existing.getOther());
        existing.getOther().addAll(set4);
        if (existing instanceof Activity) {
            XMLGregorianCalendar endTime;
            XMLGregorianCalendar startTime;
            existing2 = (Activity)existing;
            newElement2 = (Activity)newElement;
            if (existing2.getStartTime() == null && (startTime = newElement2.getStartTime()) != null) {
                existing2.setStartTime(startTime);
            }
            if (existing2.getEndTime() == null && (endTime = newElement2.getEndTime()) != null) {
                existing2.setEndTime(endTime);
            }
        }
        if (existing instanceof Entity) {
            Value value;
            existing2 = (Entity)existing;
            newElement2 = (Entity)newElement;
            if (existing2.getValue() == null && (value = newElement2.getValue()) != null) {
                existing2.setValue(value);
            }
        }
    }

    void mergeAttributes(Influence existing, Influence newElement) {
        HashSet<LangString> set = new HashSet<LangString>(newElement.getLabel());
        set.removeAll(existing.getLabel());
        existing.getLabel().addAll(set);
        if (existing instanceof HasLocation) {
            HasLocation existing2 = (HasLocation)((Object)existing);
            HashSet<Location> set2 = new HashSet<Location>(((HasLocation)((Object)newElement)).getLocation());
            set2.removeAll(existing2.getLocation());
            existing2.getLocation().addAll(set2);
        }
        HashSet<Type> set3 = new HashSet<Type>(newElement.getType());
        set3.removeAll(existing.getType());
        existing.getType().addAll(set3);
        HashSet<Other> set4 = new HashSet<Other>(newElement.getOther());
        set4.removeAll(existing.getOther());
        existing.getOther().addAll(set4);
    }

    <T extends Statement> void mergeAttributes(T existing, T newElement) {
        if (existing instanceof Element) {
            this.mergeAttributes((Element)existing, (Element)newElement);
            return;
        }
        if (existing instanceof Influence) {
            this.mergeAttributes((Influence)existing, (Influence)newElement);
            return;
        }
        throw new UnsupportedOperationException();
    }

    boolean sameEdge(Statement existing, Statement newElement, int count) {
        boolean ok = true;
        for (int i = 1; i <= count; ++i) {
            Object qn1 = this.u.getter(existing, i);
            Object qn2 = this.u.getter(newElement, i);
            if (qn1 == null) {
                if (qn2 == null) continue;
                ok = false;
                break;
            }
            if (qn2 == null) {
                ok = false;
                break;
            }
            if (qn1.equals(qn2)) continue;
            ok = false;
            break;
        }
        return ok;
    }

    public Agent add(Agent agent) {
        return this.add(agent.getId(), agent);
    }

    public Agent add(QualifiedName name, Agent agent) {
        Agent existing = this.agentMap.get(name);
        if (existing != null) {
            this.mergeAttributes(existing, agent);
            return existing;
        }
        this.agentMap.put(name, agent);
        return agent;
    }

    public Activity add(Activity activity) {
        return this.add(activity.getId(), activity);
    }

    public Activity add(QualifiedName name, Activity activity) {
        Activity existing = this.activityMap.get(name);
        if (existing != null) {
            this.mergeAttributes(existing, activity);
            return existing;
        }
        this.activityMap.put(name, activity);
        return activity;
    }

    public Activity getActivity(QualifiedName name) {
        return this.activityMap.get(name);
    }

    public Entity getEntity(QualifiedName name) {
        return this.entityMap.get(name);
    }

    public Agent getAgent(QualifiedName name) {
        return this.agentMap.get(name);
    }

    public IndexedDocument(ProvFactory pFactory, Document doc) {
        this(pFactory, doc, true);
    }

    public IndexedDocument(ProvFactory pFactory, Document doc, boolean flatten) {
        this.pFactory = pFactory;
        this.flatten = flatten;
        if (doc != null) {
            this.nss = doc.getNamespace();
            this.u.forAllStatementOrBundle(doc.getStatementOrBundle(), this);
        }
    }

    public WasInformedBy add(WasInformedBy wib) {
        return this.add(wib, 2, this.anonWasInformedBy, this.namedWasInformedByMap, this.activityEffectWasInformedByMap, this.activityCauseWasInformedByMap);
    }

    public Used add(Used used) {
        return this.add(used, 3, this.anonUsed, this.namedUsedMap, this.activityUsedMap, this.entityUsedMap);
    }

    public WasGeneratedBy add(WasGeneratedBy wgb) {
        return this.add(wgb, 3, this.anonWasGeneratedBy, this.namedWasGeneratedByMap, this.entityWasGeneratedByMap, this.activityWasGeneratedByMap);
    }

    public WasDerivedFrom add(WasDerivedFrom wdf) {
        return this.add(wdf, 5, this.anonWasDerivedFrom, this.namedWasDerivedFromMap, this.entityEffectWasDerivedFromMap, this.entityCauseWasDerivedFromMap);
    }

    public WasAssociatedWith add(WasAssociatedWith waw) {
        return this.add(waw, 3, this.anonWasAssociatedWith, this.namedWasAssociatedWithMap, this.activityWasAssociatedWithMap, this.agentWasAssociatedWithMap);
    }

    public WasAttributedTo add(WasAttributedTo wat) {
        return this.add(wat, 2, this.anonWasAttributedTo, this.namedWasAttributedToMap, this.entityWasAttributedToMap, this.agentWasAttributedToMap);
    }

    public ActedOnBehalfOf add(ActedOnBehalfOf act) {
        return this.add(act, 3, this.anonActedOnBehalfOf, this.namedActedOnBehalfOfMap, this.delegateActedOnBehalfOfMap, this.responsibleActedOnBehalfOfMap);
    }

    public WasInvalidatedBy add(WasInvalidatedBy wib) {
        return this.add(wib, 3, this.anonWasInvalidatedBy, this.namedWasInvalidatedByMap, this.entityWasInvalidatedByMap, this.activityWasInvalidatedByMap);
    }

    public SpecializationOf add(SpecializationOf spec) {
        return this.add(spec, 2, this.anonSpecializationOf, this.namedSpecializationOfMap, this.specificEntitySpecializationOfMap, this.genericEntitySpecializationOfMap);
    }

    public AlternateOf add(AlternateOf alt) {
        return this.add(alt, 2, this.anonAlternateOf, this.namedAlternateOfMap, this.entityEffectAlternateOfMap, this.entityCauseAlternateOfMap);
    }

    public WasInfluencedBy add(WasInfluencedBy winf) {
        return this.add(winf, 2, this.anonWasInfluencedBy, this.namedWasInfluencedByMap, this.influenceeWasInfluencedByMap, this.influencerWasInfluencedByMap);
    }

    public WasStartedBy add(WasStartedBy wsb) {
        return this.add(wsb, 4, this.anonWasStartedBy, this.namedWasStartedByMap, this.activityWasStartedByMap, this.entityWasStartedByMap);
    }

    public WasEndedBy add(WasEndedBy web) {
        return this.add(web, 4, this.anonWasEndedBy, this.namedWasEndedByMap, this.activityWasEndedByMap, this.entityWasEndedByMap);
    }

    public HadMember add(HadMember hm) {
        return this.add(hm, 2, this.anonHadMember, this.namedHadMemberMap, this.collHadMemberMap, this.entityHadMemberMap);
    }

    public <T extends Relation> T add(T statement, int num, Collection<T> anonRelationCollection, HashMap<QualifiedName, Collection<T>> namedRelationMap, HashMap<QualifiedName, Collection<T>> effectRelationMap, HashMap<QualifiedName, Collection<T>> causeRelationMap) {
        QualifiedName aid2 = this.u.getEffect((Relation)statement);
        QualifiedName aid1 = this.u.getCause((Relation)statement);
        QualifiedName id = (statement = this.pFactory.newStatement(statement)) instanceof Identifiable ? ((Identifiable)statement).getId() : null;
        if (id == null) {
            boolean found = false;
            Collection<T> relationCollection = effectRelationMap.get(aid2);
            if (relationCollection == null) {
                relationCollection = new LinkedList<T>();
                relationCollection.add(statement);
                effectRelationMap.put(aid2, relationCollection);
            } else {
                for (Relation u : relationCollection) {
                    if (!u.equals(statement)) continue;
                    found = true;
                    statement = u;
                    break;
                }
                if (!found) {
                    relationCollection.add(statement);
                }
            }
            relationCollection = causeRelationMap.get(aid1);
            if (relationCollection == null) {
                relationCollection = new LinkedList<T>();
                relationCollection.add(statement);
                causeRelationMap.put(aid1, relationCollection);
            } else if (!found) {
                relationCollection.add(statement);
            }
            if (!found) {
                anonRelationCollection.add(statement);
            }
        } else {
            Collection<T> relationCollection = namedRelationMap.get(id);
            if (relationCollection == null) {
                relationCollection = new LinkedList<T>();
                relationCollection.add(statement);
                namedRelationMap.put(id, relationCollection);
            } else {
                boolean found = false;
                for (Relation u1 : relationCollection) {
                    if (!this.sameEdge(u1, (Statement)statement, num)) continue;
                    found = true;
                    this.mergeAttributes(u1, statement);
                    break;
                }
                if (!found) {
                    relationCollection.add(statement);
                }
            }
        }
        return statement;
    }

    @Override
    public void doAction(Activity s) {
        this.add(s);
    }

    @Override
    public void doAction(Used s) {
        this.add(s);
    }

    @Override
    public void doAction(WasStartedBy s) {
        this.add(s);
    }

    @Override
    public void doAction(Agent s) {
        this.add(s);
    }

    @Override
    public void doAction(AlternateOf s) {
        this.add(s);
    }

    @Override
    public void doAction(WasAssociatedWith s) {
        this.add(s);
    }

    @Override
    public void doAction(WasAttributedTo s) {
        this.add(s);
    }

    @Override
    public void doAction(WasInfluencedBy s) {
        this.add(s);
    }

    @Override
    public void doAction(ActedOnBehalfOf s) {
        this.add(s);
    }

    @Override
    public void doAction(WasDerivedFrom s) {
        this.add(s);
    }

    @Override
    public void doAction(WasEndedBy s) {
        this.add(s);
    }

    @Override
    public void doAction(Entity s) {
        this.add(s);
    }

    @Override
    public void doAction(WasGeneratedBy s) {
        this.add(s);
    }

    @Override
    public void doAction(WasInvalidatedBy s) {
        this.add(s);
    }

    @Override
    public void doAction(HadMember s) {
        this.add(s);
    }

    @Override
    public void doAction(MentionOf s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doAction(SpecializationOf s) {
        this.add(s);
    }

    @Override
    public void doAction(QualifiedSpecializationOf s) {
        this.add(s);
    }

    @Override
    public void doAction(QualifiedAlternateOf s) {
        this.add(s);
    }

    @Override
    public void doAction(QualifiedHadMember s) {
        this.add(s);
    }

    @Override
    public void doAction(WasInformedBy s) {
        this.add(s);
    }

    @Override
    public void doAction(DerivedByInsertionFrom s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doAction(DictionaryMembership s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doAction(DerivedByRemovalFrom s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doAction(Bundle bun, ProvUtilities provUtilities) {
        if (this.flatten) {
            provUtilities.forAllStatement(bun.getStatement(), this);
        } else {
            IndexedDocument iDoc = this.bundleMap.get(bun.getId());
            if (iDoc == null) {
                iDoc = new IndexedDocument(this.pFactory, null, this.flatten);
                this.bundleMap.put(bun.getId(), iDoc);
            }
            this.u.forAllStatement(bun.getStatement(), iDoc);
        }
    }

    public Document toDocument() {
        Document res = this.pFactory.newDocument();
        List<StatementOrBundle> statementOrBundle = res.getStatementOrBundle();
        this.toContainer(statementOrBundle);
        if (!this.flatten) {
            for (QualifiedName bunId : this.bundleMap.keySet()) {
                IndexedDocument idoc = this.bundleMap.get(bunId);
                Bundle bun = this.pFactory.newNamedBundle(bunId, null);
                LinkedList<StatementOrBundle> ll = new LinkedList<StatementOrBundle>();
                idoc.toContainer(ll);
                for (StatementOrBundle s : ll) {
                    bun.getStatement().add((Statement)s);
                }
                bun.setNamespace(Namespace.gatherNamespaces(bun));
                statementOrBundle.add(bun);
            }
        }
        res.setNamespace(Namespace.gatherNamespaces(res));
        return res;
    }

    private void toContainer(List<StatementOrBundle> statementOrBundle) {
        statementOrBundle.addAll(this.entityMap.values());
        statementOrBundle.addAll(this.activityMap.values());
        statementOrBundle.addAll(this.agentMap.values());
        statementOrBundle.addAll(this.anonUsed);
        for (Collection<Used> collection : this.namedUsedMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonWasGeneratedBy);
        for (Collection<HasLocation> collection : this.namedWasGeneratedByMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonWasDerivedFrom);
        for (Collection<Influence> collection : this.namedWasDerivedFromMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonWasAssociatedWith);
        for (Collection<Influence> collection : this.namedWasAssociatedWithMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonWasAttributedTo);
        for (Collection<Influence> collection : this.namedWasAttributedToMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonWasInformedBy);
        for (Collection<Influence> collection : this.namedWasInformedByMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonSpecializationOf);
        statementOrBundle.addAll(this.anonAlternateOf);
        statementOrBundle.addAll(this.anonHadMember);
        statementOrBundle.addAll(this.anonWasInvalidatedBy);
        for (Collection<Influence> collection : this.namedWasInvalidatedByMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonWasStartedBy);
        for (Collection<Influence> collection : this.namedWasStartedByMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonWasEndedBy);
        for (Collection<Influence> collection : this.namedWasEndedByMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonActedOnBehalfOf);
        for (Collection<Influence> collection : this.namedActedOnBehalfOfMap.values()) {
            statementOrBundle.addAll(collection);
        }
        statementOrBundle.addAll(this.anonWasInfluencedBy);
        for (Collection<Influence> collection : this.namedWasInfluencedByMap.values()) {
            statementOrBundle.addAll(collection);
        }
    }

    public IndexedDocument merge(Document doc) {
        this.u.forAllStatementOrBundle(doc.getStatementOrBundle(), this);
        return this;
    }

    public Set<QualifiedName> traverseDerivations(QualifiedName from) {
        Stack<QualifiedName> s = new Stack<QualifiedName>();
        s.push(from);
        return this.traverseDerivations1(new HashSet<QualifiedName>(), new HashSet<QualifiedName>(), s);
    }

    public Set<QualifiedName> traverseDerivations1(Set<QualifiedName> last, Set<QualifiedName> seen, Stack<QualifiedName> todo) {
        QualifiedName current = null;
        while (!todo.isEmpty()) {
            current = todo.pop();
            if (seen.contains(current)) continue;
            seen.add(current);
            Collection<WasDerivedFrom> successors = this.entityCauseWasDerivedFromMap.get(current);
            if (successors == null || successors.isEmpty()) continue;
            for (WasDerivedFrom wdf : successors) {
                QualifiedName qn = wdf.getGeneratedEntity();
                last.add(qn);
            }
        }
        return last;
    }

    public Set<Pair<QualifiedName, WasDerivedFrom>> traverseDerivationsWithRelations(QualifiedName from) {
        Stack<QualifiedName> s = new Stack<QualifiedName>();
        s.push(from);
        return this.traverseDerivations2(new HashSet<Pair<QualifiedName, WasDerivedFrom>>(), new HashSet<QualifiedName>(), s);
    }

    public Set<Pair<QualifiedName, WasDerivedFrom>> traverseDerivations2(Set<Pair<QualifiedName, WasDerivedFrom>> last, Set<QualifiedName> seen, Stack<QualifiedName> todo) {
        QualifiedName current = null;
        while (!todo.isEmpty()) {
            current = todo.pop();
            if (seen.contains(current)) continue;
            seen.add(current);
            Collection<WasDerivedFrom> successors = this.entityCauseWasDerivedFromMap.get(current);
            if (successors == null || successors.isEmpty()) continue;
            for (WasDerivedFrom wdf : successors) {
                QualifiedName qn = wdf.getGeneratedEntity();
                last.add((Pair<QualifiedName, WasDerivedFrom>)Pair.of((Object)qn, (Object)wdf));
            }
        }
        return last;
    }

    public Set<Pair<QualifiedName, WasAttributedTo>> traverseAttributionsWithRelations(QualifiedName from) {
        Stack<QualifiedName> s = new Stack<QualifiedName>();
        s.push(from);
        return this.traverseAttributions2(new HashSet<Pair<QualifiedName, WasAttributedTo>>(), new HashSet<QualifiedName>(), s);
    }

    public Set<Pair<QualifiedName, WasAttributedTo>> traverseAttributions2(Set<Pair<QualifiedName, WasAttributedTo>> last, Set<QualifiedName> seen, Stack<QualifiedName> todo) {
        QualifiedName current = null;
        while (!todo.isEmpty()) {
            current = todo.pop();
            if (seen.contains(current)) continue;
            seen.add(current);
            Collection<WasAttributedTo> successors = this.agentWasAttributedToMap.get(current);
            if (successors == null || successors.isEmpty()) continue;
            for (WasAttributedTo wat : successors) {
                QualifiedName qn = wat.getEntity();
                last.add((Pair<QualifiedName, WasAttributedTo>)Pair.of((Object)qn, (Object)wat));
            }
        }
        return last;
    }

    public Set<Pair<QualifiedName, HadMember>> traverseMembershipsWithRelations(QualifiedName from) {
        Stack<QualifiedName> s = new Stack<QualifiedName>();
        s.push(from);
        return this.traverseMembership2(new HashSet<Pair<QualifiedName, HadMember>>(), new HashSet<QualifiedName>(), s);
    }

    public Set<Pair<QualifiedName, HadMember>> traverseMembership2(Set<Pair<QualifiedName, HadMember>> last, Set<QualifiedName> seen, Stack<QualifiedName> todo) {
        QualifiedName current = null;
        while (!todo.isEmpty()) {
            current = todo.pop();
            if (seen.contains(current)) continue;
            seen.add(current);
            Collection<HadMember> successors = this.entityHadMemberMap.get(current);
            if (successors == null || successors.isEmpty()) continue;
            for (HadMember mem : successors) {
                QualifiedName qn = mem.getCollection();
                last.add((Pair<QualifiedName, HadMember>)Pair.of((Object)qn, (Object)mem));
            }
        }
        return last;
    }

    public Set<Pair<QualifiedName, HadMember>> traverseReverseMembershipsWithRelations(QualifiedName from) {
        Stack<QualifiedName> todo = new Stack<QualifiedName>();
        todo.push(from);
        return this.traverseReverseMembership2(new HashSet<Pair<QualifiedName, HadMember>>(), new HashSet<QualifiedName>(), todo);
    }

    public Set<Pair<QualifiedName, HadMember>> traverseReverseMembership2(Set<Pair<QualifiedName, HadMember>> last, Set<QualifiedName> seen, Stack<QualifiedName> todo) {
        QualifiedName current = null;
        while (!todo.isEmpty()) {
            current = todo.pop();
            if (seen.contains(current)) continue;
            seen.add(current);
            Collection<HadMember> successors = this.collHadMemberMap.get(current);
            if (successors == null || successors.isEmpty()) continue;
            for (HadMember mem : successors) {
                if (!mem.getCollection().equals(current)) {
                    throw new InvalidIndexException("HadMember not indexed properly " + current + ": " + mem);
                }
                List<QualifiedName> qns = mem.getEntity();
                for (QualifiedName qn : qns) {
                    last.add((Pair<QualifiedName, HadMember>)Pair.of((Object)qn, (Object)mem));
                }
            }
        }
        return last;
    }

    public Set<Pair<QualifiedName, SpecializationOf>> traverseSpecializationsWithRelations(QualifiedName from) {
        Stack<QualifiedName> s = new Stack<QualifiedName>();
        s.push(from);
        return this.traverseSpecializations2(new HashSet<Pair<QualifiedName, SpecializationOf>>(), new HashSet<QualifiedName>(), s);
    }

    public Set<Pair<QualifiedName, SpecializationOf>> traverseSpecializations2(Set<Pair<QualifiedName, SpecializationOf>> last, Set<QualifiedName> seen, Stack<QualifiedName> todo) {
        QualifiedName current = null;
        while (!todo.isEmpty()) {
            current = todo.pop();
            if (seen.contains(current)) continue;
            seen.add(current);
            Collection<SpecializationOf> successors = this.genericEntitySpecializationOfMap.get(current);
            if (successors == null || successors.isEmpty()) continue;
            for (SpecializationOf spe : successors) {
                QualifiedName qn = spe.getSpecificEntity();
                last.add((Pair<QualifiedName, SpecializationOf>)Pair.of((Object)qn, (Object)spe));
            }
        }
        return last;
    }
}

