/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DateTimeOption;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasLocation;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasRole;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.HasValue;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.LiteralConstructor;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvSerialiser;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementActionValue;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.model.ValueConverter;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;

public abstract class ProvFactory
implements LiteralConstructor,
ModelConstructor,
ModelConstructorExtension {
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final String fileName = "toolbox.properties";
    private static final String toolboxVersion = ProvFactory.getPropertiesFromClasspath("toolbox.properties").getProperty("toolbox.version");
    protected DatatypeFactory dataFactory;
    private Name name = null;
    ProvUtilities util = new ProvUtilities();

    private static Properties getPropertiesFromClasspath(String propFileName) {
        Properties props = new Properties();
        InputStream inputStream = ProvFactory.class.getClassLoader().getResourceAsStream(propFileName);
        if (inputStream == null) {
            return null;
        }
        try {
            props.load(inputStream);
        }
        catch (IOException ee) {
            return null;
        }
        return props;
    }

    public ProvFactory() {
        this.init();
    }

    public void addAttribute(HasOther a, Other o) {
        a.getOther().add(o);
    }

    public ActedOnBehalfOf addAttributes(ActedOnBehalfOf from, ActedOnBehalfOf to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public Activity addAttributes(Activity from, Activity to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public Agent addAttributes(Agent from, Agent to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public Entity addAttributes(Entity from, Entity to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public Used addAttributes(Used from, Used to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasAssociatedWith addAttributes(WasAssociatedWith from, WasAssociatedWith to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasAttributedTo addAttributes(WasAttributedTo from, WasAttributedTo to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasDerivedFrom addAttributes(WasDerivedFrom from, WasDerivedFrom to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasEndedBy addAttributes(WasEndedBy from, WasEndedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasGeneratedBy addAttributes(WasGeneratedBy from, WasGeneratedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasInfluencedBy addAttributes(WasInfluencedBy from, WasInfluencedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasInformedBy addAttributes(WasInformedBy from, WasInformedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasInvalidatedBy addAttributes(WasInvalidatedBy from, WasInvalidatedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasStartedBy addAttributes(WasStartedBy from, WasStartedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public void addLabel(HasLabel a, String label) {
        a.getLabel().add(this.newInternationalizedString(label));
    }

    public void addLabel(HasLabel a, String label, String language) {
        a.getLabel().add(this.newInternationalizedString(label, language));
    }

    public void addPrimarySourceType(HasType a) {
        a.getType().add(this.newType(this.getName().PROV_PRIMARY_SOURCE, this.getName().PROV_QUALIFIED_NAME));
    }

    public void addQuotationType(HasType a) {
        a.getType().add(this.newType(this.getName().PROV_QUOTATION, this.getName().PROV_QUALIFIED_NAME));
    }

    public void addRevisionType(HasType a) {
        a.getType().add(this.newType(this.getName().PROV_REVISION, this.getName().PROV_QUALIFIED_NAME));
    }

    public void addBundleType(HasType a) {
        a.getType().add(this.newType(this.getName().PROV_BUNDLE, this.getName().PROV_QUALIFIED_NAME));
    }

    public void addRole(HasRole a, Role role) {
        if (role != null) {
            a.getRole().add(role);
        }
    }

    public void addType(HasType a, Object o, QualifiedName type) {
        a.getType().add(this.newType(o, type));
    }

    public void addType(HasType a, Type type) {
        a.getType().add(type);
    }

    public void addType(HasType a, QualifiedName type) {
        a.getType().add(this.newType(type, this.getName().PROV_QUALIFIED_NAME));
    }

    @Override
    public byte[] base64Decoding(String s) {
        return Base64.getDecoder().decode(s);
    }

    public String base64Encoding(byte[] b) {
        return Base64.getEncoder().encodeToString(b);
    }

    public String getLabel(HasLabel e) {
        List<LangString> labels = e.getLabel();
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        return labels.get(0).getValue();
    }

    public Name getName() {
        if (this.name == null) {
            this.name = new Name(this);
        }
        return this.name;
    }

    public abstract ProvSerialiser getSerializer();

    public String getRole(HasOther e) {
        return "pFact: role TODO";
    }

    public List<Type> getType(HasOther e) {
        if (e instanceof HasType) {
            return ((HasType)((Object)e)).getType();
        }
        LinkedList<Type> res = new LinkedList<Type>();
        res.add(this.newType("pFact: type TODO", this.getName().XSD_STRING));
        return res;
    }

    public String getVersion() {
        return toolboxVersion;
    }

    public byte[] hexDecoding(String s) {
        byte[] byteArray = new BigInteger(s, 16).toByteArray();
        if (byteArray[0] == 0) {
            byte[] output = new byte[byteArray.length - 1];
            System.arraycopy(byteArray, 1, output, 0, output.length);
            return output;
        }
        return byteArray;
    }

    public String hexEncoding(byte[] b) {
        BigInteger bigInteger = new BigInteger(1, b);
        return bigInteger.toString(16);
    }

    protected void init() {
        try {
            this.dataFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ActedOnBehalfOf newActedOnBehalfOf(ActedOnBehalfOf u) {
        return this.newActedOnBehalfOf(u.getId(), u.getDelegate(), u.getResponsible(), u.getActivity(), this.getAttributes(u));
    }

    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible, QualifiedName activity) {
        return this.newActedOnBehalfOf(id, delegate, responsible, activity, null);
    }

    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible) {
        return this.newActedOnBehalfOf(id, delegate, responsible, null, null);
    }

    public Activity newActivity(Activity a) {
        return this.newActivity(a.getId(), a.getStartTime(), a.getEndTime(), this.getAttributes(a));
    }

    public Activity newActivity(QualifiedName a) {
        return this.newActivity(a, null, null, null);
    }

    public Activity newActivity(QualifiedName q, String label) {
        Activity res = this.newActivity(q);
        if (label != null) {
            res.getLabel().add(this.newInternationalizedString(label));
        }
        return res;
    }

    public Agent newAgent(Agent a) {
        return this.newAgent(a.getId(), this.getAttributes(a));
    }

    public Agent newAgent(QualifiedName ag) {
        return this.newAgent(ag, (Collection<Attribute>)null);
    }

    public Agent newAgent(QualifiedName ag, String label) {
        Agent res = this.newAgent(ag);
        if (label != null) {
            res.getLabel().add(this.newInternationalizedString(label));
        }
        return res;
    }

    public abstract Attribute newAttribute(QualifiedName var1, Object var2, QualifiedName var3);

    public abstract Attribute newAttribute(Attribute.AttributeKind var1, Object var2, QualifiedName var3);

    public Attribute newAttribute(String namespace, String localName, String prefix, Object value, QualifiedName type) {
        return this.newAttribute(this.newQualifiedName(namespace, localName, prefix), value, type);
    }

    @Override
    public DictionaryMembership newDictionaryMembership(QualifiedName dict, List<Entry> entitySet) {
        return this.newDictionaryMembership(null, dict, entitySet, null);
    }

    public Document newDocument() {
        return this.newDocument(null, null);
    }

    public Document newDocument(Activity[] ps, Entity[] as, Agent[] ags, Statement[] lks) {
        return this.newDocument(ps == null ? null : Arrays.asList(ps), as == null ? null : Arrays.asList(as), ags == null ? null : Arrays.asList(ags), lks == null ? null : Arrays.asList(lks));
    }

    public Document newDocument(Collection<Activity> ps, Collection<Entity> as, Collection<Agent> ags, Collection<Statement> lks) {
        LinkedList<Statement> statements = new LinkedList<Statement>();
        statements.addAll(ps);
        statements.addAll(as);
        statements.addAll(ags);
        statements.addAll(lks);
        return this.newDocument(null, statements, null);
    }

    public Document newDocument(Document doc) {
        return this.newDocument(doc.getNamespace(), doc.getStatementOrBundle());
    }

    public Duration newDuration(int durationInMilliSeconds) {
        return this.dataFactory.newDuration(durationInMilliSeconds);
    }

    @Override
    public Duration newDuration(String lexicalRepresentation) {
        Duration dur = this.dataFactory.newDuration(lexicalRepresentation);
        return dur;
    }

    public Entity newEntity(Entity e) {
        return this.newEntity(e.getId(), this.getAttributes(e));
    }

    public Entity newEntity(QualifiedName id) {
        return this.newEntity(id, (Collection<Attribute>)null);
    }

    public Entity newEntity(QualifiedName id, String label) {
        Entity res = this.newEntity(id);
        if (label != null) {
            res.getLabel().add(this.newInternationalizedString(label));
        }
        return res;
    }

    public abstract Entry newEntry(Key var1, QualifiedName var2);

    @Override
    public XMLGregorianCalendar newGDay(int day) {
        XMLGregorianCalendar cal = this.dataFactory.newXMLGregorianCalendar();
        cal.setDay(day);
        return cal;
    }

    @Override
    public XMLGregorianCalendar newGMonth(int month) {
        XMLGregorianCalendar cal = this.dataFactory.newXMLGregorianCalendar();
        cal.setMonth(month);
        return cal;
    }

    @Override
    public XMLGregorianCalendar newGMonthDay(int month, int day) {
        XMLGregorianCalendar cal = this.dataFactory.newXMLGregorianCalendar();
        cal.setMonth(month);
        cal.setDay(day);
        return cal;
    }

    @Override
    public XMLGregorianCalendar newGYear(int year) {
        XMLGregorianCalendar cal = this.dataFactory.newXMLGregorianCalendar();
        cal.setYear(year);
        return cal;
    }

    public HadMember newHadMember(QualifiedName collection, QualifiedName ... entities) {
        return this.newHadMember(collection, Arrays.asList(entities));
    }

    @Override
    public abstract HadMember newHadMember(QualifiedName var1, Collection<QualifiedName> var2);

    public abstract LangString newInternationalizedString(String var1);

    public abstract LangString newInternationalizedString(String var1, String var2);

    @Override
    public XMLGregorianCalendar newISOTime(String time) {
        return this.newTime(DatatypeConverter.parseDateTime((String)time).getTime());
    }

    @Override
    public XMLGregorianCalendar newISOTimeTZ(String time) {
        Calendar parsedDateTime = DatatypeConverter.parseDateTime((String)time);
        return this.newTime(parsedDateTime.getTime(), parsedDateTime.getTimeZone());
    }

    @Override
    public XMLGregorianCalendar newISOTimeUTC(String time) {
        return this.newISOTime(time, UTC_TIMEZONE);
    }

    public XMLGregorianCalendar newISOTime(String time, TimeZone timeZone) {
        Calendar parsedDateTime = DatatypeConverter.parseDateTime((String)time);
        return this.newTime(parsedDateTime.getTime(), timeZone);
    }

    public XMLGregorianCalendar newISOTime(String time, DateTimeOption option, TimeZone optionalTimeZone) {
        switch (option) {
            case TIMEZONE: {
                return this.newISOTime(time, optionalTimeZone);
            }
            case PRESERVE: {
                return this.newISOTimeTZ(time);
            }
            case UTC: {
                return this.newISOTimeUTC(time);
            }
            case SYSTEM: {
                return this.newISOTime(time);
            }
        }
        throw new UnsupportedOperationException("Unknown option: " + option);
    }

    public abstract Key newKey(Object var1, QualifiedName var2);

    public abstract Attribute newLabel(Object var1, QualifiedName var2);

    public abstract Location newLocation(Object var1, QualifiedName var2);

    public MentionOf newMentionOf(MentionOf r) {
        return this.newMentionOf(r.getSpecificEntity(), r.getGeneralEntity(), r.getBundle());
    }

    public Bundle newNamedBundle(QualifiedName id, Collection<Activity> ps, Collection<Entity> as, Collection<Agent> ags, Collection<Statement> lks) {
        LinkedList<Statement> statements = new LinkedList<Statement>();
        if (ps != null) {
            statements.addAll(ps);
        }
        if (as != null) {
            statements.addAll(as);
        }
        if (ags != null) {
            statements.addAll(ags);
        }
        if (lks != null) {
            statements.addAll(lks);
        }
        return this.newNamedBundle(id, null, statements);
    }

    public Bundle newNamedBundle(QualifiedName id, Collection<Statement> statements) {
        return this.newNamedBundle(id, null, statements);
    }

    @Override
    public abstract Bundle newNamedBundle(QualifiedName var1, Namespace var2, Collection<Statement> var3);

    public abstract Other newOther(QualifiedName var1, Object var2, QualifiedName var3);

    public Other newOther(String namespace, String local, String prefix, Object value, QualifiedName type) {
        QualifiedName elementName = this.newQualifiedName(namespace, local, prefix);
        return this.newOther(elementName, value, type);
    }

    @Override
    public abstract QualifiedName newQualifiedName(String var1, String var2, String var3);

    @Override
    public abstract QualifiedName newQualifiedName(String var1, String var2, String var3, ProvUtilities.BuildFlag var4);

    public QualifiedName newQualifiedName(QName qname) {
        return this.newQualifiedName(qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix());
    }

    public abstract Role newRole(Object var1, QualifiedName var2);

    public XMLGregorianCalendar newTime(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return this.newXMLGregorianCalendar(gc);
    }

    public XMLGregorianCalendar newTime(Date date, TimeZone timeZone) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.setTimeZone(timeZone);
        return this.newXMLGregorianCalendar(gc);
    }

    @Override
    public XMLGregorianCalendar newTimeNow() {
        return this.newTime(new Date());
    }

    public abstract Type newType(Object var1, QualifiedName var2);

    public Used newUsed(QualifiedName id) {
        return this.newUsed(id, null, null, null, null);
    }

    public Used newUsed(QualifiedName id, QualifiedName activity, String role, QualifiedName entity) {
        return this.newUsed(id, activity, entity, null, this.roleAsAttributeList(role));
    }

    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity) {
        return this.newUsed(id, activity, entity, null, null);
    }

    public Used newUsed(QualifiedName activity, QualifiedName entity) {
        return this.newUsed(null, activity, entity, null, null);
    }

    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time) {
        return this.newUsed(id, activity, entity, time, null);
    }

    public Used newUsed(Used u) {
        return this.newUsed(u.getId(), u.getActivity(), u.getEntity(), u.getTime(), this.getAttributes(u));
    }

    public Value newValue(String value) {
        return this.newValue(value, this.getName().XSD_STRING);
    }

    public Value newValue(int value) {
        return this.newValue(value, this.getName().XSD_INT);
    }

    public abstract Value newValue(Object var1, QualifiedName var2);

    public WasAssociatedWith newWasAssociatedWith(QualifiedName id) {
        return this.newWasAssociatedWith(id, null, null);
    }

    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName activity, QualifiedName agent) {
        return this.newWasAssociatedWith(id, activity, agent, null, null);
    }

    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan) {
        return this.newWasAssociatedWith(id, a, ag, plan, null);
    }

    public WasAssociatedWith newWasAssociatedWith(WasAssociatedWith u) {
        return this.newWasAssociatedWith(u.getId(), u.getActivity(), u.getAgent(), u.getPlan(), this.getAttributes(u));
    }

    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName entity, QualifiedName agent) {
        return this.newWasAttributedTo(id, entity, agent, null);
    }

    public WasAttributedTo newWasAttributedTo(WasAttributedTo u) {
        return this.newWasAttributedTo(u.getId(), u.getEntity(), u.getAgent(), this.getAttributes(u));
    }

    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName e2, QualifiedName e1) {
        return this.newWasDerivedFrom(id, e2, e1, null, null, null, null);
    }

    public WasDerivedFrom newWasDerivedFrom(QualifiedName e2, QualifiedName e1) {
        return this.newWasDerivedFrom(null, e2, e1, null, null, null, null);
    }

    public WasDerivedFrom newWasDerivedFrom(WasDerivedFrom d) {
        return this.newWasDerivedFrom(d.getId(), d.getGeneratedEntity(), d.getUsedEntity(), d.getActivity(), d.getGeneration(), d.getUsage(), this.getAttributes(d));
    }

    public WasEndedBy newWasEndedBy(QualifiedName id) {
        return this.newWasEndedBy(id, null, null, null, null, null);
    }

    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger) {
        return this.newWasEndedBy(id, activity, trigger, null, null, null);
    }

    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender) {
        return this.newWasEndedBy(id, activity, trigger, ender, null, null);
    }

    public WasEndedBy newWasEndedBy(WasEndedBy u) {
        return this.newWasEndedBy(u.getId(), u.getActivity(), u.getTrigger(), u.getEnder(), u.getTime(), this.getAttributes(u));
    }

    public WasGeneratedBy newWasGeneratedBy(Entity a, String role, Activity p) {
        return this.newWasGeneratedBy((QualifiedName)null, a, role, p);
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id) {
        return this.newWasGeneratedBy(id, null, null, null, null);
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, Entity a, String role, Activity p) {
        return this.newWasGeneratedBy(id, a.getId(), p.getId(), null, this.roleAsAttributeList(role));
    }

    private List<Attribute> roleAsAttributeList(String role) {
        LinkedList<Role> attrs = null;
        if (role != null) {
            attrs = new LinkedList<Role>();
            attrs.add(this.newRole(role, this.getName().XSD_STRING));
        }
        return attrs;
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName entity, String role, QualifiedName activity) {
        return this.newWasGeneratedBy(id, entity, activity, null, this.roleAsAttributeList(role));
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName entity, QualifiedName activity) {
        return this.newWasGeneratedBy(id, entity, null, activity);
    }

    public WasGeneratedBy newWasGeneratedBy(WasGeneratedBy wgb) {
        return this.newWasGeneratedBy(wgb.getId(), wgb.getEntity(), wgb.getActivity(), wgb.getTime(), this.getAllAttributes(wgb));
    }

    protected List<Attribute> getAllAttributes(Statement s) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        if (s instanceof HasRole && ((HasRole)((Object)s)).getRole() != null) {
            attrs.addAll(((HasRole)((Object)s)).getRole());
        }
        if (s instanceof HasRole && ((HasType)((Object)s)).getType() != null) {
            attrs.addAll(((HasType)((Object)s)).getType());
        }
        if (s instanceof HasLabel && ((HasLabel)((Object)s)).getLabel() != null) {
            attrs.addAll(((HasLabel)((Object)s)).getLabel().stream().map(l -> this.newLabel(l, this.getName().XSD_STRING)).collect(Collectors.toList()));
        }
        if (s instanceof HasLocation && ((HasLocation)((Object)s)).getLocation() != null) {
            attrs.addAll(((HasLocation)((Object)s)).getLocation());
        }
        if (s instanceof HasOther && ((HasOther)((Object)s)).getOther() != null) {
            attrs.addAll(((HasOther)((Object)s)).getOther());
        }
        return attrs;
    }

    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName influencee, QualifiedName influencer) {
        return this.newWasInfluencedBy(id, influencee, influencer, null);
    }

    public WasInfluencedBy newWasInfluencedBy(WasInfluencedBy in) {
        return this.newWasInfluencedBy(in.getId(), in.getInfluencee(), in.getInfluencer(), this.getAllAttributes(in));
    }

    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName informed, QualifiedName informant) {
        return this.newWasInformedBy(id, informed, informant, null);
    }

    public WasInformedBy newWasInformedBy(WasInformedBy d) {
        return this.newWasInformedBy(d.getId(), d.getInformed(), d.getInformant(), this.getAllAttributes(d));
    }

    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName eid, QualifiedName aid) {
        return this.newWasInvalidatedBy(null, eid, aid, null, null);
    }

    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity) {
        return this.newWasInvalidatedBy(id, entity, activity, null, null);
    }

    public WasInvalidatedBy newWasInvalidatedBy(WasInvalidatedBy u) {
        return this.newWasInvalidatedBy(u.getId(), u.getEntity(), u.getActivity(), u.getTime(), this.getAttributes(u));
    }

    public WasStartedBy newWasStartedBy(QualifiedName id) {
        return this.newWasStartedBy(id, null, null, null, null, null);
    }

    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger) {
        return this.newWasStartedBy(id, activity, trigger, null, null, null);
    }

    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter) {
        return this.newWasStartedBy(id, activity, trigger, starter, null, null);
    }

    public WasStartedBy newWasStartedBy(WasStartedBy u) {
        return this.newWasStartedBy(u.getId(), u.getActivity(), u.getTrigger(), u.getStarter(), u.getTime(), this.getAttributes(u));
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar gc) {
        return this.dataFactory.newXMLGregorianCalendar(gc);
    }

    public XMLGregorianCalendar newYear(int year) {
        XMLGregorianCalendar res = this.dataFactory.newXMLGregorianCalendar();
        res.setYear(year);
        return res;
    }

    public Collection<Attribute> getAttributes(Statement statement) {
        Value val;
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        if (statement instanceof HasType) {
            result.addAll(((HasType)((Object)statement)).getType());
        }
        if (statement instanceof HasLocation) {
            result.addAll(((HasLocation)((Object)statement)).getLocation());
        }
        if (statement instanceof HasRole) {
            result.addAll(((HasRole)((Object)statement)).getRole());
        }
        if (statement instanceof HasValue && (val = ((HasValue)((Object)statement)).getValue()) != null) {
            result.add(val);
        }
        if (statement instanceof HasOther) {
            result.addAll(((HasOther)((Object)statement)).getOther());
        }
        return result;
    }

    public void setAttributes(HasOther res, Collection<Attribute> attributes) {
        if (attributes == null) {
            return;
        }
        if (attributes.isEmpty()) {
            return;
        }
        HasType typ = res instanceof HasType ? (HasType)((Object)res) : null;
        HasLocation loc = res instanceof HasLocation ? (HasLocation)((Object)res) : null;
        HasLabel lab = res instanceof HasLabel ? (HasLabel)((Object)res) : null;
        HasValue aval = res instanceof HasValue ? (HasValue)((Object)res) : null;
        HasRole rol = res instanceof HasRole ? (HasRole)((Object)res) : null;
        for (Attribute attr : attributes) {
            Object aValue = attr.getValue();
            ValueConverter vconv = new ValueConverter(this);
            if (this.getName().RDF_LITERAL.equals(attr.getType()) && aValue instanceof String) {
                System.out.println("Converting " + aValue);
                aValue = vconv.convertToJava(attr.getType(), (String)aValue);
            }
            switch (attr.getKind()) {
                case PROV_LABEL: {
                    if (lab == null) break;
                    if (aValue instanceof LangString) {
                        lab.getLabel().add((LangString)aValue);
                        break;
                    }
                    lab.getLabel().add(this.newInternationalizedString(aValue.toString()));
                    break;
                }
                case PROV_LOCATION: {
                    if (loc == null) break;
                    loc.getLocation().add(this.newLocation(aValue, attr.getType()));
                    break;
                }
                case PROV_ROLE: {
                    if (rol == null) break;
                    rol.getRole().add(this.newRole(aValue, attr.getType()));
                    break;
                }
                case PROV_TYPE: {
                    if (typ == null) break;
                    typ.getType().add(this.newType(aValue, attr.getType()));
                    break;
                }
                case PROV_VALUE: {
                    if (aval == null) break;
                    aval.setValue(this.newValue(aValue, attr.getType()));
                    break;
                }
                case OTHER: {
                    res.getOther().add(this.newOther(attr.getElementName(), aValue, attr.getType()));
                    break;
                }
            }
        }
    }

    @Override
    public void startBundle(QualifiedName bundleId, Namespace namespaces) {
    }

    @Override
    public void startDocument(Namespace namespace) {
    }

    public Namespace newNamespace(Namespace ns) {
        return new Namespace(ns);
    }

    public Namespace newNamespace() {
        return new Namespace();
    }

    public AlternateOf newAlternateOf(AlternateOf s) {
        return this.newAlternateOf(s.getAlternate1(), s.getAlternate2());
    }

    public SpecializationOf newSpecializationOf(SpecializationOf s) {
        return this.newSpecializationOf(s.getSpecificEntity(), s.getGeneralEntity());
    }

    public HadMember newHadMember(HadMember s) {
        return this.newHadMember(s.getCollection(), s.getEntity());
    }

    public <T extends Statement> T newStatement(T s) {
        return (T)((Statement)this.util.doAction(s, new Cloner()));
    }

    public class Cloner
    implements StatementActionValue {
        @Override
        public Object doAction(Activity s) {
            return ProvFactory.this.newActivity(s);
        }

        @Override
        public Object doAction(Used s) {
            return ProvFactory.this.newUsed(s);
        }

        @Override
        public Object doAction(WasStartedBy s) {
            return ProvFactory.this.newWasStartedBy(s);
        }

        @Override
        public Object doAction(Agent s) {
            return ProvFactory.this.newAgent(s);
        }

        @Override
        public Object doAction(AlternateOf s) {
            return ProvFactory.this.newAlternateOf(s);
        }

        @Override
        public Object doAction(WasAssociatedWith s) {
            return ProvFactory.this.newWasAssociatedWith(s);
        }

        @Override
        public Object doAction(WasAttributedTo s) {
            return ProvFactory.this.newWasAttributedTo(s);
        }

        @Override
        public Object doAction(WasInfluencedBy s) {
            return ProvFactory.this.newWasInfluencedBy(s);
        }

        @Override
        public Object doAction(ActedOnBehalfOf s) {
            return ProvFactory.this.newActedOnBehalfOf(s);
        }

        @Override
        public Object doAction(WasDerivedFrom s) {
            return ProvFactory.this.newWasDerivedFrom(s);
        }

        @Override
        public Object doAction(DictionaryMembership s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object doAction(DerivedByRemovalFrom s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object doAction(WasEndedBy s) {
            return ProvFactory.this.newWasEndedBy(s);
        }

        @Override
        public Object doAction(Entity s) {
            return ProvFactory.this.newEntity(s);
        }

        @Override
        public Object doAction(WasGeneratedBy s) {
            return ProvFactory.this.newWasGeneratedBy(s);
        }

        @Override
        public Object doAction(WasInvalidatedBy s) {
            return ProvFactory.this.newWasInvalidatedBy(s);
        }

        @Override
        public Object doAction(HadMember s) {
            return ProvFactory.this.newHadMember(s);
        }

        @Override
        public Object doAction(MentionOf s) {
            return ProvFactory.this.newMentionOf(s);
        }

        @Override
        public Object doAction(SpecializationOf s) {
            return ProvFactory.this.newSpecializationOf(s);
        }

        @Override
        public Object doAction(QualifiedSpecializationOf s) {
            return ProvFactory.this.newQualifiedSpecializationOf(s.getId(), s.getSpecificEntity(), s.getGeneralEntity(), ProvFactory.this.getAttributes(s));
        }

        @Override
        public Object doAction(QualifiedHadMember s) {
            return ProvFactory.this.newQualifiedHadMember(s.getId(), s.getCollection(), s.getEntity(), ProvFactory.this.getAttributes(s));
        }

        @Override
        public Object doAction(DerivedByInsertionFrom s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object doAction(WasInformedBy s) {
            return ProvFactory.this.newWasInformedBy(s);
        }

        @Override
        public Object doAction(Bundle s, ProvUtilities provUtilities) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object doAction(QualifiedAlternateOf s) {
            return ProvFactory.this.newQualifiedAlternateOf(s.getId(), s.getAlternate1(), s.getAlternate2(), ProvFactory.this.getAttributes(s));
        }
    }
}

