/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model.builder;

import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.builder.Builder;
import org.openprovenance.prov.model.builder.Prefix;

public abstract class GenericBuilder<T extends GenericBuilder<T>> {
    protected final Builder parent;
    protected final ModelConstructor mc;
    protected final ProvFactory pf;
    private final T me;
    protected final QualifiedName provType;
    protected final QualifiedName provRole;
    protected QualifiedName id;
    protected List<Attribute> attrs = new LinkedList<Attribute>();
    private final QualifiedName provLabel;
    protected final QualifiedName provValue;
    private final QualifiedName provLocation;

    public GenericBuilder(Builder builder, ModelConstructor mc, ProvFactory pf) {
        this.parent = builder;
        this.mc = mc;
        this.pf = pf;
        this.me = this;
        this.provLocation = pf.getName().PROV_LOCATION;
        this.provLabel = pf.getName().PROV_LABEL;
        this.provType = pf.getName().PROV_TYPE;
        this.provValue = pf.getName().PROV_VALUE;
        this.provRole = pf.getName().PROV_ROLE;
    }

    public final QualifiedName qn(String prefix, String local) {
        return this.parent.qn(prefix, local);
    }

    public final QualifiedName qn(Prefix prefix, String local) {
        return this.parent.qn(prefix, local);
    }

    public ProvFactory pf() {
        return this.pf;
    }

    public QualifiedName provRole() {
        return this.provRole;
    }

    public T id(QualifiedName id) {
        this.id = id;
        return this.me;
    }

    public T id(String prefix, String local) {
        this.id = this.qn(prefix, local);
        return this.me;
    }

    public T id(Prefix prefix, String local) {
        this.id = this.qn(prefix.get(), local);
        return this.me;
    }

    public T attr(Attribute attr) {
        this.attrs.add(attr);
        return this.me;
    }

    public T attr(QualifiedName elementName, Object value, QualifiedName type) {
        return this.attr(this.pf.newAttribute(elementName, value, type));
    }

    public T attr(QualifiedName elementName, boolean value) {
        return this.attr(this.pf.newAttribute(elementName, (Object)("" + value), this.pf.getName().XSD_BOOLEAN));
    }

    public T attr(QualifiedName elementName, int value) {
        return this.attr(this.pf.newAttribute(elementName, (Object)("" + value), this.pf.getName().XSD_INTEGER));
    }

    public T attr(QualifiedName elementName, double value) {
        return this.attr(this.pf.newAttribute(elementName, (Object)("" + value), this.pf.getName().XSD_DOUBLE));
    }

    public T attr(QualifiedName elementName, String value) {
        return this.attr(this.pf.newAttribute(elementName, (Object)value, this.pf.getName().XSD_STRING));
    }

    public T label(String lab) {
        return this.attr(this.pf.newAttribute(this.provLabel, (Object)lab, this.pf.getName().XSD_STRING));
    }

    public T type(QualifiedName qn) {
        return this.attr(this.pf.newAttribute(this.provType, (Object)qn, this.pf.getName().PROV_QUALIFIED_NAME));
    }

    public T type(String prefix, String local) {
        return this.attr(this.pf.newAttribute(this.provType, (Object)this.pf.newQualifiedName(this.parent.namespace.lookupPrefix(prefix), local, prefix), this.pf.getName().PROV_QUALIFIED_NAME));
    }

    public T type(Prefix prefix, String local) {
        return this.attr(this.pf.newAttribute(this.provType, (Object)this.pf.newQualifiedName(this.parent.namespace.lookupPrefix(prefix.get()), local, prefix.get()), this.pf.getName().PROV_QUALIFIED_NAME));
    }

    public T location(QualifiedName qn) {
        return this.attr(this.pf.newAttribute(this.provLocation, (Object)qn, this.pf.getName().PROV_QUALIFIED_NAME));
    }

    public T prefix(String prefix, String ns) {
        this.parent.prefix(prefix, ns);
        return this.me;
    }
}

