/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model.builder;

import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.builder.Builder;
import org.openprovenance.prov.model.builder.GenericBuilder;

public class HadMemberBuilder
extends GenericBuilder<HadMemberBuilder> {
    protected final ModelConstructorExtension mce;
    protected QualifiedName collection;
    protected List<QualifiedName> entity = new LinkedList<QualifiedName>();

    public HadMemberBuilder(Builder builder, ModelConstructor mc, ModelConstructorExtension mce, ProvFactory pf) {
        super(builder, mc, pf);
        this.mce = mce;
    }

    public HadMemberBuilder collection(QualifiedName collection) {
        this.collection = collection;
        return this;
    }

    public HadMemberBuilder collection(String prefix, String local) {
        this.collection = this.qn(prefix, local);
        return this;
    }

    public HadMemberBuilder collection(String knownAs) {
        QualifiedName qn = this.parent.knownAs.get(knownAs);
        if (qn == null) {
            throw new NullPointerException("collection cannot find knownAs " + knownAs + " in " + this.parent.knownAs.keySet());
        }
        this.collection = qn;
        return this;
    }

    public HadMemberBuilder entity(QualifiedName entity) {
        this.entity.add(entity);
        return this;
    }

    public HadMemberBuilder entity(String knownAs) {
        QualifiedName qn = this.parent.knownAs.get(knownAs);
        if (qn == null) {
            throw new NullPointerException("generalEntity cannot find knownAs " + knownAs + " in " + this.parent.knownAs);
        }
        this.entity.add(qn);
        return this;
    }

    public HadMemberBuilder entity(String prefix, String local) {
        this.entity.add(this.qn(prefix, local));
        return this;
    }

    public Builder build() {
        if (this.id == null && this.attrs.isEmpty()) {
            this.parent.statements.add(this.mc.newHadMember(this.collection, this.entity));
        } else {
            this.parent.statements.add(this.mce.newQualifiedHadMember(this.id, this.collection, this.entity, this.attrs));
        }
        return this.parent;
    }

    public Builder build(boolean oneAtTheTime) {
        if (this.id == null && this.attrs.isEmpty()) {
            if (oneAtTheTime) {
                for (QualifiedName e : this.entity) {
                    this.parent.statements.add(this.mc.newHadMember(this.collection, List.of(e)));
                }
            } else {
                this.parent.statements.add(this.mc.newHadMember(this.collection, this.entity));
            }
        } else if (oneAtTheTime) {
            for (QualifiedName e : this.entity) {
                this.parent.statements.add(this.mce.newQualifiedHadMember(this.id, this.collection, List.of(e), this.attrs));
            }
        } else {
            this.parent.statements.add(this.mce.newQualifiedHadMember(this.id, this.collection, this.entity, this.attrs));
        }
        return this.parent;
    }
}

