/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model.builder;

import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.builder.Builder;
import org.openprovenance.prov.model.builder.GenericBuilder;

public class SpecializationOfBuilder
extends GenericBuilder<SpecializationOfBuilder> {
    protected final ModelConstructorExtension mce;
    protected QualifiedName specificEntity;
    protected QualifiedName generalEntity;

    public SpecializationOfBuilder(Builder builder, ModelConstructor mc, ModelConstructorExtension mce, ProvFactory pf) {
        super(builder, mc, pf);
        this.mce = mce;
    }

    public SpecializationOfBuilder specificEntity(QualifiedName specificEntity) {
        this.specificEntity = specificEntity;
        return this;
    }

    public SpecializationOfBuilder specificEntity(String prefix, String local) {
        this.specificEntity = this.qn(prefix, local);
        return this;
    }

    public SpecializationOfBuilder specificEntity(String knownAs) {
        QualifiedName qn = this.parent.knownAs.get(knownAs);
        if (qn == null) {
            throw new NullPointerException("specificEntity cannot find knownAs " + knownAs + " in " + this.parent.knownAs.keySet());
        }
        this.specificEntity = qn;
        return this;
    }

    public SpecializationOfBuilder generalEntity(QualifiedName generalEntity) {
        this.generalEntity = generalEntity;
        return this;
    }

    public SpecializationOfBuilder generalEntity(String knownAs) {
        QualifiedName qn = this.parent.knownAs.get(knownAs);
        if (qn == null) {
            throw new NullPointerException("generalEntity cannot find knownAs " + knownAs + " in " + this.parent.knownAs);
        }
        this.generalEntity = qn;
        return this;
    }

    public SpecializationOfBuilder generalEntity(String prefix, String local) {
        this.generalEntity = this.qn(prefix, local);
        return this;
    }

    public Builder build() {
        if (this.id == null && this.attrs.isEmpty()) {
            this.parent.statements.add(this.mc.newSpecializationOf(this.specificEntity, this.generalEntity));
        } else {
            this.parent.statements.add(this.mce.newQualifiedSpecializationOf(this.id, this.specificEntity, this.generalEntity, this.attrs));
        }
        return this.parent;
    }
}

