package org.openprovenance.prov.model.interop;

import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

/** enough of the interop framework, to load it dynamically, and be able to call it in the code
 * generated by the prov-template-compiler, without having a dependency on prov-interop. */
public interface Framework {
    ProvFactory getFactory();
    void writeDocument(OutputStream os, Document document, Formats.ProvFormat format);

    static Framework dynamicLoad() {
        return dynamicallyLoadInteropFramework("org.openprovenance.prov.interop.InteropFramework");
    }

    static Properties getPropertiesFromClasspath(String propFileName) {
        return Configuration.getPropertiesFromClasspath(Framework.class, propFileName);
    }

    static Framework dynamicallyLoadInteropFramework(String className) {
        Class<?> clazz=null;
        try {
            clazz = Class.forName(className);
            Constructor<?> constructor=clazz.getConstructor();
            return (Framework) constructor.newInstance(new Object[0]);
        } catch (ClassNotFoundException | NoSuchMethodException | IllegalAccessException | InvocationTargetException |
                 InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }


}
