/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.DOMProcessing;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.DocumentEquality;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasLocation;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasRole;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.test.ExtensionRoundTripFromJavaTest;
import org.openprovenance.prov.model.test.ProvFrameworkTest;
import org.w3c.dom.Element;

public class AttributeTest
extends ProvFrameworkTest {
    Logger logger = LogManager.getLogger(AttributeTest.class);
    public static final String EX_NS = "http://example.org/";
    public static final String EX2_NS = "http://example2.org/";
    public static final String EX_PREFIX = "ex";
    public static final String EX2_PREFIX = "ex2";
    public static final String EX4_PREFIX = "ex4";
    public static ProvFactory pFactory;
    public static Name name;
    public static boolean warned;
    public boolean urlFlag = true;
    Map<String, Document> table = new Hashtable<String, Document>();
    public boolean test = true;
    public Object[][] attributeValues_small;
    public Object[][] attributeValues;

    public AttributeTest() {
        this.attributeValues_small = new Object[][]{{"un lieu", AttributeTest.name.XSD_STRING}, {pFactory.newInternationalizedString("un lieu", "fr"), AttributeTest.name.XSD_STRING}, {pFactory.newInternationalizedString("a place", "en"), AttributeTest.name.XSD_STRING}};
        this.attributeValues = new Object[][]{{"un lieu", AttributeTest.name.XSD_STRING}, {pFactory.newInternationalizedString("un lieu", "fr"), AttributeTest.name.PROV_LANG_STRING}, {pFactory.newInternationalizedString("a place", "en"), AttributeTest.name.PROV_LANG_STRING}, {1, AttributeTest.name.XSD_INT}, {1, AttributeTest.name.XSD_LONG}, {1, AttributeTest.name.XSD_SHORT}, {2.0, AttributeTest.name.XSD_DOUBLE}, {1.0, AttributeTest.name.XSD_FLOAT}, {10, AttributeTest.name.XSD_DECIMAL}, {true, AttributeTest.name.XSD_BOOLEAN}, {false, AttributeTest.name.XSD_BOOLEAN}, {10, AttributeTest.name.XSD_BYTE}, {10, AttributeTest.name.XSD_UNSIGNED_INT}, {10, AttributeTest.name.XSD_UNSIGNED_LONG}, {10, AttributeTest.name.XSD_INTEGER}, {10, AttributeTest.name.XSD_UNSIGNED_SHORT}, {10, AttributeTest.name.XSD_NON_NEGATIVE_INTEGER}, {-10, AttributeTest.name.XSD_NON_POSITIVE_INTEGER}, {10, AttributeTest.name.XSD_POSITIVE_INTEGER}, {10, AttributeTest.name.XSD_UNSIGNED_BYTE}, {"http://example.org", AttributeTest.name.XSD_ANY_URI}, {pFactory.newQualifiedName(EX_NS, "abc", EX_PREFIX), AttributeTest.name.PROV_QUALIFIED_NAME}, {pFactory.newQualifiedName(EX_NS, "abcd", "other"), AttributeTest.name.PROV_QUALIFIED_NAME}, {pFactory.newQualifiedName(EX_NS, "abcde", null), AttributeTest.name.PROV_QUALIFIED_NAME}, {pFactory.newQualifiedName("http://example4.org/", "zabc", EX_PREFIX), AttributeTest.name.PROV_QUALIFIED_NAME}, {pFactory.newQualifiedName("http://example4.org/", "zabcd", "other"), AttributeTest.name.PROV_QUALIFIED_NAME}, {pFactory.newQualifiedName("http://example4.org/", "zabcde", null), AttributeTest.name.PROV_QUALIFIED_NAME}, {pFactory.newTimeNow(), AttributeTest.name.XSD_DATETIME}, {pFactory.newYear(2013), AttributeTest.name.XSD_GYEAR}, {pFactory.newGMonth(1), AttributeTest.name.XSD_GMONTH}, {pFactory.newGDay(30), AttributeTest.name.XSD_GDAY}, {pFactory.newGMonthDay(11, 7), AttributeTest.name.XSD_GMONTH_DAY}, {pFactory.newDuration(12225), AttributeTest.name.XSD_DURATION}, {pFactory.newDuration(1222), AttributeTest.name.XSD_DURATION}, {pFactory.newDuration("P2Y6M"), AttributeTest.name.XSD_YEAR_MONTH_DURATION}, {pFactory.newDuration("P2147483647DT2147483647H2147483647M123456789012345.123456789012345S"), AttributeTest.name.XSD_DAY_TIME_DURATION}, {new byte[]{0, 1, 2, 34, 5, 6}, AttributeTest.name.XSD_HEX_BINARY}, {new byte[]{0, 1, 2, 34, 5, 6}, AttributeTest.name.XSD_BASE64_BINARY}, {new byte[1023], AttributeTest.name.XSD_BASE64_BINARY}, {"en", AttributeTest.name.XSD_LANGUAGE}, {"normal", AttributeTest.name.XSD_NORMALIZED_STRING}, {"TOK", AttributeTest.name.XSD_TOKEN}, {"NMTOK", AttributeTest.name.XSD_NMTOKEN}, {"name", AttributeTest.name.XSD_NAME}, {"NCName", AttributeTest.name.XSD_NCNAME}};
        this.documentEquality = new DocumentEquality(this.mergeDuplicateProperties(), null);
        if (!warned) {
            warned = true;
            this.logger.warn("AttributeTest not supporting RDF_LITERAL type for attributes");
            this.logger.warn("AttributeTest not supporting dictionaries");
            this.logger.warn("AttributeTest not supporting MentionOf");
        }
    }

    @Override
    public void updateNamespaces(Document doc) {
        Namespace ns = Namespace.gatherNamespaces((Document)doc);
        doc.setNamespace(ns);
    }

    @Override
    public void compareDocAndFile(Document doc, String file, boolean check) {
        file = (String)file + this.extension();
        this.writeDocument(doc, (String)file);
        if (check) {
            this.conditionalCheckSchema((String)file);
        }
        Document doc3 = this.readDocument((String)file);
        this.documentComparator.compareDocuments(doc, doc3, check && this.checkTest((String)file));
        this.updateNamespaces(doc3);
        this.writeDocument(doc3, (String)file + "-2");
    }

    @Override
    public void conditionalCheckSchema(String file) {
        if (this.checkSchema(file)) {
            this.doCheckSchema1(file);
        }
    }

    @Override
    public boolean checkSchema(String name) {
        return !name.endsWith("33" + this.extension()) && !name.endsWith("33" + this.extension()) && !name.endsWith("34" + this.extension()) && !name.endsWith("attr_delegation0" + this.extension()) && !name.endsWith("attr_end0" + this.extension()) && !name.endsWith("attr_attribution0" + this.extension()) && !name.endsWith("attr_generation0" + this.extension()) && !name.endsWith("attr_derivation0" + this.extension()) && !name.endsWith("attr_activity0" + this.extension()) && !name.endsWith("attr_influence0" + this.extension()) && !name.endsWith("attr_invalidation0" + this.extension()) && !name.endsWith("attr_agent0" + this.extension()) && !name.endsWith("attr_start0" + this.extension()) && !name.endsWith("attr_usage0" + this.extension()) && !name.endsWith("attr_association0" + this.extension()) && !name.endsWith("attr_communication0" + this.extension()) && !name.endsWith("attr_entity0" + this.extension());
    }

    public void doCheckSchema2(String file) {
        String command = "xmllint --schema src/main/resources/ex.xsd " + file;
        try {
            Process proc = Runtime.getRuntime().exec(command);
            proc.waitFor();
            int code = proc.exitValue();
            if (code != 0) {
                BufferedReader outReader;
                String s_out;
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                String s_error = errorReader.readLine();
                if (s_error != null) {
                    System.out.println("Error:  " + s_error);
                }
                if ((s_out = (outReader = new BufferedReader(new InputStreamReader(proc.getInputStream()))).readLine()) != null) {
                    System.out.println("Out:  " + s_out);
                }
            }
            AttributeTest.assertTrue((code == 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Document readDocument(String file1) {
        return this.table.get(file1);
    }

    @Override
    public void writeDocument(Document doc, String file2) {
        this.logger.info("deep copy of " + file2);
        Namespace.withThreadNamespace((Namespace)doc.getNamespace());
        Document doc2 = ExtensionRoundTripFromJavaTest.deepCopy(doc);
        this.table.put(file2, doc2);
    }

    Element createXMLLiteral() {
        DocumentBuilder builder = DOMProcessing.builder;
        org.w3c.dom.Document doc = builder.newDocument();
        Element el1 = doc.createElementNS("http://app/", "ap:aaa");
        Element el2 = doc.createElementNS("http://app/", "ap:bbb");
        Element el3 = doc.createElementNS("http://app/", "ap:ccc");
        el2.appendChild(el3);
        el1.appendChild(el2);
        return el1;
    }

    @Override
    public void addLocations(HasLocation hl) {
        for (Object[] pair : this.attributeValues) {
            Object value = pair[0];
            QualifiedName type = (QualifiedName)pair[1];
            hl.getLocation().add(pFactory.newLocation(value, type));
        }
    }

    @Override
    public void addTypes(HasType hl) {
        for (Object[] pair : this.attributeValues) {
            Object value = pair[0];
            QualifiedName type = (QualifiedName)pair[1];
            hl.getType().add(pFactory.newType(value, type));
        }
    }

    public void addRoles(HasRole hl) {
        for (Object[] pair : this.attributeValues) {
            Object value = pair[0];
            QualifiedName type = (QualifiedName)pair[1];
            hl.getRole().add(pFactory.newRole(value, type));
        }
    }

    public void addOthers(HasOther ho, QualifiedName elementName) {
        for (Object[] pair : this.attributeValues) {
            Object value = pair[0];
            QualifiedName type = (QualifiedName)pair[1];
            if (value instanceof QualifiedName) {
                QualifiedName qq = (QualifiedName)value;
                if (qq.getPrefix() != null && qq.getPrefix().equals(elementName.getPrefix()) && !qq.getNamespaceURI().equals(elementName.getNamespaceURI())) continue;
                ho.getOther().add(pFactory.newOther(elementName, value, type));
                continue;
            }
            ho.getOther().add(pFactory.newOther(elementName, value, type));
        }
    }

    public void doEntityWithOneTypeAttribute(int i) {
        Entity a = pFactory.newEntity(this.q("et" + i));
        Object[] pair = this.attributeValues[i];
        Object value = pair[0];
        QualifiedName type = (QualifiedName)pair[1];
        a.getType().add(pFactory.newType(value, type));
        this.makeDocAndTest((Statement)a, "target/attr_entity_one_attr" + i);
    }

    public void doTestEntityWithOneValueAttribute(int i) {
        Entity a = pFactory.newEntity(this.q("en_v" + i));
        Object[] pair = this.attributeValues[i];
        Object value = pair[0];
        QualifiedName type = (QualifiedName)pair[1];
        a.setValue(pFactory.newValue(value, type));
        this.makeDocAndTest((Statement)a, "target/attr_entity_one_value_attr" + i);
    }

    public void doTestAssociationWithOneRoleAttribute(int i) {
        WasAssociatedWith a = pFactory.newWasAssociatedWith(this.q("ass_r" + i), this.q("a1"), this.q("ag1"));
        Object[] pair = this.attributeValues[i];
        Object value = pair[0];
        QualifiedName type = (QualifiedName)pair[1];
        a.getRole().add(pFactory.newRole(value, type));
        this.makeDocAndTest((Statement)a, "target/attr_association_one_role_attr" + i);
    }

    public void doTestEntityWithOneLocationAttribute(int i) {
        Entity a = pFactory.newEntity(this.q("en_l" + i));
        Object[] pair = this.attributeValues[i];
        Object value = pair[0];
        QualifiedName type = (QualifiedName)pair[1];
        a.getLocation().add(pFactory.newLocation(value, type));
        this.makeDocAndTest((Statement)a, "target/attr_entity_one_location_attr" + i);
    }

    public void doTestEntityWithOneOtherAttribute(int i) {
        Entity a = pFactory.newEntity(this.q("en_o" + i));
        Object[] pair = this.attributeValues[i];
        Object value = pair[0];
        QualifiedName type = (QualifiedName)pair[1];
        a.getOther().add(pFactory.newOther(pFactory.newQualifiedName(EX_NS, "tag2", "exo"), value, type));
        this.makeDocAndTest((Statement)a, "target/attr_entity_one_other_attr" + i);
    }

    public void testEntityWithOneValueAttribute0() {
        this.doTestEntityWithOneValueAttribute(0);
    }

    public void testEntityWithOneValueAttribute1() {
        this.doTestEntityWithOneValueAttribute(1);
    }

    public void testEntityWithOneValueAttribute2() {
        this.doTestEntityWithOneValueAttribute(2);
    }

    public void testEntityWithOneValueAttribute3() {
        this.doTestEntityWithOneValueAttribute(3);
    }

    public void testEntityWithOneValueAttribute4() {
        this.doTestEntityWithOneValueAttribute(4);
    }

    public void testEntityWithOneValueAttribute5() {
        this.doTestEntityWithOneValueAttribute(5);
    }

    public void testEntityWithOneValueAttribute6() {
        this.doTestEntityWithOneValueAttribute(6);
    }

    public void testEntityWithOneValueAttribute7() {
        this.doTestEntityWithOneValueAttribute(7);
    }

    public void testEntityWithOneValueAttribute8() {
        this.doTestEntityWithOneValueAttribute(8);
    }

    public void testEntityWithOneValueAttribute9() {
        this.doTestEntityWithOneValueAttribute(9);
    }

    public void testEntityWithOneValueAttribute10() {
        this.doTestEntityWithOneValueAttribute(10);
    }

    public void testEntityWithOneValueAttribute11() {
        this.doTestEntityWithOneValueAttribute(11);
    }

    public void testEntityWithOneValueAttribute12() {
        this.doTestEntityWithOneValueAttribute(12);
    }

    public void testEntityWithOneValueAttribute13() {
        this.doTestEntityWithOneValueAttribute(13);
    }

    public void testEntityWithOneValueAttribute14() {
        this.doTestEntityWithOneValueAttribute(14);
    }

    public void testEntityWithOneValueAttribut15() {
        this.doTestEntityWithOneValueAttribute(15);
    }

    public void testEntityWithOneValueAttribute16() {
        this.doTestEntityWithOneValueAttribute(16);
    }

    public void testEntityWithOneValueAttribute17() {
        this.doTestEntityWithOneValueAttribute(17);
    }

    public void testEntityWithOneValueAttribute18() {
        this.doTestEntityWithOneValueAttribute(18);
    }

    public void testEntityWithOneValueAttribute19() {
        this.doTestEntityWithOneValueAttribute(19);
    }

    public void testEntityWithOneValueAttribute20() {
        this.doTestEntityWithOneValueAttribute(20);
    }

    public void testEntityWithOneValueAttribute21() {
        this.doTestEntityWithOneValueAttribute(21);
    }

    public void testEntityWithOneValueAttribute22() {
        this.doTestEntityWithOneValueAttribute(22);
    }

    public void testEntityWithOneValueAttribute23() {
        this.doTestEntityWithOneValueAttribute(23);
    }

    public void testEntityWithOneValueAttribute24() {
        this.doTestEntityWithOneValueAttribute(24);
    }

    public void testEntityWithOneValueAttribute25() {
        this.doTestEntityWithOneValueAttribute(25);
    }

    public void testEntityWithOneValueAttribute26() {
        this.doTestEntityWithOneValueAttribute(26);
    }

    public void testEntityWithOneValueAttribute27() {
        this.doTestEntityWithOneValueAttribute(27);
    }

    public void testEntityWithOneValueAttribute28() {
        this.doTestEntityWithOneValueAttribute(28);
    }

    public void testEntityWithOneValueAttribute29() {
        this.doTestEntityWithOneValueAttribute(29);
    }

    public void testEntityWithOneValueAttribute30() {
        this.doTestEntityWithOneValueAttribute(30);
    }

    public void testEntityWithOneValueAttribute31() {
        this.doTestEntityWithOneValueAttribute(31);
    }

    public void testEntityWithOneValueAttribute32() {
        this.doTestEntityWithOneValueAttribute(32);
    }

    public void testEntityWithOneValueAttribute33() {
        this.doTestEntityWithOneValueAttribute(33);
    }

    public void testEntityWithOneValueAttribute34() {
        this.doTestEntityWithOneValueAttribute(34);
    }

    public void testEntityWithOneValueAttribute35() {
        this.doTestEntityWithOneValueAttribute(35);
    }

    public void testEntityWithOneValueAttribute36() {
        this.doTestEntityWithOneValueAttribute(36);
    }

    public void testEntityWithOneValueAttribute37() {
        this.doTestEntityWithOneValueAttribute(37);
    }

    public void testEntityWithOneValueAttribute38() {
        this.doTestEntityWithOneValueAttribute(38);
    }

    public void testEntityWithOneValueAttribute39() {
        this.doTestEntityWithOneValueAttribute(39);
    }

    public void testEntityWithOneValueAttribute40() {
        this.doTestEntityWithOneValueAttribute(40);
    }

    public void testEntityWithOneValueAttribute41() {
        this.doTestEntityWithOneValueAttribute(41);
    }

    public void testEntityWithOneValueAttribute42() {
        this.doTestEntityWithOneValueAttribute(42);
    }

    public void testEntityWithOneLocationAttribute0() {
        this.doTestEntityWithOneLocationAttribute(0);
    }

    public void testEntityWithOneLocationAttribute1() {
        this.doTestEntityWithOneLocationAttribute(1);
    }

    public void testEntityWithOneLocationAttribute2() {
        this.doTestEntityWithOneLocationAttribute(2);
    }

    public void testEntityWithOneLocationAttribute3() {
        this.doTestEntityWithOneLocationAttribute(3);
    }

    public void testEntityWithOneLocationAttribute4() {
        this.doTestEntityWithOneLocationAttribute(4);
    }

    public void testEntityWithOneLocationAttribute5() {
        this.doTestEntityWithOneLocationAttribute(5);
    }

    public void testEntityWithOneLocationAttribute6() {
        this.doTestEntityWithOneLocationAttribute(6);
    }

    public void testEntityWithOneLocationAttribute7() {
        this.doTestEntityWithOneLocationAttribute(7);
    }

    public void testEntityWithOneLocationAttribute8() {
        this.doTestEntityWithOneLocationAttribute(8);
    }

    public void testEntityWithOneLocationAttribute9() {
        this.doTestEntityWithOneLocationAttribute(9);
    }

    public void testEntityWithOneLocationAttribute10() {
        this.doTestEntityWithOneLocationAttribute(10);
    }

    public void testEntityWithOneLocationAttribute11() {
        this.doTestEntityWithOneLocationAttribute(11);
    }

    public void testEntityWithOneLocationAttribute12() {
        this.doTestEntityWithOneLocationAttribute(12);
    }

    public void testEntityWithOneLocationAttribute13() {
        this.doTestEntityWithOneLocationAttribute(13);
    }

    public void testEntityWithOneLocationAttribute14() {
        this.doTestEntityWithOneLocationAttribute(14);
    }

    public void testEntityWithOneLocationAttribut15() {
        this.doTestEntityWithOneLocationAttribute(15);
    }

    public void testEntityWithOneLocationAttribute16() {
        this.doTestEntityWithOneLocationAttribute(16);
    }

    public void testEntityWithOneLocationAttribute17() {
        this.doTestEntityWithOneLocationAttribute(17);
    }

    public void testEntityWithOneLocationAttribute18() {
        this.doTestEntityWithOneLocationAttribute(18);
    }

    public void testEntityWithOneLocationAttribute19() {
        this.doTestEntityWithOneLocationAttribute(19);
    }

    public void testEntityWithOneLocationAttribute20() {
        this.doTestEntityWithOneLocationAttribute(20);
    }

    public void testEntityWithOneLocationAttribute21() {
        this.doTestEntityWithOneLocationAttribute(21);
    }

    public void testEntityWithOneLocationAttribute22() {
        this.doTestEntityWithOneLocationAttribute(22);
    }

    public void testEntityWithOneLocationAttribute23() {
        this.doTestEntityWithOneLocationAttribute(23);
    }

    public void testEntityWithOneLocationAttribute24() {
        this.doTestEntityWithOneLocationAttribute(24);
    }

    public void testEntityWithOneLocationAttribute25() {
        this.doTestEntityWithOneLocationAttribute(25);
    }

    public void testEntityWithOneLocationAttribute26() {
        this.doTestEntityWithOneLocationAttribute(26);
    }

    public void testEntityWithOneLocationAttribute27() {
        this.doTestEntityWithOneLocationAttribute(27);
    }

    public void testEntityWithOneLocationAttribute28() {
        this.doTestEntityWithOneLocationAttribute(28);
    }

    public void testEntityWithOneLocationAttribute29() {
        this.doTestEntityWithOneLocationAttribute(29);
    }

    public void testEntityWithOneLocationAttribute30() {
        this.doTestEntityWithOneLocationAttribute(30);
    }

    public void testEntityWithOneLocationAttribute31() {
        this.doTestEntityWithOneLocationAttribute(31);
    }

    public void testEntityWithOneLocationAttribute32() {
        this.doTestEntityWithOneLocationAttribute(32);
    }

    public void testEntityWithOneLocationAttribute33() {
        this.doTestEntityWithOneLocationAttribute(33);
    }

    public void testEntityWithOneLocationAttribute34() {
        this.doTestEntityWithOneLocationAttribute(34);
    }

    public void testEntityWithOneLocationAttribute35() {
        this.doTestEntityWithOneLocationAttribute(35);
    }

    public void testEntityWithOneLocationAttribute36() {
        this.doTestEntityWithOneLocationAttribute(36);
    }

    public void testEntityWithOneLocationAttribute37() {
        this.doTestEntityWithOneLocationAttribute(37);
    }

    public void testEntityWithOneLocationAttribute38() {
        this.doTestEntityWithOneLocationAttribute(38);
    }

    public void testEntityWithOneLocationAttribute39() {
        this.doTestEntityWithOneLocationAttribute(39);
    }

    public void testEntityWithOneLocationAttribute40() {
        this.doTestEntityWithOneLocationAttribute(40);
    }

    public void testEntityWithOneLocationAttribute41() {
        this.doTestEntityWithOneLocationAttribute(41);
    }

    public void testEntityWithOneLocationAttribute42() {
        this.doTestEntityWithOneLocationAttribute(42);
    }

    public void testEntityWithOneOtherAttribute0() {
        this.doTestEntityWithOneOtherAttribute(0);
    }

    public void testEntityWithOneOtherAttribute1() {
        this.doTestEntityWithOneOtherAttribute(1);
    }

    public void testEntityWithOneOtherAttribute2() {
        this.doTestEntityWithOneOtherAttribute(2);
    }

    public void testEntityWithOneOtherAttribute3() {
        this.doTestEntityWithOneOtherAttribute(3);
    }

    public void testEntityWithOneOtherAttribute4() {
        this.doTestEntityWithOneOtherAttribute(4);
    }

    public void testEntityWithOneOtherAttribute5() {
        this.doTestEntityWithOneOtherAttribute(5);
    }

    public void testEntityWithOneOtherAttribute6() {
        this.doTestEntityWithOneOtherAttribute(6);
    }

    public void testEntityWithOneOtherAttribute7() {
        this.doTestEntityWithOneOtherAttribute(7);
    }

    public void testEntityWithOneOtherAttribute8() {
        this.doTestEntityWithOneOtherAttribute(8);
    }

    public void testEntityWithOneOtherAttribute9() {
        this.doTestEntityWithOneOtherAttribute(9);
    }

    public void testEntityWithOneOtherAttribute10() {
        this.doTestEntityWithOneOtherAttribute(10);
    }

    public void testEntityWithOneOtherAttribute11() {
        this.doTestEntityWithOneOtherAttribute(11);
    }

    public void testEntityWithOneOtherAttribute12() {
        this.doTestEntityWithOneOtherAttribute(12);
    }

    public void testEntityWithOneOtherAttribute13() {
        this.doTestEntityWithOneOtherAttribute(13);
    }

    public void testEntityWithOneOtherAttribute14() {
        this.doTestEntityWithOneOtherAttribute(14);
    }

    public void testEntityWithOneOtherAttribut15() {
        this.doTestEntityWithOneOtherAttribute(15);
    }

    public void testEntityWithOneOtherAttribute16() {
        this.doTestEntityWithOneOtherAttribute(16);
    }

    public void testEntityWithOneOtherAttribute17() {
        this.doTestEntityWithOneOtherAttribute(17);
    }

    public void testEntityWithOneOtherAttribute18() {
        this.doTestEntityWithOneOtherAttribute(18);
    }

    public void testEntityWithOneOtherAttribute19() {
        this.doTestEntityWithOneOtherAttribute(19);
    }

    public void testEntityWithOneOtherAttribute20() {
        this.doTestEntityWithOneOtherAttribute(20);
    }

    public void testEntityWithOneOtherAttribute21() {
        this.doTestEntityWithOneOtherAttribute(21);
    }

    public void testEntityWithOneOtherAttribute22() {
        this.doTestEntityWithOneOtherAttribute(22);
    }

    public void testEntityWithOneOtherAttribute23() {
        this.doTestEntityWithOneOtherAttribute(23);
    }

    public void testEntityWithOneOtherAttribute24() {
        this.doTestEntityWithOneOtherAttribute(24);
    }

    public void testEntityWithOneOtherAttribute25() {
        this.doTestEntityWithOneOtherAttribute(25);
    }

    public void testEntityWithOneOtherAttribute26() {
        this.doTestEntityWithOneOtherAttribute(26);
    }

    public void testEntityWithOneOtherAttribute27() {
        this.doTestEntityWithOneOtherAttribute(27);
    }

    public void testEntityWithOneOtherAttribute28() {
        this.doTestEntityWithOneOtherAttribute(28);
    }

    public void testEntityWithOneOtherAttribute29() {
        this.doTestEntityWithOneOtherAttribute(29);
    }

    public void testEntityWithOneOtherAttribute30() {
        this.doTestEntityWithOneOtherAttribute(30);
    }

    public void testEntityWithOneOtherAttribute31() {
        this.doTestEntityWithOneOtherAttribute(31);
    }

    public void testEntityWithOneOtherAttribute32() {
        this.doTestEntityWithOneOtherAttribute(32);
    }

    public void testEntityWithOneOtherAttribute33() {
        this.doTestEntityWithOneOtherAttribute(33);
    }

    public void testEntityWithOneOtherAttribute34() {
        this.doTestEntityWithOneOtherAttribute(34);
    }

    public void testEntityWithOneOtherAttribute35() {
        this.doTestEntityWithOneOtherAttribute(35);
    }

    public void testEntityWithOneOtherAttribute36() {
        this.doTestEntityWithOneOtherAttribute(36);
    }

    public void testEntityWithOneOtherAttribute37() {
        this.doTestEntityWithOneOtherAttribute(37);
    }

    public void testEntityWithOneOtherAttribute38() {
        this.doTestEntityWithOneOtherAttribute(38);
    }

    public void testEntityWithOneOtherAttribute39() {
        this.doTestEntityWithOneOtherAttribute(39);
    }

    public void testEntityWithOneOtherAttribute40() {
        this.doTestEntityWithOneOtherAttribute(40);
    }

    public void testEntityWithOneOtherAttribute41() {
        this.doTestEntityWithOneOtherAttribute(41);
    }

    public void testEntityWithOneOtherAttribute42() {
        this.doTestEntityWithOneOtherAttribute(42);
    }

    public void testEntityWithOneAttribute0() {
        this.doEntityWithOneTypeAttribute(0);
    }

    public void testEntityWithOneAttribute1() {
        this.doEntityWithOneTypeAttribute(1);
    }

    public void testEntityWithOneAttribute2() {
        this.doEntityWithOneTypeAttribute(2);
    }

    public void testEntityWithOneAttribute3() {
        this.doEntityWithOneTypeAttribute(3);
    }

    public void testEntityWithOneAttribute4() {
        this.doEntityWithOneTypeAttribute(4);
    }

    public void testEntityWithOneAttribute5() {
        this.doEntityWithOneTypeAttribute(5);
    }

    public void testEntityWithOneAttribute6() {
        this.doEntityWithOneTypeAttribute(6);
    }

    public void testEntityWithOneAttribute7() {
        this.doEntityWithOneTypeAttribute(7);
    }

    public void testEntityWithOneAttribute8() {
        this.doEntityWithOneTypeAttribute(8);
    }

    public void testEntityWithOneAttribute9() {
        this.doEntityWithOneTypeAttribute(0);
    }

    public void testEntityWithOneAttribute10() {
        this.doEntityWithOneTypeAttribute(10);
    }

    public void testEntityWithOneAttribute11() {
        this.doEntityWithOneTypeAttribute(11);
    }

    public void testEntityWithOneAttribute12() {
        this.doEntityWithOneTypeAttribute(12);
    }

    public void testEntityWithOneAttribute13() {
        this.doEntityWithOneTypeAttribute(13);
    }

    public void testEntityWithOneAttribute14() {
        this.doEntityWithOneTypeAttribute(14);
    }

    public void testEntityWithOneAttribute15() {
        this.doEntityWithOneTypeAttribute(15);
    }

    public void testEntityWithOneAttribute16() {
        this.doEntityWithOneTypeAttribute(16);
    }

    public void testEntityWithOneAttribute17() {
        this.doEntityWithOneTypeAttribute(17);
    }

    public void testEntityWithOneAttribute18() {
        this.doEntityWithOneTypeAttribute(18);
    }

    public void testEntityWithOneAttribute19() {
        this.doEntityWithOneTypeAttribute(19);
    }

    public void testEntityWithOneAttribute20() {
        this.doEntityWithOneTypeAttribute(20);
    }

    public void testEntityWithOneAttribute21() {
        this.doEntityWithOneTypeAttribute(21);
    }

    public void testEntityWithOneAttribute22() {
        this.doEntityWithOneTypeAttribute(22);
    }

    public void testEntityWithOneAttribute23() {
        this.doEntityWithOneTypeAttribute(23);
    }

    public void testEntityWithOneAttribute24() {
        this.doEntityWithOneTypeAttribute(24);
    }

    public void testEntityWithOneAttribute25() {
        this.doEntityWithOneTypeAttribute(25);
    }

    public void testEntityWithOneAttribute26() {
        this.doEntityWithOneTypeAttribute(26);
    }

    public void testEntityWithOneAttribute27() {
        this.doEntityWithOneTypeAttribute(27);
    }

    public void testEntityWithOneAttribute28() {
        this.doEntityWithOneTypeAttribute(28);
    }

    public void testEntityWithOneAttribute29() {
        this.doEntityWithOneTypeAttribute(29);
    }

    public void testEntityWithOneAttribute30() {
        this.doEntityWithOneTypeAttribute(30);
    }

    public void testEntityWithOneAttribute31() {
        this.doEntityWithOneTypeAttribute(31);
    }

    public void testEntityWithOneAttribute32() {
        this.doEntityWithOneTypeAttribute(32);
    }

    public void testEntityWithOneAttribute33() {
        this.doEntityWithOneTypeAttribute(33);
    }

    public void testEntityWithOneAttribute34() {
        this.doEntityWithOneTypeAttribute(34);
    }

    public void testEntityWithOneAttribute35() {
        this.doEntityWithOneTypeAttribute(35);
    }

    public void testEntityWithOneAttribute36() {
        this.doEntityWithOneTypeAttribute(36);
    }

    public void testEntityWithOneAttribute37() {
        this.doEntityWithOneTypeAttribute(37);
    }

    public void testEntityWithOneAttribute38() {
        this.doEntityWithOneTypeAttribute(38);
    }

    public void testEntityWithOneAttribute39() {
        this.doEntityWithOneTypeAttribute(39);
    }

    public void testEntityWithOneAttribute40() {
        this.doEntityWithOneTypeAttribute(40);
    }

    public void testEntityWithOneAttribute41() {
        this.doEntityWithOneTypeAttribute(41);
    }

    public void testEntityWithOneAttribute42() {
        this.doEntityWithOneTypeAttribute(42);
    }

    public void testAssociationWithOneRoleAttribute0() {
        this.doTestAssociationWithOneRoleAttribute(0);
    }

    public void testAssociationWithOneRoleAttribute1() {
        this.doTestAssociationWithOneRoleAttribute(1);
    }

    public void testAssociationWithOneRoleAttribute2() {
        this.doTestAssociationWithOneRoleAttribute(2);
    }

    public void testAssociationWithOneRoleAttribute3() {
        this.doTestAssociationWithOneRoleAttribute(3);
    }

    public void testAssociationWithOneRoleAttribute4() {
        this.doTestAssociationWithOneRoleAttribute(4);
    }

    public void testAssociationWithOneRoleAttribute5() {
        this.doTestAssociationWithOneRoleAttribute(5);
    }

    public void testAssociationWithOneRoleAttribute6() {
        this.doTestAssociationWithOneRoleAttribute(6);
    }

    public void testAssociationWithOneRoleAttribute7() {
        this.doTestAssociationWithOneRoleAttribute(7);
    }

    public void testAssociationWithOneRoleAttribute8() {
        this.doTestAssociationWithOneRoleAttribute(8);
    }

    public void testAssociationWithOneRoleAttribute9() {
        this.doTestAssociationWithOneRoleAttribute(9);
    }

    public void testAssociationWithOneRoleAttribute10() {
        this.doTestAssociationWithOneRoleAttribute(10);
    }

    public void testAssociationWithOneRoleAttribute11() {
        this.doTestAssociationWithOneRoleAttribute(11);
    }

    public void testAssociationWithOneRoleAttribute12() {
        this.doTestAssociationWithOneRoleAttribute(12);
    }

    public void testAssociationWithOneRoleAttribute13() {
        this.doTestAssociationWithOneRoleAttribute(13);
    }

    public void testAssociationWithOneRoleAttribute14() {
        this.doTestAssociationWithOneRoleAttribute(14);
    }

    public void testAssociationWithOneRoleAttribute15() {
        this.doTestAssociationWithOneRoleAttribute(15);
    }

    public void testAssociationWithOneRoleAttribute16() {
        this.doTestAssociationWithOneRoleAttribute(16);
    }

    public void testAssociationWithOneRoleAttribute17() {
        this.doTestAssociationWithOneRoleAttribute(17);
    }

    public void testAssociationWithOneRoleAttribute18() {
        this.doTestAssociationWithOneRoleAttribute(18);
    }

    public void testAssociationWithOneRoleAttribute19() {
        this.doTestAssociationWithOneRoleAttribute(19);
    }

    public void testAssociationWithOneRoleAttribute20() {
        this.doTestAssociationWithOneRoleAttribute(20);
    }

    public void testAssociationWithOneRoleAttribute21() {
        this.doTestAssociationWithOneRoleAttribute(21);
    }

    public void testAssociationWithOneRoleAttribute22() {
        this.doTestAssociationWithOneRoleAttribute(22);
    }

    public void testAssociationWithOneRoleAttribute23() {
        this.doTestAssociationWithOneRoleAttribute(23);
    }

    public void testAssociationWithOneRoleAttribute24() {
        this.doTestAssociationWithOneRoleAttribute(24);
    }

    public void testAssociationWithOneRoleAttribute25() {
        this.doTestAssociationWithOneRoleAttribute(25);
    }

    public void testAssociationWithOneRoleAttribute26() {
        this.doTestAssociationWithOneRoleAttribute(26);
    }

    public void testAssociationWithOneRoleAttribute27() {
        this.doTestAssociationWithOneRoleAttribute(27);
    }

    public void testAssociationWithOneRoleAttribute28() {
        this.doTestAssociationWithOneRoleAttribute(28);
    }

    public void testAssociationWithOneRoleAttribute29() {
        this.doTestAssociationWithOneRoleAttribute(29);
    }

    public void testAssociationWithOneRoleAttribute30() {
        this.doTestAssociationWithOneRoleAttribute(30);
    }

    public void testAssociationWithOneRoleAttribute31() {
        this.doTestAssociationWithOneRoleAttribute(31);
    }

    public void testAssociationWithOneRoleAttribute32() {
        this.doTestAssociationWithOneRoleAttribute(32);
    }

    public void testAssociationWithOneRoleAttribute33() {
        this.doTestAssociationWithOneRoleAttribute(33);
    }

    public void testAssociationWithOneRoleAttribute34() {
        this.doTestAssociationWithOneRoleAttribute(34);
    }

    public void testAssociationWithOneRoleAttribute35() {
        this.doTestAssociationWithOneRoleAttribute(35);
    }

    public void testAssociationWithOneRoleAttribute36() {
        this.doTestAssociationWithOneRoleAttribute(36);
    }

    public void testAssociationWithOneRoleAttribute37() {
        this.doTestAssociationWithOneRoleAttribute(37);
    }

    public void testAssociationWithOneRoleAttribute38() {
        this.doTestAssociationWithOneRoleAttribute(38);
    }

    public void testAssociationWithOneRoleAttribute39() {
        this.doTestAssociationWithOneRoleAttribute(39);
    }

    public void testAssociationWithOneRoleAttribute40() {
        this.doTestAssociationWithOneRoleAttribute(40);
    }

    public void testAssociationWithOneRoleAttribute41() {
        this.doTestAssociationWithOneRoleAttribute(41);
    }

    public void testAssociationWithOneRoleAttribute42() {
        this.doTestAssociationWithOneRoleAttribute(42);
    }

    public void testEntity0() {
        Entity a = pFactory.newEntity(this.q("e0"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        a.setValue(pFactory.newValue((Object)10, AttributeTest.name.XSD_BYTE));
        a.setValue(pFactory.newValue((Object)"10", AttributeTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)a, "target/attr_entity0");
    }

    public void testActivity0() {
        Activity a = pFactory.newActivity(this.q("a0"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/attr_activity0");
    }

    public void testAgent0() {
        Agent a = pFactory.newAgent(this.q("ag0"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/attr_agent0");
    }

    @Override
    public QualifiedName q(String n) {
        return new org.openprovenance.prov.vanilla.QualifiedName(EX_NS, n, EX_PREFIX);
    }

    public void testGeneration0() {
        WasGeneratedBy a = pFactory.newWasGeneratedBy((QualifiedName)null, this.q("e1"), null, this.q("a1"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addRoles((HasRole)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/attr_generation0");
    }

    public void testInvalidation0() {
        WasInvalidatedBy a = pFactory.newWasInvalidatedBy((QualifiedName)null, this.q("e1"), this.q("a1"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addRoles((HasRole)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/attr_invalidation0");
    }

    public void testUsage0() {
        Used a = pFactory.newUsed((QualifiedName)null, this.q("a1"), null, this.q("e1"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addRoles((HasRole)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/attr_usage0");
    }

    public void testAssociation0() {
        WasAssociatedWith a = pFactory.newWasAssociatedWith(this.q("assoc0"), this.q("a1"), this.q("ag1"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addRoles((HasRole)a);
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/attr_association0");
    }

    public void testAttribution0() {
        WasAttributedTo a = pFactory.newWasAttributedTo(this.q("assoc0"), this.q("e1"), this.q("ag1"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/attr_attribution0");
    }

    public void testDerivation0() {
        WasDerivedFrom a = pFactory.newWasDerivedFrom(this.q("der0"), this.q("e2"), this.q("e1"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/attr_derivation0");
    }

    public void testEnd0() {
        WasEndedBy a = pFactory.newWasEndedBy((QualifiedName)null, this.q("a1"), this.q("e1"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addRoles((HasRole)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/attr_end0");
    }

    public void testStart0() {
        WasStartedBy a = pFactory.newWasStartedBy((QualifiedName)null, this.q("a1"), this.q("e1"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addRoles((HasRole)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/attr_start0");
    }

    public void testInfluence0() {
        WasInfluencedBy a = pFactory.newWasInfluencedBy(this.q("infl0"), this.q("e1"), this.q("e2"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/attr_influence0");
    }

    public void testCommunication0() {
        WasInformedBy a = pFactory.newWasInformedBy(this.q("com0"), this.q("a1"), this.q("a2"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/attr_communication0");
    }

    public void testDelegation0() {
        ActedOnBehalfOf a = pFactory.newActedOnBehalfOf(this.q("del0"), this.q("a1"), this.q("a2"), this.q("a3"));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX_NS, "tag3", EX2_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag4", EX4_PREFIX));
        this.addOthers((HasOther)a, pFactory.newQualifiedName(EX2_NS, "tag5", EX_PREFIX));
        this.addLabels((HasLabel)a);
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/attr_delegation0");
    }

    public void doTestDictionaryInsertionWithOneKey(int i) {
    }

    public void testDictionaryInsertionWithOneKey0() {
        this.doTestDictionaryInsertionWithOneKey(0);
    }

    public void testDictionaryInsertionWithOneKey1() {
        this.doTestDictionaryInsertionWithOneKey(1);
    }

    public void testDictionaryInsertionWithOneKey2() {
        this.doTestDictionaryInsertionWithOneKey(2);
    }

    public void testDictionaryInsertionWithOneKey3() {
        this.doTestDictionaryInsertionWithOneKey(3);
    }

    public void testDictionaryInsertionWithOneKey4() {
        this.doTestDictionaryInsertionWithOneKey(4);
    }

    public void testDictionaryInsertionWithOneKey5() {
        this.doTestDictionaryInsertionWithOneKey(5);
    }

    public void testDictionaryInsertionWithOneKey6() {
        this.doTestDictionaryInsertionWithOneKey(6);
    }

    public void testDictionaryInsertionWithOneKey7() {
        this.doTestDictionaryInsertionWithOneKey(7);
    }

    public void testDictionaryInsertionWithOneKey8() {
        this.doTestDictionaryInsertionWithOneKey(8);
    }

    public void testDictionaryInsertionWithOneKey9() {
        this.doTestDictionaryInsertionWithOneKey(9);
    }

    public void testDictionaryInsertionWithOneKey10() {
        this.doTestDictionaryInsertionWithOneKey(10);
    }

    public void testDictionaryInsertionWithOneKey11() {
        this.doTestDictionaryInsertionWithOneKey(11);
    }

    public void testDictionaryInsertionWithOneKey12() {
        this.doTestDictionaryInsertionWithOneKey(12);
    }

    public void testDictionaryInsertionWithOneKey13() {
        this.doTestDictionaryInsertionWithOneKey(13);
    }

    public void testDictionaryInsertionWithOneKey14() {
        this.doTestDictionaryInsertionWithOneKey(14);
    }

    public void testDictionaryInsertionWithOneKey15() {
        this.doTestDictionaryInsertionWithOneKey(15);
    }

    public void testDictionaryInsertionWithOneKey16() {
        this.doTestDictionaryInsertionWithOneKey(16);
    }

    public void testDictionaryInsertionWithOneKey17() {
        this.doTestDictionaryInsertionWithOneKey(17);
    }

    public void testDictionaryInsertionWithOneKey18() {
        this.doTestDictionaryInsertionWithOneKey(18);
    }

    public void testDictionaryInsertionWithOneKey19() {
        this.doTestDictionaryInsertionWithOneKey(19);
    }

    public void testDictionaryInsertionWithOneKey20() {
        this.doTestDictionaryInsertionWithOneKey(20);
    }

    public void testDictionaryInsertionWithOneKey21() {
        this.doTestDictionaryInsertionWithOneKey(21);
    }

    public void testDictionaryInsertionWithOneKey22() {
        this.doTestDictionaryInsertionWithOneKey(22);
    }

    public void testDictionaryInsertionWithOneKey23() {
        this.doTestDictionaryInsertionWithOneKey(23);
    }

    public void testDictionaryInsertionWithOneKey24() {
        this.doTestDictionaryInsertionWithOneKey(24);
    }

    public void testDictionaryInsertionWithOneKey25() {
        this.doTestDictionaryInsertionWithOneKey(25);
    }

    public void testDictionaryInsertionWithOneKey26() {
        this.doTestDictionaryInsertionWithOneKey(26);
    }

    public void testDictionaryInsertionWithOneKey27() {
        this.doTestDictionaryInsertionWithOneKey(27);
    }

    public void testDictionaryInsertionWithOneKey28() {
        this.doTestDictionaryInsertionWithOneKey(28);
    }

    public void testDictionaryInsertionWithOneKey29() {
        this.doTestDictionaryInsertionWithOneKey(29);
    }

    public void testDictionaryInsertionWithOneKey30() {
        this.doTestDictionaryInsertionWithOneKey(30);
    }

    public void testDictionaryInsertionWithOneKey31() {
        this.doTestDictionaryInsertionWithOneKey(31);
    }

    public void testDictionaryInsertionWithOneKey32() {
        this.doTestDictionaryInsertionWithOneKey(32);
    }

    public void testDictionaryInsertionWithOneKey33() {
        this.doTestDictionaryInsertionWithOneKey(33);
    }

    public void testDictionaryInsertionWithOneKey34() {
        this.doTestDictionaryInsertionWithOneKey(34);
    }

    public void testDictionaryInsertionWithOneKey35() {
        this.doTestDictionaryInsertionWithOneKey(35);
    }

    public void testDictionaryInsertionWithOneKey36() {
        this.doTestDictionaryInsertionWithOneKey(36);
    }

    public void testDictionaryInsertionWithOneKey37() {
        this.doTestDictionaryInsertionWithOneKey(37);
    }

    public void testDictionaryInsertionWithOneKey38() {
        this.doTestDictionaryInsertionWithOneKey(38);
    }

    public void testDictionaryInsertionWithOneKey39() {
        this.doTestDictionaryInsertionWithOneKey(39);
    }

    public void testDictionaryInsertionWithOneKey40() {
        this.doTestDictionaryInsertionWithOneKey(40);
    }

    public void testDictionaryInsertionWithOneKey41() {
        this.doTestDictionaryInsertionWithOneKey(41);
    }

    public void testDictionaryInsertionWithOneKey42() {
        this.doTestDictionaryInsertionWithOneKey(42);
    }

    static {
        warned = false;
        pFactory = new org.openprovenance.prov.vanilla.ProvFactory();
        name = pFactory.getName();
    }
}

