/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model.test;

import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.TestCase;
import org.openprovenance.prov.vanilla.ProvFactory;

public class DateTest
extends TestCase {
    final ProvFactory pFactory = new ProvFactory();

    public void testDate1() {
        String date = "2023-09-22T14:19:04.760-05:00";
        XMLGregorianCalendar noTZtime = this.pFactory.newISOTime(date);
        XMLGregorianCalendar yesTZtime = this.pFactory.newISOTimeTZ(date);
        System.out.println("time zone (no):  " + String.valueOf(noTZtime));
        System.out.println("time zone (yes): " + String.valueOf(yesTZtime));
        System.out.println("time now: " + String.valueOf(this.pFactory.newTimeNow()));
        DateTest.assertEquals((String)"original time format, with offset, not preserved", (String)yesTZtime.toXMLFormat(), (String)date);
    }

    public void testDate2() {
        String date = this.pFactory.newTimeNow().toXMLFormat();
        XMLGregorianCalendar noTZtime = this.pFactory.newISOTime(date);
        XMLGregorianCalendar yesTZtime = this.pFactory.newISOTimeTZ(date);
        DateTest.assertEquals((Object)noTZtime, (Object)yesTZtime);
    }

    public void testDate3() {
        String date1 = "2023-09-22T14:19:04.760-05:00";
        String date2 = "2023-09-22T15:19:04.760-04:00";
        XMLGregorianCalendar noTZtime1 = this.pFactory.newISOTime(date1);
        XMLGregorianCalendar yesTZtime1 = this.pFactory.newISOTimeTZ(date1);
        XMLGregorianCalendar noTZtime2 = this.pFactory.newISOTime(date2);
        XMLGregorianCalendar yesTZtime2 = this.pFactory.newISOTimeTZ(date2);
        DateTest.assertEquals((Object)noTZtime1, (Object)yesTZtime1);
        DateTest.assertEquals((Object)noTZtime2, (Object)yesTZtime2);
        DateTest.assertEquals((Object)noTZtime1, (Object)noTZtime2);
        DateTest.assertNotSame((Object)noTZtime1.toXMLFormat(), (Object)yesTZtime1.toXMLFormat());
        DateTest.assertNotSame((Object)noTZtime2.toXMLFormat(), (Object)yesTZtime2.toXMLFormat());
        DateTest.assertEquals((String)noTZtime1.toXMLFormat(), (String)noTZtime2.toXMLFormat());
        DateTest.assertNotSame((Object)yesTZtime1.toXMLFormat(), (Object)yesTZtime2.toXMLFormat());
        DateTest.assertEquals((String)yesTZtime1.normalize().toXMLFormat(), (String)yesTZtime2.normalize().toXMLFormat());
    }

    public void testDate4() {
        String date1 = "2023-09-22T14:19:04.760";
        String date2 = "2023-09-22T14:19:04.760Z";
        String date3 = "2023-09-22T14:19:04.760+00:00";
        XMLGregorianCalendar noTZtime1 = this.pFactory.newISOTime(date1);
        XMLGregorianCalendar yesTZtime1 = this.pFactory.newISOTimeTZ(date1);
        XMLGregorianCalendar normalizedTZtime1 = this.pFactory.newISOTimeUTC(date1);
        XMLGregorianCalendar noTZtime2 = this.pFactory.newISOTime(date2);
        XMLGregorianCalendar yesTZtime2 = this.pFactory.newISOTimeTZ(date2);
        XMLGregorianCalendar noTZtime3 = this.pFactory.newISOTime(date3);
        XMLGregorianCalendar yesTZtime3 = this.pFactory.newISOTimeTZ(date3);
        DateTest.assertEquals((Object)noTZtime1, (Object)yesTZtime1);
        DateTest.assertEquals((Object)noTZtime2, (Object)yesTZtime2);
        DateTest.assertEquals((Object)noTZtime3, (Object)yesTZtime3);
        DateTest.assertEquals((Object)noTZtime3, (Object)noTZtime2);
        DateTest.assertNotSame((Object)noTZtime1.toXMLFormat(), (Object)yesTZtime1.toXMLFormat());
        DateTest.assertNotSame((Object)noTZtime2.toXMLFormat(), (Object)yesTZtime2.toXMLFormat());
        DateTest.assertEquals((String)noTZtime2.toXMLFormat(), (String)noTZtime3.toXMLFormat());
        DateTest.assertEquals((String)noTZtime2.toXMLFormat(), (String)noTZtime3.toXMLFormat());
    }

    public void testDate5() {
        String date1 = "2023-09-08T14:12:45.10931231236545213876";
        String date2 = "2023-09-08T14:12:45.109321321312321432523";
        XMLGregorianCalendar time1 = this.pFactory.newISOTime(date1);
        XMLGregorianCalendar time2 = this.pFactory.newISOTime(date2);
        DateTest.assertEquals((Object)time1, (Object)time2);
        System.out.println("time1 = " + String.valueOf(time1));
        System.out.println("time2 = " + String.valueOf(time2));
    }
}

