/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.DocumentEquality;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.test.ExtensionRoundTripFromJavaTest;
import org.openprovenance.prov.model.test.ProvFrameworkTest;

public class InternationalizationTest
extends ProvFrameworkTest {
    public static final String EX_NS = "http://example.org/";
    public static final String EX_PREFIX = "ex";
    public static ProvFactory pFactory = new org.openprovenance.prov.vanilla.ProvFactory();
    public static Name name = pFactory.getName();
    Map<String, Document> table = new HashMap<String, Document>();

    public InternationalizationTest() {
        this.documentEquality = new DocumentEquality(this.mergeDuplicateProperties(), null);
    }

    public void doCheckSchema2(String file) {
        String command = "xmllint --schema src/main/resources/ex.xsd " + file;
        try {
            Process proc = Runtime.getRuntime().exec(command);
            proc.waitFor();
            int code = proc.exitValue();
            if (code != 0) {
                BufferedReader outReader;
                String s_out;
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                String s_error = errorReader.readLine();
                if (s_error != null) {
                    System.out.println("Error:  " + s_error);
                }
                if ((s_out = (outReader = new BufferedReader(new InputStreamReader(proc.getInputStream()))).readLine()) != null) {
                    System.out.println("Out:  " + s_out);
                }
            }
            InternationalizationTest.assertTrue((code == 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Document readDocument(String file1) {
        return this.table.get(file1);
    }

    @Override
    public void writeDocument(Document doc, String file2) {
        System.out.println("deep copy of  " + file2);
        this.table.put(file2, ExtensionRoundTripFromJavaTest.deepCopy(doc));
    }

    @Override
    public boolean checkTest(String name) {
        return true;
    }

    public void testInternationalEscape1() {
        Entity e = pFactory.newEntity(this.q("entity-escape1"));
        pFactory.addLabel((HasLabel)e, "a label with escaped \" quotes \" ");
        this.makeDocAndTest((Statement)e, "target/international_Escape1");
    }

    public void testInternationalEscape2() {
        Entity e = pFactory.newEntity(this.q("entity-escape2"));
        e.getOther().add(pFactory.newOther(EX_NS, "title1", EX_PREFIX, (Object)pFactory.newInternationalizedString("a string with escaped \" quotes \" ", "en"), InternationalizationTest.name.PROV_LANG_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "title3", EX_PREFIX, (Object)"and another one \" withquotes \" ", InternationalizationTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)e, "target/international_Escape2");
    }

    public void testInternationalFR() {
        Entity e = pFactory.newEntity(this.q("entity-FR"));
        e.getOther().add(pFactory.newOther(EX_NS, "title1", EX_PREFIX, (Object)pFactory.newInternationalizedString("Portez ce vieux whisky au juge blond qui a fum\u00e9", "fr"), InternationalizationTest.name.PROV_LANG_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "title2", EX_PREFIX, (Object)pFactory.newInternationalizedString("Voix ambigu\u00eb d\u2019un c\u0153ur qui au z\u00e9phyr pr\u00e9f\u00e8re les jattes de kiwi", "fr"), InternationalizationTest.name.PROV_LANG_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "title3", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "pr\u00e9f\u00e8re", EX_PREFIX), InternationalizationTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "ambigu\u00eb_c\u0153ur", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "test", EX_PREFIX), InternationalizationTest.name.PROV_QUALIFIED_NAME));
        this.makeDocAndTest((Statement)e, "target/international_FR1");
    }

    public void testInternationalHE() {
        Entity e = pFactory.newEntity(this.q("entity-HE"));
        e.getOther().add(pFactory.newOther(EX_NS, "title1", EX_PREFIX, (Object)pFactory.newInternationalizedString("\u05d3\u05d2 \u05e1\u05e7\u05e8\u05df \u05e9\u05d8 \u05d1\u05d9\u05dd \u05de\u05d0\u05d5\u05db\u05d6\u05d1 \u05d5\u05dc\u05e4\u05ea\u05e2 \u05de\u05e6\u05d0 \u05d7\u05d1\u05e8\u05d4", "he"), InternationalizationTest.name.PROV_LANG_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "title1", EX_PREFIX, (Object)pFactory.newInternationalizedString("A curious fish sailed the sea disappointedly, and suddenly found company", "en"), InternationalizationTest.name.PROV_LANG_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "title3", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "\u05d7\u05d1\u05e8\u05d4", EX_PREFIX), InternationalizationTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "\u05d7\u05d1\u05e8\u05d4", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "test", EX_PREFIX), InternationalizationTest.name.PROV_QUALIFIED_NAME));
        this.makeDocAndTest((Statement)e, "target/international_HE1");
    }

    public void testInternationalJP() {
        Entity e = pFactory.newEntity(this.q("entity-HE"));
        e.getOther().add(pFactory.newOther(EX_NS, "title1", EX_PREFIX, (Object)pFactory.newInternationalizedString("\u3044\u308d\u306f\u306b\u307b\u3078\u3068 \u3061\u308a\u306c\u308b\u3092 \u308f\u304b\u3088\u305f\u308c\u305d \u3064\u306d\u306a\u3089\u3080 \u3046\u3090\u306e\u304a\u304f\u3084\u307e \u3051\u3075\u3053\u3048\u3066 \u3042\u3055\u304d\u3086\u3081\u307f\u3057 \u3091\u3072\u3082\u305b\u3059\uff08\u3093\uff09", "jp"), InternationalizationTest.name.PROV_LANG_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "title3", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "\u308f\u304b\u3088\u305f\u308c\u305d", EX_PREFIX), InternationalizationTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "\u308f\u304b\u3088\u305f\u308c\u305d", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "test", EX_PREFIX), InternationalizationTest.name.PROV_QUALIFIED_NAME));
        this.makeDocAndTest((Statement)e, "target/international_JP1");
    }

    public void testInternationalRU() {
        Entity e = pFactory.newEntity(this.q("entity-HE"));
        e.getOther().add(pFactory.newOther(EX_NS, "title1", EX_PREFIX, (Object)pFactory.newInternationalizedString("\u041b\u044e\u0431\u044f, \u0441\u044a\u0435\u0448\u044c \u0449\u0438\u043f\u0446\u044b, \u2014 \u0432\u0437\u0434\u043e\u0445\u043d\u0451\u0442 \u043c\u044d\u0440, \u2014 \u041a\u0430\u0439\u0444 \u0436\u0433\u0443\u0447!", "ru"), InternationalizationTest.name.PROV_LANG_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "title1", EX_PREFIX, (Object)pFactory.newInternationalizedString("The mayor will sigh, \u201cEat the pliers with love; pleasure burns!", "en"), InternationalizationTest.name.PROV_LANG_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "title3", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "\u041b\u044e\u0431\u044f", EX_PREFIX), InternationalizationTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "\u041b\u044e\u0431\u044f", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "test", EX_PREFIX), InternationalizationTest.name.PROV_QUALIFIED_NAME));
        this.makeDocAndTest((Statement)e, "target/international_RU1");
    }
}

