/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model.test;

import junit.framework.TestCase;
import org.openprovenance.prov.model.QualifiedNameUtils;

public class XMLNameTest
extends TestCase {
    QualifiedNameUtils u = new QualifiedNameUtils();

    public XMLNameTest(String name) {
        super(name);
    }

    boolean doEscape(String in, String out) {
        String val = this.u.escapeToXsdLocalName(in);
        System.err.println("Escape " + in + " " + val);
        XMLNameTest.assertTrue((boolean)this.u.is_NC_Name(out));
        return val.equals(out);
    }

    boolean doUnescape(String out, String in) {
        String val = this.u.unescapeFromXsdLocalName(in);
        System.err.println("Unescape " + in + " " + val);
        return val.equals(out);
    }

    boolean doRT1(String in) {
        String val = this.u.unescapeFromXsdLocalName(this.u.escapeToXsdLocalName(in));
        System.err.println("RT1 " + in + " " + val);
        return val.equals(in);
    }

    boolean doRT2(String in) {
        String val = this.u.escapeToXsdLocalName(this.u.unescapeFromXsdLocalName(in));
        System.err.println("RT2 " + in + " " + val);
        return val.equals(in);
    }

    public void testEscape1() {
        XMLNameTest.assertTrue((boolean)this.doEscape("abc", "abc"));
        XMLNameTest.assertTrue((boolean)this.doEscape("abc01", "abc01"));
        XMLNameTest.assertTrue((boolean)this.doEscape("01", "_01"));
        XMLNameTest.assertTrue((boolean)this.doEscape("", "_"));
        XMLNameTest.assertTrue((boolean)this.doEscape("_", "___"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a@b", "a_40b"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a~b", "a_7Eb"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a&b", "a_26b"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a+b", "a_2Bb"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a*b", "a_2Ab"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a#b", "a_23b"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a$b", "a_24b"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a!b", "a_21b"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01bc", "a01bc"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01/bc", "a01_2Fbc"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b\\c", "a01b_5Cc"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b=c", "a01b_3Dc"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b'c", "a01b_27c"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b(c", "a01b_28c"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b)c", "a01b_29c"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b,c", "a01b_2Cc"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b_c", "a01b__c"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b:c", "a01b_3Ac"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b;c", "a01b_3Bc"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b[c", "a01b_5Bc"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b]c", "a01b_5Dc"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01b.c", "a01b.c"));
        XMLNameTest.assertTrue((boolean)this.doEscape("a01bc.", "a01bc."));
        XMLNameTest.assertTrue((boolean)this.doEscape("='(),_:;[].@~", "__3D_27_28_29_2C___3A_3B_5B_5D._40_7E"));
        XMLNameTest.assertTrue((boolean)this.doEscape("?a\\=b", "__3Fa_5C_3Db"));
        XMLNameTest.assertTrue((boolean)this.doEscape("55348dff-4fcc-4ac2-ab56-641798c64400", "_55348dff-4fcc-4ac2-ab56-641798c64400"));
        XMLNameTest.assertTrue((boolean)this.doEscape("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d"));
    }

    public void testUnescape1() {
        XMLNameTest.assertTrue((boolean)this.doUnescape("abc", "abc"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("abc01", "abc01"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("01", "_01"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("", "_"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("_", "___"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a@b", "a_40b"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a~b", "a_7Eb"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a&b", "a_26b"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a+b", "a_2Bb"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a*b", "a_2Ab"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a#b", "a_23b"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a$b", "a_24b"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a!b", "a_21b"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01bc", "a01bc"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01/bc", "a01_2Fbc"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b\\c", "a01b_5Cc"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b=c", "a01b_3Dc"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b'c", "a01b_27c"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b(c", "a01b_28c"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b)c", "a01b_29c"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b,c", "a01b_2Cc"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b_c", "a01b__c"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b:c", "a01b_3Ac"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b;c", "a01b_3Bc"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b[c", "a01b_5Bc"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b]c", "a01b_5Dc"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("a01b.c", "a01b.c"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("='(),_:;[].@~", "__3D_27_28_29_2C___3A_3B_5B_5D._40_7E"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("?a\\=b", "__3Fa_5C_3Db"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("55348dff-4fcc-4ac2-ab56-641798c64400", "_55348dff-4fcc-4ac2-ab56-641798c64400"));
        XMLNameTest.assertTrue((boolean)this.doUnescape("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d"));
    }

    public void testRoundTripFromUnescaped1() {
        XMLNameTest.assertTrue((boolean)this.doRT1("abc"));
        XMLNameTest.assertTrue((boolean)this.doRT1("abc01"));
        XMLNameTest.assertTrue((boolean)this.doRT1("01"));
        XMLNameTest.assertTrue((boolean)this.doRT1(""));
        XMLNameTest.assertTrue((boolean)this.doRT1("_"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a@b"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a~b"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a&b"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a+b"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a*b"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a#b"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a$b"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a!b"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01bc"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01/bc"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b\\c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b=c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b'c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b(c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b)c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b,c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b_c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b:c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b;c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b[c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b]c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("a01b.c"));
        XMLNameTest.assertTrue((boolean)this.doRT1("='(),_:;[].@~"));
        XMLNameTest.assertTrue((boolean)this.doRT1("?a\\=b"));
        XMLNameTest.assertTrue((boolean)this.doRT1("55348dff-4fcc-4ac2-ab56-641798c64400"));
        XMLNameTest.assertTrue((boolean)this.doRT1("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d"));
    }

    public void testRoundTripFromUnescaped2() {
        XMLNameTest.assertTrue((boolean)this.doRT2("abc"));
        XMLNameTest.assertTrue((boolean)this.doRT2("abc01"));
        XMLNameTest.assertTrue((boolean)this.doRT2("_0001"));
        XMLNameTest.assertTrue((boolean)this.doRT2("_"));
        XMLNameTest.assertTrue((boolean)this.doRT2("___"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a_40b"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a_7Eb"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a_26b"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a_2Bb"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a_2Ab"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a_23b"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a_24b"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a_21b"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01bc"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01_2Fbc"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_5Cc"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_3Dc"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_27c"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_28c"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_29c"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_2Cc"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b__c"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_3Ac"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_3Bc"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_5Bc"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b_5Dc"));
        XMLNameTest.assertTrue((boolean)this.doRT2("a01b.c"));
        XMLNameTest.assertTrue((boolean)this.doRT2("_3D_27_28_29_2C___3A_3B_5B_5D._40_7E"));
        XMLNameTest.assertTrue((boolean)this.doRT2("_3Fa_5C_3Db"));
        XMLNameTest.assertTrue((boolean)this.doRT2("_55348dff-4fcc-4ac2-ab56-641798c64400"));
        XMLNameTest.assertTrue((boolean)this.doRT2("\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d"));
    }
}

