/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.QualifiedNameUtils;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.model.ValueConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DOMProcessing {
    private static final String XML_LITERAL = "XMLLiteral";
    private static final String RDF_PREFIX = "rdf";
    private static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String RDF_LITERAL = "rdf:XMLLiteral";
    public static final String XSD_NS_FOR_XML = "http://www.w3.org/2001/XMLSchema";
    private static final String FOR_XML_XSD_QNAME = "http://www.w3.org/2001/XMLSchema#QName";
    private final QualifiedNameUtils qnU = new QualifiedNameUtils();
    private final ProvFactory pFactory;
    public static DocumentBuilder builder;

    public DOMProcessing(ProvFactory pFactory) {
        this.pFactory = pFactory;
    }

    static void initBuilder() {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String qualifiedNameToString(QualifiedName name) {
        Namespace ns = Namespace.getThreadNamespace();
        return ns.qualifiedNameToString(name);
    }

    public static String qualifiedNameToString(QName name) {
        Namespace ns = Namespace.getThreadNamespace();
        return ns.qualifiedNameToString(name);
    }

    public QualifiedName stringToQualifiedName(String str, Element el) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(58);
        if (index == -1) {
            QualifiedName qn = this.pFactory.newQualifiedName(el.lookupNamespaceURI(null), str, null);
            return qn;
        }
        String prefix = str.substring(0, index);
        String local = str.substring(index + 1, str.length());
        String escapedLocal = this.qnU.escapeProvLocalName(this.qnU.unescapeFromXsdLocalName(local));
        QualifiedName qn = this.pFactory.newQualifiedName(this.convertNsFromXml(el.lookupNamespaceURI(prefix)), escapedLocal, prefix);
        return qn;
    }

    public static String convertNsToXml(String uri) {
        if ("http://www.w3.org/2001/XMLSchema#".equals(uri)) {
            return XSD_NS_FOR_XML;
        }
        return uri;
    }

    public final String convertNsFromXml(String uri) {
        if (XSD_NS_FOR_XML.equals(uri)) {
            return "http://www.w3.org/2001/XMLSchema#";
        }
        return uri;
    }

    public static Element newElement(QualifiedName elementName, QualifiedName value) {
        Document doc = builder.newDocument();
        Element el = doc.createElementNS(elementName.getNamespaceURI(), DOMProcessing.qualifiedNameToString(elementName.toQName()));
        el.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "xsd:QName");
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", XSD_NS_FOR_XML);
        String valueAsString = DOMProcessing.qualifiedNameToString(value.toQName());
        el.appendChild(doc.createTextNode(valueAsString));
        int index = valueAsString.indexOf(":");
        if (index != -1) {
            String prefix = valueAsString.substring(0, index);
            el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, DOMProcessing.convertNsToXml(value.getNamespaceURI()));
        } else {
            el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", DOMProcessing.convertNsToXml(value.getNamespaceURI()));
        }
        doc.appendChild(el);
        return el;
    }

    public static final Element newElement(QualifiedName elementName, String value, QualifiedName type) {
        Document doc = builder.newDocument();
        String qualifiedNameString = DOMProcessing.qualifiedNameToString(elementName.toQName());
        Element el = doc.createElementNS(elementName.getNamespaceURI(), qualifiedNameString);
        el.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", DOMProcessing.qualifiedNameToString(type));
        el.appendChild(doc.createTextNode(value));
        doc.appendChild(el);
        return el;
    }

    public static final Element newElement(QualifiedName qualifiedName, String value, QualifiedName type, String lang) {
        Document doc = builder.newDocument();
        Element el = doc.createElementNS(qualifiedName.getNamespaceURI(), DOMProcessing.qualifiedNameToString(qualifiedName.toQName()));
        el.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", DOMProcessing.qualifiedNameToString(type));
        if (lang != null && lang != "") {
            el.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
        }
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        el.appendChild(doc.createTextNode(value));
        doc.appendChild(el);
        return el;
    }

    public static final Element newElement(QualifiedName name, Element value) {
        Document doc = builder.newDocument();
        Element el = doc.createElementNS(name.getNamespaceURI(), DOMProcessing.qualifiedNameToString(name));
        el.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", RDF_LITERAL);
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rdf", RDF_NAMESPACE);
        el.appendChild(doc.importNode(value, true));
        return el;
    }

    public static void writeDOMToPrinter(Node document, StreamResult result, boolean formatted) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        if (formatted) {
            transformer.setOutputProperty("indent", "yes");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        transformer.transform(source, result);
    }

    public static void writeDOMToPrinter(Node document, Writer out, boolean formatted) throws TransformerConfigurationException, TransformerException {
        StreamResult result = new StreamResult(out);
        DOMProcessing.writeDOMToPrinter(document, result, formatted);
    }

    public static String writeToString(Node toWrite) throws TransformerConfigurationException, TransformerException {
        StringWriter sw = new StringWriter();
        DOMProcessing.writeDOMToPrinter(toWrite, new PrintWriter(sw), false);
        return sw.toString();
    }

    public static void trimNode(Node node) {
        LinkedList<Text> nodes = new LinkedList<Text>();
        DOMProcessing.trimNode(node, nodes);
        for (Text n : nodes) {
            if (!n.getTextContent().equals("")) continue;
            n.getParentNode().removeChild(n);
        }
    }

    static void trimNode(Node node, List<Text> nodes) {
        if (node.getNodeType() == 3) {
            node.normalize();
            Text txt = (Text)node;
            txt.setTextContent(txt.getTextContent().trim());
            nodes.add(txt);
        } else {
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                DOMProcessing.trimNode(nl.item(i), nodes);
            }
        }
    }

    public static final Element marshalAttribute(Attribute attribute) {
        return DOMProcessing.marshalTypedValue(attribute, attribute.getElementName());
    }

    public static final Element marshalTypedValue(TypedValue attribute, QualifiedName elementName) {
        Object value = attribute.getValue();
        QualifiedName type = attribute.getType();
        if (value instanceof LangString) {
            LangString istring = (LangString)value;
            if (istring.getLang() != null) {
                return DOMProcessing.newElement(elementName, istring.getValue(), attribute.getType(), istring.getLang());
            }
            return DOMProcessing.newElement(elementName, istring.getValue(), attribute.getType());
        }
        if (value instanceof QualifiedName) {
            return DOMProcessing.newElement(elementName, (QualifiedName)value);
        }
        if (type.getNamespaceURI().equals(RDF_NAMESPACE) && type.getLocalPart().equals(XML_LITERAL)) {
            return DOMProcessing.newElement(elementName, (Element)attribute.getConvertedValue());
        }
        return DOMProcessing.newElement(elementName, value.toString(), attribute.getType());
    }

    public final Attribute unmarshallAttribute(Element el, ProvFactory pFactory, ValueConverter vconv) {
        String prefix = el.getPrefix();
        String namespace = el.getNamespaceURI();
        String local = el.getLocalName();
        local = this.qnU.escapeProvLocalName(this.qnU.unescapeFromXsdLocalName(local));
        String child = el.getTextContent();
        String typeAsString = el.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        String lang = el.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        QualifiedName type = typeAsString == null || typeAsString.equals("") ? null : this.stringToQualifiedName(typeAsString, el);
        Name name = pFactory.getName();
        if (type == null) {
            type = name.XSD_STRING;
        }
        if (FOR_XML_XSD_QNAME.equals(type.getUri())) {
            QualifiedName qn = this.stringToQualifiedName(child, el);
            Attribute x = pFactory.newAttribute(namespace, local, prefix, qn, name.PROV_QUALIFIED_NAME);
            return x;
        }
        if (type.equals(name.RDF_LITERAL)) {
            NodeList nodes = el.getChildNodes();
            Element content = null;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                content = (Element)node;
                break;
            }
            return pFactory.newAttribute(namespace, local, prefix, content, type);
        }
        if (lang == null || lang.equals("")) {
            if (type.equals(name.PROV_LANG_STRING)) {
                return pFactory.newAttribute(namespace, local, prefix, pFactory.newInternationalizedString(child), type);
            }
            return pFactory.newAttribute(namespace, local, prefix, vconv.convertToJava(type, child), type);
        }
        return pFactory.newAttribute(namespace, local, prefix, pFactory.newInternationalizedString(child, lang), type);
    }

    static {
        DOMProcessing.initBuilder();
    }
}

