/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.builder.ActedOnBehalfOfBuilder;
import org.openprovenance.prov.model.builder.ActivityBuilder;
import org.openprovenance.prov.model.builder.AgentBuilder;
import org.openprovenance.prov.model.builder.AlternateOfBuilder;
import org.openprovenance.prov.model.builder.BundleBuilder;
import org.openprovenance.prov.model.builder.EntityBuilder;
import org.openprovenance.prov.model.builder.HadMemberBuilder;
import org.openprovenance.prov.model.builder.Prefix;
import org.openprovenance.prov.model.builder.SpecializationOfBuilder;
import org.openprovenance.prov.model.builder.UsedBuilder;
import org.openprovenance.prov.model.builder.WasAssociatedWithBuilder;
import org.openprovenance.prov.model.builder.WasAttributedToBuilder;
import org.openprovenance.prov.model.builder.WasDerivedFromBuilder;
import org.openprovenance.prov.model.builder.WasEndedByBuilder;
import org.openprovenance.prov.model.builder.WasGeneratedByBuilder;
import org.openprovenance.prov.model.builder.WasInfluencedByBuilder;
import org.openprovenance.prov.model.builder.WasInformedByBuilder;
import org.openprovenance.prov.model.builder.WasInvalidatedByBuilder;
import org.openprovenance.prov.model.builder.WasStartedByBuilder;

public class Builder {
    protected final ModelConstructor mc;
    protected Namespace namespace;
    protected final ProvFactory pf;
    protected HashMap<String, QualifiedName> knownAs;
    protected final ModelConstructorExtension mce;
    protected List<Statement> statements = new LinkedList<Statement>();
    protected List<Bundle> bundles = new LinkedList<Bundle>();

    public Builder(ModelConstructor mc, ModelConstructorExtension mce, ProvFactory pf) {
        this.mc = mc;
        this.mce = mce;
        this.pf = pf;
        this.namespace = new Namespace();
        this.namespace.addKnownNamespaces();
        this.knownAs = new HashMap();
    }

    public Builder(ProvFactory pf) {
        this(pf, pf, pf);
    }

    public ActivityBuilder activity() {
        return new ActivityBuilder(this, this.mc, this.pf);
    }

    public EntityBuilder entity() {
        return new EntityBuilder(this, this.mc, this.pf);
    }

    public AgentBuilder agent() {
        return new AgentBuilder(this, this.mc, this.pf);
    }

    public WasDerivedFromBuilder wasDerivedFrom() {
        return new WasDerivedFromBuilder(this, this.mc, this.pf);
    }

    public WasAttributedToBuilder wasAttributedTo() {
        return new WasAttributedToBuilder(this, this.mc, this.pf);
    }

    public UsedBuilder used() {
        return new UsedBuilder(this, this.mc, this.pf);
    }

    public WasGeneratedByBuilder wasGeneratedBy() {
        return new WasGeneratedByBuilder(this, this.mc, this.pf);
    }

    public WasInformedByBuilder wasInformedBy() {
        return new WasInformedByBuilder(this, this.mc, this.pf);
    }

    public WasStartedByBuilder wasStartedBy() {
        return new WasStartedByBuilder(this, this.mc, this.pf);
    }

    public WasEndedByBuilder wasEndedBy() {
        return new WasEndedByBuilder(this, this.mc, this.pf);
    }

    public SpecializationOfBuilder specializationOf() {
        return new SpecializationOfBuilder(this, this.mc, this.mce, this.pf);
    }

    public AlternateOfBuilder alternateOf() {
        return new AlternateOfBuilder(this, this.mc, this.mce, this.pf);
    }

    public HadMemberBuilder hadMember() {
        return new HadMemberBuilder(this, this.mc, this.mce, this.pf);
    }

    public WasInfluencedByBuilder wasInfluencedBy() {
        return new WasInfluencedByBuilder(this, this.mc, this.pf);
    }

    public WasInvalidatedByBuilder wasInvalidatedBy() {
        return new WasInvalidatedByBuilder(this, this.mc, this.pf);
    }

    public ActedOnBehalfOfBuilder actedOnBehalfOf() {
        return new ActedOnBehalfOfBuilder(this, this.mc, this.pf);
    }

    public WasAssociatedWithBuilder wasAssociatedWith() {
        return new WasAssociatedWithBuilder(this, this.mc, this.pf);
    }

    public Document build() {
        return this.mc.newDocument(this.namespace, this.statements, this.bundles);
    }

    public BundleBuilder bundle() {
        return new BundleBuilder(this, this.mc, this.mce, this.pf);
    }

    public Builder prefix(Prefix prefix, String ns) {
        this.namespace.register(prefix.get(), ns);
        return this;
    }

    public Builder prefix(String prefix, String ns) {
        this.namespace.register(prefix, ns);
        return this;
    }

    public final QualifiedName qn(Prefix prefix, String local) {
        return this.mc.newQualifiedName(this.namespace.lookupPrefix(prefix.get()), local, prefix.get());
    }

    public final QualifiedName qn(String prefix, String local) {
        return this.mc.newQualifiedName(this.namespace.lookupPrefix(prefix), local, prefix);
    }

    public <T> Builder forEach(Collection<T> collection, Function<T, Builder> function) {
        for (T t : collection) {
            function.apply(t);
        }
        return this;
    }

    public <T> Builder forEach(Collection<T> collection, BiFunction<T, Integer, Builder> function) {
        int count = 0;
        for (T t : collection) {
            function.apply(t, count++);
        }
        return this;
    }

    public Builder buildBundle() {
        throw new UnsupportedOperationException("Cannot build a Bundle from a document builder. Call build instead.");
    }

    public Prefix prefix(String pref) {
        return new Prefix(this, pref);
    }

    public QualifiedName PROV_PERSON() {
        return this.pf.getName().PROV_PERSON;
    }
}

