/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model.builder;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.builder.Builder;
import org.openprovenance.prov.model.builder.EntityBuilder;
import org.openprovenance.prov.model.builder.Prefix;

public class BundleBuilder
extends Builder {
    private final Builder parentBuilder;
    private final ProvFactory pf;
    private final HashMap<String, QualifiedName> knowAsCopy;
    private QualifiedName id;
    private Namespace namespaceCopy;
    private List<Statement> statementsCopy;

    public BundleBuilder(Builder parentBuilder, ModelConstructor mc, ModelConstructorExtension mce, ProvFactory pf) {
        super(mc, mce, pf);
        this.pf = pf;
        this.parentBuilder = parentBuilder;
        this.namespaceCopy = parentBuilder.namespace;
        this.namespace = new Namespace();
        this.namespace.setParent(this.namespaceCopy);
        this.statementsCopy = parentBuilder.statements;
        this.statements = new LinkedList();
        this.knowAsCopy = parentBuilder.knownAs;
        this.knownAs = new HashMap();
    }

    public BundleBuilder id(QualifiedName id) {
        this.id = id;
        return this;
    }

    public BundleBuilder id(String prefix, String local) {
        this.id = this.qn(prefix, local);
        return this;
    }

    public BundleBuilder id(Prefix prefix, String local) {
        this.id = this.qn(prefix.get(), local);
        return this;
    }

    @Override
    public Builder buildBundle() {
        Bundle bundle = this.pf.newNamedBundle(this.id, this.namespace, this.statements);
        this.parentBuilder.bundles.add(bundle);
        this.parentBuilder.namespace = this.namespaceCopy;
        this.parentBuilder.statements = this.statementsCopy;
        this.parentBuilder.knownAs = this.knowAsCopy;
        return this.parentBuilder;
    }

    @Override
    public Document build() {
        throw new UnsupportedOperationException("Cannot build a document from a bundle builder. Call cuildBundle instead.");
    }

    public BundleBuilder aka() {
        this.knownAs.put(this.id.getLocalPart(), this.id);
        return this;
    }

    @Override
    public EntityBuilder entity() {
        return new EntityBuilder(this, this.mc, this.pf);
    }
}

