/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.openprovenance.apache.commons.lang.builder.EqualsBuilder;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.apache.commons.lang.builder.ToStringBuilder;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class DictionaryMembership
implements org.openprovenance.prov.model.DictionaryMembership,
Identifiable,
HasType,
HasLabel,
HasOther {
    private QualifiedName id;
    private final List<LangString> labels = new LinkedList<LangString>();
    private final List<Type> type = new LinkedList<Type>();
    private final List<Other> other = new LinkedList<Other>();
    private QualifiedName dictionary;
    private final List<Entry> keyEntityPair;
    final ProvUtilities u = new ProvUtilities();

    public DictionaryMembership(QualifiedName id, QualifiedName dictionary, List<Entry> keyEntityPair, Collection<Attribute> attributes) {
        this.id = id;
        this.dictionary = dictionary;
        this.keyEntityPair = Objects.requireNonNullElseGet(keyEntityPair, LinkedList::new);
        this.u.populateAttributes(attributes, this.labels, new LinkedList<Location>(), this.type, new LinkedList<Role>(), this.other, null);
    }

    @Override
    public QualifiedName getDictionary() {
        return this.dictionary;
    }

    @Override
    public List<Entry> getKeyEntityPair() {
        return this.keyEntityPair;
    }

    @Override
    public void setDictionary(QualifiedName dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public StatementOrBundle.Kind getKind() {
        return StatementOrBundle.Kind.PROV_DICTIONARY_MEMBERSHIP;
    }

    public void equals(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof DictionaryMembership)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        DictionaryMembership that = (DictionaryMembership)object;
        equalsBuilder.append(this.getDictionary(), that.getDictionary());
        equalsBuilder.append(this.getKeyEntityPair(), that.getKeyEntityPair());
    }

    public boolean equals(Object object) {
        if (!(object instanceof DictionaryMembership)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        this.equals(object, equalsBuilder);
        return equalsBuilder.isEquals();
    }

    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        hashCodeBuilder.append(this.getDictionary());
        hashCodeBuilder.append(this.getKeyEntityPair());
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    public void toString(ToStringBuilder toStringBuilder) {
        QualifiedName theId = this.getDictionary();
        toStringBuilder.append("dictionary", theId);
        toStringBuilder.append("entries", this.getKeyEntityPair());
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        this.toString(toStringBuilder);
        return toStringBuilder.toString();
    }

    @Override
    public List<LangString> getLabel() {
        return this.labels;
    }

    @Override
    public List<Other> getOther() {
        return this.other;
    }

    @Override
    public List<Type> getType() {
        return this.type;
    }

    @Override
    public QualifiedName getId() {
        return this.id;
    }

    @Override
    public void setId(QualifiedName id) {
        this.id = id;
    }
}

