/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.AtomConstructor;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Label;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.LiteralConstructor;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvSerialiser;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.vanilla.DerivedByInsertionFrom;
import org.openprovenance.prov.vanilla.DerivedByRemovalFrom;
import org.openprovenance.prov.vanilla.DictionaryMembership;
import org.openprovenance.prov.vanilla.Entry;
import org.openprovenance.prov.vanilla.HadMember;
import org.openprovenance.prov.vanilla.Key;
import org.openprovenance.prov.vanilla.ModelConstructor;
import org.openprovenance.prov.vanilla.QualifiedAlternateOf;
import org.openprovenance.prov.vanilla.QualifiedHadMember;
import org.openprovenance.prov.vanilla.QualifiedSpecializationOf;

public class ProvFactory
extends org.openprovenance.prov.model.ProvFactory
implements LiteralConstructor,
org.openprovenance.prov.model.ModelConstructor,
ModelConstructorExtension,
AtomConstructor {
    static Logger logger = LogManager.getLogger(ProvFactory.class);
    private static final ProvFactory oFactory = new ProvFactory();
    final org.openprovenance.prov.model.ModelConstructor mc;
    final AtomConstructor ac;

    public static ProvFactory getFactory() {
        return oFactory;
    }

    public ProvFactory() {
        this.mc = new ModelConstructor();
        this.ac = (AtomConstructor)((Object)this.mc);
    }

    public ProvFactory(org.openprovenance.prov.model.ModelConstructor mc) {
        this.mc = mc;
        this.ac = (AtomConstructor)((Object)mc);
    }

    @Override
    public ProvSerialiser getSerializer() {
        return null;
    }

    @Override
    public Attribute newAttribute(QualifiedName elementName, Object value, QualifiedName type) {
        if (elementName.equals(this.getName().PROV_LOCATION)) {
            return this.newLocation(value, type);
        }
        if (elementName.equals(this.getName().PROV_TYPE)) {
            return this.newType(value, type);
        }
        if (elementName.equals(this.getName().PROV_VALUE)) {
            return this.newValue(value, type);
        }
        if (elementName.equals(this.getName().PROV_ROLE)) {
            return this.newRole(value, type);
        }
        if (elementName.equals(this.getName().PROV_LABEL)) {
            return this.newLabel(value, type);
        }
        if (elementName.equals(this.getName().PROV_KEY)) {
            throw new UnsupportedOperationException("key not there yet");
        }
        return this.newOther(elementName, value, type);
    }

    @Override
    public Attribute newAttribute(Attribute.AttributeKind kind, Object value, QualifiedName type) {
        switch (kind) {
            case PROV_TYPE: {
                return this.newType(value, type);
            }
            case PROV_LABEL: {
                return this.newLabel(value, type);
            }
            case PROV_ROLE: {
                return this.newRole(value, type);
            }
            case PROV_LOCATION: {
                return this.newLocation(value, type);
            }
            case PROV_VALUE: {
                return this.newValue(value, type);
            }
        }
        throw new UnsupportedOperationException("Should never be here, unknown " + String.valueOf((Object)kind));
    }

    @Override
    public QualifiedName newQualifiedName(String namespace, String local, String prefix) {
        return this.mc.newQualifiedName(namespace, local, prefix);
    }

    @Override
    public QualifiedName newQualifiedName(String namespace, String local, String prefix, ProvUtilities.BuildFlag flag) {
        return this.mc.newQualifiedName(namespace, local, prefix);
    }

    @Override
    public LangString newInternationalizedString(String s, String lang) {
        return this.ac.newInternationalizedString(s, lang);
    }

    @Override
    public LangString newInternationalizedString(String s) {
        return this.ac.newInternationalizedString(s);
    }

    @Override
    public Type newType(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        return this.ac.newType(value, type);
    }

    @Override
    public Other newOther(QualifiedName elementName, Object value, QualifiedName type) {
        return this.ac.newOther(elementName, value, type);
    }

    @Override
    public Location newLocation(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        return this.ac.newLocation(value, type);
    }

    @Override
    public Activity newActivity(QualifiedName a, XMLGregorianCalendar startTime, XMLGregorianCalendar endTime, Collection<Attribute> attributes) {
        return this.mc.newActivity(a, startTime, endTime, attributes);
    }

    @Override
    public Activity newActivity(QualifiedName q, String label) {
        Attribute attr = this.newAttribute(Attribute.AttributeKind.PROV_LABEL, (Object)this.newInternationalizedString(label), this.getName().PROV_LANG_STRING);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        attributes.add(attr);
        return this.newActivity(q, null, null, attributes);
    }

    @Override
    public Entity newEntity(QualifiedName a) {
        return this.mc.newEntity(a, new LinkedList<Attribute>());
    }

    @Override
    public Entity newEntity(QualifiedName id, String label) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        attrs.add(this.newAttribute(Attribute.AttributeKind.PROV_LABEL, (Object)this.newInternationalizedString(label), this.getName().XSD_STRING));
        return this.mc.newEntity(id, attrs);
    }

    @Override
    public org.openprovenance.prov.model.Entry newEntry(org.openprovenance.prov.model.Key key, QualifiedName entity) {
        return new Entry(key, entity);
    }

    @Override
    public Entity newEntity(QualifiedName id, Collection<Attribute> attributes) {
        return this.mc.newEntity(id, attributes);
    }

    @Override
    public Document newDocument() {
        return this.mc.newDocument(null, null, null);
    }

    @Override
    public org.openprovenance.prov.model.Key newKey(Object o, QualifiedName type) {
        return new Key(o, type);
    }

    @Override
    public Value newValue(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        return this.ac.newValue(value, type);
    }

    @Override
    public Agent newAgent(QualifiedName ag) {
        return this.mc.newAgent(ag, new LinkedList<Attribute>());
    }

    @Override
    public Agent newAgent(QualifiedName id, Collection<Attribute> attributes) {
        return this.mc.newAgent(id, attributes);
    }

    @Override
    public Agent newAgent(QualifiedName ag, String label) {
        Agent res = this.newAgent(ag);
        if (label != null) {
            res.getLabel().add(this.newInternationalizedString(label));
        }
        return res;
    }

    @Override
    public Used newUsed(QualifiedName id) {
        return this.mc.newUsed(id, null, null, null, new LinkedList<Attribute>());
    }

    @Override
    public Used newUsed(QualifiedName id, QualifiedName activity, String role, QualifiedName entity) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (role != null) {
            attributes.add(this.newRole(role, this.getName().XSD_STRING));
        }
        return this.mc.newUsed(id, activity, entity, null, attributes);
    }

    @Override
    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity) {
        return this.mc.newUsed(id, activity, entity, null, new LinkedList<Attribute>());
    }

    @Override
    public Used newUsed(QualifiedName activity, QualifiedName entity) {
        return this.newUsed(null, activity, entity);
    }

    @Override
    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        return this.mc.newUsed(id, activity, entity, time, attributes);
    }

    @Override
    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time) {
        return this.newUsed(id, activity, entity, time, new LinkedList<Attribute>());
    }

    @Override
    public Role newRole(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        return this.ac.newRole(value, type);
    }

    @Override
    public Label newLabel(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        return this.ac.newLabel(value, type);
    }

    @Override
    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName entity, String role, QualifiedName activity) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (role != null) {
            attributes.add(this.newRole(role, this.getName().XSD_STRING));
        }
        return this.mc.newWasGeneratedBy(id, entity, activity, null, attributes);
    }

    @Override
    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        return this.mc.newWasGeneratedBy(id, entity, activity, time, attributes);
    }

    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName eid, String role, QualifiedName aid) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (role != null) {
            attributes.add(this.newRole(role, this.getName().XSD_STRING));
        }
        return this.mc.newWasInvalidatedBy(id, eid, aid, null, attributes);
    }

    @Override
    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity) {
        return this.mc.newWasInvalidatedBy(id, entity, activity, null, new LinkedList<Attribute>());
    }

    @Override
    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        WasInvalidatedBy res = this.mc.newWasInvalidatedBy(id, entity, activity, time, attributes);
        res.setTime(time);
        return res;
    }

    @Override
    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName activity, QualifiedName agent) {
        return this.mc.newWasAssociatedWith(id, activity, agent, null, new LinkedList<Attribute>());
    }

    @Override
    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan, Collection<Attribute> attributes) {
        return this.mc.newWasAssociatedWith(id, a, ag, plan, attributes);
    }

    @Override
    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan) {
        return this.mc.newWasAssociatedWith(id, a, ag, plan, new LinkedList<Attribute>());
    }

    @Override
    public WasAssociatedWith newWasAssociatedWith(WasAssociatedWith u) {
        WasAssociatedWith u1 = this.newWasAssociatedWith(u.getId(), u.getActivity(), u.getAgent(), u.getPlan());
        u1.getType().addAll(u.getType());
        u1.getLabel().addAll(u.getLabel());
        u1.getRole().addAll(u.getRole());
        u1.getOther().addAll(u.getOther());
        return u1;
    }

    @Override
    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName entity, QualifiedName agent) {
        return this.mc.newWasAttributedTo(id, entity, agent, new LinkedList<Attribute>());
    }

    public WasAttributedTo newWasAttributedTo(QualifiedName entity, QualifiedName agent) {
        return this.mc.newWasAttributedTo(null, entity, agent, new LinkedList<Attribute>());
    }

    @Override
    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName entity, QualifiedName agent, Collection<Attribute> attributes) {
        return this.mc.newWasAttributedTo(id, entity, agent, attributes);
    }

    @Override
    public SpecializationOf newSpecializationOf(QualifiedName specific, QualifiedName general) {
        return this.mc.newSpecializationOf(specific, general);
    }

    @Override
    public AlternateOf newAlternateOf(QualifiedName entity1, QualifiedName entity2) {
        return this.mc.newAlternateOf(entity1, entity2);
    }

    @Override
    public org.openprovenance.prov.model.DerivedByInsertionFrom newDerivedByInsertionFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<org.openprovenance.prov.model.Entry> keyEntitySet, Collection<Attribute> attributes) {
        return new DerivedByInsertionFrom(id, after, before, keyEntitySet, attributes);
    }

    @Override
    public org.openprovenance.prov.model.DerivedByRemovalFrom newDerivedByRemovalFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<org.openprovenance.prov.model.Key> keys, Collection<Attribute> attributes) {
        return new DerivedByRemovalFrom(id, after, before, keys, attributes);
    }

    @Override
    public org.openprovenance.prov.model.DictionaryMembership newDictionaryMembership(QualifiedName id, QualifiedName dict, List<org.openprovenance.prov.model.Entry> keyEntitySet, Collection<Attribute> attributes) {
        return new DictionaryMembership(id, dict, keyEntitySet, attributes);
    }

    @Override
    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName e2, QualifiedName e1) {
        return this.mc.newWasDerivedFrom(id, e2, e1, null, null, null, new LinkedList<Attribute>());
    }

    @Override
    public WasDerivedFrom newWasDerivedFrom(QualifiedName e2, QualifiedName e1) {
        return this.mc.newWasDerivedFrom(null, e2, e1, null, null, null, new LinkedList<Attribute>());
    }

    @Override
    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName e2, QualifiedName e1, QualifiedName a, QualifiedName gen, QualifiedName use, Collection<Attribute> attributes) {
        return this.mc.newWasDerivedFrom(id, e2, e1, a, gen, use, attributes);
    }

    @Override
    public Document newDocument(Collection<Activity> ps, Collection<Entity> as, Collection<Agent> ags, Collection<Statement> lks) {
        Document res = this.newDocument();
        res.getStatementOrBundle().addAll(ps);
        res.getStatementOrBundle().addAll(as);
        res.getStatementOrBundle().addAll(ags);
        res.getStatementOrBundle().addAll(lks);
        return res;
    }

    @Override
    public Document newDocument(Document graph) {
        Document res = this.newDocument();
        res.getStatementOrBundle().addAll(graph.getStatementOrBundle());
        if (graph.getNamespace() != null) {
            res.setNamespace(new Namespace(graph.getNamespace()));
        }
        return res;
    }

    @Override
    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName informed, QualifiedName informant) {
        return this.mc.newWasInformedBy(id, informed, informant, new LinkedList<Attribute>());
    }

    @Override
    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName informed, QualifiedName informant, Collection<Attribute> attributes) {
        return this.mc.newWasInformedBy(id, informed, informant, attributes);
    }

    @Override
    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName influencee, QualifiedName influencer) {
        return this.mc.newWasInfluencedBy(id, influencee, influencer, new LinkedList<Attribute>());
    }

    @Override
    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName influencee, QualifiedName influencer, Collection<Attribute> attributes) {
        return this.mc.newWasInfluencedBy(id, influencee, influencer, attributes);
    }

    @Override
    public org.openprovenance.prov.model.HadMember newHadMember(QualifiedName collection, QualifiedName ... entities) {
        return new HadMember(collection, Arrays.asList(entities));
    }

    @Override
    public org.openprovenance.prov.model.HadMember newHadMember(QualifiedName c, Collection<QualifiedName> e) {
        LinkedList<QualifiedName> ll = new LinkedList<QualifiedName>();
        if (e != null) {
            ll.addAll(e);
        }
        return new HadMember(c, ll);
    }

    @Override
    public MentionOf newMentionOf(QualifiedName e2, QualifiedName e1, QualifiedName b) {
        throw new UnsupportedOperationException("newMentionOf not supported");
    }

    @Override
    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger) {
        return this.mc.newWasStartedBy(id, activity, trigger, null, null, new LinkedList<Attribute>());
    }

    @Override
    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter) {
        return this.mc.newWasStartedBy(id, activity, trigger, starter, null, new LinkedList<Attribute>());
    }

    @Override
    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        return this.mc.newWasStartedBy(id, activity, trigger, starter, time, attributes);
    }

    @Override
    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName aid, QualifiedName eid) {
        return this.mc.newWasEndedBy(id, aid, eid, null, null, new LinkedList<Attribute>());
    }

    @Override
    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender) {
        return this.mc.newWasEndedBy(id, activity, trigger, ender, null, new LinkedList<Attribute>());
    }

    @Override
    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        return this.mc.newWasEndedBy(id, activity, trigger, ender, time, attributes);
    }

    @Override
    public Document newDocument(Namespace namespace, Collection<Statement> statements, Collection<Bundle> bundles) {
        Document res = this.newDocument();
        res.setNamespace(namespace);
        res.getStatementOrBundle().addAll(statements);
        res.getStatementOrBundle().addAll(bundles);
        return res;
    }

    @Override
    public Document newDocument(Namespace namespace, List<StatementOrBundle> statementsOrBundles) {
        Document res = this.newDocument();
        res.setNamespace(namespace);
        res.getStatementOrBundle().addAll(statementsOrBundles);
        return res;
    }

    @Override
    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible, QualifiedName activity) {
        return this.mc.newActedOnBehalfOf(id, delegate, responsible, activity, new LinkedList<Attribute>());
    }

    @Override
    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible, QualifiedName activity, Collection<Attribute> attributes) {
        return this.mc.newActedOnBehalfOf(id, delegate, responsible, activity, attributes);
    }

    @Override
    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible) {
        return this.mc.newActedOnBehalfOf(id, delegate, responsible, null, new LinkedList<Attribute>());
    }

    @Override
    public Bundle newNamedBundle(QualifiedName id, Collection<Statement> statements) {
        return this.newNamedBundle(id, null, statements);
    }

    @Override
    public Bundle newNamedBundle(QualifiedName id, Namespace namespace, Collection<Statement> statements) {
        return this.mc.newNamedBundle(id, namespace, statements);
    }

    @Override
    public Bundle newNamedBundle(QualifiedName id, Collection<Activity> ps, Collection<Entity> as, Collection<Agent> ags, Collection<Statement> lks) {
        LinkedList<Statement> attr = new LinkedList<Statement>();
        attr.addAll(ps);
        attr.addAll(as);
        attr.addAll(ags);
        attr.addAll(lks);
        return this.newNamedBundle(id, attr);
    }

    @Override
    public org.openprovenance.prov.model.extension.QualifiedHadMember newQualifiedHadMember(QualifiedName id, QualifiedName c, Collection<QualifiedName> e, Collection<Attribute> attributes) {
        return new QualifiedHadMember(id, c, e, attributes);
    }

    @Override
    public org.openprovenance.prov.model.extension.QualifiedSpecializationOf newQualifiedSpecializationOf(QualifiedName id, QualifiedName specific, QualifiedName general, Collection<Attribute> attributes) {
        return new QualifiedSpecializationOf(id, specific, general, attributes);
    }

    @Override
    public org.openprovenance.prov.model.extension.QualifiedAlternateOf newQualifiedAlternateOf(QualifiedName id, QualifiedName alt1, QualifiedName alt2, Collection<Attribute> attributes) {
        return new QualifiedAlternateOf(id, alt1, alt2, attributes);
    }
}

