/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import javax.xml.namespace.QName;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.prov.model.QualifiedNameUtils;
import org.openprovenance.prov.model.exception.QualifiedNameException;

public class QualifiedName
implements org.openprovenance.prov.model.QualifiedName {
    static final QualifiedNameUtils qnU = new QualifiedNameUtils();
    private String namespace;
    private String local;
    private String prefix;
    protected org.openprovenance.prov.model.QualifiedName ref;

    public QualifiedName(String namespaceURI, String localPart, String prefix) {
        this.namespace = namespaceURI;
        this.local = localPart;
        this.prefix = prefix;
    }

    private QualifiedName() {
    }

    @Override
    public QName toQName() {
        String escapedLocal = qnU.escapeToXsdLocalName(this.getUnescapedLocalPart());
        if (qnU.is_NC_Name(escapedLocal)) {
            if (this.prefix == null) {
                return new QName(this.namespace, escapedLocal);
            }
            return new QName(this.namespace, escapedLocal, this.prefix);
        }
        throw new QualifiedNameException("PROV-XML QName: local not valid " + escapedLocal);
    }

    private String getUnescapedLocalPart() {
        return qnU.unescapeProvLocalName(this.local);
    }

    @Override
    public String getUri() {
        return this.getNamespaceURI() + this.getUnescapedLocalPart();
    }

    @Override
    public void setUri(String uri) {
    }

    @Override
    public String getLocalPart() {
        return this.local;
    }

    @Override
    public void setLocalPart(String local) {
    }

    @Override
    public String getNamespaceURI() {
        return this.namespace;
    }

    @Override
    public void setNamespaceURI(String namespaceURI) {
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public final boolean equals(Object objectToTest) {
        if (objectToTest == this) {
            return true;
        }
        if (objectToTest instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)objectToTest;
            return this.local.equals(qualifiedName.local) && this.namespace.equals(qualifiedName.namespace);
        }
        return false;
    }

    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        hashCodeBuilder.append(this.local);
        hashCodeBuilder.append(this.namespace);
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    public String toString() {
        return "'" + this.prefix + ":{{" + this.namespace + "}}" + this.local + "'";
    }
}

