/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.notation;

import java.io.File;
import junit.framework.TestCase;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.notation.Utility;
import org.openprovenance.prov.xml.DocumentEquality;
import org.openprovenance.prov.xml.ProvDeserialiser;
import org.openprovenance.prov.xml.ProvFactory;
import org.openprovenance.prov.xml.ProvSerialiser;

public class RoundTripFromProvnTest
extends TestCase {
    final Utility u = new Utility();
    static ProvFactory pFactory = ProvFactory.getFactory();

    public RoundTripFromProvnTest(String name) {
        super(name);
    }

    public String extension() {
        return ".provn";
    }

    public void loadFromProvnSaveAndReload(String file, Boolean compare) throws Throwable {
        System.out.println("-------------- File: " + file);
        Utility u2 = new Utility();
        DocumentEquality de = new DocumentEquality(true);
        Document doc1 = this.u.readDocument("src/test/resources/" + file, (org.openprovenance.prov.model.ProvFactory)pFactory);
        file = file.replace('/', '_');
        this.u.writeDocument(doc1, "target/" + file, (org.openprovenance.prov.model.ProvFactory)pFactory);
        Document doc2 = this.u.readDocument("target/" + file, (org.openprovenance.prov.model.ProvFactory)pFactory);
        boolean result = de.check(doc1, doc2);
        if (!result && compare.booleanValue()) {
            System.out.println(doc1);
            System.out.println("------------------");
            System.out.println(doc2);
        }
        if (compare.booleanValue()) {
            RoundTripFromProvnTest.assertTrue((boolean)result);
        }
        System.out.println("result is " + result);
        ProvSerialiser.getThreadProvSerialiser().serialiseDocument(new File("target/" + file + ".xml"), doc2, true);
        u2.writeDocument(doc2, "target/" + file + ".provn", (org.openprovenance.prov.model.ProvFactory)pFactory);
    }

    public void loadFromProvnSaveToXmlAndReload(String file, Boolean compare) throws Throwable {
        System.out.println("-------------- File: " + file);
        Utility u2 = new Utility();
        DocumentEquality de = new DocumentEquality(true);
        Document doc1 = this.u.readDocument("src/test/resources/" + file, (org.openprovenance.prov.model.ProvFactory)pFactory);
        file = file.replace('/', '_');
        ProvSerialiser serial = ProvSerialiser.getThreadProvSerialiser();
        System.out.println("1. xxx");
        serial.serialiseDocument(new File("target/xml_" + file + ".xml"), doc1, true);
        ProvDeserialiser deserial = ProvDeserialiser.getThreadProvDeserialiser();
        org.openprovenance.prov.xml.Document doc2 = deserial.deserialiseDocument(new File("target/xml_" + file + ".xml"));
        System.out.println("2. xxx");
        boolean result = de.check(doc1, (Document)doc2);
        if (!result && compare.booleanValue()) {
            System.out.println(doc1);
            System.out.println("------------------");
            System.out.println(doc2);
        }
        if (compare.booleanValue()) {
            RoundTripFromProvnTest.assertTrue((boolean)result);
        }
        System.out.println("result is " + result);
        System.out.println("3. xxx");
        ProvSerialiser.getThreadProvSerialiser().serialiseDocument(new File("target/" + file + ".xml"), (Document)doc2, true);
        System.out.println("4. xxx");
        u2.writeDocument((Document)doc2, "target/" + file + ".provn", (org.openprovenance.prov.model.ProvFactory)pFactory);
    }

    private void testIssue(String issueName) throws Throwable {
        this.loadFromProvnSaveAndReload("issues/" + issueName + ".provn", true);
    }

    private void testCrossIssue(String issueName) throws Throwable {
        this.loadFromProvnSaveToXmlAndReload("issues/" + issueName + ".provn", true);
    }

    public void testMembership() throws Throwable {
        this.testIssue("unification-membership-f1-FAIL-DM");
        this.testIssue("unification-membership-f2-FAIL-DM");
    }

    public void testBundles() throws Throwable {
        this.testCrossIssue("picaso-file");
    }
}

