/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.notation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;

public class NotationConstructor
implements ModelConstructor,
ModelConstructorExtension {
    public static final String MARKER = "-";
    boolean abbrev = false;
    private final BufferedWriter buffer;
    public boolean standaloneExpression = false;

    public NotationConstructor(Writer writer) {
        this.buffer = new BufferedWriter(writer);
    }

    public String breakline() {
        return "\n";
    }

    public void close() {
        try {
            this.buffer.close();
        }
        catch (IOException e) {
            throw new UncheckedException("convertBeanToNotation: closing writer failed", (Exception)e);
        }
    }

    public Object convertDefaultNamespace(Object iri) {
        return this.keyword("default") + " " + this.showuri((String)iri);
    }

    public Object convertExtension(Object name, QualifiedName id, Object args, Object dAttrs) {
        System.out.println("Name @" + name);
        System.out.println("Name @" + id);
        System.out.println("Name @" + args);
        System.out.println("Name @" + dAttrs);
        return null;
    }

    public Object convertNamespace(Object pre, Object iri) {
        return this.keyword("prefix") + " " + this.showprefix((String)pre) + " " + this.showuri((String)iri);
    }

    public void flush() {
        try {
            this.buffer.flush();
        }
        catch (IOException e) {
            throw new UncheckedException("convertBeanToNotation: closing writer failed", (Exception)e);
        }
    }

    public String idOrMarker(QualifiedName qn) {
        return qn == null ? MARKER : Namespace.getThreadNamespace().qualifiedNameToString(qn);
    }

    private String keyEntitySet(List<Entry> kes) {
        Object s = "{";
        if (kes != null) {
            boolean first = true;
            for (Entry p : kes) {
                if (!first) {
                    s = (String)s + ", ";
                }
                first = false;
                s = (String)s + "(" + ProvUtilities.valueToNotationString((Key)p.getKey()) + ", " + this.idOrMarker(p.getEntity()) + ")";
            }
        }
        s = (String)s + "}";
        return s;
    }

    private String keySet(List<Key> ks) {
        Object s = "{";
        if (ks != null) {
            boolean first = true;
            for (Key k : ks) {
                if (!first) {
                    s = (String)s + ", ";
                }
                first = false;
                s = (String)s + ProvUtilities.valueToNotationString((Key)k);
            }
        }
        s = (String)s + "}";
        return s;
    }

    public String keyword(String s) {
        return s;
    }

    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName ag2, QualifiedName ag1, QualifiedName a, Collection<Attribute> attributes) {
        String s = this.keyword("actedOnBehalfOf") + "(" + this.optionalId(id) + this.idOrMarker(ag2) + "," + this.idOrMarker(ag1) + "," + this.idOrMarker(a) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public Activity newActivity(QualifiedName id, XMLGregorianCalendar startTime, XMLGregorianCalendar endTime, Collection<Attribute> attributes) {
        String s = this.keyword("activity") + "(" + this.idOrMarker(id) + "," + this.timeOrMarker(startTime) + "," + this.timeOrMarker(endTime) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public Agent newAgent(QualifiedName id, Collection<Attribute> attributes) {
        String s = this.keyword("agent") + "(" + this.idOrMarker(id) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public AlternateOf newAlternateOf(QualifiedName e1, QualifiedName e2) {
        this.writeln("alternateOf(" + this.idOrMarker(e1) + "," + this.idOrMarker(e2) + ")");
        return null;
    }

    public DerivedByInsertionFrom newDerivedByInsertionFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<Entry> kes, Collection<Attribute> attributes) {
        String s = "prov:derivedByInsertionFrom(" + this.optionalId(id) + this.idOrMarker(after) + "," + this.idOrMarker(before) + "," + this.keyEntitySet(kes) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public DerivedByRemovalFrom newDerivedByRemovalFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<Key> keys, Collection<Attribute> attributes) {
        String s = "prov:derivedByRemovalFrom(" + this.optionalId(id) + this.idOrMarker(after) + "," + this.idOrMarker(before) + "," + this.keySet(keys) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public DictionaryMembership newDictionaryMembership(QualifiedName dict, List<Entry> keyEntitySet) {
        if (this.abbrev) {
            String s = "provx:hadDictionaryMember(" + this.idOrMarker(dict) + "," + this.keyEntitySet(keyEntitySet) + ")";
            this.writeln(s);
        } else {
            for (Entry entry : keyEntitySet) {
                String s = "prov:hadDictionaryMember(" + this.idOrMarker(dict) + "," + this.idOrMarker(entry.getEntity()) + "," + ProvUtilities.valueToNotationString((Key)entry.getKey()) + ")";
                this.writeln(s);
            }
        }
        return null;
    }

    public Document newDocument(Namespace namespaces, Collection<Statement> statements, Collection<Bundle> bundles) {
        Object s = "";
        s = (String)s + this.keyword("endDocument");
        this.writeln((String)s);
        return null;
    }

    public Entity newEntity(QualifiedName id, Collection<Attribute> attributes) {
        String s = this.keyword("entity") + "(" + this.idOrMarker(id) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public HadMember newHadMember(QualifiedName c, Collection<QualifiedName> ll) {
        if (ll == null || ll.size() == 0) {
            String s = this.keyword("hadMember") + "(" + this.idOrMarker(c) + "," + this.idOrMarker(null) + ")";
            this.writeln(s);
        } else {
            for (QualifiedName e : ll) {
                String s = this.keyword("hadMember") + "(" + this.idOrMarker(c) + "," + this.idOrMarker(e) + ")";
                this.writeln(s);
            }
        }
        return null;
    }

    public MentionOf newMentionOf(QualifiedName e2, QualifiedName e1, QualifiedName b) {
        String s = "mentionOf(" + this.idOrMarker(e2) + ", " + this.idOrMarker(e1) + ", " + this.idOrMarker(b) + ")";
        this.writeln(s);
        return null;
    }

    public Bundle newNamedBundle(QualifiedName id, Namespace namespace, Collection<Statement> statements) {
        Object s = "";
        s = (String)s + this.keyword("endBundle");
        this.writeln((String)s);
        return null;
    }

    public SpecializationOf newSpecializationOf(QualifiedName e2, QualifiedName e1) {
        this.writeln("specializationOf(" + this.idOrMarker(e2) + "," + this.idOrMarker(e1) + ")");
        return null;
    }

    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        String s = this.keyword("used") + "(" + this.optionalId(id) + this.idOrMarker(activity) + "," + this.idOrMarker(entity) + "," + this.timeOrMarker(time) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan, Collection<Attribute> attributes) {
        String s = this.keyword("wasAssociatedWith") + "(" + this.optionalId(id) + this.idOrMarker(a) + "," + this.idOrMarker(ag) + "," + this.idOrMarker(plan) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName e, QualifiedName ag, Collection<Attribute> attributes) {
        String s = this.keyword("wasAttributedTo") + "(" + this.optionalId(id) + this.idOrMarker(e) + ", " + this.idOrMarker(ag) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName e2, QualifiedName e1, QualifiedName activity, QualifiedName generation, QualifiedName usage, Collection<Attribute> attributes) {
        String s = this.keyword("wasDerivedFrom") + "(" + this.optionalId(id) + this.idOrMarker(e2) + ", " + this.idOrMarker(e1) + (String)(activity == null && generation == null && usage == null ? "" : ", " + this.idOrMarker(activity) + ", " + this.idOrMarker(generation) + ", " + this.idOrMarker(usage)) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        String s = "wasEndedBy(" + this.optionalId(id) + this.idOrMarker(activity) + "," + this.idOrMarker(trigger) + "," + this.idOrMarker(ender) + "," + this.timeOrMarker(time) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        String s = this.keyword("wasGeneratedBy") + "(" + this.optionalId(id) + this.idOrMarker(entity) + "," + this.idOrMarker(activity) + "," + this.timeOrMarker(time) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName a2, QualifiedName a1, Collection<Attribute> attributes) {
        String s = "wasInfluencedBy(" + this.optionalId(id) + this.idOrMarker(a2) + "," + this.idOrMarker(a1) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName a2, QualifiedName a1, Collection<Attribute> attributes) {
        String s = "wasInformedBy(" + this.optionalId(id) + this.idOrMarker(a2) + "," + this.idOrMarker(a1) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        String s = this.keyword("wasInvalidatedBy") + "(" + this.optionalId(id) + this.idOrMarker(entity) + "," + this.idOrMarker(activity) + "," + this.timeOrMarker(time) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        String s = "wasStartedBy(" + this.optionalId(id) + this.idOrMarker(activity) + "," + this.idOrMarker(trigger) + "," + this.idOrMarker(starter) + "," + this.timeOrMarker(time) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public String optionalAttributes(Collection<Attribute> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Attribute attr : attrs) {
            if (first) {
                sb.append(this.symbol(",[") + attr.toNotationString());
                first = false;
                continue;
            }
            sb.append(this.symbol(",") + " " + attr.toNotationString());
        }
        if (!first) {
            sb.append(this.symbol("]"));
        }
        return sb.toString();
    }

    private String optionalId(QualifiedName id) {
        return id == null ? "" : Namespace.getThreadNamespace().qualifiedNameToString(id) + ";";
    }

    public String processNamespaces(Namespace namespace) {
        Object s = "";
        Map nss = namespace.getPrefixes();
        String def = namespace.getDefaultNamespace();
        if (def != null) {
            s = (String)s + this.convertDefaultNamespace("<" + def + ">") + this.breakline();
        }
        for (String key : nss.keySet()) {
            String uri = (String)nss.get(key);
            if (key.equals("_") || key.equals("prov") || key.equals("xsd") && "http://www.w3.org/2001/XMLSchema#".equals(uri)) continue;
            s = (String)s + this.convertNamespace(key, "<" + uri + ">") + this.breakline();
        }
        return s;
    }

    public String showprefix(String s) {
        return s;
    }

    public String showuri(String s) {
        return s;
    }

    public void startBundle(QualifiedName bundleId, Namespace namespaces) {
        String s = this.keyword("bundle") + " " + namespaces.qualifiedNameToString(bundleId) + this.breakline();
        s = s + this.processNamespaces(namespaces);
        this.writeln(s);
    }

    public void startDocument(Namespace namespaces) {
        String s = this.keyword("document") + this.breakline();
        s = s + this.processNamespaces(namespaces);
        this.write(s);
    }

    public String symbol(String s) {
        return s;
    }

    public String timeOrMarker(XMLGregorianCalendar time) {
        return time == null ? MARKER : time.toString();
    }

    public void write(String s) {
        try {
            this.buffer.write(s);
        }
        catch (IOException e) {
            throw new UncheckedException("NotationConstructor.write() failed", (Exception)e);
        }
    }

    public void writeln(String s) {
        try {
            this.buffer.write(s);
            if (!this.standaloneExpression) {
                this.buffer.newLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedException("NotationConstructor.write() failed", (Exception)e);
        }
    }

    public QualifiedName newQualifiedName(String namespace, String local, String prefix) {
        return null;
    }

    public QualifiedName newQualifiedName(String namespace, String local, String prefix, ProvUtilities.BuildFlag flag) {
        return null;
    }

    public QualifiedAlternateOf newQualifiedAlternateOf(QualifiedName id, QualifiedName e2, QualifiedName e1, Collection<Attribute> attributes) {
        if (id == null && (attributes == null || attributes.isEmpty())) {
            this.newAlternateOf(e2, e1);
            return null;
        }
        String s = this.keyword("provext:alternateOf") + "(" + this.optionalId(id) + this.idOrMarker(e2) + "," + this.idOrMarker(e1) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public QualifiedSpecializationOf newQualifiedSpecializationOf(QualifiedName id, QualifiedName e2, QualifiedName e1, Collection<Attribute> attributes) {
        if (id == null && (attributes == null || attributes.isEmpty())) {
            this.newSpecializationOf(e2, e1);
            return null;
        }
        String s = this.keyword("provext:specializationOf") + "(" + this.optionalId(id) + this.idOrMarker(e2) + "," + this.idOrMarker(e1) + this.optionalAttributes(attributes) + ")";
        this.writeln(s);
        return null;
    }

    public QualifiedHadMember newQualifiedHadMember(QualifiedName id, QualifiedName c, Collection<QualifiedName> ll, Collection<Attribute> attributes) {
        if (id == null && (attributes == null || attributes.isEmpty())) {
            this.newHadMember(c, ll);
            return null;
        }
        if (ll == null || ll.size() == 0) {
            String s = this.keyword("provext:hadMember") + "(" + this.optionalId(id) + this.idOrMarker(c) + "," + this.idOrMarker(null) + this.optionalAttributes(attributes) + ")";
            this.writeln(s);
        } else {
            for (QualifiedName e : ll) {
                String s = this.keyword("provext:hadMember") + "(" + this.optionalId(id) + this.idOrMarker(c) + "," + this.idOrMarker(e) + this.optionalAttributes(attributes) + ")";
                this.writeln(s);
            }
        }
        return null;
    }
}

