/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.notation;

import java.util.Arrays;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.notation.Utility;
import org.openprovenance.prov.xml.UncheckedTestException;

public class RoundTripFromJavaTest
extends org.openprovenance.prov.xml.RoundTripFromJavaTest {
    final Utility u = new Utility();

    public RoundTripFromJavaTest(String name) {
        super(name);
    }

    public String extension() {
        return ".provn";
    }

    public boolean checkTest(String name) {
        return !name.contains("member2") && !name.contains("member3") && !name.contains("Membership3") && !name.contains("Membership4");
    }

    public Document readDocument(String file1) {
        try {
            return (Document)this.u.convertASNToJavaBean(file1, pFactory);
        }
        catch (Throwable e) {
            throw new UncheckedTestException(e);
        }
    }

    public void writeDocument(Document doc, String file) {
        Namespace.withThreadNamespace((Namespace)doc.getNamespace());
        String s = this.u.convertBeanToASN(doc, pFactory);
        this.u.writeTextToFile(s, file);
    }

    public boolean checkSchema(String name) {
        return false;
    }

    public void NOmakeDocAndTest(Statement[] statements, String file, Statement[] opt, boolean check) {
        Document doc = pFactory.newDocument();
        for (int i = 0; i < statements.length; ++i) {
            doc.getStatementOrBundle().add(statements[i]);
        }
        this.updateNamespaces(doc);
        check = check && this.checkTest(file);
        Object file1 = opt == null ? file : file + "-S";
        file1 = (String)file1 + this.extension();
        String s = this.u.convertBeanToASN(doc, pFactory);
        this.u.writeTextToFile(s, (String)file1);
        try {
            Document doc2 = (Document)this.u.convertASNToJavaBean((String)file1, pFactory);
            this.compareDocuments(doc, doc2, check && this.checkTest((String)file1));
            if (opt != null) {
                doc.getStatementOrBundle().addAll(Arrays.asList(opt));
                String file2 = file + "-M";
                file2 = file2 + this.extension();
                String s2 = this.u.convertBeanToASN(doc, pFactory);
                this.u.writeTextToFile(s2, file2);
                Document doc3 = (Document)this.u.convertASNToJavaBean(file2, pFactory);
                this.compareDocuments(doc, doc3, check && this.checkTest(file2));
            }
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            RoundTripFromJavaTest.assertTrue((boolean)false);
            return;
        }
    }

    public void testEntity101() {
        Entity e = pFactory.newEntity(this.q("101-entity"), "entity101");
        e.getOther().add(pFactory.newOther("http://example.org/", "a01b\\[c", "ex", (Object)pFactory.newQualifiedName("http://example2.org/", "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", "ex2"), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "a01bc", "ex", (Object)pFactory.newQualifiedName("http://example2.org/", "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", "ex2"), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "unicode", "ex", (Object)pFactory.newQualifiedName("http://example2.org/", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u0370\u037d", "ex2"), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u0370\u037d", "ex", (Object)pFactory.newQualifiedName("http://example2.org/", "unicode", "ex2"), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther("http://example.org/", "?a\\=b", "ex", (Object)1, RoundTripFromJavaTest.name.XSD_INT));
        e.getOther().add(pFactory.newOther("http://example.org/", "123", "ex", (Object)"mystring", RoundTripFromJavaTest.name.XSD_STRING));
        e.getOther().add(pFactory.newOther("http://example.org/", "123", "ex", (Object)pFactory.newInternationalizedString("ma chaine", "fr"), RoundTripFromJavaTest.name.PROV_LANG_STRING));
        this.makeDocAndTest((Statement)e, "target/entity101");
        System.out.println("*** test " + pFactory.newQualifiedName("http://example2.org/", "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u0370\u037d", "ex2").getUri());
    }
}

