/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.notation;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.apache.log4j.Logger;
import org.openprovenance.prov.model.BeanTraversal;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.notation.HTMLConstructor;
import org.openprovenance.prov.notation.NotationConstructor;
import org.openprovenance.prov.notation.PROV_NLexer;
import org.openprovenance.prov.notation.PROV_NParser;
import org.openprovenance.prov.notation.TreeTraversal;

public class Utility {
    static Logger logger = Logger.getLogger(Utility.class);
    static final TreeAdaptor adaptor = new CommonTreeAdaptor(){

        public Object create(Token payload) {
            return new CommonTree(payload);
        }
    };

    public static void warn(String s) {
        logger.warn((Object)s);
    }

    public static void warn(Exception e) {
        logger.warn((Object)e.getMessage());
    }

    public PROV_NParser getParserForFile(String file) {
        try {
            ANTLRFileStream input = new ANTLRFileStream(file);
            return this.getParserForCharStream((CharStream)input);
        }
        catch (IOException e) {
            throw new UncheckedException((Exception)e);
        }
    }

    public PROV_NParser getParserForStream(InputStream is) {
        try {
            ANTLRInputStream input = new ANTLRInputStream(is);
            return this.getParserForCharStream((CharStream)input);
        }
        catch (IOException e) {
            throw new UncheckedException((Exception)e);
        }
    }

    public PROV_NParser getParserForCharStream(CharStream input) throws IOException {
        PROV_NLexer lex = new PROV_NLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        ParserWithErrorHandling parser = new ParserWithErrorHandling((TokenStream)tokens);
        return parser;
    }

    public CommonTree convertASNToTree(String file) {
        PROV_NParser parser = this.getParserForFile(file);
        return this.convertASNToTree(parser);
    }

    public CommonTree convertASNToTree(InputStream is) {
        PROV_NParser parser = this.getParserForStream(is);
        return this.convertASNToTree(parser);
    }

    private CommonTree convertASNToTree(PROV_NParser parser) {
        parser.setTreeAdaptor(adaptor);
        PROV_NParser.document_return ret = null;
        try {
            ret = parser.document();
        }
        catch (RecognitionException e) {
            throw new UncheckedException((Exception)((Object)e));
        }
        CommonTree tree = (CommonTree)ret.getTree();
        return tree;
    }

    public Object convertTreeToJavaBean(CommonTree tree, ProvFactory pFactory) {
        if (tree == null) {
            return null;
        }
        Object o = new TreeTraversal((ModelConstructor)pFactory, pFactory).convert((Tree)tree);
        return o;
    }

    public String convertBeanToHTML(Document doc, ProvFactory pFactory) {
        StringWriter writer = new StringWriter();
        HTMLConstructor nc = new HTMLConstructor(writer);
        BeanTraversal bt = new BeanTraversal((ModelConstructor)nc, pFactory);
        bt.doAction(doc);
        nc.flush();
        String s = writer.toString();
        nc.close();
        return s;
    }

    public Object convertASNToJavaBean(String file, ProvFactory pFactory) {
        CommonTree tree = this.convertASNToTree(file);
        Object o = this.convertTreeToJavaBean(tree, pFactory);
        return o;
    }

    public Object convertJavaBeanToJavaBean(Document doc, ProvFactory pFactory) {
        BeanTraversal bt = new BeanTraversal((ModelConstructor)pFactory, pFactory);
        Document o = bt.doAction(doc);
        return o;
    }

    public String convertBeanToASN(Document doc, ProvFactory pFactory) {
        StringWriter writer = new StringWriter();
        NotationConstructor nc = new NotationConstructor(writer);
        BeanTraversal bt = new BeanTraversal((ModelConstructor)nc, pFactory);
        bt.doAction(doc);
        nc.flush();
        String s = writer.toString();
        nc.close();
        return s;
    }

    public void convertBeanToASN(Document doc, Writer writer, ProvFactory pFactory) {
        NotationConstructor nc = new NotationConstructor(writer);
        BeanTraversal bt = new BeanTraversal((ModelConstructor)nc, pFactory);
        bt.doAction(doc);
        nc.flush();
    }

    public void printTree(CommonTree t, int indent) {
        if (t != null) {
            int i;
            StringBuffer sb = new StringBuffer(indent);
            for (i = 0; i < indent; ++i) {
                sb = sb.append("   ");
            }
            for (i = 0; i < t.getChildCount(); ++i) {
                System.out.println(i + sb.toString() + t.getChild(i).toString());
                this.printTree((CommonTree)t.getChild(i), indent + 1);
            }
        }
    }

    public void writeTextToFile(String text, String filename) {
        try {
            this.writeTextToFile(text, new FileWriter(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTextToFile(String text, Writer out) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(out);
            writer.write(text);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void writeDocument(Document doc, String filename, ProvFactory pFactory) {
        String s = this.convertBeanToASN(doc, pFactory);
        this.writeTextToFile(s, filename);
    }

    public void writeDocument(Document doc, OutputStream os, ProvFactory pFactory) {
        OutputStreamWriter writer = new OutputStreamWriter(os);
        this.convertBeanToASN(doc, writer, pFactory);
    }

    public Document readDocument(String filename, ProvFactory pFactory) {
        CommonTree tree = this.convertASNToTree(filename);
        Object doc = this.convertTreeToJavaBean(tree, pFactory);
        return (Document)doc;
    }

    public Document readDocument(InputStream is, ProvFactory pFactory) {
        CommonTree tree = this.convertASNToTree(is);
        Object doc = this.convertTreeToJavaBean(tree, pFactory);
        return (Document)doc;
    }

    class ParserWithErrorHandling
    extends PROV_NParser {
        public List<RecognitionException> errors;

        public void reportError(RecognitionException re) {
            super.reportError(re);
            this.errors.add(re);
        }

        public ParserWithErrorHandling(TokenStream input) {
            super(input);
            this.errors = new LinkedList<RecognitionException>();
        }
    }
}

