/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.notation;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import junit.framework.TestCase;
import org.openprovenance.prov.core.jsonld11.serialization.ProvDeserialiser;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.DocumentEquality;
import org.openprovenance.prov.notation.ProvSerialiser;
import org.openprovenance.prov.notation.Utility;
import org.openprovenance.prov.vanilla.ProvFactory;

public class RoundTripFromProvnTest
extends TestCase {
    final Utility u = new Utility();
    static org.openprovenance.prov.model.ProvFactory pFactory = new ProvFactory();

    public RoundTripFromProvnTest(String name) {
        super(name);
    }

    public void loadFromProvnSaveAndReload(String file, Boolean compare) throws Throwable {
        System.out.println("-------------- File: " + file);
        Utility u2 = new Utility();
        DocumentEquality de = new DocumentEquality(true, null);
        Document doc1 = this.u.readDocument("src/test/resources/" + file, pFactory);
        file = file.replace('/', '_');
        this.u.writeDocument(doc1, "target/" + file, pFactory);
        Document doc2 = this.u.readDocument("target/" + file, pFactory);
        boolean result = de.check(doc1, doc2);
        if (!result && compare.booleanValue()) {
            System.out.println(doc1);
            System.out.println("------------------");
            System.out.println(doc2);
        }
        if (compare.booleanValue()) {
            RoundTripFromProvnTest.assertTrue((boolean)result);
        }
        System.out.println("result is " + result);
        new ProvSerialiser(pFactory).serialiseDocument(Files.newOutputStream(new File("target/" + file + ".jsonld").toPath(), new OpenOption[0]), doc2, true);
        u2.writeDocument(doc2, "target/" + file + ".provn", pFactory);
    }

    public void loadFromProvnSaveToJsonldAndReload(String file, Boolean compare) throws Throwable {
        System.out.println("-------------- File: " + file);
        Utility u2 = new Utility();
        DocumentEquality de = new DocumentEquality(true, null);
        Document doc1 = this.u.readDocument("src/test/resources/" + file, pFactory);
        file = file.replace('/', '_');
        org.openprovenance.prov.core.jsonld11.serialization.ProvSerialiser serial = new org.openprovenance.prov.core.jsonld11.serialization.ProvSerialiser();
        System.out.println("1. xxx");
        serial.serialiseDocument(Files.newOutputStream(new File("target/ld_" + file + ".jsonld").toPath(), new OpenOption[0]), doc1, true);
        ProvDeserialiser deserial = new ProvDeserialiser();
        Document doc2 = deserial.deserialiseDocument(Files.newInputStream(new File("target/ld_" + file + ".jsonld").toPath(), new OpenOption[0]));
        System.out.println("2. xxx");
        boolean result = de.check(doc1, doc2);
        if (!result && compare.booleanValue()) {
            System.out.println(doc1);
            System.out.println("------------------");
            System.out.println(doc2);
        }
        if (compare.booleanValue()) {
            RoundTripFromProvnTest.assertTrue((boolean)result);
        }
        System.out.println("result is " + result);
        System.out.println("3. xxx");
        u2.writeDocument(doc2, "target/" + file + ".provn", pFactory);
    }

    private void testIssue(String issueName) throws Throwable {
        this.loadFromProvnSaveAndReload("issues/" + issueName + ".provn", true);
    }

    private void testCrossIssue(String issueName) throws Throwable {
        this.loadFromProvnSaveToJsonldAndReload("issues/" + issueName + ".provn", true);
    }

    public void testMembership() throws Throwable {
        this.testIssue("unification-membership-f1-FAIL-DM");
        this.testIssue("unification-membership-f2-FAIL-DM");
    }

    public void testBundles() throws Throwable {
        this.testCrossIssue("picaso-file");
    }

    public void testQualifiedName() throws Throwable {
        this.testIssue("issue-qualified-name");
    }

    public void testEscape() throws Throwable {
        this.testIssue("issue-string");
    }
}

