/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.nf.xml;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.nf.xml.Attr;

public interface Statement
extends Comparable<Statement> {
    public void normalize();

    @JsonIgnore
    public StatementOrBundle.Kind getKind();

    public LinkedList<List<String>> paramsAsListsofStrings();

    default public <T extends Comparable<T>> int compareLists(List<T> l1, List<T> l2) {
        int len1 = l1.size();
        int len2 = l2.size();
        int len = Math.min(len1, len2);
        for (int i = 0; i < len; ++i) {
            int comp = ((Comparable)l1.get(i)).compareTo((Comparable)l2.get(i));
            if (comp == 0) continue;
            return comp;
        }
        return new Integer(len2).compareTo(new Integer(len1));
    }

    default public <T extends Comparable<T>> int compareListsOfLists(LinkedList<List<T>> l1, LinkedList<List<T>> l2) {
        List<T> v2;
        List<T> v1;
        int comp;
        do {
            if (l1.isEmpty()) {
                if (l2.isEmpty()) {
                    return 0;
                }
                return -1;
            }
            if (!l2.isEmpty()) continue;
            return 1;
        } while ((comp = this.compareLists(v1 = l1.removeFirst(), v2 = l2.removeFirst())) == 0);
        return comp;
    }

    public List<Attr> getAttr();

    @Override
    default public int compareTo(Statement o) {
        LinkedList l2;
        int comp = this.getKind().compareTo((Enum)o.getKind());
        if (comp != 0) {
            return comp;
        }
        LinkedList l1 = this.paramsAsListsofStrings();
        int comp_l = this.compareListsOfLists(l1, l2 = o.paramsAsListsofStrings());
        if (comp_l != 0) {
            return comp_l;
        }
        return this.compareLists(this.getAttr(), o.getAttr());
    }

    default public <T extends Comparable<T>> void doSort(List<T> l) {
        if (l != null && !l.isEmpty()) {
            System.out.println(l);
            Collections.sort(l);
        }
    }
}

