/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rdf;

import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.QualifiedNameUtils;
import org.openprovenance.prov.rdf.GraphBuilder;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.contextaware.ContextAwareRepository;

public class SesameGraphBuilder
implements GraphBuilder<Resource, LiteralImpl, Statement> {
    final ContextAwareRepository manager;
    private final ProvFactory pFactory;
    final QualifiedNameUtils qnU;
    static int blankCounter = 0;
    private Resource currentContext = null;

    public SesameGraphBuilder(ContextAwareRepository manager, ProvFactory pFactory) {
        this.manager = manager;
        this.pFactory = pFactory;
        this.qnU = new QualifiedNameUtils();
    }

    @Override
    public void assertStatement(Statement stmnt) {
        try {
            if (this.currentContext == null) {
                this.manager.getConnection().add(stmnt, new Resource[0]);
            } else {
                this.manager.getConnection().add(stmnt, new Resource[]{this.currentContext});
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public Statement createDataProperty(Resource r, QualifiedName pred, LiteralImpl literalImpl) {
        return new StatementImpl(r, (URI)this.qualifiedNameToURI(pred), (Value)literalImpl);
    }

    @Override
    public Statement createDataProperty(QualifiedName subject, QualifiedName pred, LiteralImpl literalImpl) {
        return this.createDataProperty(this.qualifiedNameToResource(subject), pred, literalImpl);
    }

    @Override
    public Statement createObjectProperty(Resource r, QualifiedName pred, QualifiedName object) {
        return new StatementImpl(r, (URI)this.qualifiedNameToURI(pred), (Value)this.qualifiedNameToURI(object));
    }

    @Override
    public Statement createObjectProperty(QualifiedName subject, QualifiedName pred, QualifiedName object) {
        return new StatementImpl(this.qualifiedNameToResource(subject), (URI)this.qualifiedNameToURI(pred), (Value)this.qualifiedNameToResource(object));
    }

    @Override
    public URIImpl qualifiedNameToURI(QualifiedName name) {
        String unescapedLocalName = this.qnU.unescapeProvLocalName(name.getLocalPart());
        return new URIImpl(name.getNamespaceURI() + unescapedLocalName);
    }

    @Override
    public Resource qualifiedNameToResource(QualifiedName name) {
        String unescapedLocalName = this.qnU.unescapeProvLocalName(name.getLocalPart());
        if (this.isBlankName(name)) {
            return new BNodeImpl(unescapedLocalName);
        }
        return new URIImpl(name.getNamespaceURI() + unescapedLocalName);
    }

    boolean isBlankName(QualifiedName name) {
        return name.getNamespaceURI().equals("http://openprovenance.org/toolbox/") && name.getPrefix().equals("_");
    }

    @Override
    public QualifiedName newBlankName() {
        return this.newToolboxQualifiedName("blank" + ++blankCounter);
    }

    public QualifiedName newToolboxQualifiedName(String local) {
        return this.pFactory.newQualifiedName("http://openprovenance.org/toolbox/", local, "_");
    }

    @Override
    public void setContext() {
        this.currentContext = null;
    }

    @Override
    public void setContext(Resource uri) {
        this.currentContext = uri;
    }

    @Override
    public LiteralImpl newLiteral(String value, QualifiedName type) {
        return new LiteralImpl(value, (URI)this.qualifiedNameToURI(type));
    }

    @Override
    public LiteralImpl newLiteral(String value, String lang) {
        return new LiteralImpl(value, lang);
    }
}

