/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.openprovenance.prov.model.BeanTraversal;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.rdf.Ontology;
import org.openprovenance.prov.rdf.RdfConstructor;
import org.openprovenance.prov.rdf.RdfConverterException;
import org.openprovenance.prov.rdf.RepositoryHelper;
import org.openprovenance.prov.rdf.SesameGraphBuilder;
import org.openprovenance.prov.rdf.collector.QualifiedCollector;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.contextaware.ContextAwareRepository;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class Utility {
    private final ProvFactory pFactory;
    private final Ontology onto;

    public Utility(ProvFactory pFactory, Ontology onto) {
        this.pFactory = pFactory;
        this.onto = onto;
    }

    public Document parseRDF(String filename) throws RDFParseException, RDFHandlerException, IOException, JAXBException {
        File file = new File(filename);
        URL documentURL = file.toURI().toURL();
        InputStream inputStream = documentURL.openStream();
        RDFParser rdfParser = Rio.createParser((RDFFormat)Rio.getParserFormatForFileName((String)file.getName()));
        String streamName = documentURL.toString();
        return this.parseRDF(inputStream, rdfParser, streamName);
    }

    public Document parseRDF(InputStream inputStream, RDFFormat format, String baseuri) throws RDFParseException, RDFHandlerException, IOException {
        RDFParser rdfParser = Rio.createParser((RDFFormat)format);
        return this.parseRDF(inputStream, rdfParser, baseuri);
    }

    public Document parseRDF(InputStream inputStream, RDFParser rdfParser, String baseuri) throws IOException, RDFParseException, RDFHandlerException {
        QualifiedCollector rdfCollector = new QualifiedCollector(this.pFactory, this.onto);
        rdfParser.setRDFHandler((RDFHandler)rdfCollector);
        rdfParser.parse(inputStream, baseuri);
        Document doc = rdfCollector.getDocument();
        Namespace ns = doc.getNamespace();
        return doc;
    }

    public void dumpRDF(Document document, RDFFormat format, String filename) {
        this.dumpRDFInternal(document, format, filename);
    }

    public void dumpRDF(Document document, RDFFormat format, OutputStream os) {
        this.dumpRDFInternal(document, format, os);
    }

    private void dumpRDFInternal(Document document, RDFFormat format, Object out) {
        SailRepository myRepository = new SailRepository((Sail)new MemoryStore());
        try {
            myRepository.initialize();
        }
        catch (RepositoryException e) {
            throw new RdfConverterException("failed to initialize repository", e);
        }
        ContextAwareRepository rep = new ContextAwareRepository((Repository)myRepository);
        RepositoryHelper rHelper = new RepositoryHelper();
        RdfConstructor<Resource, LiteralImpl, Statement> rdfc = new RdfConstructor<Resource, LiteralImpl, Statement>(new SesameGraphBuilder(rep, this.pFactory), this.pFactory);
        Namespace ns = new Namespace(document.getNamespace());
        ns.register("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        ns.register("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        rdfc.setNamespace(ns);
        Namespace.withThreadNamespace((Namespace)document.getNamespace());
        BeanTraversal bt = new BeanTraversal(rdfc, this.pFactory);
        bt.doAction(document);
        if (out instanceof String) {
            rHelper.dumpToRDF((String)out, rep, format, rdfc.getNamespace());
        } else {
            rHelper.dumpToRDF(new OutputStreamWriter((OutputStream)out), rep, format, rdfc.getNamespace());
        }
    }
}

