/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.rdf.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.rdf.Ontology;
import org.openprovenance.prov.rdf.collector.RdfCollector;
import org.openprovenance.prov.rdf.collector.Types;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;

public class QualifiedCollector
extends RdfCollector {
    public QualifiedCollector(ProvFactory pFactory, Ontology onto) {
        super(pFactory, onto);
    }

    private ArrayList<List<?>> permute(List<?> ... lists) {
        ArrayList output = new ArrayList();
        if (lists.length == 0) {
            output.add(new ArrayList());
            return output;
        }
        for (List<?> list : lists) {
            if (list.size() != 0) continue;
            list.add(null);
        }
        List<?> first = lists[0];
        List<?>[] rest = Arrays.copyOfRange(lists, 1, lists.length);
        for (Object x : first) {
            ArrayList<List<?>> permuted = this.permute(rest);
            for (List<?> tocombine : permuted) {
                ArrayList l = new ArrayList();
                l.add(x);
                l.addAll(tocombine);
                output.add(l);
            }
        }
        return output;
    }

    private List<QualifiedName> getSubjects(QualifiedName context, QualifiedName pred, QualifiedName object) {
        HashMap resources = (HashMap)this.collators.get(context);
        ArrayList<QualifiedName> subjects = new ArrayList<QualifiedName>();
        for (QualifiedName subject : resources.keySet()) {
            List statements = (List)resources.get(subject);
            for (Statement statement : statements) {
                QualifiedName valQ;
                QualifiedName predQ = this.convertURIToQualifiedName((URI)statement.getPredicate());
                Value value = statement.getObject();
                if (!pred.equals((Object)predQ) || !(value instanceof Resource) || !(valQ = this.convertResourceToQualifiedName((Resource)value)).equals((Object)object)) continue;
                subjects.add(subject);
            }
        }
        return subjects;
    }

    @Override
    protected void buildGraph() {
        super.buildGraph();
        for (QualifiedName contextQ : this.collators.keySet()) {
            HashMap collator = (HashMap)this.collators.get(contextQ);
            for (QualifiedName qualifiedName : collator.keySet()) {
                Types.ProvType[] types;
                block20: for (Types.ProvType type : types = this.getExplicitTypes(contextQ, qualifiedName)) {
                    switch (type) {
                        case GENERATION: {
                            this.createGeneration(contextQ, qualifiedName);
                            continue block20;
                        }
                        case USAGE: {
                            this.createUsage(contextQ, qualifiedName);
                            continue block20;
                        }
                        case ASSOCIATION: {
                            this.createAssociation(contextQ, qualifiedName);
                            continue block20;
                        }
                        case ATTRIBUTION: {
                            this.createAttribution(contextQ, qualifiedName);
                            continue block20;
                        }
                        case COMMUNICATION: {
                            this.createCommunication(contextQ, qualifiedName);
                            continue block20;
                        }
                        case DELEGATION: {
                            this.createDelegation(contextQ, qualifiedName);
                            continue block20;
                        }
                        case DERIVATION: {
                            this.createDerivation(contextQ, qualifiedName, this.onto.QualifiedName_PROVO_qualifiedDerivation);
                            continue block20;
                        }
                        case PRIMARYSOURCE: {
                            this.createPrimarySource(contextQ, qualifiedName);
                            continue block20;
                        }
                        case QUOTATION: {
                            this.createQuotation(contextQ, qualifiedName);
                            continue block20;
                        }
                        case REVISION: {
                            this.createRevision(contextQ, qualifiedName);
                            continue block20;
                        }
                        case END: {
                            this.createEnd(contextQ, qualifiedName);
                            continue block20;
                        }
                        case INVALIDATION: {
                            this.createInvalidation(contextQ, qualifiedName);
                            continue block20;
                        }
                        case START: {
                            this.createStart(contextQ, qualifiedName);
                            continue block20;
                        }
                        case INFLUENCE: {
                            this.createInfluence(contextQ, qualifiedName);
                            continue block20;
                        }
                        case INSERTION: {
                            this.createInsertion(contextQ, qualifiedName);
                            continue block20;
                        }
                        case REMOVAL: {
                            this.createRemoval(contextQ, qualifiedName);
                            continue block20;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void endRDF() {
        super.endRDF();
        this.nullifyBNodes();
    }

    private void nullifyBNodes() {
        for (StatementOrBundle sob : this.document.getStatementOrBundle()) {
            Identifiable idsob;
            if (!(sob instanceof Identifiable) || (idsob = (Identifiable)sob).getId() == null || !idsob.getId().getNamespaceURI().equals(BNODE_NS) || this.isBNodeReferenced((BNode)new BNodeImpl(idsob.getId().getLocalPart()))) continue;
            idsob.setId(null);
        }
    }

    private List<XMLGregorianCalendar> getInstantaneousTimes(List<Statement> statements) {
        ArrayList<XMLGregorianCalendar> times = new ArrayList<XMLGregorianCalendar>();
        for (Statement statement : statements) {
            QualifiedName predQ = this.convertURIToQualifiedName((URI)statement.getPredicate());
            Value value = statement.getObject();
            if (!(value instanceof Literal) || !predQ.equals((Object)this.onto.QualifiedName_PROVO_atTime)) continue;
            times.add((XMLGregorianCalendar)super.decodeLiteral((Literal)value));
        }
        return times;
    }

    private void createRevision(QualifiedName contextQ, QualifiedName qualifiedName) {
        List<WasDerivedFrom> wdfs = this.createDerivation(contextQ, qualifiedName, this.onto.QualifiedName_PROVO_qualifiedRevision);
        QualifiedName q = this.onto.QualifiedName_PROVO_Revision;
        Type type = this.pFactory.newType((Object)q, this.name.PROV_QUALIFIED_NAME);
        for (WasDerivedFrom wdf : wdfs) {
            if (wdf.getType().contains(type)) continue;
            wdf.getType().add(type);
        }
    }

    private void createQuotation(QualifiedName contextQ, QualifiedName qualifiedName) {
        List<WasDerivedFrom> wdfs = this.createDerivation(contextQ, qualifiedName, this.onto.QualifiedName_PROVO_qualifiedQuotation);
        QualifiedName q = this.onto.QualifiedName_PROVO_Quotation;
        Type type = this.pFactory.newType((Object)q, this.name.PROV_QUALIFIED_NAME);
        for (WasDerivedFrom wdf : wdfs) {
            if (wdf.getType().contains(type)) continue;
            wdf.getType().add(type);
        }
    }

    private void createPrimarySource(QualifiedName context, QualifiedName qualifiedName) {
        List<WasDerivedFrom> wdfs = this.createDerivation(context, qualifiedName, this.onto.QualifiedName_PROVO_qualifiedPrimarySource);
        QualifiedName q = this.onto.QualifiedName_PROVO_PrimarySource;
        Type type = this.pFactory.newType((Object)q, this.name.PROV_QUALIFIED_NAME);
        for (WasDerivedFrom wdf : wdfs) {
            if (wdf.getType().contains(type)) continue;
            wdf.getType().add(type);
        }
    }

    private List<WasDerivedFrom> createDerivation(QualifiedName context, QualifiedName qualifiedName, QualifiedName pred) {
        List<QualifiedName> entities = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_entity);
        List<QualifiedName> activities = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_hadActivity);
        List<QualifiedName> generations = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_hadGeneration);
        List<QualifiedName> usages = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_hadUsage);
        List<QualifiedName> generated = this.getSubjects(context, pred, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.DERIVATION);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<WasDerivedFrom> wdfs = new ArrayList<WasDerivedFrom>();
        ArrayList<List<?>> perms = this.permute(generated, entities, activities, generations, usages);
        for (List list : perms) {
            WasDerivedFrom wdf = this.pFactory.newWasDerivedFrom(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), (QualifiedName)list.get(3), (QualifiedName)list.get(4), attributes);
            this.store(context, (Relation)wdf);
            wdfs.add(wdf);
        }
        return wdfs;
    }

    private List<WasInfluencedBy> createInfluence(QualifiedName context, QualifiedName qualifiedName) {
        HashSet<QualifiedName> all_influencers = new HashSet<QualifiedName>();
        List<QualifiedName> influencers = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_influencer);
        List<QualifiedName> agents = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_agent);
        List<QualifiedName> entities = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_entity);
        List<QualifiedName> activities = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_activity);
        all_influencers.addAll(influencers);
        all_influencers.addAll(agents);
        all_influencers.addAll(entities);
        all_influencers.addAll(activities);
        List<QualifiedName> influencees = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedInfluence, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.INFLUENCE);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<WasInfluencedBy> wibs = new ArrayList<WasInfluencedBy>();
        ArrayList<List<?>> perms = this.permute(influencees, new ArrayList(all_influencers));
        for (List list : perms) {
            WasInfluencedBy wib = this.pFactory.newWasInfluencedBy(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), attributes);
            this.store(context, (Relation)wib);
            wibs.add(wib);
        }
        return wibs;
    }

    private void createEnd(QualifiedName context, QualifiedName qualifiedName) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qualifiedName);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> triggers = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_entity);
        List<QualifiedName> enders = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_hadActivity);
        List<QualifiedName> activities = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedEnd, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.END);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(activities, triggers, enders, times);
        for (List list : perms) {
            WasEndedBy web = this.pFactory.newWasEndedBy(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), (XMLGregorianCalendar)list.get(3), attributes);
            this.store(context, (Relation)web);
        }
    }

    private void createInsertion(QualifiedName context, QualifiedName qualifiedName) {
        List<QualifiedName> objectDictionaries = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_dictionary);
        List<QualifiedName> pairs = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_insertedKeyEntityPair);
        List<QualifiedName> subjectDictionaries = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedInsertion, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.INSERTION);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(subjectDictionaries, objectDictionaries);
        for (List list : perms) {
            DerivedByInsertionFrom dbif = this.pFactory.newDerivedByInsertionFrom(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), this.createKeyEntityPairs(context, pairs), attributes);
            this.store(context, (Relation)dbif);
        }
    }

    private void createRemoval(QualifiedName context, QualifiedName qualifiedName) {
        List<QualifiedName> objectDictionaries = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_dictionary);
        List<Value> keys = this.getDataObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_removedKey);
        List<QualifiedName> subjectDictionaries = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedRemoval, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.REMOVAL);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        LinkedList<Key> theKeys = new LinkedList<Key>();
        for (Value key : keys) {
            theKeys.add(this.valueToKey(key));
        }
        ArrayList<List<?>> perms = this.permute(subjectDictionaries, objectDictionaries);
        for (List list : perms) {
            DerivedByRemovalFrom dbif = this.pFactory.newDerivedByRemovalFrom(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), theKeys, attributes);
            this.store(context, (Relation)dbif);
        }
    }

    private void createStart(QualifiedName context, QualifiedName qualifiedName) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qualifiedName);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> triggers = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_entity);
        List<QualifiedName> starters = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_hadActivity);
        List<QualifiedName> activities = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedStart, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.START);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(activities, triggers, starters, times);
        for (List list : perms) {
            WasStartedBy wsb = this.pFactory.newWasStartedBy(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), (XMLGregorianCalendar)list.get(3), attributes);
            this.store(context, (Relation)wsb);
        }
    }

    private void createInvalidation(QualifiedName context, QualifiedName qualifiedName) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qualifiedName);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> activities = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_activity);
        List<QualifiedName> entities = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedInvalidation, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.INVALIDATION);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(entities, activities, times);
        for (List list : perms) {
            WasInvalidatedBy wib = this.pFactory.newWasInvalidatedBy(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (XMLGregorianCalendar)list.get(2), attributes);
            this.store(context, (Relation)wib);
        }
    }

    private void createDelegation(QualifiedName context, QualifiedName qualifiedName) {
        List<QualifiedName> activities = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_hadActivity);
        List<QualifiedName> agents = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_agent);
        List<QualifiedName> subordinates = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedDelegation, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.DELEGATION);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(subordinates, agents, activities);
        for (List list : perms) {
            ActedOnBehalfOf aobo = this.pFactory.newActedOnBehalfOf(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), attributes);
            this.store(context, (Relation)aobo);
        }
    }

    private void createCommunication(QualifiedName context, QualifiedName qualifiedName) {
        List<QualifiedName> activities = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_activity);
        List<QualifiedName> effects = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedCommunication, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.COMMUNICATION);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(effects, activities);
        for (List list : perms) {
            WasInformedBy wib = this.pFactory.newWasInformedBy(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), attributes);
            this.store(context, (Relation)wib);
        }
    }

    private void createAttribution(QualifiedName context, QualifiedName qualifiedName) {
        List<QualifiedName> agents = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_agent);
        List<QualifiedName> entities = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedAttribution, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.ATTRIBUTION);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(entities, agents);
        for (List list : perms) {
            WasAttributedTo wat = this.pFactory.newWasAttributedTo(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), attributes);
            this.store(context, (Relation)wat);
        }
    }

    private void createAssociation(QualifiedName context, QualifiedName qualifiedName) {
        List<QualifiedName> plans = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_hadPlan);
        List<QualifiedName> agents = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_agent);
        List<QualifiedName> activities = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedAssociation, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.ASSOCIATION);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(activities, agents, plans);
        for (List list : perms) {
            WasAssociatedWith waw = this.pFactory.newWasAssociatedWith(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (QualifiedName)list.get(2), attributes);
            this.store(context, (Relation)waw);
        }
    }

    private void createUsage(QualifiedName context, QualifiedName qualifiedName) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qualifiedName);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> entities = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_entity);
        List<QualifiedName> activities = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedUsage, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.USAGE);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(activities, entities, times);
        for (List list : perms) {
            Used used = this.pFactory.newUsed(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (XMLGregorianCalendar)list.get(2), attributes);
            this.store(context, (Relation)used);
        }
    }

    private QualifiedName getQualqualifiedName(QualifiedName qualifiedName) {
        if (qualifiedName.getNamespaceURI() == "" || qualifiedName.getNamespaceURI() == null || qualifiedName.getNamespaceURI().equals(BNODE_NS)) {
            BNodeImpl bnode = new BNodeImpl(qualifiedName.getLocalPart());
            if (!this.isBNodeReferenced((BNode)bnode)) {
                return null;
            }
            return this.pFactory.newQualifiedName(BNODE_NS, qualifiedName.getLocalPart(), "bnode");
        }
        return qualifiedName;
    }

    private void createGeneration(QualifiedName context, QualifiedName qualifiedName) {
        List statements = (List)((HashMap)this.collators.get(context)).get(qualifiedName);
        List<XMLGregorianCalendar> times = this.getInstantaneousTimes(statements);
        List<QualifiedName> activities = this.getObjects(context, qualifiedName, this.onto.QualifiedName_PROVO_activity);
        List<QualifiedName> entities = this.getSubjects(context, this.onto.QualifiedName_PROVO_qualifiedGeneration, qualifiedName);
        List<Attribute> attributes = this.collectAttributes(context, qualifiedName, Types.ProvType.GENERATION);
        qualifiedName = this.getQualqualifiedName(qualifiedName);
        ArrayList<List<?>> perms = this.permute(entities, activities, times);
        for (List list : perms) {
            WasGeneratedBy wgb = this.pFactory.newWasGeneratedBy(qualifiedName, (QualifiedName)list.get(0), (QualifiedName)list.get(1), (XMLGregorianCalendar)list.get(2), attributes);
            this.store(context, (Relation)wgb);
        }
    }
}

