/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.scala.viz;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.scala.immutable.Attribute;
import org.openprovenance.prov.scala.immutable.Bundle;
import org.openprovenance.prov.scala.immutable.Document;
import org.openprovenance.prov.scala.immutable.HasLabel;
import org.openprovenance.prov.scala.immutable.HasOther;
import org.openprovenance.prov.scala.immutable.HasTime;
import org.openprovenance.prov.scala.immutable.Indexing;
import org.openprovenance.prov.scala.immutable.Kind$;
import org.openprovenance.prov.scala.immutable.LangString;
import org.openprovenance.prov.scala.immutable.NS$;
import org.openprovenance.prov.scala.immutable.OrderedDocument;
import org.openprovenance.prov.scala.immutable.Other;
import org.openprovenance.prov.scala.immutable.QualifiedName;
import org.openprovenance.prov.scala.immutable.Relation;
import org.openprovenance.prov.scala.immutable.SizeRange;
import org.openprovenance.prov.scala.immutable.Statement;
import org.openprovenance.prov.scala.viz.Edge;
import org.openprovenance.prov.scala.viz.GraphElement;
import org.openprovenance.prov.scala.viz.SubGraph;
import org.openprovenance.prov.scala.viz.Vertex;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Graphics$ {
    public static Graphics$ MODULE$;
    private final String shape;
    private final String side;
    private final String color;
    private final String fillcolor;
    private final String fontcolor;
    private final String style;
    private final String filled;
    private final String polygon;
    private final String house;
    private final String ellipse;
    private final String url;
    private final String penwidth;
    private final String width;
    private final String label;
    private final String tooltip;
    private final String arrowhead;
    private final String none;
    private final String point;
    private final String entityFillColor;
    private final String entityColor;
    private final String entityFontColor;
    private final String agentFillColor;
    private final String agentColor;
    private final String agentFontColor;
    private final String activityFillColor;
    private final String activityColor;
    private final String activityFontColor;
    private final String edgeColor;
    private final String DOT_NS;
    private final QualifiedName colorQN;
    private final QualifiedName fillcolorQN;
    private final QualifiedName fontcolorQN;
    private final QualifiedName tooltipQN;
    private final Set<QualifiedName> graphicsQNs;
    private final ProvUtilities pu;
    private boolean useIdAsLabel;
    private int bncounter;
    private final double nodeMaxWidth;
    private final double edgeMaxWidth;

    static {
        new Graphics$();
    }

    public String shape() {
        return this.shape;
    }

    public String side() {
        return this.side;
    }

    public String color() {
        return this.color;
    }

    public String fillcolor() {
        return this.fillcolor;
    }

    public String fontcolor() {
        return this.fontcolor;
    }

    public String style() {
        return this.style;
    }

    public String filled() {
        return this.filled;
    }

    public String polygon() {
        return this.polygon;
    }

    public String house() {
        return this.house;
    }

    public String ellipse() {
        return this.ellipse;
    }

    public String url() {
        return this.url;
    }

    public String penwidth() {
        return this.penwidth;
    }

    public String width() {
        return this.width;
    }

    public String label() {
        return this.label;
    }

    public String tooltip() {
        return this.tooltip;
    }

    public String arrowhead() {
        return this.arrowhead;
    }

    public String none() {
        return this.none;
    }

    public String point() {
        return this.point;
    }

    public String entityFillColor() {
        return this.entityFillColor;
    }

    public String entityColor() {
        return this.entityColor;
    }

    public String entityFontColor() {
        return this.entityFontColor;
    }

    public String agentFillColor() {
        return this.agentFillColor;
    }

    public String agentColor() {
        return this.agentColor;
    }

    public String agentFontColor() {
        return this.agentFontColor;
    }

    public String activityFillColor() {
        return this.activityFillColor;
    }

    public String activityColor() {
        return this.activityColor;
    }

    public String activityFontColor() {
        return this.activityFontColor;
    }

    public String edgeColor() {
        return this.edgeColor;
    }

    public String DOT_NS() {
        return this.DOT_NS;
    }

    public QualifiedName colorQN() {
        return this.colorQN;
    }

    public QualifiedName fillcolorQN() {
        return this.fillcolorQN;
    }

    public QualifiedName fontcolorQN() {
        return this.fontcolorQN;
    }

    public QualifiedName tooltipQN() {
        return this.tooltipQN;
    }

    public Set<QualifiedName> graphicsQNs() {
        return this.graphicsQNs;
    }

    public ProvUtilities pu() {
        return this.pu;
    }

    public Set<GraphElement> toElements(Statement s, Function1<QualifiedName, String> idmap, SizeRange r) {
        Enumeration.Value value = s.enumType();
        Enumeration.Value value2 = Kind$.MODULE$.ent();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Vertex((String)idmap.apply((Object)s.id()), this.addLabel(s, this.addWidth(s, r, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.url()), (Object)s.id().getUri()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.shape()), (Object)this.ellipse()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.color()), (Object)this.colorOf(s, this.entityColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fontcolor()), (Object)this.fontcolorOf(s, this.entityFontColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fillcolor()), (Object)this.fillcolorOf(s, this.entityFillColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.style()), (Object)this.filled())}))))))}));
        }
        Enumeration.Value value4 = Kind$.MODULE$.ag();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Vertex((String)idmap.apply((Object)s.id()), this.addLabel(s, this.addWidth(s, r, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.url()), (Object)s.id().getUri()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.shape()), (Object)this.house()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.color()), (Object)this.colorOf(s, this.agentColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fontcolor()), (Object)this.fontcolorOf(s, this.agentFontColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fillcolor()), (Object)this.fillcolorOf(s, this.agentFillColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.style()), (Object)this.filled())}))))))}));
        }
        Enumeration.Value value6 = Kind$.MODULE$.act();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Vertex((String)idmap.apply((Object)s.id()), this.addLabel(s, this.addWidth(s, r, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.url()), (Object)s.id().getUri()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.shape()), (Object)this.polygon()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.color()), (Object)this.colorOf(s, this.activityColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fontcolor()), (Object)this.fontcolorOf(s, this.activityFontColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fillcolor()), (Object)this.fillcolorOf(s, this.activityFillColor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.style()), (Object)this.filled()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.side()), (Object)"4")}))))))}));
        }
        return this.toElements((Relation)s, idmap, r);
    }

    public String colorOf(Statement s, String col) {
        return this.colorOf(s, col, this.colorQN());
    }

    public String fillcolorOf(Statement s, String col) {
        return this.colorOf(s, col, this.fillcolorQN());
    }

    public String fontcolorOf(Statement s, String col) {
        return this.colorOf(s, col, this.fontcolorQN());
    }

    public String colorOf(Statement s, String col, QualifiedName colorQN) {
        Statement statement = s;
        if (statement instanceof HasOther) {
            Statement statement2 = statement;
            Option option = ((HasOther)statement2).other().get((Object)colorQN);
            if (option instanceof Some) {
                Some some = (Some)option;
                Set set = (Set)some.value();
                return ((Other)set.head()).value().toString();
            }
            if (None$.MODULE$.equals(option)) {
                return col;
            }
            throw new MatchError((Object)option);
        }
        return col;
    }

    public Set<GraphElement> toElements(Bundle s2, Function1<QualifiedName, String> idmap, SizeRange r) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new SubGraph((String)idmap.apply((Object)s2.id()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)s2.id().localPart()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.url()), (Object)s2.id().getUri())}))), (Iterable<GraphElement>)((Iterable)s2.statement().flatMap((Function1 & Serializable & scala.Serializable)s -> MODULE$.toElements((Statement)s, idmap, r), Iterable$.MODULE$.canBuildFrom())))}));
    }

    public Option<Object> getSize(Statement s) {
        Option option = ((HasOther)s).other().get((Object)NS$.MODULE$.QN_SIZE());
        if (option instanceof Some) {
            Some some = (Some)option;
            Set set = (Set)some.value();
            Option option2 = set.headOption();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Other s2 = (Other)some2.value();
                return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s2.value().toString())).toInt()));
            }
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option2);
        }
        return None$.MODULE$;
    }

    public Map<String, String> addPenWidth(Relation s, SizeRange r, Map<String, String> m) {
        Option<Object> sizeAttributes = this.getSize((Statement)s);
        Option<Object> option = sizeAttributes;
        if (option instanceof Some) {
            Some some = (Some)option;
            int size = BoxesRunTime.unboxToInt((Object)some.value());
            return m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.penwidth()), (Object)Double.toString(this.edgeVisualSizeAttribute(size, r.edgeMin(), r.edgeMax()))));
        }
        if (None$.MODULE$.equals(option)) {
            return m;
        }
        throw new MatchError(option);
    }

    public Map<String, String> addWidth(Statement s, SizeRange r, Map<String, String> m) {
        Option<Object> sizeAttributes = this.getSize(s);
        Option<Object> option = sizeAttributes;
        if (option instanceof Some) {
            Some some = (Some)option;
            int size = BoxesRunTime.unboxToInt((Object)some.value());
            return m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.width()), (Object)Double.toString(this.nodeVisualSizeAttribute(size, r.nodeMin(), r.nodeMax()))));
        }
        if (None$.MODULE$.equals(option)) {
            return m;
        }
        throw new MatchError(option);
    }

    public boolean useIdAsLabel() {
        return this.useIdAsLabel;
    }

    public void useIdAsLabel_$eq(boolean x$1) {
        this.useIdAsLabel = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> addLabel(Statement s, Map<String, String> m) {
        Map map;
        Statement statement = s;
        if (statement instanceof HasLabel) {
            Statement statement2 = statement;
            Option labelOpt = ((HasLabel)statement2).label().headOption();
            Option option = labelOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                LangString str = (LangString)some.value();
                map = m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)str.value()));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                map = this.useIdAsLabel() ? m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)statement2.getId().getLocalPart())) : m;
            }
        } else {
            map = statement.getId() != null ? (this.useIdAsLabel() ? m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)s.getId().getLocalPart())) : m) : m;
        }
        Map res = map;
        return res.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tooltip()), (Object)s.id().localPart()));
    }

    public int bncounter() {
        return this.bncounter;
    }

    public void bncounter_$eq(int x$1) {
        this.bncounter = x$1;
    }

    public Set<Attribute> usefulAttributes(Set<Attribute> attrs) {
        return (Set)attrs.filterNot((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)Graphics$.$anonfun$usefulAttributes$1(attr)));
    }

    public Set<GraphElement> toElements(Relation s, Function1<QualifiedName, String> idmap, SizeRange r) {
        Map mapi = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.color()), (Object)this.colorOf((Statement)s, this.edgeColor()))}));
        org.openprovenance.prov.model.Relation cast = (org.openprovenance.prov.model.Relation)s;
        List causes = this.pu().getOtherCauses(cast);
        None$ time = s instanceof HasTime ? ((HasTime)s).time() : None$.MODULE$;
        Set attrs = s.getAttributes();
        if (causes != null || attrs != null && !this.usefulAttributes((Set<Attribute>)attrs).isEmpty() || !time.equals((Object)None$.MODULE$)) {
            this.bncounter_$eq(this.bncounter() + 1);
            String bnid = new StringBuilder(2).append("bn").append(Integer.toString(this.bncounter())).toString();
            Set aset = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Vertex(bnid, (Map<String, String>)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.label()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.shape()), (Object)this.point())}))).$plus$plus((GenTraversableOnce)mapi)), new Edge(null, (String)idmap.apply((Object)s.getEffect()), bnid, this.addPenWidth(s, r, (Map<String, String>)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.arrowhead()), (Object)this.none())}))).$plus$plus((GenTraversableOnce)mapi)))}));
            Set aset2 = s.getCause() != null ? (Set)aset.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge(null, bnid, (String)idmap.apply((Object)s.getCause()), this.addPenWidth(s, r, (Map<String, String>)mapi))}))) : aset;
            Set aset3 = causes != null ? (Set)aset2.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge(null, bnid, (String)idmap.apply((Object)((QualifiedName)causes.get(0))), this.addPenWidth(s, r, (Map<String, String>)mapi))}))) : aset2;
            return aset3;
        }
        if (s.getEffect() != null && s.getCause() != null) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GraphElement[]{new Edge(null, (String)idmap.apply((Object)s.getEffect()), (String)idmap.apply((Object)s.getCause()), this.addPenWidth(s, r, (Map<String, String>)mapi))}));
        }
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public Set<GraphElement> toElements(Document doc, Function1<QualifiedName, String> idmap, SizeRange r) {
        return (Set)((TraversableOnce)doc.statements().flatMap((Function1 & Serializable & scala.Serializable)s -> MODULE$.toElements((Statement)s, idmap, r), Iterable$.MODULE$.canBuildFrom())).toSet().$plus$plus((GenTraversableOnce)doc.bundles().flatMap((Function1 & Serializable & scala.Serializable)s -> MODULE$.toElements((Bundle)s, idmap, r), Iterable$.MODULE$.canBuildFrom()));
    }

    public Seq<GraphElement> toElements(OrderedDocument doc, Function1<QualifiedName, String> idmap, SizeRange r) {
        return (Seq)((TraversableLike)doc.orderedStatements().flatMap((Function1 & Serializable & scala.Serializable)s -> MODULE$.toElements((Statement)s, idmap, r), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)doc.orderedBundles().flatMap((Function1 & Serializable & scala.Serializable)s -> MODULE$.toElements((Bundle)s, idmap, r), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public void toDot(Document doc, Function1<QualifiedName, String> idmap, SizeRange r, Writer outw) {
        outw.write("digraph \"PROV\" { size=\"16,12\"; rankdir=\"BT\";\n");
        this.toElements(doc, idmap, r).foreach((Function1 & Serializable & scala.Serializable)e -> {
            e.toDot(outw);
            return BoxedUnit.UNIT;
        });
        outw.write("}\n");
        outw.close();
    }

    public void toDot(OrderedDocument doc, Function1<QualifiedName, String> idmap, SizeRange r, Writer outw) {
        outw.write("digraph \"PROV\" { size=\"16,12\"; rankdir=\"BT\";\n");
        this.toElements(doc, idmap, r).foreach((Function1 & Serializable & scala.Serializable)e -> {
            e.toDot(outw);
            return BoxedUnit.UNIT;
        });
        outw.write("}\n");
        outw.close();
    }

    public void toDot(Document doc, Function1<QualifiedName, String> idmap, SizeRange r, File outw) {
        Document document = doc;
        if (document instanceof OrderedDocument) {
            OrderedDocument orderedDocument = (OrderedDocument)document;
            this.toDot(orderedDocument, idmap, r, (Writer)new FileWriter(outw));
            return;
        }
        this.toDot(doc, idmap, r, (Writer)new FileWriter(outw));
    }

    public void toDot(Indexing ind, File outw) {
        this.toDot(ind.document(), ind.idPrinter(), ind.sizeRange(), outw);
    }

    public void dotConvert(String dot, String svg, String t) {
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec(new StringBuilder(11).append("dot -o ").append(svg).append(" -T").append(t).append(" ").append(dot).toString());
    }

    public void dotConvert(String dot, OutputStream os, String t) {
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec(new StringBuilder(7).append("dot -T").append(t).append(" ").append(dot).toString());
        InputStream in = proc.getInputStream();
        IOUtils.copy((InputStream)in, (OutputStream)os);
    }

    public double nodeMaxWidth() {
        return this.nodeMaxWidth;
    }

    public double edgeMaxWidth() {
        return this.edgeMaxWidth;
    }

    public double edgeVisualSizeAttribute(int size, int min, int max) {
        if (min == max) {
            return 1.0;
        }
        return 1.0 + this.edgeMaxWidth() * (double)(size - min) / (double)(max - min);
    }

    public double nodeVisualSizeAttribute(int size, int min, int max) {
        if (min == max) {
            return 1.0;
        }
        return 1.0 + this.nodeMaxWidth() * (double)(size - min) / (double)(max - min);
    }

    public static final /* synthetic */ boolean $anonfun$usefulAttributes$1(Attribute attr) {
        String ns;
        return attr instanceof Other && ((ns = ((Other)attr).elementName().namespaceURI()).equals(MODULE$.DOT_NS()) || ns.equals(NS$.MODULE$.SUM_NS()));
    }

    private Graphics$() {
        MODULE$ = this;
        this.shape = "shape";
        this.side = "side";
        this.color = "color";
        this.fillcolor = "fillcolor";
        this.fontcolor = "fontcolor";
        this.style = "style";
        this.filled = "filled";
        this.polygon = "polygon";
        this.house = "house";
        this.ellipse = "ellipse";
        this.url = "URL";
        this.penwidth = "penwidth";
        this.width = "width";
        this.label = "label";
        this.tooltip = "tooltip";
        this.arrowhead = "arrowhead";
        this.none = "none";
        this.point = "point";
        this.entityFillColor = "#FFFC87";
        this.entityColor = "#808080";
        this.entityFontColor = "#808080";
        this.agentFillColor = "#FDB266";
        this.agentColor = "#000000";
        this.agentFontColor = "#000000";
        this.activityFillColor = "#9FB1FC";
        this.activityColor = "#0000FF";
        this.activityFontColor = "#0000FF";
        this.edgeColor = "#000000";
        this.DOT_NS = "http://openprovenance.org/Toolbox/dot#";
        this.colorQN = new QualifiedName("dot", "color", this.DOT_NS());
        this.fillcolorQN = new QualifiedName("dot", "fillcolor", this.DOT_NS());
        this.fontcolorQN = new QualifiedName("dot", "fontcolor", this.DOT_NS());
        this.tooltipQN = new QualifiedName("dot", "tooltip", this.DOT_NS());
        this.graphicsQNs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QualifiedName[]{this.colorQN(), this.fillcolorQN(), this.fontcolorQN(), this.tooltipQN()}));
        this.pu = new ProvUtilities();
        this.useIdAsLabel = true;
        this.bncounter = 0;
        this.nodeMaxWidth = 4.0;
        this.edgeMaxWidth = 9.0;
    }
}

