/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.template.Bindings;

public class BindingsJson {
    public static Object convertValueToBean(Object o, QualifiedName type, Hashtable<String, String> context) {
        if (o instanceof Integer) {
            return o;
        }
        if (o instanceof Float) {
            return o;
        }
        if (o instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)o;
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("@id", qn.toString());
            context.put(qn.getPrefix(), qn.getNamespaceURI());
            return table;
        }
        if (o instanceof LangString) {
            LangString qn = (LangString)o;
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("@language", qn.getLang());
            table.put("@value", qn.getValue());
            return table;
        }
        if (o instanceof String) {
            if (type == null || type.getUri().equals("http://www.w3.org/2001/XMLSchema#string")) {
                return o;
            }
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("@type", type.toString());
            table.put("@value", o.toString());
            return table;
        }
        throw new UnsupportedOperationException("type is " + o);
    }

    public static Object[] convertBeanToValue(Object v, Hashtable<String, String> context, Namespace ns, ProvFactory pf) {
        if (v instanceof Integer) {
            return new Object[]{v, pf.getName().XSD_INT};
        }
        if (v instanceof Float) {
            return new Object[]{v, pf.getName().XSD_FLOAT};
        }
        if (v instanceof QualifiedName) {
            return new Object[]{v, pf.getName().PROV_QUALIFIED_NAME};
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.startsWith("{")) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    v = mapper.readValue((String)v, Hashtable.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                return new Object[]{v, pf.getName().XSD_STRING};
            }
        }
        if (v instanceof HashMap) {
            HashMap table = (HashMap)v;
            String lang = (String)table.get("@language");
            String value = (String)table.get("@value");
            String type = (String)table.get("@type");
            String id = (String)table.get("@id");
            if (lang != null) {
                return new Object[]{pf.newInternationalizedString(value, lang), pf.getName().XSD_STRING};
            }
            if (id != null) {
                return new Object[]{ns.stringToQualifiedName(id, pf), pf.getName().PROV_QUALIFIED_NAME};
            }
            if (type != null) {
                String[] strings = type.split(":");
                String prefix = "";
                String local = type;
                if (strings.length > 1) {
                    prefix = strings[0];
                    local = strings[1];
                }
                String namespace = "http://foo/";
                namespace = context.getOrDefault(prefix, namespace);
                if ("xsd".equals(prefix)) {
                    namespace = "http://www.w3.org/2001/XMLSchema#";
                }
                return new Object[]{value, pf.newQualifiedName(namespace, local, prefix)};
            }
            return new Object[]{value, pf.newQualifiedName("xa", "xb", "cx")};
        }
        throw new UnsupportedOperationException("bean is " + v.getClass());
    }

    public static BindingsBean toBean(Bindings bindings) {
        BindingsBean bean = new BindingsBean();
        bean.var = new Hashtable();
        bean.vargen = new Hashtable();
        bean.context = new Hashtable();
        for (Map.Entry<QualifiedName, List<List<TypedValue>>> entry : bindings.getAttributes().entrySet()) {
            LinkedList<Object> l1 = new LinkedList<Object>();
            for (List<TypedValue> ll : entry.getValue()) {
                if (ll.size() == 1) {
                    l1.add(BindingsJson.convertValueToBean(ll.get(0).getValue(), ll.get(0).getType(), bean.context));
                    continue;
                }
                LinkedList<Object> l2 = new LinkedList<Object>();
                for (TypedValue tv : ll) {
                    l2.add(BindingsJson.convertValueToBean(tv.getValue(), tv.getType(), bean.context));
                }
                l1.add(l2);
            }
            if (entry.getKey().getNamespaceURI().startsWith("http://openprovenance.org/vargen#")) {
                bean.vargen.put(entry.getKey().getLocalPart(), l1);
                continue;
            }
            bean.var.put(entry.getKey().getLocalPart(), l1);
        }
        return bean;
    }

    public static Bindings fromBean(BindingsBean bean, ProvFactory pf) {
        return BindingsJson.fromBeanElements(bean.var, bean.vargen, bean.context, pf);
    }

    public static Bindings fromBeanElements(Hashtable<String, List<Object>> var, Hashtable<String, List<Object>> vargen, Hashtable<String, String> context, ProvFactory pf) {
        Bindings result = new Bindings(pf);
        Namespace ns = new Namespace(context);
        for (Map.Entry<String, List<Object>> bindings : var.entrySet()) {
            String key = bindings.getKey();
            int i = 0;
            LinkedList allvalues = new LinkedList();
            boolean single_value = true;
            for (Object value : bindings.getValue()) {
                LinkedList<Object> wrapped;
                if (!(value instanceof List)) {
                    wrapped = new LinkedList<Object>();
                    wrapped.add(value);
                } else {
                    wrapped = (LinkedList<Object>)value;
                    single_value = false;
                }
                int count = 0;
                LinkedList<Attribute> values = new LinkedList<Attribute>();
                for (Object e : wrapped) {
                    Object[] conversion = BindingsJson.convertBeanToValue(e, context, ns, pf);
                    Object theValue = conversion[0];
                    QualifiedName type = (QualifiedName)conversion[1];
                    if (!type.equals((Object)pf.getName().PROV_QUALIFIED_NAME)) {
                        single_value = false;
                    }
                    values.add(pf.newAttribute("http://openprovenance.org/tmpl#", "2dvalue_" + i + "_" + count, "tmpl", theValue, type));
                    ++count;
                }
                allvalues.add(values);
                ++i;
            }
            QualifiedName myvar = pf.newQualifiedName("http://openprovenance.org/var#", key, "var");
            result.getAttributes().put(myvar, allvalues);
            if (!single_value) continue;
            LinkedList<QualifiedName> ll = new LinkedList<QualifiedName>();
            for (Object o : bindings.getValue()) {
                Object[] conversion = BindingsJson.convertBeanToValue(o, context, ns, pf);
                Object theValue = conversion[0];
                Object object = conversion[1];
                ll.add((QualifiedName)theValue);
            }
            result.getVariables().put(myvar, ll);
        }
        return result;
    }

    public static void exportBean(String output_file1, BindingsBean bean, boolean pretty) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            if (pretty) {
                mapper.writerWithDefaultPrettyPrinter().writeValue(new File(output_file1), (Object)bean);
            } else {
                mapper.writeValue(new File(output_file1), (Object)bean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UncheckedException("JSON serialization failed", e);
        }
    }

    public static BindingsBean importBean(File input_file1) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            BindingsBean bean = (BindingsBean)mapper.readValue(input_file1, BindingsBean.class);
            return bean;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException("JSON serialization failed", (Exception)e);
        }
    }

    public static BindingsBean importBean(InputStream input_file1) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            BindingsBean bean = (BindingsBean)mapper.readValue(input_file1, BindingsBean.class);
            return bean;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException("JSON serialization failed", (Exception)e);
        }
    }

    public static class BindingsBean {
        public Hashtable<String, List<Object>> var;
        public Hashtable<String, List<Object>> vargen;
        public Hashtable<String, String> context;
    }
}

