/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvSerialiser;

@Provider
@Produces(value={"text/turtle", "text/provenance-notation", "application/provenance+xml", "application/trig", "application/rdf+xml", "application/json", "image/svg+xml", "application/pdf", "image/jpeg", "image/png"})
public class DocumentMessageBodyWriter
implements MessageBodyWriter<org.openprovenance.prov.xml.Document> {
    private final ProvSerialiser serializer;

    public String trimCharSet(MediaType mediaType) {
        String med = mediaType.toString();
        int ind = med.indexOf(";");
        if (ind > 0) {
            med = med.substring(0, ind);
        }
        return med;
    }

    public DocumentMessageBodyWriter(ProvSerialiser serializer) {
        System.out.println("*********** DocumentMessageBodyWriter  ************");
        this.serializer = serializer;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.serializer.mediaTypes().contains(this.trimCharSet(mediaType));
    }

    public long getSize(org.openprovenance.prov.xml.Document t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(org.openprovenance.prov.xml.Document doc, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String media = this.trimCharSet(mediaType);
        System.out.println(" ---- writeTo doc " + media);
        this.serializer.serialiseDocument(entityStream, (Document)doc, media, true);
    }
}

