/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.log4j.Logger;
import org.openprovenance.prov.service.core.DocumentResource;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class JobManagement {
    public static final String CURL_TOKEN = "CURL_TOKEN";
    public static final String LOG_JOB = "logJob";
    public static final String LOG_URL = "logUrl";
    public static final String LOG_SOURCE = "logSource";
    static Logger logger = Logger.getLogger(JobManagement.class);
    public static final String LOGGED_MESSAGE = "loggedMessage";
    private static final String SAVE_MESSAGE = null;
    private static Scheduler the_scheduler;
    Scheduler scheduler;
    public static boolean logJobp;
    static String logUrl;
    static String logSource;
    static String token;

    public static Scheduler getScheduler() {
        return the_scheduler;
    }

    public boolean setupScheduler() {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        try {
            this.scheduler = sf.getScheduler();
            this.scheduler.start();
            the_scheduler = this.scheduler;
            return true;
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Date scheduleJob(String graphId) {
        JobDetail job = JobBuilder.newJob(DeleteJob.class).withIdentity(graphId, "graph").build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(graphId + "-trigger", "graph").startAt(DateBuilder.futureDate((int)10, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MINUTE)).build();
        try {
            Date date = this.scheduler.scheduleJob(job, trigger);
            logger.info((Object)("schedule date " + date));
            return date;
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void scheduleCurlJob(String id, String loggedMessage) {
        logger.debug((Object)("========================> " + logJobp));
        if (!logJobp) {
            return;
        }
        JobDetail job = JobBuilder.newJob(CurlJob.class).withIdentity(id, "curl").usingJobData(LOGGED_MESSAGE, loggedMessage).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(id, "graph").startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MINUTE)).build();
        try {
            JobManagement.getScheduler().scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    static {
        logJobp = "true".equals(System.getProperty(LOG_JOB));
        logUrl = System.getProperty(LOG_URL);
        logSource = System.getProperty(LOG_SOURCE, "provapi");
        token = System.getProperty(CURL_TOKEN);
    }

    public static class CurlJob
    implements Job {
        public void execute(JobExecutionContext arg0) throws JobExecutionException {
            String message = arg0.getJobDetail().getJobDataMap().getString(JobManagement.LOGGED_MESSAGE);
            logger.debug((Object)("==========> curl job called " + message));
            String[] components = message.split(",");
            Runtime runtime = Runtime.getRuntime();
            try {
                String action = components[0];
                String graphId = components[1];
                String filename = components[2];
                String source = components[3];
                if ("expansion".equals(action)) {
                    graphId = graphId + "_expanded";
                }
                String[] curl_cmd = new String[]{"curl", "--fail", "-H", "Authorization: Token " + token, "-F", "source=" + logSource, "-F", "uri=https://openprovenance.org/services/provapi/documents/" + graphId, "-F", "prov_format=" + source.toLowerCase(), "-F", "content=@" + filename, logUrl};
                System.out.println(">curl cmd:\n");
                for (String str : curl_cmd) {
                    System.out.println(str);
                }
                Process process = runtime.exec(curl_cmd);
                InputStream is = process.getInputStream();
                int resultCode = process.waitFor();
                System.out.println(">curl cmd: " + resultCode);
                if (resultCode != 0) {
                    String line;
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader buff = new BufferedReader(isr);
                    while ((line = buff.readLine()) != null) {
                        System.out.print(line);
                    }
                    buff.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class DeleteJob
    implements Job {
        public void execute(JobExecutionContext arg0) throws JobExecutionException {
            System.out.println("==========> delete job called " + arg0.getTrigger());
            String graphId = arg0.getJobDetail().getKey().getName();
            if (graphId == null) {
                logger.error((Object)("no graphId " + arg0));
            } else {
                DocumentResource vr = DocumentResource.table.get(graphId);
                if (vr == null) {
                    logger.error((Object)("no validation resource for " + graphId));
                } else {
                    logger.debug((Object)("deleting ... " + graphId));
                    if (vr.filepath != null) {
                        logger.debug((Object)("deleting ... " + vr.filepath));
                        new File(vr.filepath).delete();
                        vr.filepath = null;
                    }
                    if (vr.reportFile != null) {
                        logger.debug((Object)("deleting ... " + vr.reportFile));
                        new File(vr.reportFile).delete();
                        vr.reportFile = null;
                    }
                    if (vr.complete != null) {
                        logger.debug((Object)("deleting ... " + vr.complete));
                        new File(vr.complete).delete();
                        vr.complete = null;
                    }
                    if (vr.dotFilepath != null) {
                        logger.debug((Object)("deleting ... " + vr.dotFilepath));
                        new File(vr.dotFilepath).delete();
                        vr.dotFilepath = null;
                    }
                    if (vr.svgFilepath != null) {
                        logger.debug((Object)("deleting ... " + vr.svgFilepath));
                        new File(vr.svgFilepath).delete();
                        vr.svgFilepath = null;
                    }
                    if (vr.pdfFilepath != null) {
                        logger.debug((Object)("deleting ... " + vr.pdfFilepath));
                        new File(vr.pdfFilepath).delete();
                        vr.pdfFilepath = null;
                    }
                    DocumentResource.table.remove(graphId);
                }
            }
        }
    }
}

