/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.openprovenance.prov.interop.CommandLineArguments;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.service.core.DocumentResource;

public class ServiceUtils {
    public static final String DOCUMENT_NOT_FOUND = "Document not found";
    public static final String WILDCARD = "*";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String HEADER_PARAM_ACCEPT = "Accept";
    static Logger logger = Logger.getLogger(ServiceUtils.class);
    private static String fileName = "config.properties";
    public final String UPLOADED_FILE_PATH = ServiceUtils.getPropertiesFromClasspath(fileName).getProperty("upload.directory");
    public static final String containerVersion = ServiceUtils.getPropertiesFromClasspath(fileName).getProperty("container.version");
    public static final String containerClassifier = ServiceUtils.getPropertiesFromClasspath(fileName).getProperty("container.classifier");
    public static final String longContainerVersion = "ProvToolbox/modules-services ... " + containerVersion + (containerClassifier == null || containerClassifier == "" ? "" : "-" + containerClassifier) + " (" + ServiceUtils.getPropertiesFromClasspath(fileName).getProperty("timestamp") + ")";

    private static Properties getPropertiesFromClasspath(String propFileName) {
        return CommandLineArguments.getPropertiesFromClasspath(ServiceUtils.class, (String)propFileName);
    }

    public Destination getDestination(Map<String, List<InputPart>> formData) throws IOException {
        String val;
        if (formData.get("translate") != null && (val = this.getFormDataValue(formData, "translate")) != null) {
            if ("json".equals(val)) {
                return Destination.JSON;
            }
            if ("provx".equals(val)) {
                return Destination.XML;
            }
            if ("provn".equals(val)) {
                return Destination.PROVN;
            }
            if ("turtle".equals(val)) {
                return Destination.TURTLE;
            }
            if ("trig".equals(val)) {
                return Destination.TRIG;
            }
            if ("svg".equals(val)) {
                return Destination.SVG;
            }
            if ("jpg".equals(val)) {
                return Destination.JPG;
            }
        }
        if (formData.get("expand") != null && (val = this.getFormDataValue(formData, "expand")) != null) {
            if ("json".equals(val)) {
                return Destination.JSON;
            }
            if ("provx".equals(val)) {
                return Destination.XML;
            }
            if ("provn".equals(val)) {
                return Destination.PROVN;
            }
            if ("turtle".equals(val)) {
                return Destination.TURTLE;
            }
            if ("trig".equals(val)) {
                return Destination.TRIG;
            }
            if ("svg".equals(val)) {
                return Destination.SVG;
            }
            return Destination.UNKNOWN;
        }
        if (formData.get("summarise") != null && (val = this.getFormDataValue(formData, "summarise")) != null) {
            if ("json".equals(val)) {
                return Destination.JSON;
            }
            if ("provx".equals(val)) {
                return Destination.XML;
            }
            if ("provn".equals(val)) {
                return Destination.PROVN;
            }
            if ("turtle".equals(val)) {
                return Destination.TURTLE;
            }
            if ("trig".equals(val)) {
                return Destination.TRIG;
            }
            if ("svg".equals(val)) {
                return Destination.SVG;
            }
            return Destination.UNKNOWN;
        }
        return Destination.UNKNOWN;
    }

    public String getFormDataValue(Map<String, List<InputPart>> formData, String name) throws IOException {
        List<InputPart> furtherInputParts = formData.get(name);
        if (furtherInputParts != null && furtherInputParts.size() > 0) {
            return furtherInputParts.get(0).getBodyAsString();
        }
        return null;
    }

    public Action getAction(Map<String, List<InputPart>> formData) throws IOException {
        String val;
        if (formData.get("validate") != null) {
            return Action.VALIDATE;
        }
        if (formData.get("check") != null) {
            return Action.CHECK;
        }
        if (formData.get("upload") != null) {
            return Action.UPLOAD;
        }
        if (formData.get("translate") != null) {
            return Action.TRANSLATE;
        }
        if (formData.get("sign") != null && (val = this.getFormDataValue(formData, "sign")) != null) {
            if ("NF".equals(val)) {
                return Action.NF;
            }
            if ("Sign".equals(val)) {
                return Action.SIGN;
            }
            if ("Signature".equals(val)) {
                return Action.SIGNATURE;
            }
            return Action.UNKNOWN;
        }
        if (formData.get("narrate") != null && (val = this.getFormDataValue(formData, "narrate")) != null) {
            if ("Random".equals(val)) {
                return Action.RANDOM;
            }
            if ("Linear".equals(val)) {
                return Action.LINEAR;
            }
            return Action.UNKNOWN;
        }
        if (formData.get("summarise") != null) {
            return Action.SUMMARISE;
        }
        if (formData.get("expand") != null) {
            return Action.EXPAND;
        }
        return Action.UNKNOWN;
    }

    public static String getRequestURL(HttpServletRequest request, String api, String docId, String action) {
        String name = request.getLocalName();
        if (name.startsWith("0:0:0:0:0:0:0:1")) {
            name = "localhost";
        }
        int port = request.getLocalPort();
        String context = request.getContextPath();
        String url = "http://" + name + ":" + port + context + "/" + api + "/documents/" + docId + action;
        return url;
    }

    public static boolean isNumeric(String str) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }

    public static String isSelf(String s, UriInfo uInfo, String resource) {
        UriBuilder base = uInfo.getBaseUriBuilder();
        String theUri = base.path(resource).build(new Object[0]).toString();
        logger.debug((Object)("found theUri " + theUri + " for " + s));
        if (s.startsWith(theUri)) {
            return s.substring(theUri.length());
        }
        return null;
    }

    public Response composeResponseNotFOUND(String result) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)result).header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD).build();
    }

    public Response composeResponseBadRequest(String result, Throwable thrown) {
        return this.composeResponseError(Response.Status.BAD_REQUEST, result, thrown);
    }

    public Response composeResponseNotFOUND(String result, Throwable thrown) {
        return this.composeResponseError(Response.Status.NOT_FOUND, result, thrown);
    }

    public Response composeResponseError(Response.Status status, String result, Throwable thrown) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        pw.println("<html>");
        pw.println("<h2>Error " + status.getStatusCode() + ": " + status + "</h2>");
        pw.println("<p/>");
        pw.println("<p/>");
        pw.println("<h3> " + result + ": <em>" + thrown.getMessage() + "</em></h3>");
        pw.println("<p/>");
        pw.println("<hr/>");
        pw.println("<pre>");
        if (thrown != null) {
            this.printStackTrace(pw, thrown);
        }
        pw.println("</pre>");
        pw.println("</html>");
        ByteArrayInputStream is = new ByteArrayInputStream(stringWriter.toString().getBytes(StandardCharsets.UTF_8));
        return Response.status((Response.Status)status).entity((Object)is).type("text/html").header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD).build();
    }

    public void printStackTrace(PrintWriter pw, Throwable thrown) {
        while (thrown != null) {
            thrown.printStackTrace(pw);
            pw.println("<p/><hr/><p/>");
            thrown = thrown.getCause();
        }
    }

    public Response composeResponseInternalServerError(String result, Throwable thrown) {
        return this.composeResponseError(Response.Status.INTERNAL_SERVER_ERROR, result, thrown);
    }

    public Response.ResponseBuilder composeResponseSeeOther(String uri) {
        return Response.seeOther((URI)URI.create(uri)).header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD);
    }

    public Response.ResponseBuilder composeResponseOK(Object o) {
        return Response.status((Response.Status)Response.Status.OK).entity(o).header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD);
    }

    public Response composeResponseNotAcceptable(List<Variant> vs) {
        return Response.notAcceptable(vs).header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD).build();
    }

    public Response composeResponseNotFoundDocument(String msg) {
        return this.composeResponseNotFOUND("Not found document for : " + msg);
    }

    public Response composeResponseNotFoundResource(String msg) {
        return this.composeResponseNotFOUND("Not found resource for : " + msg);
    }

    public Response composeResponseNotFoundConstraintResource(String msg) {
        return this.composeResponseNotFOUND("Not found constraint resource for : " + msg);
    }

    public Response composeResponseNotFoundType(String msg) {
        return this.composeResponseNotFOUND("Not found validation resource for : " + msg);
    }

    public Response composeResponseNotFoundSummarisation(String msg) {
        return this.composeResponseNotFOUND("Not found summarisation resource for : " + msg);
    }

    public DocumentResource doProcessFile(InputStream inputStream, String mediaType) {
        try {
            String absoluteFilePath = "";
            InteropFramework interop = new InteropFramework();
            Formats.ProvFormat format = (Formats.ProvFormat)interop.mimeTypeRevMap.get(mediaType.toString());
            String extension = interop.getExtension(format);
            File temp = this.createTempFile(extension);
            absoluteFilePath = temp.getAbsolutePath();
            String s = temp.getName();
            String graphId = s.substring(0, s.lastIndexOf("."));
            System.out.println("---------- Destination name " + graphId);
            System.out.println("---------- Temp file name " + absoluteFilePath);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)temp);
            System.out.println("----------- Done");
            DocumentResource vr = new DocumentResource();
            vr.format = format;
            vr.graphId = graphId;
            vr.filepath = absoluteFilePath;
            vr.graphpath = absoluteFilePath.substring(0, absoluteFilePath.lastIndexOf("."));
            vr.mimeType = null;
            DocumentResource.table.put(graphId, vr);
            this.doProcessFile(vr, true);
            return vr;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean doProcessFile(DocumentResource vr, boolean known) {
        try {
            InteropFramework interop = new InteropFramework();
            Document doc = known ? interop.readDocumentFromFile(vr.filepath) : (Document)interop.loadProvUnknownGraph(vr.filepath);
            if (doc == null) {
                throw new NullPointerException("read document returned null for " + vr.filepath);
            }
            vr.document = (org.openprovenance.prov.xml.Document)doc;
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            vr.thrown = e;
            return false;
        }
    }

    public DocumentResource doProcessStatementsForm(List<InputPart> inputParts, List<InputPart> type) {
        String absoluteFilePath = "";
        Iterator<InputPart> iterator = inputParts.iterator();
        if (iterator.hasNext()) {
            InputPart inputPart = iterator.next();
            try {
                MultivaluedMap header = inputPart.getHeaders();
                System.out.println("Header " + header);
                System.out.println("Header " + header.values());
                System.out.println("Header " + header.keySet());
                String mybody = inputPart.getBodyAsString();
                String mytype = type.get(0).getBodyAsString();
                InteropFramework interop = new InteropFramework();
                Formats.ProvFormat format = interop.getTypeForFile("." + mytype);
                String extension = interop.getExtension(format);
                logger.debug((Object)("processStatementsForm: type is " + mytype));
                logger.debug((Object)("processStatementsForm: extension is " + extension));
                File temp = this.createTempFile(extension);
                absoluteFilePath = temp.getAbsolutePath();
                String s = temp.getName();
                String graphId = s.substring(0, s.lastIndexOf("."));
                System.out.println("---------- Destination name " + graphId);
                System.out.println("---------- Temp file name " + absoluteFilePath);
                FileUtils.write((File)temp, (CharSequence)mybody);
                System.out.println("----------- Done");
                DocumentResource vr = new DocumentResource();
                vr.format = format;
                vr.graphId = graphId;
                vr.filepath = absoluteFilePath;
                vr.graphpath = absoluteFilePath.substring(0, absoluteFilePath.lastIndexOf("."));
                DocumentResource.table.put(graphId, vr);
                return vr;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public DocumentResource doProcessFileForm(List<InputPart> inputParts) {
        String fileName = "";
        String absoluteFilePath = "";
        Iterator<InputPart> iterator = inputParts.iterator();
        if (iterator.hasNext()) {
            InputPart inputPart = iterator.next();
            try {
                MultivaluedMap header = inputPart.getHeaders();
                System.out.println("Header " + header);
                System.out.println("Header " + header.values());
                System.out.println("Header " + header.keySet());
                fileName = this.getFileName((MultivaluedMap<String, String>)header);
                System.out.println("---------- filename " + fileName);
                if (fileName == null || fileName.equals("")) {
                    return null;
                }
                InputStream inputStream = (InputStream)inputPart.getBody(InputStream.class, null);
                fileName = this.UPLOADED_FILE_PATH + fileName;
                InteropFramework interop = new InteropFramework();
                Formats.ProvFormat format = interop.getTypeForFile(fileName);
                String extension = interop.getExtension(format);
                File temp = this.createTempFile(extension);
                absoluteFilePath = temp.getAbsolutePath();
                String s = temp.getName();
                String graphId = s.substring(0, s.lastIndexOf("."));
                System.out.println("---------- Destination name " + graphId);
                System.out.println("---------- Temp file name " + absoluteFilePath);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)temp);
                System.out.println("----------- Done");
                String formatString = format != null ? format.toString() : "unknown";
                DocumentResource vr = new DocumentResource();
                vr.format = format;
                vr.graphId = graphId;
                vr.filepath = absoluteFilePath;
                vr.graphpath = absoluteFilePath.substring(0, absoluteFilePath.lastIndexOf("."));
                vr.mimeType = null;
                DocumentResource.table.put(graphId, vr);
                return vr;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public DocumentResource doProcessURLForm(List<InputPart> inputParts) {
        String absoluteFilePath = "";
        Iterator<InputPart> iterator = inputParts.iterator();
        if (iterator.hasNext()) {
            InputPart inputPart = iterator.next();
            try {
                MultivaluedMap header = inputPart.getHeaders();
                System.out.println("Header " + header);
                System.out.println("Header " + header.values());
                System.out.println("Header " + header.keySet());
                InputStream inputStream = (InputStream)inputPart.getBody(InputStream.class, null);
                String url = IOUtils.toString((InputStream)inputStream).trim();
                System.out.println("---------- URL " + url);
                inputStream.close();
                if (url == null || url.equals("")) {
                    return null;
                }
                InteropFramework interop = new InteropFramework();
                URL theURL = new URL(url);
                URLConnection conn = interop.connectWithRedirect(theURL);
                if (conn == null) {
                    return null;
                }
                Formats.ProvFormat format = null;
                String content_type = conn.getContentType();
                logger.debug((Object)("Content-type: " + content_type));
                if (content_type != null) {
                    int end = content_type.indexOf(";");
                    if (end < 0) {
                        end = content_type.length();
                    }
                    String actual_content_type = content_type.substring(0, end).trim();
                    logger.debug((Object)("Found Content-type: " + actual_content_type));
                    format = (Formats.ProvFormat)interop.mimeTypeRevMap.get(actual_content_type);
                }
                logger.debug((Object)("Format after Content-type: " + format));
                if (format == null) {
                    format = interop.getTypeForFile(theURL.toString());
                }
                logger.debug((Object)("Format after extension: " + format));
                String formatString = format != null ? format.toString() : "unknown";
                String extension = interop.getExtension(format);
                File temp = this.createTempFile(extension);
                InputStream content_stream = conn.getInputStream();
                FileUtils.copyInputStreamToFile((InputStream)content_stream, (File)temp);
                absoluteFilePath = temp.getAbsolutePath();
                String s = temp.getName();
                String graphId = s.substring(0, s.lastIndexOf("."));
                System.out.println("---------- Destination name " + graphId);
                System.out.println("---------- Temp file name " + absoluteFilePath);
                System.out.println("----------- Done");
                DocumentResource vr = new DocumentResource();
                vr.format = format;
                vr.graphId = graphId;
                vr.filepath = absoluteFilePath;
                vr.graphpath = absoluteFilePath.substring(0, absoluteFilePath.lastIndexOf("."));
                vr.mimeType = null;
                DocumentResource.table.put(graphId, vr);
                vr.url = url;
                return vr;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public File createTempFile(String extension) throws IOException {
        return File.createTempFile("graph", "." + extension, new File(this.UPLOADED_FILE_PATH));
    }

    public File createConfigurationFile() throws IOException {
        return File.createTempFile("config", ".json", new File(this.UPLOADED_FILE_PATH));
    }

    public String getFileName(MultivaluedMap<String, String> header) {
        String[] contentDisposition;
        for (String filename : contentDisposition = ((String)header.getFirst((Object)"Content-Disposition")).split(";")) {
            if (!filename.trim().startsWith("filename")) continue;
            String[] name = filename.split("=");
            String finalFileName = name[1].trim().replaceAll("\"", "");
            return finalFileName;
        }
        return null;
    }

    public Response contentNegotiationForDocument(Request request, String msg, String uriPath) throws IllegalArgumentException {
        return this.contentNegotiationForDocument(request, "documents/" + msg + uriPath);
    }

    public Response contentNegotiationForDocument(Request request, String path) throws IllegalArgumentException {
        String type;
        InteropFramework intF = new InteropFramework();
        List vs = intF.getVariants();
        MediaType m = MediaType.TEXT_HTML_TYPE;
        Variant v = request.selectVariant(vs);
        if (v == null) {
            return this.composeResponseNotAcceptable(vs);
        }
        if (v.getMediaType().equals((Object)MediaType.TEXT_HTML_TYPE)) {
            type = "html";
        } else {
            String mt = v.getMediaType().toString();
            type = intF.getExtension((Formats.ProvFormat)intF.mimeTypeRevMap.get(mt));
        }
        if (type != null) {
            return this.composeResponseSeeOther(path + type).build();
        }
        return this.composeResponseNotFoundResource("not found type for " + path);
    }

    public static enum Destination {
        UNKNOWN("UNKNOWN"),
        JSON("json"),
        XML("provx"),
        PROVN("provn"),
        TURTLE("ttl"),
        TRIG("trig"),
        SVG("svg"),
        JPG("jpg");

        private final String text;

        private Destination(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Action {
        UNKNOWN("UNKNOWN"),
        VALIDATE("VALIDATE"),
        EXPAND("EXPAND"),
        NF("NF"),
        SIGN("SIGN"),
        SIGNATURE("SIGNATURE)"),
        CHECK("CHECK"),
        RANDOM("RANDOM"),
        LINEAR("LINEAR"),
        TRANSLATE("TRANSLATE"),
        SUMMARISE("SUMMARISE"),
        UPLOAD("UPLOAD");

        private final String text;

        private Action(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

