/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ForwardedUriInfo
implements UriInfo {
    static Logger logger = LogManager.getLogger(ForwardedUriInfo.class);
    private final transient UriInfo info;
    private final transient AtomicReference<HttpHeaders> headers;
    private transient boolean analyzed;
    private transient String host;
    private transient String scheme;

    public ForwardedUriInfo(UriInfo inf, AtomicReference<HttpHeaders> hdrs) {
        if (inf == null) {
            throw new IllegalStateException("UriInfo is incorrectly injected into BaseResource");
        }
        this.info = inf;
        this.headers = hdrs;
    }

    public URI getAbsolutePath() {
        return this.getAbsolutePathBuilder().build(new Object[0]);
    }

    public UriBuilder getAbsolutePathBuilder() {
        return this.forward(this.info.getAbsolutePathBuilder());
    }

    public URI getBaseUri() {
        return this.getBaseUriBuilder().build(new Object[0]);
    }

    public UriBuilder getBaseUriBuilder() {
        return this.forward(this.info.getBaseUriBuilder());
    }

    public URI getRequestUri() {
        return this.getRequestUriBuilder().build(new Object[0]);
    }

    public UriBuilder getRequestUriBuilder() {
        return this.forward(this.info.getRequestUriBuilder());
    }

    public List<Object> getMatchedResources() {
        return this.info.getMatchedResources();
    }

    public List<String> getMatchedURIs() {
        return this.info.getMatchedURIs();
    }

    public List<String> getMatchedURIs(boolean decode) {
        return this.info.getMatchedURIs(decode);
    }

    public String getPath() {
        return this.info.getPath();
    }

    public String getPath(boolean decode) {
        return this.info.getPath(decode);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.info.getPathParameters();
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        return this.info.getPathParameters(decode);
    }

    public List<PathSegment> getPathSegments() {
        return this.info.getPathSegments();
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return this.info.getPathSegments(decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.info.getQueryParameters();
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        return this.info.getQueryParameters(decode);
    }

    private UriBuilder forward(UriBuilder builder) {
        if (!this.analyzed) {
            if (this.headers.get() == null) {
                throw new IllegalStateException("HttpHeaders is not injected into BaseResource");
            }
            for (Map.Entry header : this.headers.get().getRequestHeaders().entrySet()) {
                for (String value : (List)header.getValue()) {
                    this.consume((String)header.getKey(), value);
                }
            }
            logger.debug("#forward(..): analyzed, host=" + this.host + ", scheme=" + this.scheme);
            this.analyzed = true;
        }
        if (this.host != null) {
            builder.host(this.host);
            int ndx = this.host.indexOf(":");
            if (ndx == -1) {
                logger.debug("unsetting port");
                builder.port(-1);
            } else {
                int myport = Integer.parseInt(this.host.substring(ndx + 1));
                logger.debug("setting port to " + myport);
                builder.port(myport);
            }
        }
        if (this.scheme != null) {
            builder.scheme(this.scheme);
        }
        return builder;
    }

    private void consume(String name, String value) {
        if (this.host == null && "x-forwarded-host".equals(name.toLowerCase(Locale.ENGLISH))) {
            this.host = value;
        } else if (this.scheme == null && "x-forwarded-proto".equals(name.toLowerCase(Locale.ENGLISH))) {
            this.scheme = value;
        } else if ("forwarded".equals(name.toLowerCase(Locale.ENGLISH))) {
            this.forwarded(value);
        }
    }

    private void forwarded(String value) {
        for (String sector : value.split("\\s*,\\s*")) {
            for (String opt : sector.split("\\s*;\\s*")) {
                String[] parts = opt.split("=", 2);
                if (this.host == null && "host".equals(parts[0])) {
                    this.host = parts[1];
                }
                if (this.scheme != null || !"proto".equals(parts[0])) continue;
                this.scheme = parts[1];
            }
        }
    }

    public URI resolve(URI uri) {
        return this.info.resolve(uri);
    }

    public URI relativize(URI uri) {
        return this.info.relativize(uri);
    }
}

