/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.openprovenance.prov.interop.InteropMediaType;
import org.openprovenance.prov.log.ProvLevel;
import org.openprovenance.prov.model.exception.ParserException;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.Constants;
import org.openprovenance.prov.service.core.OtherActionPerformer;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.ServiceUtilsConfig;
import org.openprovenance.prov.service.core.UploadForm;
import org.openprovenance.prov.service.core.jobs.JobManagement;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.quartz.SchedulerException;

@Path(value="")
public class PostService
implements Constants,
InteropMediaType {
    static Logger logger = LogManager.getLogger(PostService.class);
    private final JobManagement jobManager = new JobManagement();
    private final boolean autoDelete;
    private final int deletePeriod;
    protected final ServiceUtils utils;
    private final List<ActionPerformer> performers;
    private Optional<OtherActionPerformer> otherPerformer;

    public PostService(ServiceUtilsConfig config) {
        this(config, new LinkedList<ActionPerformer>(), Optional.empty());
    }

    public JobManagement getJobManager() {
        return this.jobManager;
    }

    public static <E> List<E> addToList(E element, List<E> list) {
        LinkedList<E> result = new LinkedList<E>();
        result.add(element);
        result.addAll(list);
        return result;
    }

    public PostService(ServiceUtilsConfig config, List<ActionPerformer> performers, Optional<OtherActionPerformer> otherPerformer) {
        this.utils = new ServiceUtils(this, config);
        this.autoDelete = config.autoDelete;
        this.deletePeriod = config.deletePeriod;
        this.jobManager.setupScheduler();
        try {
            PostService postService = this;
            postService.jobManager.getScheduler().getContext().put("utils", (Object)this.utils);
            PostService postService2 = this;
            postService2.jobManager.getScheduler().getContext().put("duration", config.deletePeriod);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        this.performers = performers;
        this.otherPerformer = otherPerformer;
    }

    public ServiceUtils getServiceUtils() {
        return this.utils;
    }

    public void addToPerformers(List<ActionPerformer> newPerformers) {
        this.performers.addAll(newPerformers);
    }

    public void addOtherPerformer(Optional<OtherActionPerformer> newOtherPerformer) {
        this.otherPerformer = newOtherPerformer;
    }

    @POST
    @Path(value="/documents/")
    @Consumes(value={"multipart/form-data"})
    @Tag(name="documents")
    @Operation(summary="Post a document. Payload is a form that may contain a file, prov statements or a url", description="Post a document in a form; indicate if validation or translation required; and redirects to the appropriate page. This method  is also designed for browser interaction, allowing the user to select a file, a url or statements for provenance.  The user may specify validate or translate directly.", responses={@ApiResponse(responseCode="303", headers={@Header(name="location", description="Location of posted document")}, description="See other url for serialization of posted resource as requested by accept header."), @ApiResponse(responseCode="404", description="Provenance not found")})
    public Response submit(@Parameter(name="form", description="form to be posted", required=true, schema=@Schema(implementation=UploadForm.class)) MultipartFormDataInput input, @Context HttpHeaders headers, @Context HttpServletRequest requestContext) {
        MediaType mediaType = headers.getMediaType();
        if (mediaType.toString().startsWith("multipart/form-data")) {
            try {
                Map formData = input.getFormDataMap();
                logger.debug("submitted " + formData);
                DocumentResource vr = this.processFileInForm(formData);
                if (vr == null) {
                    vr = this.processUrlInForm(formData);
                }
                if (vr == null) {
                    vr = this.processStatementsInForm(formData);
                }
                boolean success = this.utils.doProcessFile(vr, true);
                if (vr == null) {
                    String result = "No provenance was found, and therefore failed to create resource for validation service";
                    return this.utils.composeResponseNotFOUND(result);
                }
                if (!success) {
                    String result = "Failed to parse provenance";
                    return this.utils.composeResponseBadRequest(result, vr.getThrown());
                }
                if (!this.utils.documentCache.containsKey(vr.getStorageId())) {
                    String result = "No provenance was found (empty document), and therefore failed to create resource for validation service";
                    return this.utils.composeResponseNotFOUND(result);
                }
                Date date = this.autoDelete ? this.jobManager.scheduleJob(vr.getVisibleId()) : null;
                vr.setExpires(date);
                ServiceUtils.Action action = this.utils.getAction(formData);
                this.doLog(action, vr);
                logger.debug("trying performers " + this.performers);
                for (ActionPerformer performer : this.performers) {
                    logger.debug("trying performer " + performer.getAction());
                    if (!performer.getAction().equals((Object)action)) continue;
                    logger.debug("invoking performer " + performer.getAction());
                    return performer.doAction(formData, vr, date);
                }
                logger.debug("checking other performer ");
                if (this.otherPerformer.isPresent() && this.otherPerformer.get().otherAction(action, formData)) {
                    logger.debug("invoking other performer ");
                    return this.otherPerformer.get().doAction(action, formData, vr, date);
                }
                String location = "view/documents/" + vr.getVisibleId() + "/translation.html";
                return this.utils.composeResponseSeeOther(location).header("Expires", (Object)date).build();
            }
            catch (UncheckedException e) {
                return this.utils.composeResponseBadRequest("URI problem (" + e.getCause() + ")", e);
            }
            catch (ParserException e) {
                return this.utils.composeResponseBadRequest("Parser problem", e);
            }
            catch (Throwable t) {
                t.printStackTrace();
                String result = "exception occurred";
                return this.utils.composeResponseInternalServerError(result, t);
            }
        }
        String result = "Media type " + mediaType + " Not Supported yet";
        return this.utils.composeResponseNotFOUND(result);
    }

    @POST
    @Path(value="/documents2/")
    @Tag(name="documents")
    @Consumes(value={"text/turtle", "text/provenance-notation", "application/provenance+xml", "application/trig", "application/rdf+xml", "application/json"})
    @Operation(summary="Post a document, directly, creates a resource, supports content negotiation, redirects to URL providing serialization for the resource", description="It supports the direct posting of documents using a prov serialization.", responses={@ApiResponse(responseCode="200", content={@Content(mediaType="text/turtle"), @Content(mediaType="text/provenance-notation"), @Content(mediaType="application/provenance+xml"), @Content(mediaType="application/trig"), @Content(mediaType="application/rdf+xml"), @Content(mediaType="application/json")}), @ApiResponse(responseCode="303", headers={@Header(name="location", description="Location of posted document")}, description="See other url for serialization of posted resource as requested by accept header."), @ApiResponse(responseCode="404", description="Provenance not found")})
    public Response submit2(@Parameter(name="input", description="input file in a prov serialization", example="document\n prefix ex <http://foo>\n entity(ex:e)\nendDocument") InputStream input, @Context HttpHeaders headers, @Context Request request) {
        MediaType mediaType = headers.getMediaType();
        String type = mediaType.getType() + "/" + mediaType.getSubtype();
        logger.debug(">>> post media type is " + type);
        logger.debug("accept header is" + headers.getAcceptableMediaTypes());
        DocumentResource vr = this.utils.doProcessFile(input, type);
        Date date = this.jobManager.scheduleJob(vr.getVisibleId());
        vr.setExpires(date);
        return this.utils.contentNegotiationForDocument(request, vr.getVisibleId(), ".");
    }

    private DocumentResource processFileInForm(Map<String, List<InputPart>> formData) {
        DocumentResource vr = null;
        List<InputPart> inputParts = formData.get("file");
        if (inputParts != null) {
            vr = this.utils.doProcessFileForm(inputParts);
        }
        return vr;
    }

    private DocumentResource processUrlInForm(Map<String, List<InputPart>> formData) {
        DocumentResource vr = null;
        List<InputPart> inputParts = formData.get("url");
        if (inputParts != null) {
            vr = this.utils.doProcessURLForm(inputParts);
        }
        return vr;
    }

    private DocumentResource processStatementsInForm(Map<String, List<InputPart>> formData) {
        DocumentResource vr = null;
        List<InputPart> inputParts = formData.get("statements");
        List<InputPart> type = formData.get("type");
        if (inputParts != null) {
            vr = this.utils.doProcessStatementsForm(inputParts, type);
        }
        return vr;
    }

    private void doLog(ServiceUtils.Action action, DocumentResource vr) {
        this.doLog(action.toString(), vr);
    }

    private void doLog(String action, DocumentResource vr) {
        logger.log(ProvLevel.PROV, action + "," + vr.getVisibleId() + "," + vr.getStorageId());
    }

    @GET
    @Path(value="/resources/prov/{name}.{type}")
    @Tag(name="documents")
    @Operation(summary="Returns static provenance document", description="No content negotiation allowed here.", responses={@ApiResponse(responseCode="200", description="Representation of document"), @ApiResponse(responseCode="404", description="Document not found")})
    public Response getResource(@Context HttpServletResponse response, @Context HttpServletRequest request, @Parameter(name="name", description="document name", required=true) @PathParam(value="name") String name, @Parameter(name="type", description="document type", required=true) @PathParam(value="type") String type) throws IOException {
        logger.debug("requesting resource " + name);
        InputStream stream = this.getClass().getResourceAsStream("/resources/prov/" + name + "." + type);
        StreamingOutput promise = out -> stream.transferTo(out);
        return this.utils.composeResponseOK(promise).type("text/provenance-notation").build();
    }
}

