/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core.jobs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.service.core.jobs.JobManagement;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

public class CurlJob
implements Job {
    static Logger logger = LogManager.getLogger(CurlJob.class);

    public void execute(JobExecutionContext arg0) {
        String message = arg0.getJobDetail().getJobDataMap().getString("loggedMessage");
        logger.debug("==========> curl job called " + message);
        String[] components = message.split(",");
        Runtime runtime = Runtime.getRuntime();
        try {
            String action = components[0];
            Object graphId = components[1];
            String filename = components[2];
            String source = components[3];
            if ("expansion".equals(action)) {
                graphId = (String)graphId + "_expanded";
            }
            String[] curl_cmd = new String[]{"curl", "--fail", "-H", "Authorization: Token " + JobManagement.token, "-F", "source=" + JobManagement.logSource, "-F", "uri=https://openprovenance.org/services/provapi/documents/" + (String)graphId, "-F", "prov_format=" + source.toLowerCase(), "-F", "content=@" + filename, JobManagement.logUrl};
            System.out.println(">curl cmd:\n");
            for (String str : curl_cmd) {
                System.out.println(str);
            }
            Process process = runtime.exec(curl_cmd);
            InputStream is = process.getInputStream();
            int resultCode = process.waitFor();
            System.out.println(">curl cmd: " + resultCode);
            if (resultCode != 0) {
                String line;
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader buff = new BufferedReader(isr);
                while ((line = buff.readLine()) != null) {
                    System.out.print(line);
                }
                buff.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

