/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.exception.ParserException;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtilsConfig;
import org.openprovenance.prov.service.core.jobs.JobManagement;
import org.openprovenance.prov.service.core.memory.LRUHashMap;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.NonDocumentGenericResourceStorage;
import org.openprovenance.prov.storage.api.NonDocumentResource;
import org.openprovenance.prov.storage.api.NonDocumentResourceIndex;
import org.openprovenance.prov.storage.api.NonDocumentResourceStorage;
import org.openprovenance.prov.storage.api.ResourceIndex;
import org.openprovenance.prov.storage.api.ResourceStorage;

public class ServiceUtils {
    public static final String DOCUMENT_NOT_FOUND = "Document not found";
    public static final String WILDCARD = "*";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String HEADER_PARAM_ACCEPT = "Accept";
    private static String fileName = "config.properties";
    public static final String UPLOADED_FILE_PATH = ServiceUtils.getPropertiesFromClasspath(fileName).getProperty("upload.directory");
    public static final String containerVersion = ServiceUtils.getPropertiesFromClasspath(fileName).getProperty("container.version");
    public static final String containerClassifier = ServiceUtils.getPropertiesFromClasspath(fileName).getProperty("container.classifier");
    public static final String longContainerVersion = "ProvToolbox/modules-services " + containerVersion + (String)(containerClassifier == null || containerClassifier == "" ? "" : "-" + containerClassifier) + " (" + ServiceUtils.getPropertiesFromClasspath(fileName).getProperty("timestamp") + ")";
    private final JobManagement jobManager;
    private final NonDocumentResourceIndex<NonDocumentResource> nonDocumentResourceIndex;
    private final NonDocumentResourceStorage nonDocumentResourceStorage;
    private final InteropFramework interop;
    private final Map<String, NonDocumentGenericResourceStorage<?>> genericResourceStorageMap;
    private final ServiceUtilsConfig config;
    private static Logger logger = LogManager.getLogger(ServiceUtils.class);
    private final ResourceStorage storageManager;
    private final ResourceIndex<DocumentResource> documentResourceIndex;
    private final Map<String, ResourceIndex<?>> extensionMap;
    private final ProvFactory pFactory;
    public LRUHashMap<String, Document> documentCache;

    public Map<String, NonDocumentGenericResourceStorage<?>> getGenericResourceStorageMap() {
        return this.genericResourceStorageMap;
    }

    public ServiceUtilsConfig getConfig() {
        return this.config;
    }

    private static Properties getPropertiesFromClasspath(String propFileName) {
        return Configuration.getPropertiesFromClasspath(ServiceUtils.class, (String)propFileName);
    }

    public ServiceUtils(PostService postService, ServiceUtilsConfig config) {
        this.config = config;
        this.storageManager = config.storageManager;
        this.pFactory = config.pFactory;
        this.interop = new InteropFramework(config.pFactory);
        this.documentResourceIndex = (ResourceIndex)config.extensionMap.get(DocumentResource.getResourceKind());
        this.nonDocumentResourceIndex = config.nonDocumentResourceIndex;
        this.nonDocumentResourceStorage = config.nonDocumentResourceStorage;
        this.genericResourceStorageMap = config.genericResourceStorageMap;
        this.extensionMap = config.extensionMap;
        this.jobManager = postService.getJobManager();
        this.documentCache = new LRUHashMap(config.documentCacheSize);
    }

    public NonDocumentResourceStorage getNonDocumentResourceStorage() {
        return this.nonDocumentResourceStorage;
    }

    public ResourceIndex<DocumentResource> getDocumentResourceIndex() {
        return this.documentResourceIndex;
    }

    public ResourceStorage getStorageManager() {
        return this.storageManager;
    }

    public final Map<String, ResourceIndex<?>> getExtensionMap() {
        return this.extensionMap;
    }

    public NonDocumentResourceIndex<NonDocumentResource> getNonDocumentResourceIndex() {
        return this.nonDocumentResourceIndex;
    }

    public ProvFactory getProvFactory() {
        return this.pFactory;
    }

    public Destination getDestination(Map<String, List<InputPart>> formData) throws IOException {
        String val;
        if (formData.get("translate") != null && (val = this.getFormDataValue(formData, "translate")) != null) {
            if ("json".equals(val)) {
                return Destination.JSON;
            }
            if ("jsonld".equals(val)) {
                return Destination.JSONLD;
            }
            if ("provx".equals(val)) {
                return Destination.XML;
            }
            if ("provn".equals(val)) {
                return Destination.PROVN;
            }
            if ("turtle".equals(val)) {
                return Destination.TURTLE;
            }
            if ("trig".equals(val)) {
                return Destination.TRIG;
            }
            if ("svg".equals(val)) {
                return Destination.SVG;
            }
            if ("jpg".equals(val)) {
                return Destination.JPG;
            }
        }
        if (formData.get("expand") != null && (val = this.getFormDataValue(formData, "expand")) != null) {
            if ("json".equals(val)) {
                return Destination.JSON;
            }
            if ("jsonld".equals(val)) {
                return Destination.JSONLD;
            }
            if ("provx".equals(val)) {
                return Destination.XML;
            }
            if ("provn".equals(val)) {
                return Destination.PROVN;
            }
            if ("turtle".equals(val)) {
                return Destination.TURTLE;
            }
            if ("trig".equals(val)) {
                return Destination.TRIG;
            }
            if ("svg".equals(val)) {
                return Destination.SVG;
            }
            return Destination.UNKNOWN;
        }
        if (formData.get("summarise") != null && (val = this.getFormDataValue(formData, "summarise")) != null) {
            if ("json".equals(val)) {
                return Destination.JSON;
            }
            if ("provx".equals(val)) {
                return Destination.XML;
            }
            if ("provn".equals(val)) {
                return Destination.PROVN;
            }
            if ("turtle".equals(val)) {
                return Destination.TURTLE;
            }
            if ("trig".equals(val)) {
                return Destination.TRIG;
            }
            if ("svg".equals(val)) {
                return Destination.SVG;
            }
            return Destination.UNKNOWN;
        }
        return Destination.UNKNOWN;
    }

    public JobManagement getJobManager() {
        return this.jobManager;
    }

    public String getFormDataValue(Map<String, List<InputPart>> formData, String name) throws IOException {
        List<InputPart> furtherInputParts = formData.get(name);
        if (furtherInputParts != null && furtherInputParts.size() > 0) {
            return furtherInputParts.get(0).getBodyAsString();
        }
        return null;
    }

    public Action getAction(Map<String, List<InputPart>> formData) throws IOException {
        String val;
        if (formData.get("validate") != null) {
            return Action.VALIDATE;
        }
        if (formData.get("check") != null) {
            return Action.CHECK;
        }
        if (formData.get("upload") != null) {
            return Action.UPLOAD;
        }
        if (formData.get("translate") != null) {
            return Action.TRANSLATE;
        }
        if (formData.get("sign") != null && (val = this.getFormDataValue(formData, "sign")) != null) {
            if ("NF".equals(val)) {
                return Action.NF;
            }
            if ("Sign".equals(val)) {
                return Action.SIGN;
            }
            if ("Signature".equals(val)) {
                return Action.SIGNATURE;
            }
            return Action.UNKNOWN;
        }
        if (formData.get("narrate") != null && (val = this.getFormDataValue(formData, "narrate")) != null) {
            if ("Random".equals(val)) {
                return Action.RANDOM;
            }
            if ("Linear".equals(val)) {
                return Action.LINEAR;
            }
            return Action.UNKNOWN;
        }
        if (formData.get("explain") != null && (val = this.getFormDataValue(formData, "explain")) != null) {
            if ("Explanation".equals(val)) {
                return Action.EXPLANATION;
            }
            return Action.UNKNOWN;
        }
        if (formData.get("summarise") != null) {
            return Action.SUMMARISE;
        }
        if (formData.get("expand") != null) {
            return Action.EXPAND;
        }
        return Action.UNKNOWN;
    }

    public static String getRequestURL(HttpServletRequest request, String api, String docId, String action) {
        String name = request.getLocalName();
        if (name.startsWith("0:0:0:0:0:0:0:1")) {
            name = "localhost";
        }
        int port = request.getLocalPort();
        String context = request.getContextPath();
        String url = "http://" + name + ":" + port + context + "/" + api + "/documents/" + docId + action;
        return url;
    }

    public static boolean isNumeric(String str) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }

    public static String isSelf(String s, UriInfo uInfo, String resource) {
        UriBuilder base = uInfo.getBaseUriBuilder();
        String theUri = base.path(resource).build(new Object[0]).toString();
        logger.debug("found theUri " + theUri + " for " + s);
        if (s.startsWith(theUri)) {
            return s.substring(theUri.length());
        }
        return null;
    }

    public Response composeResponseNotFOUND(String result) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)result).type("text/plain").header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD).build();
    }

    public Response composeResponseBadRequest(String result, Throwable thrown) {
        return this.composeResponseError(Response.Status.BAD_REQUEST, result, thrown);
    }

    public Response composeResponseNotFOUND(String result, Throwable thrown) {
        return this.composeResponseError(Response.Status.NOT_FOUND, result, thrown);
    }

    public Response composeResponseError(Response.Status status, String result, Throwable thrown) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        pw.println("<html>");
        pw.println("<h2>Error " + status.getStatusCode() + ": " + status + "</h2>");
        pw.println("<p/>");
        pw.println("<p/>");
        pw.println("<h3> " + result + ": <em>" + thrown.getMessage() + "</em></h3>");
        pw.println("<p/>");
        pw.println("<hr/>");
        pw.println("<pre>");
        if (thrown != null) {
            this.printStackTrace(pw, thrown);
        }
        pw.println("</pre>");
        pw.println("</html>");
        ByteArrayInputStream is = new ByteArrayInputStream(stringWriter.toString().getBytes(StandardCharsets.UTF_8));
        return Response.status((Response.Status)status).entity((Object)is).type("text/html").header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD).build();
    }

    public void printStackTrace(PrintWriter pw, Throwable thrown) {
        while (thrown != null) {
            thrown.printStackTrace(pw);
            pw.println("<p/><hr/><p/>");
            thrown = thrown.getCause();
        }
    }

    public Response composeResponseInternalServerError(String result, Throwable thrown) {
        return this.composeResponseError(Response.Status.INTERNAL_SERVER_ERROR, result, thrown);
    }

    public Response.ResponseBuilder composeResponseSeeOther(String uri) {
        return Response.seeOther((URI)URI.create(uri)).header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD);
    }

    public Response.ResponseBuilder composeResponseOK(Object o) {
        return Response.status((Response.Status)Response.Status.OK).entity(o).header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD);
    }

    public Response composeResponseNotAcceptable(List<Variant> vs) {
        return Response.notAcceptable(vs).header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)WILDCARD).build();
    }

    public Response composeResponseNotFoundDocument(String msg) {
        return this.composeResponseNotFOUND("Not found document for : " + msg);
    }

    public Response composeResponseNotFoundResource(String msg) {
        return this.composeResponseNotFOUND("No resource found for id: " + msg);
    }

    public Response composeResponseNotFoundConstraintResource(String msg) {
        return this.composeResponseNotFOUND("Not found constraint resource for : " + msg);
    }

    public Response composeResponseNotFoundType(String msg) {
        return this.composeResponseNotFOUND("Not found validation resource for : " + msg);
    }

    public Response composeResponseNotFoundSummarisation(String msg) {
        return this.composeResponseNotFOUND("Not found summarisation resource for : " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentResource doProcessFile(InputStream inputStream, String mediaType) {
        DocumentResource documentResource;
        String storedResourceIdentifier = "";
        Formats.ProvFormat format = (Formats.ProvFormat)this.interop.mimeTypeRevMap.get(mediaType.toString());
        storedResourceIdentifier = this.storageManager.newStore(format);
        logger.debug("storage Id: " + storedResourceIdentifier);
        ResourceIndex index = this.documentResourceIndex.getIndex();
        try {
            DocumentResource dr = index.newResource();
            dr.setStorageId(storedResourceIdentifier);
            index.put(dr.getVisibleId(), dr);
            logger.debug("visible Id: " + dr.getVisibleId());
            this.storageManager.copyInputStreamToStore(inputStream, format, storedResourceIdentifier);
            logger.debug("----------- Done");
            this.doProcessFile(dr, true);
            documentResource = dr;
        }
        catch (Throwable throwable) {
            try {
                index.close();
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new ParserException(e);
            }
        }
        index.close();
        return documentResource;
    }

    public boolean doProcessFile(DocumentResource dr, boolean known) {
        try {
            logger.debug("doProcessFile for " + dr.getVisibleId() + " " + dr.getStorageId());
            Document doc = this.getDocumentFromCacheOrStore(dr.getStorageId());
            if (doc == null) {
                throw new NullPointerException("read document returned null for " + dr.getStorageId());
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            dr.setThrown(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocumentFromCacheOrStore(String storageId) throws IOException {
        Document doc;
        ServiceUtils serviceUtils = this;
        synchronized (serviceUtils) {
            doc = (Document)this.documentCache.get(storageId);
        }
        if (doc != null) {
            logger.debug("Retrieved document from cache: " + storageId);
            return doc;
        }
        logger.debug("Retrieving document from store: " + storageId);
        doc = this.storageManager.readDocument(storageId, true);
        if (doc != null) {
            serviceUtils = this;
            synchronized (serviceUtils) {
                this.documentCache.put(storageId, doc);
            }
            logger.debug("Stored document in cache: " + storageId);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFromCache(String storageId) {
        Object o;
        ServiceUtils serviceUtils = this;
        synchronized (serviceUtils) {
            o = this.documentCache.remove(this);
        }
        return o != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentResource doProcessStatementsForm(List<InputPart> inputParts, List<InputPart> type) {
        String storedResourceIdentifier = "";
        Iterator<InputPart> iterator = inputParts.iterator();
        if (iterator.hasNext()) {
            DocumentResource documentResource;
            InputPart inputPart = iterator.next();
            MultivaluedMap header = inputPart.getHeaders();
            logger.debug("Header " + header);
            logger.debug("Header " + header.values());
            logger.debug("Header " + header.keySet());
            String mybody = inputPart.getBodyAsString();
            String mytype = type.get(0).getBodyAsString();
            Formats.ProvFormat format = this.interop.getTypeForFile("." + mytype);
            storedResourceIdentifier = this.storageManager.newStore(format);
            logger.debug("storage Id: " + storedResourceIdentifier);
            logger.debug("processStatementsForm: type is " + mytype);
            ResourceIndex index = this.documentResourceIndex.getIndex();
            try {
                DocumentResource dr = index.newResource();
                dr.setStorageId(storedResourceIdentifier);
                index.put(dr.getVisibleId(), dr);
                logger.debug("visible Id: " + dr.getVisibleId());
                this.storageManager.copyStringToStore((CharSequence)mybody, format, storedResourceIdentifier);
                documentResource = dr;
            }
            catch (Throwable throwable) {
                try {
                    index.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw new ParserException(e);
                }
            }
            index.close();
            return documentResource;
        }
        throw new RuntimeException("Not properly structured input parts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentResource doProcessFileForm(List<InputPart> inputParts) {
        String storedResourceIdentifier = "";
        Iterator<InputPart> iterator = inputParts.iterator();
        if (iterator.hasNext()) {
            InputPart inputPart = iterator.next();
            try {
                DocumentResource dr;
                MultivaluedMap header = inputPart.getHeaders();
                logger.debug("Header " + header);
                logger.debug("Header " + header.values());
                logger.debug("Header " + header.keySet());
                String fileName = this.getFileName((MultivaluedMap<String, String>)header);
                if (fileName == null || fileName.equals("")) {
                    return null;
                }
                InputStream inputStream = (InputStream)inputPart.getBody(InputStream.class, null);
                Formats.ProvFormat format = this.interop.getTypeForFile(fileName);
                storedResourceIdentifier = this.storageManager.newStore(format);
                try (ResourceIndex index = this.documentResourceIndex.getIndex();){
                    dr = index.newResource();
                    dr.setStorageId(storedResourceIdentifier);
                    index.put(dr.getVisibleId(), dr);
                }
                logger.debug("storage Id: " + storedResourceIdentifier);
                logger.debug("visible Id: " + dr.getVisibleId());
                this.storageManager.copyInputStreamToStore(inputStream, format, storedResourceIdentifier);
                String formatString = format != null ? format.toString() : "unknown";
                return dr;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new ParserException(e);
            }
        }
        throw new RuntimeException("Not properly structured input parts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentResource doProcessURLForm(List<InputPart> inputParts) {
        String storedResourceIdentifier = "";
        Iterator<InputPart> iterator = inputParts.iterator();
        if (iterator.hasNext()) {
            DocumentResource documentResource;
            InputPart inputPart = iterator.next();
            MultivaluedMap header = inputPart.getHeaders();
            logger.debug("Header " + header);
            logger.debug("Header " + header.values());
            logger.debug("Header " + header.keySet());
            InputStream inputStream = (InputStream)inputPart.getBody(InputStream.class, null);
            String url = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset()).trim();
            inputStream.close();
            if (url == null || url.equals("")) {
                return null;
            }
            URL theURL = new URL(url);
            URLConnection conn = this.interop.connectWithRedirect(theURL);
            if (conn == null) {
                throw new RuntimeException("Failed to connect to url");
            }
            Formats.ProvFormat format = null;
            String content_type = conn.getContentType();
            logger.debug("Content-type: " + content_type);
            if (content_type != null) {
                int end = content_type.indexOf(";");
                if (end < 0) {
                    end = content_type.length();
                }
                String actual_content_type = content_type.substring(0, end).trim();
                logger.debug("Found Content-type: " + actual_content_type);
                format = (Formats.ProvFormat)this.interop.mimeTypeRevMap.get(actual_content_type);
            }
            logger.debug("Format after Content-type: " + format);
            if (format == null) {
                format = this.interop.getTypeForFile(theURL.toString());
            }
            logger.debug("Format after extension: " + format);
            storedResourceIdentifier = this.storageManager.newStore(format);
            InputStream content_stream = conn.getInputStream();
            this.storageManager.copyInputStreamToStore(content_stream, format, storedResourceIdentifier);
            ResourceIndex index = this.documentResourceIndex.getIndex();
            try {
                DocumentResource dr = index.newResource();
                dr.setStorageId(storedResourceIdentifier);
                index.put(dr.getVisibleId(), dr);
                logger.debug("storage Id: " + storedResourceIdentifier);
                logger.debug("visible Id: " + dr.getVisibleId());
                documentResource = dr;
            }
            catch (Throwable throwable) {
                try {
                    index.close();
                    throw throwable;
                }
                catch (UnknownHostException e) {
                    throw new UncheckedException("UnknownHostException", (Exception)e);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw new ParserException(e);
                }
            }
            index.close();
            return documentResource;
        }
        throw new RuntimeException("Not properly structured input parts");
    }

    public String getFileName(MultivaluedMap<String, String> header) {
        String[] contentDisposition;
        for (String filename : contentDisposition = ((String)header.getFirst((Object)"Content-Disposition")).split(";")) {
            if (!filename.trim().startsWith("filename")) continue;
            String[] name = filename.split("=");
            String finalFileName = name[1].trim().replaceAll("\"", "");
            return finalFileName;
        }
        return null;
    }

    public Response contentNegotiationForDocument(Request request, String msg, String uriPath) throws IllegalArgumentException {
        return this.contentNegotiationForDocument(request, "documents/" + msg + uriPath);
    }

    public Response contentNegotiationForDocument(Request request, String path) throws IllegalArgumentException {
        String type;
        List vs = this.interop.getVariants();
        MediaType m = MediaType.TEXT_HTML_TYPE;
        Variant v = request.selectVariant(vs);
        if (v == null) {
            return this.composeResponseNotAcceptable(vs);
        }
        if (v.getMediaType().equals((Object)MediaType.TEXT_HTML_TYPE)) {
            type = "html";
        } else {
            String mt = v.getMediaType().toString();
            type = this.interop.getExtension((Formats.ProvFormat)this.interop.mimeTypeRevMap.get(mt));
        }
        if (type != null) {
            return this.composeResponseSeeOther(path + type).build();
        }
        return this.composeResponseNotFoundResource("not found type for " + path);
    }

    public static enum Destination {
        UNKNOWN("UNKNOWN"),
        JSON("json"),
        XML("provx"),
        PROVN("provn"),
        TURTLE("ttl"),
        TRIG("trig"),
        SVG("svg"),
        JPG("jpg"),
        JSONLD("jsonld");

        private final String text;

        private Destination(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Action {
        UNKNOWN("UNKNOWN"),
        VALIDATE("VALIDATE"),
        EXPAND("EXPAND"),
        NF("NF"),
        SIGN("SIGN"),
        SIGNATURE("SIGNATURE)"),
        CHECK("CHECK"),
        RANDOM("RANDOM"),
        LINEAR("LINEAR"),
        EXPLANATION("EXPLANATION"),
        TRANSLATE("TRANSLATE"),
        SUMMARISE("SUMMARISE"),
        UPLOAD("UPLOAD");

        private final String text;

        private Action(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

