/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core.memory;

import java.util.HashMap;
import java.util.Map;
import org.openprovenance.prov.service.core.memory.DocumentResourceInMemory;
import org.openprovenance.prov.service.core.memory.LRUHashMap;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.Instantiable;
import org.openprovenance.prov.storage.api.ResourceIndex;

public class DocumentResourceIndexInMemory
implements ResourceIndex<DocumentResource> {
    static int count = 100000;
    public final Map<String, DocumentResource> table;
    public static Instantiable<DocumentResource> factory = new Instantiable<DocumentResource>(){

        public DocumentResource newResource(DocumentResource dr) {
            return dr;
        }

        public DocumentResource newResource() {
            return new DocumentResourceInMemory();
        }
    };

    public DocumentResourceIndexInMemory(Map<String, DocumentResource> table) {
        this.table = table;
    }

    public DocumentResourceIndexInMemory(int limit) {
        this.table = new LRUHashMap<String, DocumentResource>(limit);
    }

    public DocumentResourceIndexInMemory() {
        this.table = new HashMap<String, DocumentResource>();
    }

    public DocumentResource get(String key) {
        return this.table.get(key);
    }

    public void put(String key, DocumentResource dr) {
        this.table.put(key, dr);
    }

    public void remove(String key) {
        this.table.remove(key);
    }

    public synchronized String newId() {
        return "m" + count++;
    }

    public DocumentResource newResource() {
        String id = this.newId();
        DocumentResourceInMemory dr = new DocumentResourceInMemory();
        dr.setVisibleId(id);
        this.put(id, dr);
        return dr;
    }

    public DocumentResource newResource(DocumentResource dr) {
        return dr;
    }

    public ResourceIndex.StorageKind kind() {
        return ResourceIndex.StorageKind.ME;
    }

    public ResourceIndex<DocumentResource> getAncestor() {
        throw new UnsupportedOperationException("No ancestor to root Index");
    }

    public ResourceIndex<DocumentResource> getIndex() {
        return this;
    }

    public void close() {
    }

    public static void register(Map<String, Instantiable<?>> m) {
        m.put(DocumentResource.getResourceKind(), factory);
    }
}

