/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core.jobs;

import java.util.Date;
import org.apache.log4j.Logger;
import org.openprovenance.prov.service.core.jobs.CurlJob;
import org.openprovenance.prov.service.core.jobs.JobDeleteDocumentResource;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class JobManagement {
    public static final String CURL_TOKEN = "CURL_TOKEN";
    public static final String LOG_JOB = "logJob";
    public static final String LOG_URL = "logUrl";
    public static final String LOG_SOURCE = "logSource";
    public static final String UTILS_KEY = "utils";
    public static final String DURATION_KEY = "duration";
    static Logger logger = Logger.getLogger(JobManagement.class);
    public static final String LOGGED_MESSAGE = "loggedMessage";
    private static Scheduler the_scheduler;
    Scheduler scheduler;
    public static boolean logJobp;
    public static String logUrl;
    public static String logSource;
    public static String token;

    public static Scheduler getScheduler() {
        return the_scheduler;
    }

    public boolean setupScheduler() {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        try {
            this.scheduler = sf.getScheduler();
            this.scheduler.start();
            the_scheduler = this.scheduler;
            return true;
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Date scheduleJob(String visibleId) {
        return this.scheduleJob(JobDeleteDocumentResource.class, visibleId, "-trigger", "graph");
    }

    public Date scheduleJob(Class<? extends Job> jobClazz, String visibleId, String idSuffix, String group) {
        int duration = 600;
        try {
            duration = (Integer)the_scheduler.getContext().get((Object)DURATION_KEY);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        JobDetail job = JobBuilder.newJob(jobClazz).withIdentity(visibleId, group).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(visibleId + idSuffix, group).startAt(DateBuilder.futureDate((int)duration, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).build();
        try {
            Date date = this.scheduler.scheduleJob(job, trigger);
            logger.debug((Object)("schedule date " + date));
            return date;
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void scheduleCurlJob(String id, String loggedMessage) {
        logger.debug((Object)("========================> " + logJobp));
        if (!logJobp) {
            return;
        }
        JobDetail job = JobBuilder.newJob(CurlJob.class).withIdentity(id, "curl").usingJobData(LOGGED_MESSAGE, loggedMessage).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(id, "graph").startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MINUTE)).build();
        try {
            JobManagement.getScheduler().scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    static {
        logJobp = "true".equals(System.getProperty(LOG_JOB));
        logUrl = System.getProperty(LOG_URL);
        logSource = System.getProperty(LOG_SOURCE, "provapi");
        token = System.getProperty(CURL_TOKEN);
    }
}

