/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.client;

import java.util.Objects;
import java.util.Properties;
import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.model.interop.ApiUriFragments;

public class ClientConfig
implements ApiUriFragments {
    public final Properties properties;
    public final String port;
    public final String context;
    public final String host;
    public final String protocol;
    public final String hostURLprefix;
    public final String hostURLprefixContext;
    public final String postURL;
    public final String formURL;
    public final String resourcesURLprefix;
    public final String htmlURL;

    public ClientConfig(Class<?> clazz) {
        this.properties = Objects.requireNonNull(Configuration.getPropertiesFromClasspath(clazz, (String)"config.properties"));
        this.port = this.properties.getProperty("service.port");
        this.context = this.properties.getProperty("service.context");
        this.host = this.properties.getProperty("service.host");
        this.protocol = this.properties.getProperty("service.protocol");
        this.hostURLprefix = this.protocol + "://" + this.host + ":" + this.port;
        this.hostURLprefixContext = this.protocol + "://" + this.host + ":" + this.port + this.context;
        this.postURL = this.hostURLprefixContext + "/provapi/documents/";
        this.formURL = this.hostURLprefixContext + "/provapi/documents_form/";
        this.resourcesURLprefix = this.hostURLprefixContext + "/provapi/resources/";
        this.htmlURL = this.hostURLprefixContext + "/contact.html";
    }
}

