/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.InputStream;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.openprovenance.prov.log.ProvLevel;
import org.openprovenance.prov.model.exception.ParserException;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.model.interop.ApiUriFragments;
import org.openprovenance.prov.model.interop.InteropMediaType;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.Constants;
import org.openprovenance.prov.service.core.OtherActionPerformer;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.ServiceUtilsConfig;
import org.openprovenance.prov.service.core.SwaggerTags;
import org.openprovenance.prov.service.core.UploadForm;
import org.openprovenance.prov.service.core.jobs.JobManagement;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.quartz.SchedulerException;

@Path(value="")
public class PostService
implements Constants,
InteropMediaType,
SwaggerTags,
ApiUriFragments {
    static Logger logger = LogManager.getLogger(PostService.class);
    private final JobManagement jobManager = new JobManagement();
    private final boolean autoDelete;
    protected final ServiceUtils utils;
    private final List<ActionPerformer> performers;
    private Optional<OtherActionPerformer> otherPerformer;
    private final Map<String, Object> configuration = new HashMap<String, Object>();

    public PostService(ServiceUtilsConfig config) {
        this(config, new LinkedList<ActionPerformer>(), Optional.empty());
    }

    public JobManagement getJobManager() {
        return this.jobManager;
    }

    public static <E> List<E> addToList(E element, List<E> list) {
        LinkedList<E> result = new LinkedList<E>();
        result.add(element);
        result.addAll(list);
        return result;
    }

    public PostService(ServiceUtilsConfig config, List<ActionPerformer> performers, Optional<OtherActionPerformer> otherPerformer) {
        this.utils = new ServiceUtils(this, config);
        this.autoDelete = config.autoDelete;
        this.jobManager.setupScheduler();
        try {
            JobManagement.getScheduler().getContext().put("utils", (Object)this.utils);
            JobManagement.getScheduler().getContext().put("duration", config.deletePeriod);
        }
        catch (SchedulerException e) {
            logger.throwing((Throwable)e);
        }
        this.performers = performers;
        this.otherPerformer = otherPerformer;
    }

    public ServiceUtils getServiceUtils() {
        return this.utils;
    }

    public void addToPerformers(List<ActionPerformer> newPerformers) {
        this.performers.addAll(newPerformers);
    }

    public void addOtherPerformer(Optional<OtherActionPerformer> newOtherPerformer) {
        this.otherPerformer = newOtherPerformer;
    }

    public Map<String, Object> addToConfiguration(String property, Object value) {
        this.configuration.put(property, value);
        return this.configuration;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @POST
    @Path(value="/documents_form/")
    @Consumes(value={"multipart/form-data"})
    @Tag(name="documents")
    @Operation(summary="Post a document. Payload is a form that may contain a file, prov statements or a url", description="Post a document in a form; indicate if validation or translation required; and redirects to the appropriate page. This method  is also designed for browser interaction, allowing the user to select a file, a url or statements for provenance.  The user may specify validate or translate directly.", responses={@ApiResponse(responseCode="303", headers={@Header(name="location", description="Location of posted document")}, description="See other url for serialization of posted resource as requested by accept header."), @ApiResponse(responseCode="404", description="Provenance not found")})
    public Response submit(@Parameter(name="form", description="form to be posted", required=true, schema=@Schema(implementation=UploadForm.class)) MultipartFormDataInput input, @Context HttpHeaders headers, @Context HttpServletRequest ignoredRequestContext) {
        MediaType mediaType = headers.getMediaType();
        Principal principal = ignoredRequestContext.getUserPrincipal();
        logger.info("principal is " + String.valueOf(principal));
        if (mediaType.toString().startsWith("multipart/form-data")) {
            try {
                Map formData = input.getFormDataMap();
                logger.debug("submitted " + String.valueOf(formData));
                DocumentResource vr = this.processFileInForm(formData);
                if (vr == null) {
                    vr = this.processUrlInForm(formData);
                }
                if (vr == null) {
                    vr = this.processStatementsInForm(formData);
                }
                boolean success = this.utils.doProcessFile(vr, true);
                if (vr == null) {
                    String result = "No provenance was found, and therefore failed to create resource for validation service";
                    return this.utils.composeResponseNotFOUND(result);
                }
                if (!success) {
                    String result = "Failed to parse provenance";
                    return this.utils.composeResponseBadRequest(result, vr.getThrown());
                }
                if (!this.utils.documentCache.containsKey(vr.getStorageId())) {
                    String result = "No provenance was found (empty document), and therefore failed to create resource for validation service";
                    return this.utils.composeResponseNotFOUND(result);
                }
                Date date = this.autoDelete ? this.jobManager.scheduleJob(vr.getVisibleId()) : null;
                vr.setExpires(date);
                ServiceUtils.Action action = this.utils.getAction(formData);
                this.doLog(action, vr);
                logger.debug("trying performers " + String.valueOf(this.performers));
                for (ActionPerformer performer : this.performers) {
                    logger.debug("trying performer " + String.valueOf((Object)performer.getAction()));
                    if (!performer.getAction().equals((Object)action)) continue;
                    logger.debug("invoking performer " + String.valueOf((Object)performer.getAction()));
                    return performer.doAction(formData, vr, date);
                }
                logger.debug("checking other performer ");
                if (this.otherPerformer.isPresent() && this.otherPerformer.get().otherAction(action, formData)) {
                    logger.debug("invoking other performer ");
                    return this.otherPerformer.get().doAction(action, formData, vr, date);
                }
                String location = "view/documents/" + vr.getVisibleId() + "/translation.html";
                return this.utils.composeResponseSeeOther(location).header("Expires", (Object)date).build();
            }
            catch (UncheckedException e) {
                return this.utils.composeResponseBadRequest("URI problem (" + String.valueOf(e.getCause()) + ")", e);
            }
            catch (ParserException e) {
                return this.utils.composeResponseBadRequest("Parser problem", e);
            }
            catch (Throwable t) {
                logger.throwing(t);
                String result = "exception occurred";
                return this.utils.composeResponseInternalServerError(result, t);
            }
        }
        String result = "Media type " + String.valueOf(mediaType) + " Not Supported yet";
        return this.utils.composeResponseNotFOUND(result);
    }

    @POST
    @Path(value="/documents/")
    @Tag(name="documents")
    @Consumes(value={"text/turtle", "text/provenance-notation", "application/provenance+xml", "application/json"})
    @Operation(summary="Post a document, directly, creates a resource, supports content negotiation, redirects to URL providing serialization for the resource", description="It supports the direct posting of documents using a prov serialization.", responses={@ApiResponse(responseCode="200", content={@Content(mediaType="text/turtle"), @Content(mediaType="text/provenance-notation"), @Content(mediaType="application/provenance+xml"), @Content(mediaType="application/json")}), @ApiResponse(responseCode="303", headers={@Header(name="location", description="Location of posted document")}, description="See other url for serialization of posted resource as requested by accept header."), @ApiResponse(responseCode="404", description="Provenance not found")})
    public Response submit2(@Parameter(name="input", description="input file in a prov serialization", example="document\n prefix ex <http://foo>\n entity(ex:e)\nendDocument") InputStream input, @Context HttpHeaders headers, @Context Request request) {
        MediaType mediaType = headers.getMediaType();
        String type = mediaType.getType() + "/" + mediaType.getSubtype();
        logger.debug(">>> post media type is " + type);
        logger.debug("accept header is" + String.valueOf(headers.getAcceptableMediaTypes()));
        DocumentResource vr = this.utils.doProcessFile(input, type);
        Date date = this.jobManager.scheduleJob(vr.getVisibleId());
        vr.setExpires(date);
        return this.utils.contentNegotiationForDocument(request, vr.getVisibleId(), ".");
    }

    @GET
    @Path(value="/configuration")
    @Tag(name="configuration")
    @Operation(summary="Get configuration", description="Get configuration", responses={@ApiResponse(responseCode="200", content={@Content(mediaType="application/json")})})
    public Response getConfiguration(@Context HttpHeaders headers) {
        StreamingOutput promise = out -> new ObjectMapper().writeValue(out, this.configuration);
        return ServiceUtils.composeResponseOK(promise).type("application/json").build();
    }

    private DocumentResource processFileInForm(Map<String, List<InputPart>> formData) {
        DocumentResource vr = null;
        List<InputPart> inputParts = formData.get("file");
        if (inputParts != null) {
            vr = this.utils.doProcessFileForm(inputParts);
        }
        return vr;
    }

    private DocumentResource processUrlInForm(Map<String, List<InputPart>> formData) {
        DocumentResource vr = null;
        List<InputPart> inputParts = formData.get("url");
        if (inputParts != null) {
            vr = this.utils.doProcessURLForm(inputParts);
        }
        return vr;
    }

    private DocumentResource processStatementsInForm(Map<String, List<InputPart>> formData) {
        DocumentResource vr = null;
        List<InputPart> inputParts = formData.get("statements");
        List<InputPart> type = formData.get("type");
        if (inputParts != null) {
            vr = this.utils.doProcessStatementsForm(inputParts, type);
        }
        return vr;
    }

    private void doLog(ServiceUtils.Action action, DocumentResource vr) {
        this.doLog(action.toString(), vr);
    }

    private void doLog(String action, DocumentResource vr) {
        logger.log(ProvLevel.PROV, action + "," + vr.getVisibleId() + "," + vr.getStorageId());
    }
}

