/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core.memory;

import java.util.HashMap;
import java.util.Map;
import org.openprovenance.prov.service.core.memory.DocumentResourceInMemory;
import org.openprovenance.prov.service.core.memory.DocumentResourceIndexInMemory;
import org.openprovenance.prov.service.core.memory.LRUHashMap;
import org.openprovenance.prov.service.core.memory.NonDocumentResourceInMemory;
import org.openprovenance.prov.storage.api.DocumentResource;
import org.openprovenance.prov.storage.api.Instantiable;
import org.openprovenance.prov.storage.api.NonDocumentResource;
import org.openprovenance.prov.storage.api.NonDocumentResourceIndex;

public class NonDocumentResourceIndexInMemory
implements NonDocumentResourceIndex<NonDocumentResource> {
    public final Map<String, NonDocumentResource> table;
    public static Instantiable<DocumentResource> factory = new Instantiable<DocumentResource>(){

        public DocumentResource newResource(DocumentResource dr) {
            return dr;
        }

        public DocumentResource newResource() {
            return new DocumentResourceInMemory();
        }
    };

    public NonDocumentResourceIndexInMemory(Map<String, NonDocumentResource> table) {
        this.table = table;
    }

    public NonDocumentResourceIndexInMemory(int limit) {
        this.table = new LRUHashMap<String, NonDocumentResource>(limit);
    }

    public NonDocumentResourceIndexInMemory() {
        this.table = new HashMap<String, NonDocumentResource>();
    }

    public NonDocumentResource get(String key) {
        return this.table.get(key);
    }

    public void put(String key, NonDocumentResource dr) {
        this.table.put(key, dr);
    }

    public void remove(String key) {
        System.out.println("NonDocumentResourceIndexInMemory.remove() " + key);
        this.table.remove(key);
    }

    public synchronized String newId() {
        return "m" + DocumentResourceIndexInMemory.count++;
    }

    public NonDocumentResource newResource() {
        String id = this.newId();
        NonDocumentResourceInMemory dr = new NonDocumentResourceInMemory();
        dr.setVisibleId(id);
        this.put(id, dr);
        return dr;
    }

    public NonDocumentResourceIndex.StorageKind kind() {
        return NonDocumentResourceIndex.StorageKind.ME;
    }

    public static void register(Map<String, Instantiable<?>> m) {
        m.put(DocumentResource.getResourceKind(), factory);
    }
}

