/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.SwaggerTags;

@Path(value="")
@Tag(name="resources")
public class ResourcesService
implements SwaggerTags {
    private final InteropFramework interopFramework = new InteropFramework();
    static final Logger logger = LogManager.getLogger(ResourcesService.class);
    public static final String WEBRESOURCES_BASEPATH = "/webresources/";

    @GET
    @Path(value="/resources/{path: .+}")
    @Tag(name="resources")
    @Operation(summary="Returns static resources.", description="No content negotiation allowed here, no dynamic generation.", responses={@ApiResponse(responseCode="200", description="Representation of resource"), @ApiResponse(responseCode="404", description="Representatoin not found")})
    @Produces(value={"text/provenance-notation", "application/provenance+xml", "application/json", "application/ld+json", "plain/text"})
    public Response getResource(@Context HttpServletResponse response, @Context HttpServletRequest request, @Parameter(name="path", description="document path", required=true) @PathParam(value="path") String path) {
        String mediaType;
        logger.info("get resources " + path);
        String type = path.substring(path.lastIndexOf(".") + 1);
        logger.info(" type " + type);
        if (!this.interopFramework.extensionRevMap.containsKey(type)) {
            mediaType = "text/plain";
        } else {
            mediaType = (String)this.interopFramework.getMimeTypeMap().get(this.interopFramework.extensionRevMap.get(type));
            if (mediaType == null) {
                mediaType = "text/plain";
            }
        }
        String the_path = WEBRESOURCES_BASEPATH + path;
        logger.info(" the_path " + the_path);
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(the_path);
        StreamingOutput promise = stream != null ? stream::transferTo : out -> out.write(("Resource " + the_path + " not found").getBytes());
        logger.info("media type is " + mediaType);
        return ServiceUtils.composeResponseOK(promise).type(mediaType).build();
    }
}

