/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core.readers;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
@Consumes(value={"application/json"})
public class GenericJsonMessageBodyReader<T>
implements MessageBodyReader<T> {
    private final Class<T> clazz;
    ObjectMapper om = new ObjectMapper();

    public GenericJsonMessageBodyReader(Class<T> clazz) {
        this.clazz = clazz;
    }

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return mediaType.toString().startsWith("application/json");
    }

    public T readFrom(Class<T> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        return (T)this.om.readValue(inputStream, this.clazz);
    }
}

