/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core.readers;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.interop.Formats;
import org.openprovenance.prov.service.core.writers.VanillaDocumentMessageBodyWriter;
import org.openprovenance.prov.vanilla.Document;

@Provider
public class VanillaDocumentMessageBodyReader
implements MessageBodyReader<Document> {
    final ProvFactory pf;
    final InteropFramework intF;

    public VanillaDocumentMessageBodyReader(ProvFactory pf) {
        this.pf = pf;
        this.intF = new InteropFramework(pf);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Formats.ProvFormat format = (Formats.ProvFormat)this.intF.mimeTypeRevMap.get(VanillaDocumentMessageBodyWriter.trimCharSet(mediaType));
        return format != null;
    }

    public Document readFrom(Class<Document> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream is) throws IOException, WebApplicationException {
        Formats.ProvFormat format = (Formats.ProvFormat)this.intF.mimeTypeRevMap.get(VanillaDocumentMessageBodyWriter.trimCharSet(mediaType));
        return (Document)this.intF.readDocument(is, format);
    }
}

