/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.core.writers;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvDocumentWriter;

@Provider
@Produces(value={"text/provenance-notation", "application/provenance+xml", "application/ld+json", "application/json", "image/svg+xml", "application/pdf", "image/jpeg", "image/png"})
public class VanillaDocumentMessageBodyWriter
implements MessageBodyWriter<org.openprovenance.prov.vanilla.Document> {
    private final ProvDocumentWriter documentWriter;

    public VanillaDocumentMessageBodyWriter(ProvDocumentWriter documentWriter) {
        this.documentWriter = documentWriter;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.documentWriter.mediaTypes().contains(VanillaDocumentMessageBodyWriter.trimCharSet(mediaType));
    }

    public long getSize(org.openprovenance.prov.vanilla.Document t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(org.openprovenance.prov.vanilla.Document doc, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String media = VanillaDocumentMessageBodyWriter.trimCharSet(mediaType);
        this.documentWriter.writeDocument(entityStream, (Document)doc, media, true);
    }

    public static String trimCharSet(MediaType mediaType) {
        String med = mediaType.toString();
        int ind = med.indexOf(";");
        if (ind > 0) {
            med = med.substring(0, ind);
        }
        return med;
    }
}

