/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.summary;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.log.ProvLevel;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.scala.immutable.Indexer;
import org.openprovenance.prov.scala.immutable.ProvFactory;
import org.openprovenance.prov.scala.summary.SummaryAPI;
import org.openprovenance.prov.scala.summary.SummaryConfig;
import org.openprovenance.prov.scala.summary.SummaryIndex;
import org.openprovenance.prov.scala.summary.TypePropagator;
import org.openprovenance.prov.service.core.ActionPerformer;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.core.jobs.JobManagement;
import org.openprovenance.prov.service.summary.SummaryDocumentResource;
import org.openprovenance.prov.service.summary.SummaryDocumentResourceInMemory;
import org.openprovenance.prov.storage.api.DocumentResource;
import scala.Tuple2;

public final class ActionSummary
implements ActionPerformer {
    static Logger logger = LogManager.getLogger(ActionSummary.class);
    private final ServiceUtils utils;

    public ActionSummary(ServiceUtils utils) {
        this.utils = utils;
    }

    public ServiceUtils.Action getAction() {
        return ServiceUtils.Action.SUMMARISE;
    }

    public Response doAction(Map<String, List<InputPart>> formData, DocumentResource dr, Date date) throws IOException {
        SummaryDocumentResourceInMemory sdr = new SummaryDocumentResourceInMemory(dr);
        this.utils.getDocumentResourceIndex().put(dr.getVisibleId(), (DocumentResource)sdr);
        ServiceUtils.Destination destination = this.utils.getDestination(formData);
        String location = "documents/" + dr.getVisibleId() + "." + destination;
        logger.info(" TODO TODO TODO: sdr.setDocument(doc)");
        throw new UnsupportedOperationException("Code has not been updated to work with summary/config stored in storage");
    }

    public void doLogSummary(SummaryDocumentResource vr, org.openprovenance.prov.scala.immutable.Document doc) {
        try {
            SummaryDocumentResource vr2 = (SummaryDocumentResource)((SummaryDocumentResourceInMemory)vr).clone();
            Runnable run = () -> {
                logger.debug("========================> " + JobManagement.logJobp);
                if (!JobManagement.logJobp) {
                    return;
                }
                InteropFramework interop = new InteropFramework();
                String myfile = vr2.getStorageId() + "_summary.provn";
                vr2.setStorageId(myfile);
                interop.writeDocument(myfile, (Document)doc);
                this.doLog("summarisation", vr2);
            };
            run.run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void doLog(String action, SummaryDocumentResource vr) {
        logger.log(ProvLevel.PROV, "" + action + "," + vr.getVisibleId() + "," + vr.getStorageId());
    }

    public SummaryIndex getSummary(DocumentResource vr) throws IOException {
        org.openprovenance.prov.scala.immutable.Document d2;
        Document doc = this.utils.getDocumentFromCacheOrStore(vr.getStorageId());
        org.openprovenance.prov.scala.immutable.Document d3 = d2 = ProvFactory.pf().newDocument(doc);
        SummaryConfig config = new SummaryConfig(1);
        Tuple2 pair = SummaryAPI.sum((org.openprovenance.prov.scala.immutable.Document)d3, (SummaryConfig)config, null);
        Indexer ind = (Indexer)pair._1;
        TypePropagator tp = (TypePropagator)pair._2;
        SummaryIndex indexed = SummaryAPI.makeSummaryIndex((SummaryConfig)config, (TypePropagator)tp, (Indexer)ind, (int)1, null, null);
        return indexed;
    }

    public String toString() {
        return "<<performer:" + this.getAction() + ">>";
    }
}

