/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.summary;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.openprovenance.prov.scala.immutable.Document;
import org.openprovenance.prov.scala.summary.SummaryAPI;
import org.openprovenance.prov.scala.summary.SummaryConfig;

@Provider
@Produces(value={"text/provenance-notation", "application/provenance+xml", "application/json", "image/svg+xml", "application/pdf"})
public class ScalaDocumentMessageBodyWriter
implements MessageBodyWriter<Document> {
    public String trimCharSet(MediaType mediaType) {
        String med = mediaType.toString();
        int ind = med.indexOf(";");
        if (ind > 0) {
            med = med.substring(0, ind);
        }
        return med;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(Document t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Document doc, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) {
        SummaryConfig config = new SummaryConfig(entityStream, this.trimCharSet(mediaType));
        SummaryAPI.outputer((Document)doc, (SummaryConfig)config);
    }
}

